#ifdef __cplusplus
extern "C" {
#endif
/*
ANSI C code generated by SmartEiffel The GNU Eiffel Compiler, Eiffel tools and libraries
Release 1.1 Release (Monday June 16th 2003) [Charlemagne]
Copyright (C), 1994-2003 - INRIA - LORIA - UHP - Nancy 2 - FRANCE
D.COLNET, S.COLLIN, O.ZENDRA, P.RIBET, C.ADRIAN - SmartEiffel@loria.fr
http://SmartEiffel.loria.fr
C Compiler options used: -pipe -O2
*/
#ifdef __cplusplus
}
#endif
#include "lisaac.h"
#ifdef __cplusplus
extern "C" {
#endif
/*
-- This file is  free  software, which  comes  along  with  SmartEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of
-- another product.
--       Copyright (C) 1994-2002 LORIA - INRIA - U.H.P. Nancy 1 - FRANCE
--          Dominique COLNET and Suzanne COLLIN - SmartEiffel@loria.fr
--                       http://SmartEiffel.loria.fr
--
*/
/*
  This file (SmartEiffel/sys/runtime/base.c) is included for _all_ modes of
  compilation (-boost, -no_check, ... -all_check, -debug_check).
*/

/*
  Byte swapping function
*/
void copy_swap_16(const uint16_t *src, uint16_t *dest, int count){
  while (count--) {
    *dest++ = (*src << 8) | (*src >> 8);
    src++;
  }
}


/*
  The wrapper for `malloc' (generated C code is supposed to use
  only `se_malloc' instead of direct `malloc').
*/
void* se_malloc(size_t size) {
  void *result = malloc(size);
  if (result == NULL) {
#ifdef SE_EXCEPTIONS
    internal_exception_handler(No_more_memory);
#elif !defined(SE_BOOST)
    error0("No more memory.", NULL);
#else
  fprintf(SE_ERR,"No more memory.\n");
  se_print_run_time_stack();
  exit(EXIT_FAILURE);
#endif
  }
  return result;
}

/*
  The wrapper for `calloc' (generated C code is supposed to use
  only `se_calloc' instead of direct `calloc').
*/
void* se_calloc(size_t nmemb, size_t size) {
  void *result = calloc(nmemb,size);
  if (result == NULL) {
#ifdef SE_EXCEPTIONS
    internal_exception_handler(No_more_memory);
#elif !defined(SE_BOOST)
    error0("No more memory.", NULL);
#else
  fprintf(SE_ERR,"No more memory.\n");
  se_print_run_time_stack();
  exit(EXIT_FAILURE);
#endif
  }
  return result;
}

/*
  The wrapper for `realloc' (generated C code is supposed to use
  only `se_realloc' instead of direct `realloc').
*/
void* se_realloc(void* src, size_t size) {
  void *result = realloc(src, size);
  if (result == NULL) {
#ifdef SE_EXCEPTIONS
    internal_exception_handler(No_more_memory);
#elif !defined(SE_BOOST)
    error0("No more memory.", NULL);
#else
  fprintf(SE_ERR,"No more memory.\n");
  se_print_run_time_stack();
  exit(EXIT_FAILURE);
#endif
  }
  return result;
}

int se_cmpT20(T20 o1,T20 o2){
return memcmp(&o1,&o2,sizeof(o1));}
T40 M40={0,NULL};
T68 M68=NULL;
T191 M191={191,0,NULL};
T127 M127={NULL,NULL};
T12 M12={NULL,NULL,NULL};
T140 M140={NULL,NULL};
T181 M181=0;
T157 M157={157,NULL,NULL,0,NULL,0,0,0};
T183 M183={183,0,NULL,0,NULL,0};
T193 M193={193,0,NULL,NULL};
T148 M148={148,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL};
T200 M200={200,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL};
T46 M46={NULL,0,0};
T55 M55={0,NULL,NULL,0,NULL};
T160 M160={NULL,0,0};
T89 M89={NULL,0,0,0};
T197 M197={197,0,NULL};
T199 M199={199,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL};
T65 M65={NULL,NULL};
T108 M108={108,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0};
T201 M201={201,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL};
T196 M196={196,0,NULL,NULL,NULL,0};
T87 M87={NULL,NULL};
T60 M60={0,NULL};
T123 M123={NULL,0,0,0};
T222 M222={NULL};
T120 M120={NULL,NULL};
T220 M220={0,NULL,NULL,0,NULL};
T85 M85={NULL,NULL};
T67 M67=0;
T172 M172={172,NULL,0,NULL,NULL,NULL,0,NULL,0};
T63 M63={NULL,NULL,NULL,0};
T163 M163={163,NULL,NULL,0,NULL,0};
T103 M103={NULL,NULL};
T37 M37={NULL,0,0};
T187 M187={187,0,NULL,0};
T224 M224={0};
T194 M194={194,0,NULL,NULL};
T203 M203={0,NULL,NULL,0,NULL};
T70 M70={0,0,0,NULL,0,0,0,0};
T159 M159={159,NULL,0,0,NULL,0,NULL};
T202 M202={0,NULL,NULL,0,NULL};
T204 M204={204,NULL,0,0,NULL,NULL,NULL,NULL};
T186 M186={186,0,NULL};
T221 M221={NULL,NULL};
T176 M176={176,NULL,0,0,NULL,NULL,0,0,NULL,NULL,NULL};
T117 M117={NULL,NULL,NULL};
T195 M195={195,0,NULL,NULL};
T110 M110={0,NULL,NULL,0,NULL};
T114 M114={114,NULL,0,0,NULL,0};
T112 M112={0,NULL,NULL,0,NULL};
T131 M131={131,NULL,NULL,0,NULL};
T185 M185={185,0,NULL};
T113 M113={113,NULL,0,0,NULL,NULL,0,0,0,NULL,0,NULL,0,0,0,NULL,0};
T152 M152={152,0,NULL,NULL,0,NULL};
T106 M106={106,NULL,NULL,0,NULL,0};
T182 M182={NULL,NULL,NULL,0,0,NULL,NULL,0,NULL,NULL,NULL,0,0};
T142 M142={0,NULL,NULL,0,NULL};
T128 M128={NULL,NULL};
T198 M198={198,NULL,0,0,NULL,NULL,0,0,NULL,NULL,NULL,0,0};
T206 M206={NULL,NULL};
T170 M170={170,NULL};
T102 M102={0,NULL,NULL,0,NULL};
T49 M49={NULL,0,0};
T104 M104=0;
T111 M111={0,NULL,NULL,0,NULL};
T105 M105={NULL,0,0,0,NULL,NULL,0,0,0,0};
T121 M121={NULL,NULL};
T25 M25={25,NULL,NULL,0,0,0,NULL,NULL,NULL,NULL,NULL,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL};
T125 M125={0,NULL,NULL,0,NULL};
T119 M119={0,NULL,NULL,0,NULL};
T174 M174={174,0,NULL,NULL,0,NULL};
T81 M81={0};
T94 M94={0,NULL};
T98 M98={98,NULL,NULL,0,0,0,NULL,NULL,NULL,NULL,NULL,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL};
T171 M171={171,NULL,NULL,0,NULL,NULL,0,0};
T71 M71={NULL,0,0,NULL};
T151 M151={151,NULL,0,NULL,NULL,NULL,NULL,0,NULL,NULL};
T7 M7={NULL,0,0};
T58 M58={NULL,NULL};
T213 M213={213,NULL,NULL,0,NULL,0,0,0};
T192 M192={192,0,NULL,NULL};
T99 M99={99,0,0};
T188 M188={188,0,NULL,NULL,NULL};
T190 M190={190,0,NULL,NULL};
T205 M205={NULL,NULL};
T84 M84={NULL,0,NULL,0,0,0};
T168 M168={168,NULL};
T132 M132={132,NULL,NULL,0,0,0};
T165 M165={165,0};
T155 M155={155,NULL,NULL,0,0,0,0};
T135 M135={135,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,0,NULL};
T167 M167=0;
T116 M116={NULL,0,0,0,NULL,0};
T41 M41={41,NULL,0,0};
T178 M178={NULL,0,0};
T209 M209={209,NULL,0,0,NULL,0,NULL};
T173 M173={173,NULL,0,NULL,NULL,NULL,NULL,0,0};
T72 M72={NULL,0,0};
T144 M144={NULL,0,0,0};
T141 M141={0,0,NULL,NULL};
T138 M138={NULL,NULL,NULL};
T75 M75={75,NULL,0,0,NULL,NULL,0,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0,0};
T92 M92={0,NULL,NULL};
T175 M175={175,NULL,NULL};
T95 M95={95,NULL,NULL,0,0,0,NULL,NULL,NULL,NULL,NULL,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL};
T20 M20={0};
T52 M52={52,NULL,0,0,NULL,NULL,0,0,0,NULL,0,NULL,0,0,NULL,0,0,NULL,NULL,NULL,NULL,NULL,0};
T227 M227={227,0,0};
T136 M136={136,0,NULL,NULL,NULL};
T62 M62={0,NULL,NULL,0,NULL};
T129 M129={129,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL};
T126 M126={NULL,NULL};
T93 M93={93,0,NULL,NULL,NULL};
T225 M225={225,0,NULL,NULL};
T208 M208={208,NULL,0,0,NULL,0,NULL};
T134 M134={134,NULL,0,NULL,NULL};
T147 M147={147,NULL,0,0,NULL};
T56 M56={56,NULL,0,NULL,0,0,0};
T184 M184={NULL,NULL,0,0,0};
T143 M143={NULL,NULL};
T97 M97={97,0,NULL,NULL};
T145 M145={NULL,0,NULL};
T34 M34={0,NULL,NULL,0,NULL};
T21 M21={NULL,NULL,0,0,NULL};
T217 M217={NULL,0,0};
T139 M139={0,NULL,NULL,0,NULL};
T154 M154={154,NULL,NULL};
T80 M80={0,NULL,0};
T44 M44=NULL;
T64 M64={NULL,0,0,0};
T189 M189={189,NULL,NULL,NULL};
T101 M101={101,NULL,NULL,0,0,0,NULL,NULL,NULL,NULL,NULL,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL};
/*Aliased storage area or unicode storage.*/
char*s182_764636964="Incorrect value expression.";
char*s172_706737602="Late binding is not possible for this prototype.";
char*s25_10="\n";
char*s25_32=" ";
char*s208_34="\"";
char*s198_38="&";
char*s182_39="\'";
char*s40_40="(";
char*s108_41=")";
char*s95_42="*";
char*s182_43="+";
char*s108_44=",";
char*s182_45="-";
char*s25_46=".";
char*s108_47="/";
char*s108_58=":";
char*s182_59=";";
char*s76_60="<";
char*s63_61="=";
char*s76_62=">";
char*s108_63="\?";
char*s63_1863820="__infix";
char*s182_91="[";
char*s108_93="]";
char*s198_96="`";
char*s108_125="\175""";
char*s25_192="  ";
char*s25_200=" (";
char*s25_215=")\n";
char*s63_226="!=";
char*s172_237=") ";
char*s147_240="((";
char*s213_246="))";
char*s159_251=" [";
char*s82_251=").";
char*s159_276="..";
char*s182_287="->";
char*s75_300=":\n";
char*s76_304="/E";
char*s25_305=";\n";
char*s76_317="/R";
char*s12_329=".c";
char*s63_351=":=";
char*s198_360="<<";
char*s198_366="==";
char*s149_6550=") \173""\n";
char*s93_570="__";
char*s108_661417606="\n------------------------------------------------------------------------------\n";
char*s108_625="\173""\n";
char*s182_1718922222="Incorrect external.";
char*s12_994="  \"";
char*s182_22661311="Incorrect expression.";
char*s171_1151=" :=";
char*s198_1197="(! ";
char*s182_1341337541="identifier is needed.";
char*s204_1350=". (";
char*s182_878727141="Added \':=\'.";
char*s25_1442="// ";
char*s198_1603481221="stack_print(";
char*s182_1753159665="Type is needed.";
char*s172_180037=" else ";
char*s82_1251176606="Type static ";
char*s182_1615162081="Incorrect symbol.";
char*s75_81737="goto ";
char*s12_1795=".li";
char*s53_14150="Void";
char*s12_26485=" */\n\n";
char*s106_945201589=" is invalid with type static ";
char*s159_32851=" [0..";
char*s198_481576475="Not External Lisaac.";
char*s182_1752268520="Unknown escape sequence.";
char*s12_2645="\n/*\n";
char*s182_66888916="Incorrect local type.";
char*s204_1383424395="\' not found in ";
char*s182_1722000227="Incorrect operator.";
char*s12_9366=".txt";
char*s163_45981962="__ISAAC->";
char*s182_923600569="Incorrect type.";
char*s172_15875="if (";
char*s182_1008712295="Incorrect section identifier.";
char*s108_1849670875="==============================================================================\n";
char*s25_660418299="------------------------------------------------------------------------------\n";
char*s130_527704541="Compiler crash: BASE_SEND.build_case_type_action with \'*\'";
char*s201_10359="BASE";
char*s159_274388042="] => new value=0.";
char*s200_738702612="Impossible assignment for \'*\' slot.";
char*s108_1640741="Pass N\260""";
char*s182_175744891="Added \')\'.";
char*s25_17160="\175"";\n\n";
char*s182_175745341="Added \';\'.";
char*s182_40847997="Identifier is incorrect.";
char*s130_343849="Slot \'";
char*s25_4692662="#define ";
char*s12_5867=" => ";
char*s182_175746191="Added \']\'.";
char*s182_9343320="__prefix";
/*
-- This file is  free  software, which  comes  along  with  SmartEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of
-- another product.
--       Copyright (C) 1994-2002 LORIA - INRIA - U.H.P. Nancy 1 - FRANCE
--          Dominique COLNET and Suzanne COLLIN - SmartEiffel@loria.fr
--                       http://SmartEiffel.loria.fr
--
*/

/*
  This file (SmartEiffel/sys/runtime/boost.c) is automatically included when
  `run_control.boost' is true (ie. only for mode -boost).
*/

void se_print_run_time_stack (void) {
  fprintf(SE_ERR,"Eiffel program crash at run time.\n");
  fprintf(SE_ERR,"No trace when using option \"-boost\"\n");
}

void se_signal_handler(int sig) {
  printf("Received signal %d.\n",sig);
  se_print_run_time_stack();
  exit(EXIT_FAILURE);
}
/*
-- This file is  free  software, which  comes  along  with  SmartEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of
-- another product.
--       Copyright (C) 1994-2002 LORIA - INRIA - U.H.P. Nancy 1 - FRANCE
--          Dominique COLNET and Suzanne COLLIN - SmartEiffel@loria.fr
--                       http://SmartEiffel.loria.fr
--
*/

/*
   This file (SmartEiffel/sys/runtime/gc_lib.c) is automatically included
   when the Garbage Collector is used (default, unless option -no_gc has been
   selected).
*/
/*
   The `mark_stack_and_registers' C function is called by the Garbage
   Collector (GC) of SmartEiffel. It has to be customized for some systems,
   but also for some C compilers. This file provides some definitions in the
   end and has to be completed for systems which need specific work.

   On some architectures, addresses increase as the stack grows; or,
   conversely, addresses decrease as the stack grows. A C compiler may be
   clever enough to hide some root object inside registers. Unfortunately all
   registers are not always accessible via the C `setjmp' function!

   Thus, in order to be able to use the GC on your architecture/C-compiler,
   you have to provide the correct `mark_stack_and_registers' function.

   What is the `mark_stack_and_registers' function supposed to do?  The
   `mark_stack_and_registers' function is supposed to notify the GC with all
   the possible roots one can find in the C stack and registers by calling the
   `gc_mark' function. A root is an object which must not be collected.  The
   SmartEiffel GC already knows about some root objects like once function
   results or manifest strings. The `mark_stack_and_registers' function has to
   notify the other possible roots. Obviously, one can find in the C stack any
   kind of adresses, but the `gc_mark' function is clever enough to determine
   if the passed pointer is an Eiffel object or not.  When the passed pointer
   reaches some Eiffel object, this object as well as its descendant(s) are
   automatically marked as un-collectable.

   In order to provide the most appropriate `mark_stack_and_registers'
   function, the very first question is to know about the way the C stack is
   managed (addresses of the stack may increase or decrease as the C stack
   grows). The DEFAULT BEHAVIOUR FOR UNKNOWN SYSTEMS is to consider ADDRESSES
   DECREASE AS THE STACK GROWS, as it's the most common case.  The global C
   variable `stack_bottom' is set with some pointer which is supposed to be
   the bottom of the stack (this variable is automatically initialized in the
   C main function).  Note: using the current stack pointer inside
   `mark_stack_and_registers', it is quite obvious to determine if addresses
   increase or not as the C stack grows.  Note2: on some systems, the stack is
   not in contiguous addresses. In such case, `mark_stack_and_registers' has
   to go through all the stack fragments.

   Some roots may be stored only in registers and not in the C stack.  In
   order to reach the registers as well, the first attempt is to use setjmp,
   in the hope that setjmp will save registers in the stack!  Note: this
   technique do not work on processors using windows registers (such as sparc
   processors).

*/


int se_gc_strategy = SE_GC_DEFAULT_MEMORY_STRATEGY;

int collector_counter = 0;

static void gcna_align_mark(rsoc*c,void*o);
static rsoc*rsocfl=NULL; /* ReSizable Object Chunk Free List. */

void**stack_bottom=NULL;
mch**gcmt=NULL; /* Garbage Collector Main Table. */
int gcmt_max=2048;
int gcmt_used=0;
fsoc*fsocfl=NULL; /* Fixed Size Object Chunk Free List. */
int gc_is_off=1;
unsigned int fsoc_count=0;
unsigned int rsoc_count=0;
void*gcmt_tail_addr=NULL;

static int chunk_rounded(int size) {
  int rounded_size = size;
  int diff = rounded_size%RSOC_SIZE;

  if (diff != 0) rounded_size += (RSOC_SIZE-diff);
  return rounded_size;
}

static void free_and_remove_from_gcmt(mch* c) {
  /* Remove and free the chunk `c' from the
   * gcmt (Garbage Collector Main Table).
   */
  mch**p=(gcmt+gcmt_used-1);
  mch*save=*p;
  mch*save2;
  p--;
  while(save != c) {
    save2 = save;
    save = *p;
    *p = save2;
    p--;
  }
  free(c);
  gcmt_used--;
}

static void may_free_rsocfl(void) {
  /* May free all chunks of `rsocfl' (ReSizable Object Chunk Free List)
     in some circumstances.
  */
  rsoc* next, *current;
  unsigned int count = rsocfl_count();
  if ((count > 50) && (count > (rsoc_count >> 1))) { 
    current=rsocfl;
    rsocfl=NULL;
    while (current != NULL) {
      next=current->next;
      if (current->isize == current->header.size) {
	free_and_remove_from_gcmt(((mch*)current)); 
	rsoc_count--;
      }
      else {
	current->next=rsocfl;
	rsocfl=current;
      }
      current = next;
    }
  }
}

int gc_memory_used(void) {
  int i;
  int result = 0;
  mch* mch;
  for (i = gcmt_used; i --> 0; ) {
    mch = gcmt[i];
    switch(mch->state_type) {
    case RSO_USED_CHUNK:
    case FSO_USED_CHUNK:
    case FSO_STORE_CHUNK:
      result += mch->size;
      break;
    default:
      break;
    }
  }
  return result;
}

void gc_sweep(void) {
  mch** p2 = gcmt;
  mch** p1 = gcmt+1;
  mch**eogcmt=gcmt+gcmt_used;
  if (FREE_CHUNK((*p2)->state_type)) {
    if (RSO_FREE_CHUNK == ((*p2)->state_type)) {
      ((rsoc*)(*p2))->next=NULL;
      rsocfl=((rsoc*)(*p2));
    }
    else {
      rsocfl=NULL;
    }
  }
  else {
    ((*gcmt)->swfp)(*p2);
    if (RSO_FREE_CHUNK==((*p2)->state_type)) {
      ((rsoc*)(*p2))->next=NULL;
      rsocfl=((rsoc*)(*p2));
    }
    else {
      rsocfl=NULL;
    }
  }
  while (p1 < eogcmt) {
    if (FREE_CHUNK((*p1)->state_type)) {
      if (RSO_FREE_CHUNK == ((*p1)->state_type)) {
	if (RSO_FREE_CHUNK == ((*p2)->state_type)) {
	  if (((char*)(*p2))+(*p2)->size == ((char*)(*p1))) {
	    ((*p2)->size)+=((*p1)->size);
	    p1++;
	  }
	  else {
	    ((rsoc*)(*p1))->next=rsocfl;
	    rsocfl=((rsoc*)(*p1));
	    *(p2+1)=*p1; p2++; p1++;
	  }
	}
	else {
	  ((rsoc*)(*p1))->next=rsocfl;
	  rsocfl=((rsoc*)(*p1));
	  *(p2+1)=*p1; p2++; p1++;
	}
      }
      else {
	*(p2+1)=*p1; p2++; p1++;
      }
    }
    else {
      ((*p1)->swfp)(*p1);
      if (RSO_FREE_CHUNK == ((*p1)->state_type)) {
	if (RSO_FREE_CHUNK == ((*p2)->state_type)) {
	  if (((char*)(*p2))+(*p2)->size == ((char*)(*p1))) {
	    ((*p2)->size)+=((*p1)->size);
	    p1++;
	  }
	  else {
	    ((rsoc*)(*p1))->next=rsocfl;
	    rsocfl=((rsoc*)(*p1));
	    *(p2+1)=*p1; p2++; p1++;
	  }
	}
	else {
	  ((rsoc*)(*p1))->next=rsocfl;
	  rsocfl=((rsoc*)(*p1));
	  *(p2+1)=*p1; p2++; p1++;
	}
      }
      else {
	*(p2+1)=*p1; p2++; p1++;
      }
    }
  }
  gcmt_used=(p2-gcmt)+1;
  may_free_rsocfl();
}

/* return the mch containing p or NULL if p is not 
 * a valid address or was externally allocated 
 */
mch * gc_find_chunk(void * p){
  if ((p>((void*)*gcmt))&&(p<=gcmt_tail_addr)) {
    int i1=0;
    int i2=gcmt_used-1;
    int m=i2>>1;
    mch*c;
    for (;i2>i1;m=((i1+i2)>>1)) {
      if (p<=((void*)gcmt[m+1])) {
	i2=m;
      }
      else {
	i1=m+1;
      }
    }
    c=gcmt[i2];
    if((char*)p<(char*)c+c->size)   /* check for upper bound */
      if (!(FREE_CHUNK(c->state_type)))
	return c;
  }
  return NULL;
}

void gc_mark(void*p) {
  mch * c = gc_find_chunk(p);
  if(NULL != c) 
    (c->amfp)(c,p);
}

int gc_stack_size(void) {
  void*stack_top[2]={NULL,NULL};
  if (stack_top > stack_bottom) {
    return ((void**)stack_top)-((void**)stack_bottom);
  }
  else {
    return ((void**)stack_bottom)-((void**)stack_top);
  }
}

/*
  To delay Garbage Collection when the stack is too large.
  To allow fast increase of ceils.
*/
#define FSOC_LIMIT (10240/((FSOC_SIZE)>>10))
#define RSOC_LIMIT (10240/((RSOC_SIZE)>>10))

/*
  When stack is too large, collection may be delayed.
*/
#define GCLARGESTACK 50000

int garbage_delayed(void) {
  /*
    To delay the first GC call.
  */
  if (gc_stack_size() > GCLARGESTACK) {
    if (fsoc_count_ceil <= fsoc_count) {
      if (rsoc_count_ceil <= rsoc_count) {
	if ((fsoc_count<FSOC_LIMIT)&&(rsoc_count<RSOC_LIMIT)) {
	  fsoc_count_ceil++;
	  rsoc_count_ceil++;
	  return 1;
	}
	else return 0;
      }
      else {
	if (fsoc_count<FSOC_LIMIT) {
	  fsoc_count_ceil++;
	  return 1;
	}
	else return 0;
      }
    }
    else {
      if (rsoc_count_ceil <= rsoc_count) {
	if (rsoc_count<RSOC_LIMIT) {
	  rsoc_count_ceil++;
	  return 1;
	}
	else return 0;
      }
      else return 0;
    }
  }
  else {
    return 0;
  }
}

void gc_update_ceils(void) {
  /* This function is automatically called after each collection
     cycle.
  */
  if (se_gc_strategy == SE_GC_LOW_MEMORY_STRATEGY) {
    fsoc_count_ceil = fsoc_count;
    rsoc_count_ceil = rsoc_count;
    /* Todo: we should also consider to free unused chunks here. */
    return;
  }
  if (se_gc_strategy == SE_GC_HIGH_MEMORY_STRATEGY) {
    fsoc_count_ceil = (256 + fsoc_count) << 2;
    rsoc_count_ceil = (256 + rsoc_count) << 2;
    return;
  }
  /* The SE_GC_DEFAULT_MEMORY_STRATEGY. */
  /* Compute fsoc_count_ceil: */
  if (fsocfl == NULL) {
    if (fsoc_count >= fsoc_count_ceil) {
      if (fsoc_count_ceil < FSOC_LIMIT) {
	fsoc_count_ceil <<= 1;
      }
      else {
	unsigned int c = fsoc_count + (fsoc_count/3);
	if (fsoc_count_ceil < c)
	  fsoc_count_ceil = c;
      }
    }
  }
  else {
    if (fsoc_count_ceil < fsoc_count) {
      fsoc_count_ceil = fsoc_count;
    }
  }
  /* Compute rsoc_count_ceil: */
  if (rsocfl == NULL) {
    if (rsoc_count >= rsoc_count_ceil) {
      if (rsoc_count_ceil < RSOC_LIMIT) {
	rsoc_count_ceil <<= 1;
      }
      else {
	unsigned int c = rsoc_count + (rsoc_count / 3);
	if (rsoc_count_ceil < c) {
	  rsoc_count_ceil = c;
	}
      }
    }
  }
  else {
    if (rsoc_count_ceil < rsoc_count) {
      rsoc_count_ceil = rsoc_count;
    }
  }
}

static void gc_add_into_gcmt(mch*c) {
  /* Update the `gcmt' (Garbage Collector Main Table) by adding the
     new `mch' (Memory Chunk Header).
  */
  mch** p;
  if (gcmt_used == gcmt_max) {
    gcmt_max <<= 1;
    gcmt = ((mch**)(se_realloc(gcmt,(gcmt_max+1)*sizeof(void*))));
  }
  for (p=gcmt+(gcmt_used++ -1) ; (p>=gcmt)&&(*p>c) ; p--) {
    *(p+1) = *p;
  }
  *(p+1) = c;
}

static char*rso_from_store(na_env*nae,unsigned int size) {
  rsoh*r=(nae->store);
  nae->store_left-=size;
  if ((nae->store_left) > sizeof(rsoh)) {
    r->header.size=size;
    nae->store=((rsoh*)(((char*)(nae->store))+size));
  }
  else {
    r->header.size=size+nae->store_left;
    nae->store_left=0;
  }
  (r->header.magic_flag)=RSOH_UNMARKED;
  ((void)memset((r+1),0,r->header.size-sizeof(rsoh)));
  return (char*)(r+1);
}

static void rsoc_sweep(rsoc*c) {
  na_env*nae=c->nae;
  rsoh*gp=(rsoh*)&(c->first_header);
  rsoh*pp;
  rsoh*eoc=((rsoh*)(((char*)c)+c->header.size));
  c->free_list_of_large=NULL;
  if (c->header.size > RSOC_SIZE) {
    if (gp->header.magic_flag == RSOH_MARKED) {
      gp->header.magic_flag=RSOH_UNMARKED;
      c->next=nae->chunk_list;
      nae->chunk_list=c;
    }
    else {
      c->header.state_type=RSO_FREE_CHUNK;
    }
    return;
  }
  while (gp<eoc) {
    while (gp->header.magic_flag == RSOH_MARKED) {
      gp->header.magic_flag=RSOH_UNMARKED;
      gp=((rsoh*)(((char*)gp)+gp->header.size));
      if(gp>=eoc) {
	c->next=nae->chunk_list;
	nae->chunk_list=c;
	return;
      }
    }
    gp->header.magic_flag=RSOH_FREE;
    pp=(rsoh*)(((char*)gp)+gp->header.size);
    while ((pp<eoc)&&(pp->header.magic_flag != RSOH_MARKED)) {
      pp->header.magic_flag=RSOH_FREE;
      gp->header.size+=pp->header.size;
      pp=((rsoh*)(((char*)pp)+pp->header.size));
    }
    if (gp->header.size >= RSOC_MIN_STORE) {
      if (nae->store_left==0) {
	nae->store_left=gp->header.size;
	nae->store=gp;
	nae->store_chunk=c;
      }
      else if (nae->store->header.size < gp->header.size) {
	((fll_rsoh*)nae->store)->nextflol=nae->store_chunk->free_list_of_large;
	nae->store_chunk->free_list_of_large=((fll_rsoh*)nae->store);
	nae->store_left=gp->header.size;
	nae->store=gp;
	nae->store_chunk=c;
      }
      else {
	((fll_rsoh*)gp)->nextflol=c->free_list_of_large;
	c->free_list_of_large=((fll_rsoh*)gp);
      }
    }
    gp=pp;
  }
  if (((rsoh*)(&c->first_header))->header.size >=
      (c->header.size-sizeof(rsoc)+sizeof(rsoh))){
    c->header.state_type=RSO_FREE_CHUNK;
    nae->store_chunk=NULL;
    nae->store_left=0;
  }
  else{
    c->next=nae->chunk_list;
    nae->chunk_list=c;
  }
}

static const rsoc MRSOC = {
    {
	RSOC_SIZE,
	RSO_USED_CHUNK,
	((void(*)(mch*,void*))gcna_align_mark),
	((void(*)(mch*))rsoc_sweep)
    },
    0,
    NULL,
    NULL,
    NULL,
    {
      {
	0,
	RSOH_MARKED
      }
    }
};

static void rsoc_malloc(na_env*nae) {
  rsoc* r = ((rsoc*)(se_malloc(RSOC_SIZE)));
  rsoc_count++;
  *r=MRSOC;
  r->nae=nae;
  r->isize=RSOC_SIZE;
  nae->store=(&(r->first_header));
  nae->store_left=RSOC_SIZE-sizeof(rsoc)+sizeof(rsoh);
  nae->store_chunk=r;
  r->next=nae->chunk_list;
  nae->chunk_list=r;
  gc_add_into_gcmt((mch*)r);
}

static rsoc* rsocfl_best_fit(unsigned int size) {
  unsigned int best_size = 0;
  rsoc *pc,*best_pc,*best_c, *c;
  if (rsocfl==NULL)
    return NULL;
  pc=NULL;
  best_pc=NULL;
  best_c=NULL;
  c=rsocfl;
  while ((NULL!=c)&&(NULL==best_c)){
    if (c->header.size>=size){
      best_c=c;
      best_pc=pc;
      best_size=c->header.size;
    }
    pc=c;
    c=c->next;
  }
  if (NULL==c){
    if (best_pc != NULL)
      best_pc->next=best_c->next;
    else if (best_c==rsocfl)
      rsocfl=best_c->next;
    return best_c;
  }
  do {
    if ((c->header.size >= size) && (c->header.size < best_size)) {
      best_c = c;
      best_pc = pc;
      best_size = c->header.size;
    }
    pc=c;
    c=c->next;
  }
  while(c!=NULL);
  if (NULL==best_pc) {
    rsocfl = best_c->next;
  }
  else {
    best_pc->next=best_c->next;
  }
  return best_c;
}

static int get_store_in(rsoc*c,unsigned int size) {
  na_env*nae=c->nae;
  fll_rsoh*pf=NULL;
  fll_rsoh*f=c->free_list_of_large;
  while (f != NULL) {
    if (f->rsoh_field.size >= size) {
      nae->store_left=f->rsoh_field.size;
      nae->store=(rsoh*)f;
      nae->store_chunk=c;
      if (pf == NULL) {
	c->free_list_of_large=f->nextflol;
      }
      else {
	pf->nextflol=f->nextflol;
      }
      return 1;
    }
    pf = f;
    f = f->nextflol;
  }
  return 0;
}

char*new_na_from_chunk_list(na_env*nae,unsigned int size) {
  rsoc*c=nae->chunk_list;
  unsigned int csize;
  while (c != NULL) {
    if (get_store_in(c,size)) {
      return rso_from_store(nae,size);
    }
    c = c->next;
  }
  csize=size+(sizeof(rsoc)-sizeof(rsoh));
  c=rsocfl_best_fit(csize);
  if (c != NULL){
    if ((c->header.size > RSOC_SIZE)
	&&
	(c->header.size-csize > RSOC_MIN_STORE*4)) {
      int csize_left=c->header.size-csize;
      if ((csize_left%sizeof(double))!=0) {
	csize_left-=(csize_left%sizeof(double));
	csize=c->header.size-csize_left;
      }
      c->header.size=csize_left;
      c->next=rsocfl;
      rsocfl=c;
      c=(rsoc*)(((char*)c)+csize_left);
      gc_add_into_gcmt((mch*)c);
      c->header.amfp=(void(*)(mch*,void*))gcna_align_mark;
      c->header.swfp=(void(*)(mch*))rsoc_sweep;
    }
    else {
      csize=c->header.size;
    }
    c->header.size=csize;
    c->header.state_type=RSO_USED_CHUNK;
    c->free_list_of_large=NULL;
    c->nae=nae;
    nae->store=(&(c->first_header));
    nae->store_left=csize-sizeof(rsoc)+sizeof(rsoh);
    nae->store_chunk=c;
    c->next=nae->chunk_list;
    nae->chunk_list=c;
    return rso_from_store(nae,size);
  }
  return NULL;
}

char*new_na(na_env*nae,unsigned int size) {
  if (nae->store_left>0) {
    nae->store->header.size=nae->store_left;
    nae->store->header.magic_flag=RSOH_FREE;
    if (nae->store_left >= RSOC_MIN_STORE) {
      ((fll_rsoh*)(nae->store))->nextflol=nae->store_chunk->free_list_of_large;
      nae->store_chunk->free_list_of_large=((fll_rsoh*)nae->store);
    }
    nae->store_left=0;
  }
  if ((nae->store_chunk!=NULL)&&(get_store_in(nae->store_chunk,size))) {
    return rso_from_store(nae,size);
  }
  {
    char*r=new_na_from_chunk_list(nae,size);
    if (r!=NULL)
      return r;
  }
  if (rsoc_count<rsoc_count_ceil) {
    if((size+sizeof(rsoc)-sizeof(rsoh))>RSOC_SIZE){
      rsoc*c;
      rsoh*r;
      unsigned int rounded_size= chunk_rounded(size+sizeof(rsoc)-sizeof(rsoh));
      c=((rsoc*)(se_malloc(rounded_size)));
      r=(&(c->first_header));
      rsoc_count++;
      *c=MRSOC;
      c->isize = rounded_size;
      c->header.size=rounded_size;
      c->nae=nae;
      c->next=nae->chunk_list;
      nae->chunk_list=c;
      gc_add_into_gcmt((mch*)c);
      r->header.size=size;
      (r->header.magic_flag)=RSOH_UNMARKED;
      ((void)memset((r+1),0,size-sizeof(rsoh)));
      return (char*)(r+1);
    }
    else {
      rsoc_malloc(nae);
      return rso_from_store(nae,size);
    }
  }
  gc_start();
  if (size<=(nae->store_left)) {
    return rso_from_store(nae,size);
  }
  {
    char*r=new_na_from_chunk_list(nae,size);
    if (r!=NULL) {
      return r;
    }
  }
  if((size+sizeof(rsoc)-sizeof(rsoh))>RSOC_SIZE){
    rsoc*c;
    rsoh*r;
    unsigned int rounded_size = chunk_rounded(size+sizeof(rsoc)-sizeof(rsoh));
    c=((rsoc*)(se_malloc(rounded_size)));
    r=(&(c->first_header));
    rsoc_count++;
    *c=MRSOC;
    c->isize = rounded_size;
    c->header.size=rounded_size;
    c->nae=nae;
    c->next=nae->chunk_list;
    nae->chunk_list=c;
    gc_add_into_gcmt((mch*)c);
    r->header.size=size;
    (r->header.magic_flag)=RSOH_UNMARKED;
    ((void)memset((r+1),0,size-sizeof(rsoh)));
    gc_update_ceils();
    return (char*)(r+1);
  }
  else {
    rsoc_malloc(nae);
    gc_update_ceils();
    return rso_from_store(nae,size);
  }
}

static void gcna_align_mark(rsoc*c,void*o) {
  na_env* nae = c->nae;
  fll_rsoh* f;
  fll_rsoh* pf;
  char* b = (char*)&(c->first_header);

  /* properly aligned ? */
  if (((((char*)o)-((char*)c))%sizeof(int)) != 0) {
      return;
  }
  /* already marked ? */
  if ((((rsoh*)o)-1)->header.magic_flag != RSOH_UNMARKED) {
      return;
  }
  if (((char*)o) < ((char*)(c+1))) {
      return;
  }
  /* a large chunck ? */
  if (c->header.size > RSOC_SIZE) {
      if (o == (c+1)) {
	nae->gc_mark((T0*)o);
      }
      return;
  }
  pf=NULL;
  f=c->free_list_of_large;
  while ((f != NULL) && (f < ((fll_rsoh*)o))) {
      pf=f;
      f=f->nextflol;
  }
  if (pf == NULL) {
      pf=(fll_rsoh*)b;
  }
  while ((((rsoh*)pf)+1) < (rsoh*)o) {
      pf = ((fll_rsoh*)(((char*)pf)+pf->rsoh_field.size));
  }
  if (o == (((rsoh*)pf)+1)) {
    nae->gc_mark((T0*)o);
  }
}

unsigned int rsocfl_count(void) {
  /* Returns the number of items in the ReSizable Object Free List.
  */
  unsigned int r=0;
  rsoc*p=rsocfl;
  while (p!=NULL) {
    r++;
    p=p->next;
  }
  return r;
}

unsigned int fsocfl_count(void) {
  unsigned int r=0;
  fsoc*p=fsocfl;
  while (p!=NULL) {
    r++;
    p=p->next;
  }
  return r;
}

void gc_dispose_before_exit(void) {
  mch** p = gcmt;
  mch**eogcmt=gcmt+gcmt_used;

  while (p < eogcmt) {
    if (((*p)->state_type == FSO_STORE_CHUNK) ||
	((*p)->state_type == FSO_USED_CHUNK)) {
      ((*p)->swfp)(*p);
    }
    p++;
  }
}

fsoc* gc_fsoc_get1(void) {
  /* Get a `fsoc' (Fixed Size Object Chunk) from the free fsoc list or
     allocate a new one (using `se_malloc') only when the ceil is not
     yet reached. Otherwise, call the `gc_start()' function and
     return NULL.
  */
  fsoc* result;
  if (fsocfl != NULL) {
    result = fsocfl;
    fsocfl = fsocfl->next;
    return result;
  }
  else if (fsoc_count_ceil > fsoc_count) {
    result = ((fsoc*)se_malloc(FSOC_SIZE));
    fsoc_count++;
    gc_add_into_gcmt((mch*)result);
    return result;
  }
  else {
    gc_start();
    return NULL;
  }
}

fsoc* gc_fsoc_get2(void) {
  /* Get a `fsoc' (Fixed Size Object Chunk) or force the allocation of a
     new `fsoc' (using the `se_malloc' function). Update various ceils
     accordingly.
  */
  fsoc* result;
  if (fsocfl != NULL) {
    result = fsocfl;
    fsocfl=fsocfl->next;
    return result;
  }
  else {
    result = ((fsoc*)(se_malloc(FSOC_SIZE)));
    fsoc_count++;
    gc_update_ceils();
    gc_add_into_gcmt((mch*)result);
    return result;
  }
}

#if defined(__sparc__) || defined(sparc) || defined(__sparc)
/* For SPARC architecture.
   As this part contains assembly code (asm), you must not use
   the flag -ansi of gcc compiler.
*/

void mark_loop(void) {
  void** max = stack_bottom;
  void** stack_pointer;
  void* stack_top[2]={NULL,NULL};
  stack_pointer = stack_top;
  /* Addresses decrease as the stack grows. */
  while (stack_pointer <= max) {
    gc_mark(*(stack_pointer++));
  }
}

void mark_stack_and_registers(void) {
#  if defined(__sparcv9)
  asm(" flushw");
#  else
  asm(" ta      0x3   ! ST_FLUSH_WINDOWS");
#  endif
  mark_loop();
}

#elif defined(__ELATE__) || defined(ELATE)
/* GNU Eiffel's VP (Virtual Processor) garbage collector for Elate.
   (c) 2000 Rudi Chiarito <rudi@amiga.com>

   Thanks to Andy Stout and Kevin Croombs at Tao Group for their
   precious help!

   ChangeLog:
   - 2000-06-12 Rudi Chiarito <rudi@amiga.com>
     * Version 1.0
   - 2001-01-01 Joseph Kiniry <kiniry@acm.org>
     * Integrated with new SE 0.75b
   - 2001-08-10 Rudi Chiarito <rudi@amiga.com>
     * Inlined and optimised range marking
     * Added some more comments
     * Added conditional breakpoint in mark_stack_and_registers
   - 2002-09-21 Rudi Chiarito <rudi@amiga.com>
     * Removed redundant 'ret'
*/

__inline__ void mark_stack_and_registers(void)
{

  void *pointer_to_gc_mark = &gc_mark;

  __asm__ __volatile__
  (
    /*
      WARNING: funky code ahead!
      \t and \n are needed to make the final output easier to read
      while debugging. Hopefully you'll never have to bother with all
      of this.

      Registers:
        p0  pointer to stack block
        p1  pointer to gc_mark()
        p2  scratch pointer
        i0  length of current stack block
        i1  scratch register
    */

#  ifdef __ELATE_SE_DEBUG_GC
   "\tqcall sys/cii/breakpt,(-:-)\n"
#  endif

   "\tsync\n"                          /* spill all the registers */
   "\tsyncreg\n"                       /* to the stack */

   "\tcpy.p %0,p1\n"                   /* pointer to gc_mark() */

   /* pointer to the current stack block */
   "\tcpy.p [gp+PROC_STACK],p0\n"

   /* point to last location in the block, before the descriptor */
   "\tcpy.p p0 + ([(p0 - STK_SIZE) + STK_LENGTH] - STK_SIZE - 4),p2\n"

   /* mark the contents of the current stack block */
   "\twhile p2>=sp\n"
      "\t\tgos p1,(p2 : -)\n"
      "\t\tsub.p 4,p2\n"
   "\tendwhile\n"

   /* now scan other blocks (if any) */

   "\tloop\n"
      "\t\tcpy.p [p0 - STK_SIZE + STK_LINK],p0\n" /* get next block */
      "\t\tbreakif p0=NULL\n"

      /* point to last location in the block, before the descriptor */
      "\t\tcpy.p p0 + ([(p0 - STK_SIZE) + STK_LENGTH] - STK_SIZE - 4),p2\n"

      /* mark this block */
      "\t\twhile p2>=p0\n"

         "\t\t\tgos p1,(p2 : -)\n"
         "\t\t\tsub.p 4,p2\n"
      "\t\tendwhile\n"
   "\tendloop\n"

   : /* no output */
   : "p" (pointer_to_gc_mark)
   : "p0", "p1", "p2", "i0" 
   );
}

#elif defined(__hppa__) || defined(__hppa) || defined(__hp9000) || \
      defined(__hp9000s300) || defined(hp9000s300) || \
      defined(__hp9000s700) || defined(hp9000s700) || \
      defined(__hp9000s800) || defined(hp9000s800) || defined(hp9000s820)

/****************************************************************************
 * Generic code for architectures where addresses increase as the stack grows.
 ****************************************************************************/

void mark_stack_and_registers(void){
  void** max = stack_bottom;
  JMP_BUF registers;   /* The jmp_buf buffer is in the C stack. */
  void**stack_pointer; /* Used to traverse the stack and registers assuming
			  that `setjmp' will save registers in the C stack.
		       */

  (void)SETJMP(registers);  /* To fill the C stack with registers. */
  stack_pointer = (void**)(&registers) + ((sizeof(JMP_BUF)/sizeof(void*))-1);
  /* stack_pointer will traverse the JMP_BUF as well (jmp_buf size is added, 
     otherwise stack_pointer would be below the registers structure). */

#  if !defined(SE_BOOST)
  if (stack_pointer < max) {
    fprintf(stderr, "Wrong stack direction: your stack decrease as the stack grows (or complex stack management). Please drop an e-mail to SmartEiffel@loria.fr\n");
    exit(1); }
#  endif

  while (stack_pointer >= max) {
    gc_mark(*(stack_pointer--));
  }
}
#else

/****************************************************************************
 * Generic code for architectures where addresses decrease as the stack grows.
 ****************************************************************************/

void mark_stack_and_registers(void){
  void** max = stack_bottom;
  JMP_BUF registers;   /* The jmp_buf buffer is in the C stack. */
  void**stack_pointer; /* Used to traverse the stack and registers assuming
			  that `setjmp' will save registers in the C stack.
		       */

  (void)SETJMP(registers);  /* To fill the C stack with registers. */
  stack_pointer = (void**)(&registers);

#  if !defined(SE_BOOST)
  if (stack_pointer > max) {
    fprintf(stderr, "Wrong stack direction: the stack addresses increase as the stack grows (or complex stack management). Please drop an e-mail to SmartEiffel@loria.fr\n");
    exit(1); }
#  endif

  while (stack_pointer <= max) {
    gc_mark(*(stack_pointer++));
  }
}
#endif

/*
-- This file is  free  software, which  comes  along  with  SmartEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of
-- another product.
--       Copyright (C) 1994-2002 LORIA - INRIA - U.H.P. Nancy 1 - FRANCE
--          Dominique COLNET and Suzanne COLLIN - SmartEiffel@loria.fr
--                       http://SmartEiffel.loria.fr
--
*/
/*
  This file (SmartEiffel/sys/runtime/basic_io.c) is automatically
  included when some external "SmartEiffel" basic_io_* feature is used.
*/

#if defined __USE_POSIX || defined __unix__ || defined _POSIX_C_SOURCE
/* macro read is used of basic_io_read_stdin */
#else
int basic_io_read_stdin(char *buffer, int size) {
  int c;
  c = getc(stdin);
  if (c==EOF)
    return 0;
  *buffer = (char)c;
  return 1;
}
#endif

/*
-- This file is  free  software, which  comes  along  with  SmartEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of
-- another product.
--       Copyright (C) 1994-2002 LORIA - INRIA - U.H.P. Nancy 1 - FRANCE
--          Dominique COLNET and Suzanne COLLIN - SmartEiffel@loria.fr
--                       http://SmartEiffel.loria.fr
--
*/
/*
  This file (SmartEiffel/sys/runtime/basic_time.c) is automatically
  included when some external "SmartEiffel" basic_time_* feature is
  used (i.e. in live code).
*/

EIF_DOUBLE basic_time_difftime(time_t t2, time_t t1) {
  return difftime((time_t)t2, (time_t)t1);
}

EIF_INTEGER basic_time_getyear(time_t t, EIF_INTEGER m) {
  if (m == 1) {
    return (gmtime((time_t *)(&t)))->tm_year + 1900;
  }
  else {
    return (localtime((time_t *)(&t)))->tm_year + 1900;
  }
}

EIF_INTEGER basic_time_getmonth(time_t t, EIF_INTEGER m) {
  if (m == 1) {
    return (gmtime((time_t *)(&t)))->tm_mon + 1;
  }
  else {
    return (localtime((time_t *)(&t)))->tm_mon + 1;
  }
}

EIF_INTEGER basic_time_getday(time_t t, EIF_INTEGER m) {
  if (m == 1) {
    return (gmtime((time_t *)(&t)))->tm_mday;
  }
  else {
    return (localtime((time_t *)(&t)))->tm_mday;
  }
}

EIF_INTEGER basic_time_gethour(time_t t, EIF_INTEGER m) {
  if (m == 1) {
    return (gmtime((time_t *)(&t)))->tm_hour;
  }
  else {
    return (localtime((time_t *)(&t)))->tm_hour;
  }
}

EIF_INTEGER basic_time_getminute(time_t t, EIF_INTEGER m) {
  if (m == 1) {
    return (gmtime((time_t *)(&t)))->tm_min;
  }
  else {
    return (localtime((time_t *)(&t)))->tm_min;
  }
}

EIF_INTEGER basic_time_getsecond(time_t t, EIF_INTEGER m) {
  if (m == 1) {
    return (gmtime((time_t *)(&t)))->tm_sec;
  }
  else {
    return (localtime((time_t *)(&t)))->tm_sec;
  }
}

EIF_INTEGER basic_time_getwday(time_t t, EIF_INTEGER m) {
  if (m == 1) {
    return (gmtime((time_t *)(&t)))->tm_wday;
  }
  else {
    return (localtime((time_t *)(&t)))->tm_wday;
  }
}

EIF_INTEGER basic_time_getyday(time_t t, EIF_INTEGER m) {
  if (m == 1) {
    return (gmtime((time_t *)(&t)))->tm_yday;
  }
  else {
    return (localtime((time_t *)(&t)))->tm_yday;
  }
}

EIF_BOOLEAN basic_time_is_summer_time_used(time_t t) {
  return (EIF_BOOLEAN)(((localtime((time_t *)(&t)))->tm_isdst) != 0);
}

EIF_INTEGER_64 basic_time_mktime(EIF_INTEGER year,
			     EIF_INTEGER mon,
			     EIF_INTEGER mday,
			     EIF_INTEGER hour,
			     EIF_INTEGER min,
			     EIF_INTEGER sec) {
  struct tm tm_buf;

  tm_buf.tm_year  = (year - 1900);
  tm_buf.tm_mon   = (mon - 1);
  tm_buf.tm_mday  = mday;
  tm_buf.tm_hour  = hour;
  tm_buf.tm_min   = min;
  tm_buf.tm_sec   = sec;
  tm_buf.tm_isdst = -1;

  return (EIF_INTEGER_64)mktime(&tm_buf);
}

void basic_time_add_second(EIF_INTEGER_64 *t, EIF_INTEGER s) {
  *t += s;
}
unsigned int fsoc_count_ceil=564;
unsigned int rsoc_count_ceil=51;

/*BOOLEAN*/
T6 r6_ix_and(T6 C,T6 a1){
T6 R=0;
/*l39c10/boolean.e*/
R=((T6)((T6)((C)&&((T6)(a1)))));
return R;
}

/*BOOLEAN*/
T6 r6_ix_xor(T6 C,T6 a1){
T6 R=0;
/*l70c3/boolean.e*/
R=((T6)((C)!=(a1)));
return R;
}

/*BOOLEAN*/
T0* r6to_string(T6 C){
T0* R=NULL;
/*l81c10/boolean.e*/
/*[IF*/
if((/*RF2*/C)){
/*l82c13/boolean.e*/
R=ms6_14036;
}
else{
/*l84c13/boolean.e*/
R=ms6_59251;
}
/*FI]*/
return R;
}

/*BOOLEAN*/
T6 r6_px_not(T6 C){
T6 R=0;
/*l76c3/boolean.e*/
R=((T6)((C)==(0)));
return R;
}

/*BOOLEAN*/
T6 r6_ix_or(T6 C,T6 a1){
T6 R=0;
/*l59c10/boolean.e*/
R=((T6)((T6)((C)||((T6)(a1)))));
return R;
}

/*CHARACTER*/
T6 r3is_bit(T3 C){
T6 R=0;
/*l277c10/character.e*/
/*[INSPECT*/
{int z1=(/*RF2*/C);
switch(z1){
case 48:
case 49:
/*l280c13/character.e*/
R=((T6)(1));
break;
}
}/*INSPECT]*/
return R;
}

/*CHARACTER*/
T6 r3is_digit(T3 C){
T6 R=0;
/*l181c10/character.e*/
/*[IF*/
if((((unsigned)((/*RF2*/C)))>=((unsigned)(((T3)'0'))))){
/*l182c13/character.e*/
R=((T6)((((unsigned)((/*RF2*/C)))<=((unsigned)(((T3)'9'))))));
}
/*FI]*/
return R;
}

/*CHARACTER*/
T6 r3is_separator(T3 C){
T6 R=0;
/*l247c10/character.e*/
/*[INSPECT*/
{int z1=(/*RF2*/C);
switch(z1){
case 0:
case 9:
case 10:
case 12:
case 13:
case 32:
/*l250c13/character.e*/
R=((T6)(1));
break;
}
}/*INSPECT]*/
return R;
}

/*CHARACTER*/
T1 r3octal_value(T3 C){
T1 R=0;
/*l100c10/character.e*/
R=/*(IRF4.6-*/(int8_t)(((/*RF2*/((EIF_INTEGER_8)(T3code(C)))))-(INT8_C(48)))/*)*/;
return R;
}

/*CHARACTER*/
T6 r3is_hexadecimal_digit(T3 C){
T6 R=0;
/*l211c10/character.e*/
/*[IF*/
if(r3is_digit(C)){
/*l212c13/character.e*/
R=((T6)(1));
}
 else if((((unsigned)((/*RF2*/C)))>=((unsigned)(((T3)'a'))))){
/*l214c13/character.e*/
R=((T6)((((unsigned)((/*RF2*/C)))<=((unsigned)(((T3)'f'))))));
}
 else if((((unsigned)((/*RF2*/C)))>=((unsigned)(((T3)'A'))))){
/*l216c13/character.e*/
R=((T6)((((unsigned)((/*RF2*/C)))<=((unsigned)(((T3)'F'))))));
}
/*FI]*/
return R;
}

/*CHARACTER*/
T6 r3is_octal_digit(T3 C){
T6 R=0;
/*l201c10/character.e*/
/*[IF*/
if((((unsigned)((/*RF2*/C)))>=((unsigned)(((T3)'0'))))){
/*l202c13/character.e*/
R=((T6)((((unsigned)((/*RF2*/C)))<=((unsigned)(((T3)'7'))))));
}
/*FI]*/
return R;
}

/*CHARACTER*/
T6 r3_ix_6061(T3 C,T3 a1){
T6 R=0;
/*l60c10/character.e*/
R=((T6)((int16_t)((T3code(C))<=(T3code(a1)))));
return R;
}

/*CHARACTER*/
T1 r3value(T3 C){
T1 R=0;
/*l80c10/character.e*/
R=/*(IRF4.6-*/(int8_t)(((/*RF2*/((EIF_INTEGER_8)(T3code(C)))))-(INT8_C(48)))/*)*/;
return R;
}

/*CHARACTER*/
T6 r3is_letter(T3 C){
T6 R=0;
/*l169c10/character.e*/
/*[IF*/
if((((unsigned)((/*RF2*/C)))>=((unsigned)(((T3)'a'))))){
/*l170c13/character.e*/
R=((T6)((((unsigned)((/*RF2*/C)))<=((unsigned)(((T3)'z'))))));
}
 else if((((unsigned)((/*RF2*/C)))>=((unsigned)(((T3)'A'))))){
/*l172c13/character.e*/
R=((T6)((((unsigned)((/*RF2*/C)))<=((unsigned)(((T3)'Z'))))));
}
/*FI]*/
return R;
}

/*CHARACTER*/
T1 r3decimal_value(T3 C){
T1 R=0;
/*l80c10/character.e*/
R=/*(IRF4.6-*/(int8_t)(((/*RF2*/((EIF_INTEGER_8)(T3code(C)))))-(INT8_C(48)))/*)*/;
return R;
}

/*CHARACTER*/
T6 r3_ix_6261(T3 C,T3 a1){
T6 R=0;
/*l72c10/character.e*/
R=((T6)((int16_t)((T3code(C))>=(T3code(a1)))));
return R;
}

/*CHARACTER*/
T3 r3to_upper(T3 C){
T3 R=0;
/*l145c10/character.e*/
/*[IF*/
if((int16_t)((T3code(C))<(INT8_C(97)))){
/*l146c13/character.e*/
R=(/*RF2*/C);
}
 else if((int16_t)((T3code(C))>(INT8_C(122)))){
/*l148c13/character.e*/
R=(/*RF2*/C);
}
else{
/*l150c13/character.e*/
R=((T3)(/*(IRF4.6-*/(int16_t)(((/*RF2*/T3code(C)))-(INT8_C(32)))/*)*/));
}
/*FI]*/
return R;
}

/*CHARACTER*/
T6 r3is_upper(T3 C){
T6 R=0;
/*l236c10/character.e*/
/*[INSPECT*/
{int z1=(/*RF2*/C);
switch(z1){
case 65:
case 66:
case 67:
case 68:
case 69:
case 70:
case 71:
case 72:
case 73:
case 74:
case 75:
case 76:
case 77:
case 78:
case 79:
case 80:
case 81:
case 82:
case 83:
case 84:
case 85:
case 86:
case 87:
case 88:
case 89:
case 90:
/*l239c13/character.e*/
R=((T6)(1));
break;
}
}/*INSPECT]*/
return R;
}

/*CHARACTER*/
T3 r3to_lower(T3 C){
T3 R=0;
/*l157c10/character.e*/
/*[IF*/
if((int16_t)((T3code(C))<(INT8_C(65)))){
/*l158c13/character.e*/
R=(/*RF2*/C);
}
 else if((int16_t)((T3code(C))>(INT8_C(90)))){
/*l160c13/character.e*/
R=(/*RF2*/C);
}
else{
/*l162c13/character.e*/
R=((T3)(/*(IRF4.6+*/(int16_t)(((/*RF2*/T3code(C)))+(INT8_C(32)))/*)*/));
}
/*FI]*/
return R;
}

/*CHARACTER*/
T6 r3_ix_62(T3 C,T3 a1){
T6 R=0;
/*l66c10/character.e*/
R=((T6)((int16_t)((T3code(C))>(T3code(a1)))));
return R;
}

/*CHARACTER*/
T6 r3is_letter_or_digit(T3 C){
T6 R=0;
/*l258c10/character.e*/
R=((T6)((T6)((r3is_letter(C))||((T6)(r3is_digit(C))))));
return R;
}

/*CHARACTER*/
T6 r3is_lower(T3 C){
T6 R=0;
/*l225c10/character.e*/
/*[INSPECT*/
{int z1=(/*RF2*/C);
switch(z1){
case 97:
case 98:
case 99:
case 100:
case 101:
case 102:
case 103:
case 104:
case 105:
case 106:
case 107:
case 108:
case 109:
case 110:
case 111:
case 112:
case 113:
case 114:
case 115:
case 116:
case 117:
case 118:
case 119:
case 120:
case 121:
case 122:
/*l228c13/character.e*/
R=((T6)(1));
break;
}
}/*INSPECT]*/
return R;
}

/*CHARACTER*/
T1 r3hexadecimal_value(T3 C){
T1 R=0;
/*l110c10/character.e*/
R=((EIF_INTEGER_8)(T3code(C)));
/*l111c10/character.e*/
/*[IF*/
if((int16_t)((T3code(C))<(T3code(((T3)'A'))))){
/*l112c13/character.e*/
R=/*(IRF4.6-*/(int8_t)(((/*RF2*/R))-(INT8_C(48)))/*)*/;
}
 else if((int16_t)((T3code(C))<(T3code(((T3)'a'))))){
/*l114c13/character.e*/
R=/*(IRF4.6-*/(int8_t)(((/*RF2*/R))-(INT8_C(55)))/*)*/;
}
else{
/*l116c13/character.e*/
R=/*(IRF4.6-*/(int8_t)(((/*RF2*/R))-(INT8_C(87)))/*)*/;
}
/*FI]*/
return R;
}

/*INTEGER*/
T11 r2_ix_94(T2 C,T2 a1){
T11 R=0;
T2 _i=0;
T11 _k=0;
/*l103c3/integer_general.e*/
_i=a1;
/*l104c3/integer_general.e*/
/*[IF*/
if((_i)==(INT8_C(0))){
/*l105c6/integer_general.e*/
R=INT8_C(1);
}
else{
/*l107c6/integer_general.e*/
R=/*IC*/(T11)((/*RF2*/C));
/*l108c6/integer_general.e*/
/*l109c9/integer_general.e*/
_k=INT8_C(1);
while (!((int32_t)((_i)<=(INT8_C(1)))))
{
/*l113c9/integer_general.e*/
/*[IF*/
if(r2odd(_i)){
/*l114c5/integer_general.e*/
_k=/*(IRF4.6**/(int64_t)(((/*RF2*/_k))*(R))/*)*/;
}
/*FI]*/
/*l116c9/integer_general.e*/
R=/*(IRF4.6**/(int64_t)(((/*RF2*/R))*(R))/*)*/;
/*l117c9/integer_general.e*/
_i=(int32_t)((_i)/(INT8_C(2)));
}
/*l119c6/integer_general.e*/
R=/*(IRF4.6**/(int64_t)(((/*RF2*/R))*(_k))/*)*/;
}
/*FI]*/
return R;
}

/*INTEGER*/
T6 r2is_equal(T2 C,T2 a1){
T6 R=0;
/*l812c3/integer_general.e*/
R=((T6)((r2to_integer_64((/*RF2*/a1)))==(r2to_integer_64((/*RF2*/C)))));
return R;
}
T0*oBC16string_buffer=NULL;

/*INTEGER*/
T2 r2max(T2 C,T2 a1){
T2 R=0;
/*l120c10/comparable.e*/
/*[IF*/
if((int32_t)((C)>=(a1))){
/*l121c13/comparable.e*/
R=C;
}
else{
/*l123c13/comparable.e*/
R=a1;
}
/*FI]*/
return R;
}

/*INTEGER*/
T5 r2to_double(T2 C){
T5 R=0;
/*l222c10/integer_general.e*/
R=/*IC*/(T5)((/*RF2*/C));
return R;
}

/*INTEGER*/
T0* r2to_string(T2 C){
T0* R=NULL;
/*l230c17/integer_general.e*/
/*[IRF3.3clear*/((((T7*)((T7*)(oBC16string_buffer))))->_count/*4*/)=(INT8_C(0));
/*]*/
/*l231c10/integer_general.e*/
r2append_in(C,oBC16string_buffer);
/*l232c10/integer_general.e*/
R=r7twin((T7*)(oBC16string_buffer));
return R;
}

/*INTEGER*/
T5 r2log(T2 C){
T5 R=0;
/*l187c10/integer_general.e*/
R=log(r2to_double(C));
return R;
}

/*INTEGER*/
T6 r2odd(T2 C){
T6 R=0;
/*l165c10/integer_general.e*/
R=((T6)((((/*RF2*/C)&INT8_C(1)))!=(INT8_C(0))));
return R;
}

/*INTEGER*/
T5 r2log10(T2 C){
T5 R=0;
/*l195c10/integer_general.e*/
R=log10(r2to_double(C));
return R;
}

/*INTEGER*/
T3 r2digit(T2 C){
T3 R=0;
/*l526c10/integer_general.e*/
R=((T3)(/*(IRF4.6+*/(int32_t)(((/*RF2*/(/*RF2*/C)))+(/*IC*/(T2)(T3code(((T3)'0')))))/*)*/));
return R;
}

/*INTEGER*/
T0* r2to_string_format(T2 C,T2 a1){
T0* R=NULL;
T2 _i=0;
/*l432c17/integer_general.e*/
/*[IRF3.3clear*/((((T7*)((T7*)(oBC16string_buffer))))->_count/*4*/)=(INT8_C(0));
/*]*/
/*l433c3/integer_general.e*/
r2append_in(C,oBC16string_buffer);
/*l434c10/integer_general.e*/
/*l435c6/integer_general.e*/
{T7*n=new7();
r7make(n,r2max((/*RF2*/((T7*)(oBC16string_buffer))->_count/*4*/),a1));
R=((T0*)n);
}
/*l436c6/integer_general.e*/
_i=/*(IRF4.6-*/(int32_t)(((/*RF2*/a1))-((/*RF2*/((T7*)(oBC16string_buffer))->_count/*4*/)))/*)*/;
while (!((int32_t)((_i)<=(INT8_C(0)))))
{
/*l440c20/integer_general.e*/
r7extend(((T7*)R),((T3)'\040'));
/*l441c6/integer_general.e*/
_i=/*(IRF4.6-*/(int32_t)(((/*RF2*/_i))-(INT8_C(1)))/*)*/;
}
/*l443c17/integer_general.e*/
r7append(((T7*)R),oBC16string_buffer);
return R;
}

/*INTEGER*/
T2 r2hash_code(T2 C){
T2 R=0;
/*l641c3/integer_general.e*/
R=(((EIF_INTEGER_32)((/*RF2*/C)))&/*0x7FFFFFFF*/INT32_C(2147483647));
return R;
}

/*INTEGER*/
void r2append_in(T2 C,T0* a1){
T2 _val=0;
T2 _i=0;
T2 _idx=0;
/*l341c10/integer_general.e*/
/*[IF*/
if(((/*RF2*/C))==(INT8_C(0))){
/*l342c20/integer_general.e*/
r7extend(((T7*)a1),((T3)'0'));
}
else{
/*l344c13/integer_general.e*/
/*[IF*/
if((int32_t)(((/*RF2*/C))>(INT8_C(0)))){
/*l345c16/integer_general.e*/
/*l346c19/integer_general.e*/
_i=/*(IRF4.6+*/(int32_t)(((/*RF2*/(/*RF2*/(((T7*)a1))->_count/*4*/)))+(INT8_C(1)))/*)*/;
/*l347c19/integer_general.e*/
_val=(/*RF2*/C);
while (!((_val)==(INT8_C(0))))
{
/*l351c26/integer_general.e*/
r7extend(((T7*)a1),r2digit((int32_t)((_val)%(/*IC*/(T2)(INT8_C(10))))));
/*l352c19/integer_general.e*/
_val=(int32_t)((_val)/(INT8_C(10)));
}
}
else{
/*l355c23/integer_general.e*/
r7extend(((T7*)a1),((T3)'\055'));
/*l356c16/integer_general.e*/
/*l357c19/integer_general.e*/
_i=/*(IRF4.6+*/(int32_t)(((/*RF2*/(/*RF2*/(((T7*)a1))->_count/*4*/)))+(INT8_C(1)))/*)*/;
/*l358c19/integer_general.e*/
_val=(/*RF2*/C);
while (!((_val)==(INT8_C(0))))
{
/*l362c26/integer_general.e*/
r7extend(((T7*)a1),r2digit(-((int32_t)((_val)%(/*IC*/(T2)(INT8_C(10)))))));
/*l363c19/integer_general.e*/
_val=(int32_t)((_val)/(INT8_C(10)));
}
}
/*FI]*/
/*l366c13/integer_general.e*/
/*l367c16/integer_general.e*/
_idx=(/*RF2*/(((T7*)a1))->_count/*4*/);
while (!((int32_t)((_i)>=(_idx))))
{
/*l371c23/integer_general.e*/
r7swap(((T7*)a1),_i,_idx);
/*l372c16/integer_general.e*/
_idx=/*(IRF4.6-*/(int32_t)(((/*RF2*/_idx))-(INT8_C(1)))/*)*/;
/*l373c16/integer_general.e*/
_i=/*(IRF4.6+*/(int32_t)(((/*RF2*/_i))+(INT8_C(1)))/*)*/;
}
}
/*FI]*/
}

/*INTEGER*/
T5 r2sqrt(T2 C){
T5 R=0;
/*l179c10/integer_general.e*/
R=sqrt(r2to_double(C));
return R;
}

/*INTEGER*/
T2 r2abs(T2 C){
T2 R=0;
/*l128c10/integer_general.e*/
/*[IF*/
if((int32_t)(((/*RF2*/C))<(INT8_C(0)))){
/*l129c13/integer_general.e*/
R=-((/*RF2*/C));
}
else{
/*l131c13/integer_general.e*/
R=C;
}
/*FI]*/
return R;
}

/*INTEGER*/
T3 r2decimal_digit(T2 C){
T3 R=0;
/*l526c10/integer_general.e*/
R=((T3)(/*(IRF4.6+*/(int32_t)(((/*RF2*/(/*RF2*/C)))+(/*IC*/(T2)(T3code(((T3)'0')))))/*)*/));
return R;
}

/*INTEGER*/
T11 r2to_integer_64(T2 C){
T11 R=0;
/*l314c3/integer_general.e*/
R=/*IC*/(T11)(C);
return R;
}

/*DOUBLE*/
T2 r5floor(T5 C){
T2 R=0;
/*l104c10/double.e*/
R=((int)floor(C));
return R;
}

/*DOUBLE*/
T2 r5ceiling(T5 C){
T2 R=0;
T5 _d=0;
/*l121c10/double.e*/
_d=r5double_ceiling(C);
/*l122c10/double.e*/
R=((int)floor(_d));
return R;
}

/*DOUBLE*/
T5 r5double_ceiling(T5 C){
T5 R=0;
/*l113c10/double.e*/
R=ceil(C);
return R;
}

/*INTEGER_64*/
T3 r11digit(T11 C){
T3 R=0;
/*l526c10/integer_general.e*/
R=((T3)(/*(IRF4.6+*/(int64_t)(((/*RF2*/(/*RF2*/C)))+(/*IC*/(T11)(T3code(((T3)'0')))))/*)*/));
return R;
}

/*INTEGER_64*/
void r11append_in(T11 C,T0* a1){
T11 _val=0;
T2 _i=0;
T2 _idx=0;
/*l341c10/integer_general.e*/
/*[IF*/
if(((/*RF2*/C))==(INT8_C(0))){
/*l342c20/integer_general.e*/
r7extend(((T7*)a1),((T3)'0'));
}
else{
/*l344c13/integer_general.e*/
/*[IF*/
if((int64_t)(((/*RF2*/C))>(INT8_C(0)))){
/*l345c16/integer_general.e*/
/*l346c19/integer_general.e*/
_i=/*(IRF4.6+*/(int32_t)(((/*RF2*/(/*RF2*/(((T7*)a1))->_count/*4*/)))+(INT8_C(1)))/*)*/;
/*l347c19/integer_general.e*/
_val=(/*RF2*/C);
while (!((_val)==(INT8_C(0))))
{
/*l351c26/integer_general.e*/
r7extend(((T7*)a1),r11digit((int64_t)((_val)%(/*IC*/(T11)(INT8_C(10))))));
/*l352c19/integer_general.e*/
_val=(int64_t)((_val)/(INT8_C(10)));
}
}
else{
/*l355c23/integer_general.e*/
r7extend(((T7*)a1),((T3)'\055'));
/*l356c16/integer_general.e*/
/*l357c19/integer_general.e*/
_i=/*(IRF4.6+*/(int32_t)(((/*RF2*/(/*RF2*/(((T7*)a1))->_count/*4*/)))+(INT8_C(1)))/*)*/;
/*l358c19/integer_general.e*/
_val=(/*RF2*/C);
while (!((_val)==(INT8_C(0))))
{
/*l362c26/integer_general.e*/
r7extend(((T7*)a1),r11digit(-((int64_t)((_val)%(/*IC*/(T11)(INT8_C(10)))))));
/*l363c19/integer_general.e*/
_val=(int64_t)((_val)/(INT8_C(10)));
}
}
/*FI]*/
/*l366c13/integer_general.e*/
/*l367c16/integer_general.e*/
_idx=(/*RF2*/(((T7*)a1))->_count/*4*/);
while (!((int32_t)((_i)>=(_idx))))
{
/*l371c23/integer_general.e*/
r7swap(((T7*)a1),_i,_idx);
/*l372c16/integer_general.e*/
_idx=/*(IRF4.6-*/(int32_t)(((/*RF2*/_idx))-(INT8_C(1)))/*)*/;
/*l373c16/integer_general.e*/
_i=/*(IRF4.6+*/(int32_t)(((/*RF2*/_i))+(INT8_C(1)))/*)*/;
}
}
/*FI]*/
}

/*NATIVE_ARRAY[LINKED_LIST[CODE_SLOT]]*/
void r219clear_all(T219 C,T2 a1){
T0* _v=NULL;
T2 _i=0;
/*l358c10/native_array.e*/
/*l358c15/native_array.e*/
_i=a1;
while (!((int32_t)((_i)<(INT8_C(0)))))
{
/*l360c13/native_array.e*/
(C)[_i]=(_v);
/*l361c13/native_array.e*/
_i=/*(IRF4.6-*/(int32_t)(((/*RF2*/_i))-(INT8_C(1)))/*)*/;
}
}

/*NATIVE_ARRAY[LINKED_LIST[CODE_SLOT]]*/
T219 r219realloc(T219 C,T2 a1,T2 a2){
T219 R=NULL;
/*l78c10/native_array.e*/
R=new219(a2);
/*l79c17/native_array.e*/
r219copy_from(R,C,/*(IRF4.6-*/(int32_t)(((/*RF2*/a1))-(/*IC*/(T2)(INT8_C(1))))/*)*/);
return R;
}

/*NATIVE_ARRAY[LINKED_LIST[CODE_SLOT]]*/
void r219clear(T219 C,T2 a1,T2 a2){
T0* _v=NULL;
T2 _i=0;
/*l376c10/native_array.e*/
/*l376c15/native_array.e*/
_i=a1;
while (!((int32_t)((_i)>(a2))))
{
/*l378c13/native_array.e*/
(C)[_i]=(_v);
/*l379c13/native_array.e*/
_i=/*(IRF4.6+*/(int32_t)(((/*RF2*/_i))+(INT8_C(1)))/*)*/;
}
}

/*NATIVE_ARRAY[LINKED_LIST[CODE_SLOT]]*/
void r219copy_from(T219 C,T219 a1,T2 a2){
T2 _i=0;
/*l390c10/native_array.e*/
/*l390c15/native_array.e*/
_i=a2;
while (!((int32_t)((_i)<(INT8_C(0)))))
{
/*l392c13/native_array.e*/
(C)[_i]=((a1)[_i]);
/*l393c13/native_array.e*/
_i=/*(IRF4.6-*/(int32_t)(((/*RF2*/_i))-(INT8_C(1)))/*)*/;
}
}

/*NATIVE_ARRAY[BOOLEAN]*/
void r48clear_all(T48 C,T2 a1){
T6 _v=0;
T2 _i=0;
/*l358c10/native_array.e*/
/*l358c15/native_array.e*/
_i=a1;
while (!((int32_t)((_i)<(INT8_C(0)))))
{
/*l360c13/native_array.e*/
(C)[_i]=((T6)(_v));
/*l361c13/native_array.e*/
_i=/*(IRF4.6-*/(int32_t)(((/*RF2*/_i))-(INT8_C(1)))/*)*/;
}
}

/*NATIVE_ARRAY[ITM_CODE]*/
void r162clear_all(T162 C,T2 a1){
T0* _v=NULL;
T2 _i=0;
/*l358c10/native_array.e*/
/*l358c15/native_array.e*/
_i=a1;
while (!((int32_t)((_i)<(INT8_C(0)))))
{
/*l360c13/native_array.e*/
(C)[_i]=(_v);
/*l361c13/native_array.e*/
_i=/*(IRF4.6-*/(int32_t)(((/*RF2*/_i))-(INT8_C(1)))/*)*/;
}
}

/*NATIVE_ARRAY[ITM_CODE]*/
T162 r162realloc(T162 C,T2 a1,T2 a2){
T162 R=NULL;
/*l78c10/native_array.e*/
R=new162(a2);
/*l79c17/native_array.e*/
r162copy_from(R,C,/*(IRF4.6-*/(int32_t)(((/*RF2*/a1))-(/*IC*/(T2)(INT8_C(1))))/*)*/);
return R;
}

/*NATIVE_ARRAY[ITM_CODE]*/
void r162clear(T162 C,T2 a1,T2 a2){
T0* _v=NULL;
T2 _i=0;
/*l376c10/native_array.e*/
/*l376c15/native_array.e*/
_i=a1;
while (!((int32_t)((_i)>(a2))))
{
/*l378c13/native_array.e*/
(C)[_i]=(_v);
/*l379c13/native_array.e*/
_i=/*(IRF4.6+*/(int32_t)(((/*RF2*/_i))+(INT8_C(1)))/*)*/;
}
}

/*NATIVE_ARRAY[ITM_CODE]*/
void r162copy_from(T162 C,T162 a1,T2 a2){
T2 _i=0;
/*l390c10/native_array.e*/
/*l390c15/native_array.e*/
_i=a2;
while (!((int32_t)((_i)<(INT8_C(0)))))
{
/*l392c13/native_array.e*/
(C)[_i]=((a1)[_i]);
/*l393c13/native_array.e*/
_i=/*(IRF4.6-*/(int32_t)(((/*RF2*/_i))-(INT8_C(1)))/*)*/;
}
}

/*NATIVE_ARRAY[DICTIONARY_NODE[STRING,STRING]]*/
void r118set_all_with(T118 C,T0* a1,T2 a2){
T2 _i=0;
/*l343c10/native_array.e*/
/*l343c15/native_array.e*/
_i=a2;
while (!((int32_t)((_i)<(INT8_C(0)))))
{
/*l345c13/native_array.e*/
(C)[_i]=(a1);
/*l346c13/native_array.e*/
_i=/*(IRF4.6-*/(int32_t)(((/*RF2*/_i))-(INT8_C(1)))/*)*/;
}
}

/*NATIVE_ARRAY[PROTOTYPE]*/
void r39clear_all(T39 C,T2 a1){
T0* _v=NULL;
T2 _i=0;
/*l358c10/native_array.e*/
/*l358c15/native_array.e*/
_i=a1;
while (!((int32_t)((_i)<(INT8_C(0)))))
{
/*l360c13/native_array.e*/
(C)[_i]=(_v);
/*l361c13/native_array.e*/
_i=/*(IRF4.6-*/(int32_t)(((/*RF2*/_i))-(INT8_C(1)))/*)*/;
}
}

/*NATIVE_ARRAY[PROTOTYPE]*/
T39 r39realloc(T39 C,T2 a1,T2 a2){
T39 R=NULL;
/*l78c10/native_array.e*/
R=new39(a2);
/*l79c17/native_array.e*/
r39copy_from(R,C,/*(IRF4.6-*/(int32_t)(((/*RF2*/a1))-(/*IC*/(T2)(INT8_C(1))))/*)*/);
return R;
}

/*NATIVE_ARRAY[PROTOTYPE]*/
void r39copy_from(T39 C,T39 a1,T2 a2){
T2 _i=0;
/*l390c10/native_array.e*/
/*l390c15/native_array.e*/
_i=a2;
while (!((int32_t)((_i)<(INT8_C(0)))))
{
/*l392c13/native_array.e*/
(C)[_i]=((a1)[_i]);
/*l393c13/native_array.e*/
_i=/*(IRF4.6-*/(int32_t)(((/*RF2*/_i))-(INT8_C(1)))/*)*/;
}
}

/*NATIVE_ARRAY[SLOT]*/
void r180clear_all(T180 C,T2 a1){
T0* _v=NULL;
T2 _i=0;
/*l358c10/native_array.e*/
/*l358c15/native_array.e*/
_i=a1;
while (!((int32_t)((_i)<(INT8_C(0)))))
{
/*l360c13/native_array.e*/
(C)[_i]=(_v);
/*l361c13/native_array.e*/
_i=/*(IRF4.6-*/(int32_t)(((/*RF2*/_i))-(INT8_C(1)))/*)*/;
}
}

/*NATIVE_ARRAY[STRING]*/
void r51clear_all(T51 C,T2 a1){
T0* _v=NULL;
T2 _i=0;
/*l358c10/native_array.e*/
/*l358c15/native_array.e*/
_i=a1;
while (!((int32_t)((_i)<(INT8_C(0)))))
{
/*l360c13/native_array.e*/
(C)[_i]=(_v);
/*l361c13/native_array.e*/
_i=/*(IRF4.6-*/(int32_t)(((/*RF2*/_i))-(INT8_C(1)))/*)*/;
}
}

/*NATIVE_ARRAY[STRING]*/
T51 r51realloc(T51 C,T2 a1,T2 a2){
T51 R=NULL;
/*l78c10/native_array.e*/
R=new51(a2);
/*l79c17/native_array.e*/
r51copy_from(R,C,/*(IRF4.6-*/(int32_t)(((/*RF2*/a1))-(/*IC*/(T2)(INT8_C(1))))/*)*/);
return R;
}

/*NATIVE_ARRAY[STRING]*/
void r51clear(T51 C,T2 a1,T2 a2){
T0* _v=NULL;
T2 _i=0;
/*l376c10/native_array.e*/
/*l376c15/native_array.e*/
_i=a1;
while (!((int32_t)((_i)>(a2))))
{
/*l378c13/native_array.e*/
(C)[_i]=(_v);
/*l379c13/native_array.e*/
_i=/*(IRF4.6+*/(int32_t)(((/*RF2*/_i))+(INT8_C(1)))/*)*/;
}
}

/*NATIVE_ARRAY[STRING]*/
void r51copy_from(T51 C,T51 a1,T2 a2){
T2 _i=0;
/*l390c10/native_array.e*/
/*l390c15/native_array.e*/
_i=a2;
while (!((int32_t)((_i)<(INT8_C(0)))))
{
/*l392c13/native_array.e*/
(C)[_i]=((a1)[_i]);
/*l393c13/native_array.e*/
_i=/*(IRF4.6-*/(int32_t)(((/*RF2*/_i))-(INT8_C(1)))/*)*/;
}
}

/*NATIVE_ARRAY[SET_NODE[INTEGER]]*/
void r61set_all_with(T61 C,T0* a1,T2 a2){
T2 _i=0;
/*l343c10/native_array.e*/
/*l343c15/native_array.e*/
_i=a2;
while (!((int32_t)((_i)<(INT8_C(0)))))
{
/*l345c13/native_array.e*/
(C)[_i]=(a1);
/*l346c13/native_array.e*/
_i=/*(IRF4.6-*/(int32_t)(((/*RF2*/_i))-(INT8_C(1)))/*)*/;
}
}

/*NATIVE_ARRAY[CHARACTER]*/
void r9copy_slice(T9 C,T2 a1,T9 a2,T2 a3,T2 a4){
T2 _i1=0;
T2 _i2=0;
/*l321c10/native_array.e*/
/*l322c13/native_array.e*/
_i1=a1;
/*l323c6/native_array.e*/
_i2=a3;
while (!((int32_t)((_i2)>(a4))))
{
/*l327c13/native_array.e*/
(C)[_i1]=((a2)[_i2]);
/*l328c13/native_array.e*/
_i2=/*(IRF4.6+*/(int32_t)(((/*RF2*/_i2))+(INT8_C(1)))/*)*/;
/*l329c13/native_array.e*/
_i1=/*(IRF4.6+*/(int32_t)(((/*RF2*/_i1))+(INT8_C(1)))/*)*/;
}
}

/*NATIVE_ARRAY[CHARACTER]*/
T9 r9realloc(T9 C,T2 a1,T2 a2){
T9 R=NULL;
/*l78c10/native_array.e*/
R=new9(a2);
/*l79c17/native_array.e*/
r9copy_from(R,C,/*(IRF4.6-*/(int32_t)(((/*RF2*/a1))-(/*IC*/(T2)(INT8_C(1))))/*)*/);
return R;
}

/*NATIVE_ARRAY[CHARACTER]*/
void r9move(T9 C,T2 a1,T2 a2,T2 a3){
T2 _i=0;
/*l434c10/native_array.e*/
/*[IF*/
if((a3)==(INT8_C(0))){
}
 else if((int32_t)((a3)<(INT8_C(0)))){
/*l436c13/native_array.e*/
/*l436c18/native_array.e*/
_i=a1;
while (!((int32_t)((_i)>(a2))))
{
/*l438c16/native_array.e*/
(C)[/*(IRF4.6+*/(int32_t)(((/*RF2*/_i))+(a3))/*)*/]=((C)[_i]);
/*l439c16/native_array.e*/
_i=/*(IRF4.6+*/(int32_t)(((/*RF2*/_i))+(INT8_C(1)))/*)*/;
}
}
else{
/*l442c13/native_array.e*/
/*l442c18/native_array.e*/
_i=a2;
while (!((int32_t)((_i)<(a1))))
{
/*l444c16/native_array.e*/
(C)[/*(IRF4.6+*/(int32_t)(((/*RF2*/_i))+(a3))/*)*/]=((C)[_i]);
/*l445c16/native_array.e*/
_i=/*(IRF4.6-*/(int32_t)(((/*RF2*/_i))-(INT8_C(1)))/*)*/;
}
}
/*FI]*/
}

/*NATIVE_ARRAY[CHARACTER]*/
T6 r9fast_memcmp(T9 C,T9 a1,T2 a2){
T6 R=0;
T2 _i=0;
/*l113c10/native_array.e*/
/*l114c13/native_array.e*/
_i=/*(IRF4.6-*/(int32_t)(((/*RF2*/a2))-(INT8_C(1)))/*)*/;
while (!((T6)(((int32_t)((_i)<(INT8_C(0))))||((T6)(((C)[_i])!=((a1)[_i]))))))
{
/*l118c13/native_array.e*/
_i=/*(IRF4.6-*/(int32_t)(((/*RF2*/_i))-(INT8_C(1)))/*)*/;
}
/*l120c10/native_array.e*/
R=((T6)((int32_t)((_i)<(INT8_C(0)))));
return R;
}

/*NATIVE_ARRAY[CHARACTER]*/
void r9fast_replace_all(T9 C,T3 a1,T3 a2,T2 a3){
T2 _i=0;
/*l279c10/native_array.e*/
/*l279c15/native_array.e*/
_i=a3;
while (!((int32_t)((_i)<(INT8_C(0)))))
{
/*l281c13/native_array.e*/
/*[IF*/
if((a1)==((C)[_i])){
/*l282c16/native_array.e*/
(C)[_i]=(a2);
}
/*FI]*/
/*l284c13/native_array.e*/
_i=/*(IRF4.6-*/(int32_t)(((/*RF2*/_i))-(INT8_C(1)))/*)*/;
}
}

/*NATIVE_ARRAY[CHARACTER]*/
T6 r9fast_has(T9 C,T3 a1,T2 a2){
T6 R=0;
T2 _i=0;
/*l207c10/native_array.e*/
/*l208c13/native_array.e*/
_i=a2;
while (!((T6)(((int32_t)((_i)<(INT8_C(0))))||((T6)((a1)==((C)[_i]))))))
{
/*l212c13/native_array.e*/
_i=/*(IRF4.6-*/(int32_t)(((/*RF2*/_i))-(INT8_C(1)))/*)*/;
}
/*l214c10/native_array.e*/
R=((T6)((int32_t)((_i)>=(INT8_C(0)))));
return R;
}

/*NATIVE_ARRAY[CHARACTER]*/
void r9copy_at(T9 C,T2 a1,T9 a2,T2 a3){
T2 _at_idx=0;
T2 _src_idx=0;
/*l299c10/native_array.e*/
/*l300c13/native_array.e*/
_src_idx=/*(IRF4.6-*/(int32_t)(((/*RF2*/a3))-(INT8_C(1)))/*)*/;
/*l301c13/native_array.e*/
_at_idx=/*(IRF4.6+*/(int32_t)(((/*RF2*/a1))+(_src_idx))/*)*/;
while (!((int32_t)((_src_idx)<(INT8_C(0)))))
{
/*l305c13/native_array.e*/
(C)[_at_idx]=((a2)[_src_idx]);
/*l306c13/native_array.e*/
_src_idx=/*(IRF4.6-*/(int32_t)(((/*RF2*/_src_idx))-(INT8_C(1)))/*)*/;
/*l307c13/native_array.e*/
_at_idx=/*(IRF4.6-*/(int32_t)(((/*RF2*/_at_idx))-(INT8_C(1)))/*)*/;
}
}

/*NATIVE_ARRAY[CHARACTER]*/
void r9clear(T9 C,T2 a1,T2 a2){
T3 _v=0;
T2 _i=0;
/*l376c10/native_array.e*/
/*l376c15/native_array.e*/
_i=a1;
while (!((int32_t)((_i)>(a2))))
{
/*l378c13/native_array.e*/
(C)[_i]=(_v);
/*l379c13/native_array.e*/
_i=/*(IRF4.6+*/(int32_t)(((/*RF2*/_i))+(INT8_C(1)))/*)*/;
}
}

/*NATIVE_ARRAY[CHARACTER]*/
void r9copy_from(T9 C,T9 a1,T2 a2){
T2 _i=0;
/*l390c10/native_array.e*/
/*l390c15/native_array.e*/
_i=a2;
while (!((int32_t)((_i)<(INT8_C(0)))))
{
/*l392c13/native_array.e*/
(C)[_i]=((a1)[_i]);
/*l393c13/native_array.e*/
_i=/*(IRF4.6-*/(int32_t)(((/*RF2*/_i))-(INT8_C(1)))/*)*/;
}
}

/*NATIVE_ARRAY[INTEGER]*/
void r43clear_all(T43 C,T2 a1){
T2 _v=0;
T2 _i=0;
/*l358c10/native_array.e*/
/*l358c15/native_array.e*/
_i=a1;
while (!((int32_t)((_i)<(INT8_C(0)))))
{
/*l360c13/native_array.e*/
(C)[_i]=(_v);
/*l361c13/native_array.e*/
_i=/*(IRF4.6-*/(int32_t)(((/*RF2*/_i))-(INT8_C(1)))/*)*/;
}
}

/*NATIVE_ARRAY[INTEGER]*/
T43 r43realloc(T43 C,T2 a1,T2 a2){
T43 R=NULL;
/*l78c10/native_array.e*/
R=new43(a2);
/*l79c17/native_array.e*/
r43copy_from(R,C,/*(IRF4.6-*/(int32_t)(((/*RF2*/a1))-(/*IC*/(T2)(INT8_C(1))))/*)*/);
return R;
}

/*NATIVE_ARRAY[INTEGER]*/
T6 r43fast_memcmp(T43 C,T43 a1,T2 a2){
T6 R=0;
T2 _i=0;
/*l113c10/native_array.e*/
/*l114c13/native_array.e*/
_i=/*(IRF4.6-*/(int32_t)(((/*RF2*/a2))-(INT8_C(1)))/*)*/;
while (!((T6)(((int32_t)((_i)<(INT8_C(0))))||((T6)(((C)[_i])!=((a1)[_i]))))))
{
/*l118c13/native_array.e*/
_i=/*(IRF4.6-*/(int32_t)(((/*RF2*/_i))-(INT8_C(1)))/*)*/;
}
/*l120c10/native_array.e*/
R=((T6)((int32_t)((_i)<(INT8_C(0)))));
return R;
}

/*NATIVE_ARRAY[INTEGER]*/
void r43clear(T43 C,T2 a1,T2 a2){
T2 _v=0;
T2 _i=0;
/*l376c10/native_array.e*/
/*l376c15/native_array.e*/
_i=a1;
while (!((int32_t)((_i)>(a2))))
{
/*l378c13/native_array.e*/
(C)[_i]=(_v);
/*l379c13/native_array.e*/
_i=/*(IRF4.6+*/(int32_t)(((/*RF2*/_i))+(INT8_C(1)))/*)*/;
}
}

/*NATIVE_ARRAY[INTEGER]*/
void r43copy_from(T43 C,T43 a1,T2 a2){
T2 _i=0;
/*l390c10/native_array.e*/
/*l390c15/native_array.e*/
_i=a2;
while (!((int32_t)((_i)<(INT8_C(0)))))
{
/*l392c13/native_array.e*/
(C)[_i]=((a1)[_i]);
/*l393c13/native_array.e*/
_i=/*(IRF4.6-*/(int32_t)(((/*RF2*/_i))-(INT8_C(1)))/*)*/;
}
}

/*NATIVE_ARRAY[RUNTIME]*/
T74 r74realloc(T74 C,T2 a1,T2 a2){
T74 R=NULL;
/*l78c10/native_array.e*/
R=new74(a2);
/*l79c17/native_array.e*/
r74copy_from(R,C,/*(IRF4.6-*/(int32_t)(((/*RF2*/a1))-(/*IC*/(T2)(INT8_C(1))))/*)*/);
return R;
}

/*NATIVE_ARRAY[RUNTIME]*/
void r74remove_first(T74 C,T2 a1){
T2 _i=0;
/*l227c10/native_array.e*/
while (!((_i)==(a1)))
{
/*l229c13/native_array.e*/
(C)[_i]=((C)[/*(IRF4.6+*/(int32_t)(((/*RF2*/_i))+(/*IC*/(T2)(INT8_C(1))))/*)*/]);
/*l230c13/native_array.e*/
_i=/*(IRF4.6+*/(int32_t)(((/*RF2*/_i))+(INT8_C(1)))/*)*/;
}
}

/*NATIVE_ARRAY[RUNTIME]*/
void r74clear(T74 C,T2 a1,T2 a2){
T0* _v=NULL;
T2 _i=0;
/*l376c10/native_array.e*/
/*l376c15/native_array.e*/
_i=a1;
while (!((int32_t)((_i)>(a2))))
{
/*l378c13/native_array.e*/
(C)[_i]=(_v);
/*l379c13/native_array.e*/
_i=/*(IRF4.6+*/(int32_t)(((/*RF2*/_i))+(INT8_C(1)))/*)*/;
}
}

/*NATIVE_ARRAY[RUNTIME]*/
void r74copy_from(T74 C,T74 a1,T2 a2){
T2 _i=0;
/*l390c10/native_array.e*/
/*l390c15/native_array.e*/
_i=a2;
while (!((int32_t)((_i)<(INT8_C(0)))))
{
/*l392c13/native_array.e*/
(C)[_i]=((a1)[_i]);
/*l393c13/native_array.e*/
_i=/*(IRF4.6-*/(int32_t)(((/*RF2*/_i))-(INT8_C(1)))/*)*/;
}
}

/*NATIVE_ARRAY[ANY]*/
T124 r124realloc(T124 C,T2 a1,T2 a2){
T124 R=NULL;
/*l78c10/native_array.e*/
R=new124(a2);
/*l79c17/native_array.e*/
r124copy_from(R,C,/*(IRF4.6-*/(int32_t)(((/*RF2*/a1))-(/*IC*/(T2)(INT8_C(1))))/*)*/);
return R;
}

/*NATIVE_ARRAY[ANY]*/
T2 r124fast_index_of(T124 C,T0* a1,T2 a2){
T2 R=0;
/*l173c10/native_array.e*/
while (!((T6)(((int32_t)((R)>(a2)))||((T6)((a1)==((void*)((C)[R])))))))
{
/*l177c13/native_array.e*/
R=/*(IRF4.6+*/(int32_t)(((/*RF2*/R))+(INT8_C(1)))/*)*/;
}
return R;
}

/*NATIVE_ARRAY[ANY]*/
void r124copy_from(T124 C,T124 a1,T2 a2){
T2 _i=0;
/*l390c10/native_array.e*/
/*l390c15/native_array.e*/
_i=a2;
while (!((int32_t)((_i)<(INT8_C(0)))))
{
/*l392c13/native_array.e*/
(C)[_i]=((a1)[_i]);
/*l393c13/native_array.e*/
_i=/*(IRF4.6-*/(int32_t)(((/*RF2*/_i))-(INT8_C(1)))/*)*/;
}
}

/*STRING*/
void r7copy(T7* C,T0* a1){
T2 _c=0;
/*l968c3/string.e*/
_c=(/*RF2*/(((T7*)a1))->_count/*4*/);
/*l969c10/string.e*/
/*[IF*/
if((int32_t)((_c)>(INT8_C(0)))){
/*l970c13/string.e*/
/*[IF*/
if((int32_t)(((/*RF2*/(C)->_capacity/*8*/))<(_c))){
/*l971c16/string.e*/
/*SFN*/(C->_storage/*0*/)=new9(_c);
/*l972c16/string.e*/
/*SFN*/(C->_capacity/*8*/)=_c;
}
/*FI]*/
/*l974c21/string.e*/
r9copy_from((/*RF2*/(C)->_storage/*0*/),(/*RF2*/(((T7*)a1))->_storage/*0*/),/*(IRF4.6-*/(int32_t)(((/*RF2*/_c))-(/*IC*/(T2)(INT8_C(1))))/*)*/);
}
/*FI]*/
/*l976c10/string.e*/
/*SFN*/(C->_count/*4*/)=_c;
}

/*STRING*/
T6 r7is_bit(T7* C){
T6 R=0;
T2 _i=0;
/*l845c10/string.e*/
/*l846c13/string.e*/
_i=(/*RF2*/(C)->_count/*4*/);
/*l847c13/string.e*/
R=((T6)(1));
while (!((T6)((!(R))||((T6)((_i)==(INT8_C(0)))))))
{
/*l851c13/string.e*/
R=((T6)(r3is_bit(/*(IRF4.6item*/((/*RF2*/(C)->_storage/*0*/))[(_i)-(INT8_C(1))]/*)*/)));
/*l852c13/string.e*/
_i=/*(IRF4.6-*/(int32_t)(((/*RF2*/_i))-(INT8_C(1)))/*)*/;
}
return R;
}

/*STRING*/
void r7remove_first(T7* C,T2 a1){
/*l1294c10/string.e*/
/*[IF*/
if((int32_t)((a1)>((/*RF2*/(C)->_count/*4*/)))){
/*l1295c13/string.e*/
/*SFN*/(C->_count/*4*/)=INT8_C(0);
}
else{
/*l1297c13/string.e*/
/*[IF*/
if((int32_t)((a1)>(INT8_C(0)))){
/*l1298c16/string.e*/
r7remove_between(C,/*IC*/(T2)(INT8_C(1)),a1);
}
/*FI]*/
}
/*FI]*/
}

/*STRING*/
T3 r7last(T7* C){
T3 R=0;
/*l1474c10/string.e*/
R=((/*RF2*/(C)->_storage/*0*/))[/*(IRF4.6-*/(int32_t)(((/*RF2*/(/*RF2*/(C)->_count/*4*/)))-(INT8_C(1)))/*)*/];
return R;
}

/*STRING*/
T2 r7first_substring_index(T7* C,T0* a1){
T2 R=0;
/*l1651c3/string.e*/
R=r7substring_index(C,a1,/*IC*/(T2)(INT8_C(1)));
return R;
}

/*STRING*/
void r7remove_between(T7* C,T2 a1,T2 a2){
T2 _i=0;
T2 _len=0;
/*l1328c10/string.e*/
_len=/*(IRF4.6+*/(int32_t)(((/*RF2*//*(IRF4.6-*/(int32_t)(((/*RF2*/a2))-(a1))/*)*/))+(INT8_C(1)))/*)*/;
/*l1329c10/string.e*/
/*[IF*/
if((int32_t)((_len)>(INT8_C(0)))){
/*l1330c13/string.e*/
/*l1331c16/string.e*/
_i=/*(IRF4.6+*/(int32_t)(((/*RF2*/a2))+(INT8_C(1)))/*)*/;
while (!((int32_t)((_i)>((/*RF2*/(C)->_count/*4*/)))))
{
/*l1335c16/string.e*/
/*[IRF3.5put*/((/*RF2*/(C)->_storage/*0*/))[(/*(IRF4.6-*/(int32_t)(((/*RF2*/_i))-(_len))/*)*/)-(INT8_C(1))]=(/*(IRF4.6item*/((/*RF2*/(C)->_storage/*0*/))[(_i)-(INT8_C(1))]/*)*/);
/*]*/
/*l1336c16/string.e*/
_i=/*(IRF4.6+*/(int32_t)(((/*RF2*/_i))+(INT8_C(1)))/*)*/;
}
/*l1338c13/string.e*/
/*SFN*/(C->_count/*4*/)=/*(IRF4.6-*/(int32_t)(((/*RF2*/(/*RF2*/(C)->_count/*4*/)))-(_len))/*)*/;
}
/*FI]*/
}

/*STRING*/
T6 r7is_equal(T7* C,T0* a1){
T6 R=0;
/*l204c10/string.e*/
/*[IF*/
if(((/*RF2*/(C)->_count/*4*/))==((/*RF2*/(((T7*)a1))->_count/*4*/))){
/*l205c13/string.e*/
R=((T6)(r9fast_memcmp((/*RF2*/(C)->_storage/*0*/),(/*RF2*/(((T7*)a1))->_storage/*0*/),(/*RF2*/(C)->_count/*4*/))));
}
/*FI]*/
return R;
}

/*STRING*/
void r7prepend(T7* C,T0* a1){
T2 _i=0;
T2 _j=0;
/*l1029c3/string.e*/
_i=(/*RF2*/(C)->_count/*4*/);
/*l1030c3/string.e*/
_j=(/*RF2*/(((T7*)a1))->_count/*4*/);
/*l1031c3/string.e*/
r7resize(C,/*(IRF4.6+*/(int32_t)(((/*RF2*/_i))+(_j))/*)*/);
/*l1032c3/string.e*/
/*[IF*/
if((T6)(((int32_t)((_i)>(INT8_C(0))))&&((T6)((int32_t)((_j)>(INT8_C(0))))))){
/*l1033c14/string.e*/
r9move((/*RF2*/(C)->_storage/*0*/),/*IC*/(T2)(INT8_C(0)),/*(IRF4.6-*/(int32_t)(((/*RF2*/_i))-(/*IC*/(T2)(INT8_C(1))))/*)*/,_j);
}
/*FI]*/
/*l1035c11/string.e*/
r9copy_from((/*RF2*/(C)->_storage/*0*/),(/*RF2*/(((T7*)a1))->_storage/*0*/),/*(IRF4.6-*/(int32_t)(((/*RF2*/_j))-(/*IC*/(T2)(INT8_C(1))))/*)*/);
}

/*STRING*/
void r7append(T7* C,T0* a1){
T2 _s_count=0;
T2 _needed_capacity=0;
T2 _new_capacity=0;
/*l1006c3/string.e*/
_s_count=(/*RF2*/(((T7*)a1))->_count/*4*/);
/*l1007c10/string.e*/
_needed_capacity=/*(IRF4.6+*/(int32_t)(((/*RF2*/(/*RF2*/(C)->_count/*4*/)))+(_s_count))/*)*/;
/*l1008c10/string.e*/
/*[IF*/
if((int32_t)((_needed_capacity)>((/*RF2*/(C)->_capacity/*8*/)))){
/*l1009c13/string.e*/
/*[IF*/
if(((/*RF2*/(C)->_capacity/*8*/))==(INT8_C(0))){
/*l1010c16/string.e*/
/*SFN*/(C->_storage/*0*/)=new9(_needed_capacity);
/*l1011c16/string.e*/
/*SFN*/(C->_capacity/*8*/)=_needed_capacity;
}
else{
/*l1013c16/string.e*/
_new_capacity=r2max(/*(IRF4.6**/(int32_t)(((/*RF2*/INT8_C(2)))*((/*RF2*/(C)->_capacity/*8*/)))/*)*/,_needed_capacity);
/*l1014c9/string.e*/
/*SFN*/(C->_storage/*0*/)=r9realloc((/*RF2*/(C)->_storage/*0*/),(/*RF2*/(C)->_capacity/*8*/),_new_capacity);
/*l1015c9/string.e*/
/*SFN*/(C->_capacity/*8*/)=_new_capacity;
}
/*FI]*/
}
/*FI]*/
/*l1018c18/string.e*/
r9copy_at((/*RF2*/(C)->_storage/*0*/),(/*RF2*/(C)->_count/*4*/),(/*RF2*/(((T7*)a1))->_storage/*0*/),_s_count);
/*l1019c10/string.e*/
/*SFN*/(C->_count/*4*/)=_needed_capacity;
}

/*STRING*/
T0* r7to_number(T7* C){
T0* R=NULL;
int _number_tools=0;
/*l836c3/string.e*/
R=r167from_string(_number_tools,(T0*)C);
return R;
}

/*STRING*/
T2 r7index_of(T7* C,T3 a1,T2 a2){
T2 R=0;
/*l262c3/string.e*/
/*l263c6/string.e*/
R=a2;
while (!((T6)(((int32_t)((R)>((/*RF2*/(C)->_count/*4*/))))||((T6)((a1)==(/*(IRF4.6item*/((/*RF2*/(C)->_storage/*0*/))[(R)-(INT8_C(1))]/*)*/))))))
{
/*l267c6/string.e*/
R=/*(IRF4.6+*/(int32_t)(((/*RF2*/R))+(INT8_C(1)))/*)*/;
}
/*l269c3/string.e*/
/*[IF*/
if((int32_t)((R)>((/*RF2*/(C)->_count/*4*/)))){
/*l270c6/string.e*/
R=INT8_C(0);
}
/*FI]*/
return R;
}

/*STRING*/
T6 r7has_suffix(T7* C,T0* a1){
T6 R=0;
T2 _i1=0;
T2 _i2=0;
/*l333c10/string.e*/
/*[IF*/
if((int32_t)(((/*RF2*/(((T7*)a1))->_count/*4*/))<=((/*RF2*/(C)->_count/*4*/)))){
/*l334c13/string.e*/
/*l335c16/string.e*/
_i1=/*(IRF4.6+*/(int32_t)(((/*RF2*//*(IRF4.6-*/(int32_t)(((/*RF2*/(/*RF2*/(C)->_count/*4*/)))-((/*RF2*/(((T7*)a1))->_count/*4*/)))/*)*/))+(INT8_C(1)))/*)*/;
/*l336c16/string.e*/
_i2=INT8_C(1);
while (!((T6)(((int32_t)((_i1)>((/*RF2*/(C)->_count/*4*/))))||((T6)((/*(IRF4.6item*/((/*RF2*/(C)->_storage/*0*/))[(_i1)-(INT8_C(1))]/*)*/)!=(/*(IRF4.6item*/((/*RF2*/(((T7*)a1))->_storage/*0*/))[(_i2)-(INT8_C(1))]/*)*/))))))
{
/*l341c16/string.e*/
_i1=/*(IRF4.6+*/(int32_t)(((/*RF2*/_i1))+(INT8_C(1)))/*)*/;
/*l342c16/string.e*/
_i2=/*(IRF4.6+*/(int32_t)(((/*RF2*/_i2))+(INT8_C(1)))/*)*/;
}
/*l344c13/string.e*/
R=((T6)((int32_t)((_i1)>((/*RF2*/(C)->_count/*4*/)))));
}
/*FI]*/
return R;
}

/*STRING*/
T6 r7is_integer(T7* C){
T6 R=0;
T2 _i=0;
T2 _state=0;
T2 _value=0;
T6 _negative=0;
T3 _cc=0;
/*l409c10/string.e*/
/*l410c13/string.e*/
_i=INT8_C(1);
while (!((T6)(((_state)==(INT8_C(4)))||((T6)((int32_t)((_i)>((/*RF2*/(C)->_count/*4*/))))))))
{
/*l416c13/string.e*/
_cc=/*(IRF4.6item*/((/*RF2*/(C)->_storage/*0*/))[(_i)-(INT8_C(1))]/*)*/;
/*l417c13/string.e*/
/*[INSPECT*/
{int z1=_state;
switch(z1){
case 0:
/*l420c16/string.e*/
/*[IF*/
if(r3is_separator(_cc)){
}
 else if((_cc)==(((T3)'\053'))){
/*l422c19/string.e*/
_state=INT8_C(1);
}
 else if((_cc)==(((T3)'\055'))){
/*l424c19/string.e*/
_negative=((T6)(1));
/*l425c19/string.e*/
_state=INT8_C(1);
}
 else if(r3is_digit(_cc)){
/*l427c19/string.e*/
_value=/*IC*/(T2)(r3decimal_value(_cc));
/*l428c19/string.e*/
_state=INT8_C(2);
}
else{
/*l430c19/string.e*/
_state=INT8_C(4);
}
/*FI]*/
break;
case 1:
/*l433c16/string.e*/
/*[IF*/
if(r3is_digit(_cc)){
/*l434c19/string.e*/
_value=/*IC*/(T2)(r3decimal_value(_cc));
/*l435c19/string.e*/
/*[IF*/
if(_negative){
/*l436c22/string.e*/
_value=/*(IRF4.6**/(int32_t)(((/*RF2*/INT8_C(-1)))*(_value))/*)*/;
}
/*FI]*/
/*l438c19/string.e*/
_state=INT8_C(2);
}
else{
/*l440c19/string.e*/
_state=INT8_C(4);
}
/*FI]*/
break;
case 2:
/*l443c16/string.e*/
/*[IF*/
if(r3is_digit(_cc)){
/*l444c19/string.e*/
/*[IF*/
if(_negative){
/*l445c22/string.e*/
_value=/*(IRF4.6-*/(int32_t)(((/*RF2*//*(IRF4.6**/(int32_t)(((/*RF2*/INT8_C(10)))*(_value))/*)*/))-(/*IC*/(T2)(r3decimal_value(_cc))))/*)*/;
}
else{
/*l447c22/string.e*/
_value=/*(IRF4.6+*/(int32_t)(((/*RF2*//*(IRF4.6**/(int32_t)(((/*RF2*/INT8_C(10)))*(_value))/*)*/))+(/*IC*/(T2)(r3decimal_value(_cc))))/*)*/;
}
/*FI]*/
/*l450c19/string.e*/
/*[IF*/
if((T6)(((T6)((_negative)&&((T6)((int32_t)((_value)>(INT8_C(0)))))))||((T6)((T6)((!(_negative))&&((T6)((int32_t)((_value)<(INT8_C(0)))))))))){
/*l452c22/string.e*/
_state=INT8_C(4);
}
/*FI]*/
}
 else if(r3is_separator(_cc)){
/*l455c19/string.e*/
_state=INT8_C(3);
}
else{
/*l457c19/string.e*/
_state=INT8_C(4);
}
/*FI]*/
break;
default:;
/*l460c16/string.e*/
/*[IF*/
if(r3is_separator(_cc)){
}
else{
/*l462c19/string.e*/
_state=INT8_C(4);
}
/*FI]*/
}
}/*INSPECT]*/
/*l465c13/string.e*/
_i=/*(IRF4.6+*/(int32_t)(((/*RF2*/_i))+(INT8_C(1)))/*)*/;
}
/*l467c3/string.e*/
/*[IF*/
if((T6)(((_state)==(INT8_C(2)))||((T6)((_state)==(INT8_C(3)))))){
/*l468c13/string.e*/
R=((T6)(1));
}
/*FI]*/
return R;
}

/*STRING*/
void r7make(T7* C,T2 a1){
/*l72c10/string.e*/
/*[IF*/
if((int32_t)((a1)>(INT8_C(0)))){
/*l73c13/string.e*/
/*[IF*/
if((int32_t)(((/*RF2*/(C)->_capacity/*8*/))<(a1))){
/*l74c16/string.e*/
/*SFN*/(C->_storage/*0*/)=new9(a1);
/*l75c16/string.e*/
/*SFN*/(C->_capacity/*8*/)=a1;
}
/*FI]*/
}
/*FI]*/
/*l78c10/string.e*/
/*SFN*/(C->_count/*4*/)=INT8_C(0);
}

/*STRING*/
void r7extend(T7* C,T3 a1){
T2 _new_capacity=0;
/*l1202c10/string.e*/
/*[IF*/
if((int32_t)(((/*RF2*/(C)->_capacity/*8*/))>((/*RF2*/(C)->_count/*4*/)))){
}
 else if(((/*RF2*/(C)->_capacity/*8*/))==(INT8_C(0))){
/*l1204c6/string.e*/
_new_capacity=INT8_C(32);
/*l1205c13/string.e*/
/*SFN*/(C->_storage/*0*/)=new9(_new_capacity);
/*l1206c13/string.e*/
/*SFN*/(C->_capacity/*8*/)=_new_capacity;
}
else{
/*l1208c13/string.e*/
_new_capacity=/*(IRF4.6**/(int32_t)(((/*RF2*/INT8_C(2)))*((/*RF2*/(C)->_capacity/*8*/)))/*)*/;
/*l1209c13/string.e*/
/*SFN*/(C->_storage/*0*/)=r9realloc((/*RF2*/(C)->_storage/*0*/),(/*RF2*/(C)->_capacity/*8*/),_new_capacity);
/*l1210c13/string.e*/
/*SFN*/(C->_capacity/*8*/)=_new_capacity;
}
/*FI]*/
/*l1212c18/string.e*/
((/*RF2*/(C)->_storage/*0*/))[(/*RF2*/(C)->_count/*4*/)]=(a1);
/*l1213c10/string.e*/
/*SFN*/(C->_count/*4*/)=/*(IRF4.6+*/(int32_t)(((/*RF2*/(/*RF2*/(C)->_count/*4*/)))+(INT8_C(1)))/*)*/;
}

/*STRING*/
void r7insert_string(T7* C,T0* a1,T2 a2){
T2 _j=0;
T2 _k=0;
/*l1049c10/string.e*/
_j=(/*RF2*/(C)->_count/*4*/);
/*l1050c10/string.e*/
_k=(/*RF2*/(((T7*)a1))->_count/*4*/);
/*l1051c10/string.e*/
r7resize(C,/*(IRF4.6+*/(int32_t)(((/*RF2*/_j))+(_k))/*)*/);
/*l1052c3/string.e*/
/*[IF*/
if((int32_t)((a2)<=(_j))){
/*l1053c14/string.e*/
r9move((/*RF2*/(C)->_storage/*0*/),/*(IRF4.6-*/(int32_t)(((/*RF2*/a2))-(/*IC*/(T2)(INT8_C(1))))/*)*/,/*(IRF4.6-*/(int32_t)(((/*RF2*/_j))-(/*IC*/(T2)(INT8_C(1))))/*)*/,_k);
}
/*FI]*/
/*l1055c18/string.e*/
r9copy_at((/*RF2*/(C)->_storage/*0*/),/*(IRF4.6-*/(int32_t)(((/*RF2*/a2))-(/*IC*/(T2)(INT8_C(1))))/*)*/,(/*RF2*/(((T7*)a1))->_storage/*0*/),_k);
}

/*STRING*/
T2 r7hash_code(T7* C){
T2 R=0;
T2 _i=0;
T2 _j=0;
/*l137c10/string.e*/
/*l138c6/string.e*/
_j=(/*RF2*/(C)->_count/*4*/);
/*l139c6/string.e*/
_i=INT8_C(1);
while (!((int32_t)((_j)<=(INT8_C(0)))))
{
/*l143c13/string.e*/
R=(int32_t)(((int32_t)((INT8_C(5))*(R)))+(/*IC*/(T2)(T3code(/*(IRF4.6item*/((/*RF2*/(C)->_storage/*0*/))[(_i)-(INT8_C(1))]/*)*/))));
/*l144c13/string.e*/
_i=/*(IRF4.6+*/(int32_t)(((/*RF2*/_i))+(INT8_C(1)))/*)*/;
/*l145c6/string.e*/
_j=/*(IRF4.6-*/(int32_t)(((/*RF2*/_j))-(INT8_C(1)))/*)*/;
}
/*l147c10/string.e*/
/*[IF*/
if((int32_t)((R)<(INT8_C(0)))){
/*l148c13/string.e*/
R=~(R);
}
/*FI]*/
return R;
}

/*STRING*/
void r7remove_last(T7* C,T2 a1){
/*l1310c10/string.e*/
/*[IF*/
if((int32_t)((a1)>((/*RF2*/(C)->_count/*4*/)))){
/*l1311c13/string.e*/
/*SFN*/(C->_count/*4*/)=INT8_C(0);
}
else{
/*l1313c13/string.e*/
/*SFN*/(C->_count/*4*/)=/*(IRF4.6-*/(int32_t)(((/*RF2*/(/*RF2*/(C)->_count/*4*/)))-(a1))/*)*/;
}
/*FI]*/
}

/*STRING*/
T6 r7has(T7* C,T3 a1){
T6 R=0;
/*l307c10/string.e*/
R=((T6)(r9fast_has((/*RF2*/(C)->_storage/*0*/),a1,/*(IRF4.6-*/(int32_t)(((/*RF2*/(/*RF2*/(C)->_count/*4*/)))-(/*IC*/(T2)(INT8_C(1))))/*)*/)));
return R;
}

/*STRING*/
T2 r7to_integer(T7* C){
T2 R=0;
T2 _i=0;
T2 _state=0;
T3 _cc=0;
T6 _negative=0;
/*l483c10/string.e*/
/*l484c13/string.e*/
_i=INT8_C(1);
while (!((int32_t)((_i)>((/*RF2*/(C)->_count/*4*/)))))
{
/*l490c13/string.e*/
_cc=/*(IRF4.6item*/((/*RF2*/(C)->_storage/*0*/))[(_i)-(INT8_C(1))]/*)*/;
/*l491c13/string.e*/
/*[INSPECT*/
{int z1=_state;
switch(z1){
case 0:
/*l494c16/string.e*/
/*[IF*/
if(r3is_separator(_cc)){
}
 else if((_cc)==(((T3)'\053'))){
/*l496c19/string.e*/
_state=INT8_C(1);
}
 else if((_cc)==(((T3)'\055'))){
/*l498c19/string.e*/
_negative=((T6)(1));
/*l499c19/string.e*/
_state=INT8_C(1);
}
else{
/*l501c19/string.e*/
R=/*IC*/(T2)(r3value(_cc));
/*l502c19/string.e*/
_state=INT8_C(2);
}
/*FI]*/
break;
case 1:
/*l506c16/string.e*/
R=/*IC*/(T2)(r3value(_cc));
/*l507c16/string.e*/
/*[IF*/
if(_negative){
/*l508c22/string.e*/
R=/*(IRF4.6**/(int32_t)(((/*RF2*/INT8_C(-1)))*(R))/*)*/;
}
/*FI]*/
/*l510c16/string.e*/
_state=INT8_C(2);
break;
case 2:
/*l512c16/string.e*/
/*[IF*/
if(r3is_digit(_cc)){
/*l513c19/string.e*/
/*[IF*/
if(_negative){
/*l514c22/string.e*/
R=/*(IRF4.6-*/(int32_t)(((/*RF2*//*(IRF4.6**/(int32_t)(((/*RF2*/INT8_C(10)))*(R))/*)*/))-(/*IC*/(T2)(r3decimal_value(_cc))))/*)*/;
}
else{
/*l516c22/string.e*/
R=/*(IRF4.6+*/(int32_t)(((/*RF2*//*(IRF4.6**/(int32_t)(((/*RF2*/INT8_C(10)))*(R))/*)*/))+(/*IC*/(T2)(r3decimal_value(_cc))))/*)*/;
}
/*FI]*/
}
else{
/*l519c19/string.e*/
_state=INT8_C(3);
}
/*FI]*/
break;
default:;
/*l523c16/string.e*/
_i=(/*RF2*/(C)->_count/*4*/);
}
}/*INSPECT]*/
/*l525c13/string.e*/
_i=/*(IRF4.6+*/(int32_t)(((/*RF2*/_i))+(INT8_C(1)))/*)*/;
}
return R;
}

/*STRING*/
void r7append_character(T7* C,T3 a1){
T2 _new_capacity=0;
/*l1202c10/string.e*/
/*[IF*/
if((int32_t)(((/*RF2*/(C)->_capacity/*8*/))>((/*RF2*/(C)->_count/*4*/)))){
}
 else if(((/*RF2*/(C)->_capacity/*8*/))==(INT8_C(0))){
/*l1204c6/string.e*/
_new_capacity=INT8_C(32);
/*l1205c13/string.e*/
/*SFN*/(C->_storage/*0*/)=new9(_new_capacity);
/*l1206c13/string.e*/
/*SFN*/(C->_capacity/*8*/)=_new_capacity;
}
else{
/*l1208c13/string.e*/
_new_capacity=/*(IRF4.6**/(int32_t)(((/*RF2*/INT8_C(2)))*((/*RF2*/(C)->_capacity/*8*/)))/*)*/;
/*l1209c13/string.e*/
/*SFN*/(C->_storage/*0*/)=r9realloc((/*RF2*/(C)->_storage/*0*/),(/*RF2*/(C)->_capacity/*8*/),_new_capacity);
/*l1210c13/string.e*/
/*SFN*/(C->_capacity/*8*/)=_new_capacity;
}
/*FI]*/
/*l1212c18/string.e*/
((/*RF2*/(C)->_storage/*0*/))[(/*RF2*/(C)->_count/*4*/)]=(a1);
/*l1213c10/string.e*/
/*SFN*/(C->_count/*4*/)=/*(IRF4.6+*/(int32_t)(((/*RF2*/(/*RF2*/(C)->_count/*4*/)))+(INT8_C(1)))/*)*/;
}

/*STRING*/
void r7add_last(T7* C,T3 a1){
T2 _new_capacity=0;
/*l1202c10/string.e*/
/*[IF*/
if((int32_t)(((/*RF2*/(C)->_capacity/*8*/))>((/*RF2*/(C)->_count/*4*/)))){
}
 else if(((/*RF2*/(C)->_capacity/*8*/))==(INT8_C(0))){
/*l1204c6/string.e*/
_new_capacity=INT8_C(32);
/*l1205c13/string.e*/
/*SFN*/(C->_storage/*0*/)=new9(_new_capacity);
/*l1206c13/string.e*/
/*SFN*/(C->_capacity/*8*/)=_new_capacity;
}
else{
/*l1208c13/string.e*/
_new_capacity=/*(IRF4.6**/(int32_t)(((/*RF2*/INT8_C(2)))*((/*RF2*/(C)->_capacity/*8*/)))/*)*/;
/*l1209c13/string.e*/
/*SFN*/(C->_storage/*0*/)=r9realloc((/*RF2*/(C)->_storage/*0*/),(/*RF2*/(C)->_capacity/*8*/),_new_capacity);
/*l1210c13/string.e*/
/*SFN*/(C->_capacity/*8*/)=_new_capacity;
}
/*FI]*/
/*l1212c18/string.e*/
((/*RF2*/(C)->_storage/*0*/))[(/*RF2*/(C)->_count/*4*/)]=(a1);
/*l1213c10/string.e*/
/*SFN*/(C->_count/*4*/)=/*(IRF4.6+*/(int32_t)(((/*RF2*/(/*RF2*/(C)->_count/*4*/)))+(INT8_C(1)))/*)*/;
}

/*STRING*/
void r7resize(T7* C,T2 a1){
T9 _s=NULL;
/*l937c10/string.e*/
/*[IF*/
if((int32_t)((a1)<=((/*RF2*/(C)->_count/*4*/)))){
}
 else if((int32_t)(((/*RF2*/(C)->_capacity/*8*/))<(a1))){
/*l939c6/string.e*/
/*[IF*/
if(((/*RF2*/(C)->_capacity/*8*/))==(INT8_C(0))){
/*l940c9/string.e*/
/*SFN*/(C->_storage/*0*/)=new9(a1);
}
else{
/*l942c9/string.e*/
/*SFN*/(C->_storage/*0*/)=r9realloc((/*RF2*/(C)->_storage/*0*/),(/*RF2*/(C)->_capacity/*8*/),a1);
}
/*FI]*/
/*l944c6/string.e*/
/*SFN*/(C->_capacity/*8*/)=a1;
}
else{
/*l946c14/string.e*/
r9clear((/*RF2*/(C)->_storage/*0*/),(/*RF2*/(C)->_count/*4*/),/*(IRF4.6-*/(int32_t)(((/*RF2*/a1))-(/*IC*/(T2)(INT8_C(1))))/*)*/);
}
/*FI]*/
/*l948c3/string.e*/
/*SFN*/(C->_count/*4*/)=a1;
}

/*STRING*/
void r7to_upper(T7* C){
T2 _i=0;
/*l1239c10/string.e*/
/*l1240c13/string.e*/
_i=(/*RF2*/(C)->_count/*4*/);
while (!((_i)==(INT8_C(0))))
{
/*l1244c13/string.e*/
/*[IRF3.5put*/((/*RF2*/(C)->_storage/*0*/))[(_i)-(INT8_C(1))]=(r3to_upper(/*(IRF4.6item*/((/*RF2*/(C)->_storage/*0*/))[(_i)-(INT8_C(1))]/*)*/));
/*]*/
/*l1245c13/string.e*/
_i=/*(IRF4.6-*/(int32_t)(((/*RF2*/_i))-(INT8_C(1)))/*)*/;
}
}

/*STRING*/
T2 r7substring_index(T7* C,T0* a1,T2 a2){
T2 R=0;
T2 _i=0;
T2 _s=0;
/*l1626c10/string.e*/
/*l1627c13/string.e*/
_s=a2;
while (!((T6)(((R)!=(INT8_C(0)))||((T6)((int32_t)((/*(IRF4.6-*/(int32_t)(((/*RF2*//*(IRF4.6+*/(int32_t)(((/*RF2*/_s))+((/*RF2*/(((T7*)a1))->_count/*4*/)))/*)*/))-(INT8_C(1)))/*)*/)>((/*RF2*/(C)->_count/*4*/))))))))
{
/*l1631c13/string.e*/
/*l1632c16/string.e*/
_i=INT8_C(1);
while (!((T6)(((int32_t)((_i)>((/*RF2*/(((T7*)a1))->_count/*4*/))))||((T6)((/*(IRF4.6item*/((/*RF2*/(C)->_storage/*0*/))[(/*(IRF4.6-*/(int32_t)(((/*RF2*//*(IRF4.6+*/(int32_t)(((/*RF2*/_s))+(_i))/*)*/))-(INT8_C(1)))/*)*/)-(INT8_C(1))]/*)*/)!=(/*(IRF4.6item*/((/*RF2*/(((T7*)a1))->_storage/*0*/))[(_i)-(INT8_C(1))]/*)*/))))))
{
/*l1636c16/string.e*/
_i=/*(IRF4.6+*/(int32_t)(((/*RF2*/_i))+(INT8_C(1)))/*)*/;
}
/*l1638c13/string.e*/
/*[IF*/
if((int32_t)((_i)>((/*RF2*/(((T7*)a1))->_count/*4*/)))){
/*l1639c16/string.e*/
R=_s;
}
else{
/*l1641c16/string.e*/
_s=/*(IRF4.6+*/(int32_t)(((/*RF2*/_s))+(INT8_C(1)))/*)*/;
}
/*FI]*/
}
return R;
}

/*STRING*/
void r7from_external_copy(T7* C,T8 a1){
T9 _s=NULL;
T2 _i=0;
/*l1791c10/string.e*/
/*l1792c13/string.e*/
_s=a1;
/*l1793c6/string.e*/
/*SFN*/(C->_count/*4*/)=INT8_C(0);
while (!(((_s)[_i])==(((T3)'\000'))))
{
/*l1797c13/string.e*/
r7append_character(C,(_s)[_i]);
/*l1798c13/string.e*/
_i=/*(IRF4.6+*/(int32_t)(((/*RF2*/_i))+(INT8_C(1)))/*)*/;
}
}

/*STRING*/
void r7right_adjust(T7* C){
/*l1384c10/string.e*/
while (!((T6)((((/*RF2*/(C)->_count/*4*/))==(INT8_C(0)))||((T6)((/*(IRF4.6item*/((/*RF2*/(C)->_storage/*0*/))[((/*RF2*/(C)->_count/*4*/))-(INT8_C(1))]/*)*/)!=(((T3)'\040')))))))
{
/*l1388c13/string.e*/
/*SFN*/(C->_count/*4*/)=/*(IRF4.6-*/(int32_t)(((/*RF2*/(/*RF2*/(C)->_count/*4*/)))-(INT8_C(1)))/*)*/;
}
}

/*STRING*/
T8 r7to_external(T7* C){
T8 R=NULL;
/*l1741c10/string.e*/
/*[IF*/
if((int32_t)(((/*RF2*/(C)->_capacity/*8*/))>((/*RF2*/(C)->_count/*4*/)))){
/*l1742c13/string.e*/
/*SFN*/(C->_count/*4*/)=/*(IRF4.6+*/(int32_t)(((/*RF2*/(/*RF2*/(C)->_count/*4*/)))+(INT8_C(1)))/*)*/;
/*l1743c13/string.e*/
/*[IF*/
if((/*(IRF4.6item*/((/*RF2*/(C)->_storage/*0*/))[((/*RF2*/(C)->_count/*4*/))-(INT8_C(1))]/*)*/)!=(((T3)'\000'))){
/*l1744c16/string.e*/
/*[IRF3.5put*/((/*RF2*/(C)->_storage/*0*/))[((/*RF2*/(C)->_count/*4*/))-(INT8_C(1))]=(((T3)'\000'));
/*]*/
}
/*FI]*/
}
else{
/*l1747c13/string.e*/
r7append_character(C,((T3)'\000'));
}
/*FI]*/
/*l1749c10/string.e*/
/*SFN*/(C->_count/*4*/)=/*(IRF4.6-*/(int32_t)(((/*RF2*/(/*RF2*/(C)->_count/*4*/)))-(INT8_C(1)))/*)*/;
/*l1750c10/string.e*/
R=((void*)((/*RF2*/(C)->_storage/*0*/)));
return R;
}

/*STRING*/
void r7extend_multiple(T7* C,T3 a1,T2 a2){
T2 _i=0;
/*l1504c10/string.e*/
/*l1505c13/string.e*/
_i=a2;
while (!((_i)==(INT8_C(0))))
{
/*l1509c13/string.e*/
r7append_character(C,a1);
/*l1510c13/string.e*/
_i=/*(IRF4.6-*/(int32_t)(((/*RF2*/_i))-(INT8_C(1)))/*)*/;
}
}

/*STRING*/
void r7to_lower(T7* C){
T2 _i=0;
/*l1224c10/string.e*/
/*l1225c13/string.e*/
_i=(/*RF2*/(C)->_count/*4*/);
while (!((_i)==(INT8_C(0))))
{
/*l1229c13/string.e*/
/*[IRF3.5put*/((/*RF2*/(C)->_storage/*0*/))[(_i)-(INT8_C(1))]=(r3to_lower(/*(IRF4.6item*/((/*RF2*/(C)->_storage/*0*/))[(_i)-(INT8_C(1))]/*)*/));
/*]*/
/*l1230c13/string.e*/
_i=/*(IRF4.6-*/(int32_t)(((/*RF2*/_i))-(INT8_C(1)))/*)*/;
}
}

/*STRING*/
T0* r7twin(T7* C){
T0* R=NULL;
R=((void*)new7());
r7copy(((T7*)R),((T0*)C));
return R;
}

/*STRING*/
T0* r7_ix_43(T7* C,T0* a1){
T0* R=NULL;
/*l1093c10/string.e*/
{T7*n=new7();
r7make(n,/*(IRF4.6+*/(int32_t)(((/*RF2*/(/*RF2*/(C)->_count/*4*/)))+((/*RF2*/(((T7*)a1))->_count/*4*/)))/*)*/);
R=((T0*)n);
}
/*l1094c17/string.e*/
r7append(((T7*)R),(T0*)C);
/*l1095c17/string.e*/
r7append(((T7*)R),a1);
return R;
}

/*STRING*/
T6 r7is_number(T7* C){
T6 R=0;
int _number_tools=0;
/*l826c3/string.e*/
R=((T6)(r167is_number(_number_tools,(T0*)C)));
return R;
}

/*STRING*/
void r7left_adjust(T7* C){
T2 _i=0;
/*l1369c10/string.e*/
/*l1370c6/string.e*/
_i=INT8_C(1);
while (!((T6)(((int32_t)((_i)>((/*RF2*/(C)->_count/*4*/))))||((T6)((/*(IRF4.6item*/((/*RF2*/(C)->_storage/*0*/))[(_i)-(INT8_C(1))]/*)*/)!=(((T3)'\040')))))))
{
/*l1374c13/string.e*/
_i=/*(IRF4.6+*/(int32_t)(((/*RF2*/_i))+(INT8_C(1)))/*)*/;
}
/*l1376c10/string.e*/
r7remove_first(C,/*(IRF4.6-*/(int32_t)(((/*RF2*/_i))-(/*IC*/(T2)(INT8_C(1))))/*)*/);
}

/*STRING*/
void r7swap(T7* C,T2 a1,T2 a2){
T3 _tmp=0;
/*l1117c10/string.e*/
_tmp=/*(IRF4.6item*/((/*RF2*/(C)->_storage/*0*/))[(a1)-(INT8_C(1))]/*)*/;
/*l1118c10/string.e*/
/*[IRF3.5put*/((/*RF2*/(C)->_storage/*0*/))[(a1)-(INT8_C(1))]=(/*(IRF4.6item*/((/*RF2*/(C)->_storage/*0*/))[(a2)-(INT8_C(1))]/*)*/);
/*]*/
/*l1119c10/string.e*/
/*[IRF3.5put*/((/*RF2*/(C)->_storage/*0*/))[(a2)-(INT8_C(1))]=(_tmp);
/*]*/
}

/*FIXED_ARRAY[BOOLEAN]*/
void r46make(T46* C,T2 a1){
/*l45c3/fixed_array.e*/
/*[IF*/
if((int32_t)((a1)>((/*RF2*/(C)->_capacity/*4*/)))){
/*l47c13/fixed_array.e*/
/*SFN*/(C->_storage/*0*/)=new48(a1);
/*l48c13/fixed_array.e*/
/*SFN*/(C->_capacity/*4*/)=a1;
}
 else if((int32_t)(((/*RF2*/(C)->_capacity/*4*/))>(INT8_C(0)))){
/*l51c6/fixed_array.e*/
/*SFN*/(C->_upper/*8*/)=r2max((/*RF2*/(C)->_upper/*8*/),/*(IRF4.6-*/(int32_t)(((/*RF2*/a1))-(INT8_C(1)))/*)*/);
/*l52c6/fixed_array.e*/
/*[IF*/
if((int32_t)(((/*RF2*/(C)->_upper/*8*/))>=(INT8_C(0)))){
/*l53c17/fixed_array.e*/
r48clear_all((/*RF2*/(C)->_storage/*0*/),(/*RF2*/(C)->_upper/*8*/));
}
/*FI]*/
}
/*FI]*/
/*l56c3/fixed_array.e*/
/*SFN*/(C->_upper/*8*/)=/*(IRF4.6-*/(int32_t)(((/*RF2*/a1))-(INT8_C(1)))/*)*/;
}

/*FIXED_ARRAY[ITM_CODE]*/
void r160force(T160* C,T0* a1,T2 a2){
/*l276c10/fixed_array.e*/
/*[IF*/
if((int32_t)((a2)<=((/*RF2*/(C)->_upper/*8*/)))){
/*l277c21/fixed_array.e*/
((/*RF2*/(C)->_storage/*0*/))[a2]=(a1);
}
 else if((a2)==(/*(IRF4.6+*/(int32_t)(((/*RF2*/(/*RF2*/(C)->_upper/*8*/)))+(INT8_C(1)))/*)*/)){
/*l279c13/fixed_array.e*/
r160add_last(C,a1);
}
else{
/*l281c13/fixed_array.e*/
r160resize(C,/*(IRF4.6+*/(int32_t)(((/*RF2*/a2))+(/*IC*/(T2)(INT8_C(1))))/*)*/);
/*l282c21/fixed_array.e*/
((/*RF2*/(C)->_storage/*0*/))[a2]=(a1);
}
/*FI]*/
}

/*FIXED_ARRAY[ITM_CODE]*/
void r160make(T160* C,T2 a1){
/*l45c3/fixed_array.e*/
/*[IF*/
if((int32_t)((a1)>((/*RF2*/(C)->_capacity/*4*/)))){
/*l47c13/fixed_array.e*/
/*SFN*/(C->_storage/*0*/)=new162(a1);
/*l48c13/fixed_array.e*/
/*SFN*/(C->_capacity/*4*/)=a1;
}
 else if((int32_t)(((/*RF2*/(C)->_capacity/*4*/))>(INT8_C(0)))){
/*l51c6/fixed_array.e*/
/*SFN*/(C->_upper/*8*/)=r2max((/*RF2*/(C)->_upper/*8*/),/*(IRF4.6-*/(int32_t)(((/*RF2*/a1))-(INT8_C(1)))/*)*/);
/*l52c6/fixed_array.e*/
/*[IF*/
if((int32_t)(((/*RF2*/(C)->_upper/*8*/))>=(INT8_C(0)))){
/*l53c17/fixed_array.e*/
r162clear_all((/*RF2*/(C)->_storage/*0*/),(/*RF2*/(C)->_upper/*8*/));
}
/*FI]*/
}
/*FI]*/
/*l56c3/fixed_array.e*/
/*SFN*/(C->_upper/*8*/)=/*(IRF4.6-*/(int32_t)(((/*RF2*/a1))-(INT8_C(1)))/*)*/;
}

/*FIXED_ARRAY[ITM_CODE]*/
void r160add_last(T160* C,T0* a1){
T2 _new_capacity=0;
/*l148c10/fixed_array.e*/
/*[IF*/
if((int32_t)((/*(IRF4.6+*/(int32_t)(((/*RF2*/(/*RF2*/(C)->_upper/*8*/)))+(INT8_C(1)))/*)*/)<=(/*(IRF4.6-*/(int32_t)(((/*RF2*/(/*RF2*/(C)->_capacity/*4*/)))-(INT8_C(1)))/*)*/))){
/*l149c13/fixed_array.e*/
/*SFN*/(C->_upper/*8*/)=/*(IRF4.6+*/(int32_t)(((/*RF2*/(/*RF2*/(C)->_upper/*8*/)))+(INT8_C(1)))/*)*/;
}
 else if(((/*RF2*/(C)->_capacity/*4*/))==(INT8_C(0))){
/*l151c13/fixed_array.e*/
/*SFN*/(C->_storage/*0*/)=new162(INT8_C(2));
/*l152c13/fixed_array.e*/
/*SFN*/(C->_capacity/*4*/)=INT8_C(2);
/*l153c13/fixed_array.e*/
/*SFN*/(C->_upper/*8*/)=INT8_C(0);
}
else{
/*l155c13/fixed_array.e*/
_new_capacity=/*(IRF4.6**/(int32_t)(((/*RF2*/INT8_C(2)))*((/*RF2*/(C)->_capacity/*4*/)))/*)*/;
/*l156c13/fixed_array.e*/
/*SFN*/(C->_storage/*0*/)=r162realloc((/*RF2*/(C)->_storage/*0*/),(/*RF2*/(C)->_capacity/*4*/),_new_capacity);
/*l157c13/fixed_array.e*/
/*SFN*/(C->_capacity/*4*/)=_new_capacity;
/*l158c13/fixed_array.e*/
/*SFN*/(C->_upper/*8*/)=/*(IRF4.6+*/(int32_t)(((/*RF2*/(/*RF2*/(C)->_upper/*8*/)))+(INT8_C(1)))/*)*/;
}
/*FI]*/
/*l160c18/fixed_array.e*/
((/*RF2*/(C)->_storage/*0*/))[(/*RF2*/(C)->_upper/*8*/)]=(a1);
}

/*FIXED_ARRAY[ITM_CODE]*/
void r160resize(T160* C,T2 a1){
T2 _new_capacity=0;
/*l91c10/fixed_array.e*/
/*[IF*/
if((int32_t)((a1)>(/*(IRF4.6count*//*(IRF4.6+*/(int32_t)(((/*RF2*/(/*RF2*/(C)->_upper/*8*/)))+(INT8_C(1)))/*)*//*)*/))){
/*l92c6/fixed_array.e*/
/*[IF*/
if(((/*RF2*/(C)->_capacity/*4*/))==(INT8_C(0))){
/*l93c9/fixed_array.e*/
/*SFN*/(C->_storage/*0*/)=new162(a1);
/*l94c9/fixed_array.e*/
/*SFN*/(C->_capacity/*4*/)=a1;
}
 else if((int32_t)(((/*RF2*/(C)->_capacity/*4*/))<(a1))){
/*l96c9/fixed_array.e*/
/*l97c5/fixed_array.e*/
_new_capacity=/*(IRF4.6**/(int32_t)(((/*RF2*/(/*RF2*/(C)->_capacity/*4*/)))*(INT8_C(2)))/*)*/;
while (!((int32_t)((_new_capacity)>=(a1))))
{
/*l101c5/fixed_array.e*/
_new_capacity=/*(IRF4.6**/(int32_t)(((/*RF2*/_new_capacity))*(INT8_C(2)))/*)*/;
}
/*l103c9/fixed_array.e*/
/*SFN*/(C->_storage/*0*/)=r162realloc((/*RF2*/(C)->_storage/*0*/),(/*RF2*/(C)->_capacity/*4*/),_new_capacity);
/*l104c9/fixed_array.e*/
/*SFN*/(C->_capacity/*4*/)=_new_capacity;
}
/*FI]*/
}
 else if((a1)!=(/*(IRF4.6count*//*(IRF4.6+*/(int32_t)(((/*RF2*/(/*RF2*/(C)->_upper/*8*/)))+(INT8_C(1)))/*)*//*)*/)){
/*l107c14/fixed_array.e*/
r162clear((/*RF2*/(C)->_storage/*0*/),a1,/*(IRF4.6-*/(int32_t)(((/*RF2*//*(IRF4.6count*//*(IRF4.6+*/(int32_t)(((/*RF2*/(/*RF2*/(C)->_upper/*8*/)))+(INT8_C(1)))/*)*//*)*/))-(/*IC*/(T2)(INT8_C(1))))/*)*/);
}
/*FI]*/
/*l109c3/fixed_array.e*/
/*SFN*/(C->_upper/*8*/)=/*(IRF4.6-*/(int32_t)(((/*RF2*/a1))-(INT8_C(1)))/*)*/;
}

/*ARRAY[ANY]*/
T2 r123count(T123* C){
T2 R=0;
/*l164c10/array.e*/
R=/*(IRF4.6+*/(int32_t)(((/*RF2*//*(IRF4.6-*/(int32_t)(((/*RF2*/(/*RF2*/(C)->_upper/*8*/)))-((/*RF2*/(C)->_lower/*12*/)))/*)*/))+(INT8_C(1)))/*)*/;
return R;
}

/*ARRAY[ANY]*/
void r123add_last(T123* C,T0* a1){
T2 _new_capacity=0;
/*l255c10/array.e*/
/*[IF*/
if((int32_t)(((/*RF2*/(C)->_capacity/*4*/))<(/*(IRF4.6+*/(int32_t)(((/*RF2*/r123count(C)))+(INT8_C(1)))/*)*/))){
/*l256c13/array.e*/
/*[IF*/
if(((/*RF2*/(C)->_capacity/*4*/))==(INT8_C(0))){
/*l257c16/array.e*/
_new_capacity=INT8_C(16);
/*l258c16/array.e*/
/*SFN*/(C->_storage/*0*/)=new124(_new_capacity);
/*l259c16/array.e*/
/*SFN*/(C->_capacity/*4*/)=_new_capacity;
}
else{
/*l261c16/array.e*/
_new_capacity=/*(IRF4.6**/(int32_t)(((/*RF2*/INT8_C(2)))*((/*RF2*/(C)->_capacity/*4*/)))/*)*/;
/*l262c16/array.e*/
/*SFN*/(C->_storage/*0*/)=r124realloc((/*RF2*/(C)->_storage/*0*/),(/*RF2*/(C)->_capacity/*4*/),_new_capacity);
/*l263c16/array.e*/
/*SFN*/(C->_capacity/*4*/)=_new_capacity;
}
/*FI]*/
}
/*FI]*/
/*l266c10/array.e*/
/*SFN*/(C->_upper/*8*/)=/*(IRF4.6+*/(int32_t)(((/*RF2*/(/*RF2*/(C)->_upper/*8*/)))+(INT8_C(1)))/*)*/;
/*l267c10/array.e*/
/*[IRF3.6put*/{T123* C1=C;
T0* b1=a1;
T2 b2=(/*RF2*/(C)->_upper/*8*/);
/*l174c18/array.e*/
((/*RF2*/(C1)->_storage/*0*/))[/*(IRF4.6-*/(int32_t)(((/*RF2*/b2))-((/*RF2*/(C1)->_lower/*12*/)))/*)*/]=(b1);
}/*]*/
}

/*ARRAY[ANY]*/
T2 r123fast_index_of(T123* C,T0* a1){
T2 R=0;
/*l312c10/array.e*/
R=/*(IRF4.6+*/(int32_t)(((/*RF2*/(/*RF2*/(C)->_lower/*12*/)))+(r124fast_index_of((/*RF2*/(C)->_storage/*0*/),a1,/*(IRF4.6-*/(int32_t)(((/*RF2*/(/*RF2*/(C)->_upper/*8*/)))-((/*RF2*/(C)->_lower/*12*/)))/*)*/)))/*)*/;
return R;
}

/*ARRAY[ANY]*/
void r123with_capacity(T123* C,T2 a1,T2 a2){
/*l67c10/array.e*/
/*[IF*/
if((int32_t)(((/*RF2*/(C)->_capacity/*4*/))<(a1))){
/*l68c13/array.e*/
/*SFN*/(C->_storage/*0*/)=new124(a1);
/*l69c13/array.e*/
/*SFN*/(C->_capacity/*4*/)=a1;
}
/*FI]*/
/*l71c10/array.e*/
/*SFN*/(C->_lower/*12*/)=a2;
/*l72c10/array.e*/
/*SFN*/(C->_upper/*8*/)=/*(IRF4.6-*/(int32_t)(((/*RF2*/a2))-(INT8_C(1)))/*)*/;
}

/*FIXED_ARRAY[PROTOTYPE]*/
void r37make(T37* C,T2 a1){
/*l45c3/fixed_array.e*/
/*[IF*/
if((int32_t)((a1)>((/*RF2*/(C)->_capacity/*4*/)))){
/*l47c13/fixed_array.e*/
/*SFN*/(C->_storage/*0*/)=new39(a1);
/*l48c13/fixed_array.e*/
/*SFN*/(C->_capacity/*4*/)=a1;
}
 else if((int32_t)(((/*RF2*/(C)->_capacity/*4*/))>(INT8_C(0)))){
/*l51c6/fixed_array.e*/
/*SFN*/(C->_upper/*8*/)=r2max((/*RF2*/(C)->_upper/*8*/),/*(IRF4.6-*/(int32_t)(((/*RF2*/a1))-(INT8_C(1)))/*)*/);
/*l52c6/fixed_array.e*/
/*[IF*/
if((int32_t)(((/*RF2*/(C)->_upper/*8*/))>=(INT8_C(0)))){
/*l53c17/fixed_array.e*/
r39clear_all((/*RF2*/(C)->_storage/*0*/),(/*RF2*/(C)->_upper/*8*/));
}
/*FI]*/
}
/*FI]*/
/*l56c3/fixed_array.e*/
/*SFN*/(C->_upper/*8*/)=/*(IRF4.6-*/(int32_t)(((/*RF2*/a1))-(INT8_C(1)))/*)*/;
}

/*FIXED_ARRAY[PROTOTYPE]*/
void r37add_last(T37* C,T0* a1){
T2 _new_capacity=0;
/*l148c10/fixed_array.e*/
/*[IF*/
if((int32_t)((/*(IRF4.6+*/(int32_t)(((/*RF2*/(/*RF2*/(C)->_upper/*8*/)))+(INT8_C(1)))/*)*/)<=(/*(IRF4.6-*/(int32_t)(((/*RF2*/(/*RF2*/(C)->_capacity/*4*/)))-(INT8_C(1)))/*)*/))){
/*l149c13/fixed_array.e*/
/*SFN*/(C->_upper/*8*/)=/*(IRF4.6+*/(int32_t)(((/*RF2*/(/*RF2*/(C)->_upper/*8*/)))+(INT8_C(1)))/*)*/;
}
 else if(((/*RF2*/(C)->_capacity/*4*/))==(INT8_C(0))){
/*l151c13/fixed_array.e*/
/*SFN*/(C->_storage/*0*/)=new39(INT8_C(2));
/*l152c13/fixed_array.e*/
/*SFN*/(C->_capacity/*4*/)=INT8_C(2);
/*l153c13/fixed_array.e*/
/*SFN*/(C->_upper/*8*/)=INT8_C(0);
}
else{
/*l155c13/fixed_array.e*/
_new_capacity=/*(IRF4.6**/(int32_t)(((/*RF2*/INT8_C(2)))*((/*RF2*/(C)->_capacity/*4*/)))/*)*/;
/*l156c13/fixed_array.e*/
/*SFN*/(C->_storage/*0*/)=r39realloc((/*RF2*/(C)->_storage/*0*/),(/*RF2*/(C)->_capacity/*4*/),_new_capacity);
/*l157c13/fixed_array.e*/
/*SFN*/(C->_capacity/*4*/)=_new_capacity;
/*l158c13/fixed_array.e*/
/*SFN*/(C->_upper/*8*/)=/*(IRF4.6+*/(int32_t)(((/*RF2*/(/*RF2*/(C)->_upper/*8*/)))+(INT8_C(1)))/*)*/;
}
/*FI]*/
/*l160c18/fixed_array.e*/
((/*RF2*/(C)->_storage/*0*/))[(/*RF2*/(C)->_upper/*8*/)]=(a1);
}

/*FIXED_ARRAY[STRING]*/
void r49make(T49* C,T2 a1){
/*l45c3/fixed_array.e*/
/*[IF*/
if((int32_t)((a1)>((/*RF2*/(C)->_capacity/*4*/)))){
/*l47c13/fixed_array.e*/
/*SFN*/(C->_storage/*0*/)=new51(a1);
/*l48c13/fixed_array.e*/
/*SFN*/(C->_capacity/*4*/)=a1;
}
 else if((int32_t)(((/*RF2*/(C)->_capacity/*4*/))>(INT8_C(0)))){
/*l51c6/fixed_array.e*/
/*SFN*/(C->_upper/*8*/)=r2max((/*RF2*/(C)->_upper/*8*/),/*(IRF4.6-*/(int32_t)(((/*RF2*/a1))-(INT8_C(1)))/*)*/);
/*l52c6/fixed_array.e*/
/*[IF*/
if((int32_t)(((/*RF2*/(C)->_upper/*8*/))>=(INT8_C(0)))){
/*l53c17/fixed_array.e*/
r51clear_all((/*RF2*/(C)->_storage/*0*/),(/*RF2*/(C)->_upper/*8*/));
}
/*FI]*/
}
/*FI]*/
/*l56c3/fixed_array.e*/
/*SFN*/(C->_upper/*8*/)=/*(IRF4.6-*/(int32_t)(((/*RF2*/a1))-(INT8_C(1)))/*)*/;
}

/*FIXED_ARRAY[STRING]*/
void r49add_last(T49* C,T0* a1){
T2 _new_capacity=0;
/*l148c10/fixed_array.e*/
/*[IF*/
if((int32_t)((/*(IRF4.6+*/(int32_t)(((/*RF2*/(/*RF2*/(C)->_upper/*8*/)))+(INT8_C(1)))/*)*/)<=(/*(IRF4.6-*/(int32_t)(((/*RF2*/(/*RF2*/(C)->_capacity/*4*/)))-(INT8_C(1)))/*)*/))){
/*l149c13/fixed_array.e*/
/*SFN*/(C->_upper/*8*/)=/*(IRF4.6+*/(int32_t)(((/*RF2*/(/*RF2*/(C)->_upper/*8*/)))+(INT8_C(1)))/*)*/;
}
 else if(((/*RF2*/(C)->_capacity/*4*/))==(INT8_C(0))){
/*l151c13/fixed_array.e*/
/*SFN*/(C->_storage/*0*/)=new51(INT8_C(2));
/*l152c13/fixed_array.e*/
/*SFN*/(C->_capacity/*4*/)=INT8_C(2);
/*l153c13/fixed_array.e*/
/*SFN*/(C->_upper/*8*/)=INT8_C(0);
}
else{
/*l155c13/fixed_array.e*/
_new_capacity=/*(IRF4.6**/(int32_t)(((/*RF2*/INT8_C(2)))*((/*RF2*/(C)->_capacity/*4*/)))/*)*/;
/*l156c13/fixed_array.e*/
/*SFN*/(C->_storage/*0*/)=r51realloc((/*RF2*/(C)->_storage/*0*/),(/*RF2*/(C)->_capacity/*4*/),_new_capacity);
/*l157c13/fixed_array.e*/
/*SFN*/(C->_capacity/*4*/)=_new_capacity;
/*l158c13/fixed_array.e*/
/*SFN*/(C->_upper/*8*/)=/*(IRF4.6+*/(int32_t)(((/*RF2*/(/*RF2*/(C)->_upper/*8*/)))+(INT8_C(1)))/*)*/;
}
/*FI]*/
/*l160c18/fixed_array.e*/
((/*RF2*/(C)->_storage/*0*/))[(/*RF2*/(C)->_upper/*8*/)]=(a1);
}

/*FIXED_ARRAY[STRING]*/
void r49with_capacity(T49* C,T2 a1){
/*l68c10/fixed_array.e*/
/*[IF*/
if((int32_t)(((/*RF2*/(C)->_capacity/*4*/))<(a1))){
/*l69c13/fixed_array.e*/
/*SFN*/(C->_storage/*0*/)=new51(a1);
/*l70c13/fixed_array.e*/
/*SFN*/(C->_capacity/*4*/)=a1;
}
 else if((int32_t)(((/*RF2*/(C)->_capacity/*4*/))>(a1))){
/*l72c14/fixed_array.e*/
r51clear((/*RF2*/(C)->_storage/*0*/),/*IC*/(T2)(INT8_C(0)),(/*RF2*/(C)->_upper/*8*/));
}
/*FI]*/
/*l74c10/fixed_array.e*/
/*SFN*/(C->_upper/*8*/)=INT8_C(-1);
}

/*FIXED_ARRAY[INTEGER]*/
void r41copy(T41* C,T0* a1){
T2 _other_upper=0;
T2 _new_capacity=0;
/*l180c10/fixed_array.e*/
_other_upper=(/*RF2*/(((T41*)a1))->_upper/*9*/);
/*l181c10/fixed_array.e*/
/*[IF*/
if((int32_t)((_other_upper)>=(INT8_C(0)))){
/*l182c13/fixed_array.e*/
_new_capacity=/*(IRF4.6+*/(int32_t)(((/*RF2*/_other_upper))+(INT8_C(1)))/*)*/;
/*l183c13/fixed_array.e*/
/*[IF*/
if((int32_t)(((/*RF2*/(C)->_capacity/*5*/))<(_new_capacity))){
/*l184c16/fixed_array.e*/
/*SFN*/(C->_storage/*1*/)=new43(_new_capacity);
/*l185c16/fixed_array.e*/
/*SFN*/(C->_capacity/*5*/)=_new_capacity;
}
 else if((int32_t)(((/*RF2*/(C)->_capacity/*5*/))>(INT8_C(0)))){
/*l187c24/fixed_array.e*/
r43clear_all((/*RF2*/(C)->_storage/*1*/),/*(IRF4.6-*/(int32_t)(((/*RF2*/(/*RF2*/(C)->_capacity/*5*/)))-(/*IC*/(T2)(INT8_C(1))))/*)*/);
}
/*FI]*/
/*l189c21/fixed_array.e*/
r43copy_from((/*RF2*/(C)->_storage/*1*/),(/*RF2*/(((T41*)a1))->_storage/*1*/),_other_upper);
}
 else if((int32_t)(((/*RF2*/(C)->_capacity/*5*/))>(INT8_C(0)))){
/*l191c21/fixed_array.e*/
r43clear_all((/*RF2*/(C)->_storage/*1*/),/*(IRF4.6-*/(int32_t)(((/*RF2*/(/*RF2*/(C)->_capacity/*5*/)))-(/*IC*/(T2)(INT8_C(1))))/*)*/);
}
/*FI]*/
/*l193c10/fixed_array.e*/
/*SFN*/(C->_upper/*9*/)=_other_upper;
}

/*FIXED_ARRAY[INTEGER]*/
T6 r41is_equal(T41* C,T0* a1){
T6 R=0;
/*l222c10/fixed_array.e*/
/*[IF*/
if((C)==((void*)(a1))){
/*l223c13/fixed_array.e*/
R=((T6)(1));
}
 else if(((/*RF2*/(C)->_upper/*9*/))==((/*RF2*/(((T41*)a1))->_upper/*9*/))){
/*l225c13/fixed_array.e*/
R=((T6)(r43fast_memcmp((/*RF2*/(C)->_storage/*1*/),(/*RF2*/(((T41*)a1))->_storage/*1*/),/*(IRF4.6+*/(int32_t)(((/*RF2*/(/*RF2*/(C)->_upper/*9*/)))+(/*IC*/(T2)(INT8_C(1))))/*)*/)));
}
/*FI]*/
return R;
}

/*FIXED_ARRAY[INTEGER]*/
void r41make(T41* C,T2 a1){
/*l45c3/fixed_array.e*/
/*[IF*/
if((int32_t)((a1)>((/*RF2*/(C)->_capacity/*5*/)))){
/*l47c13/fixed_array.e*/
/*SFN*/(C->_storage/*1*/)=new43(a1);
/*l48c13/fixed_array.e*/
/*SFN*/(C->_capacity/*5*/)=a1;
}
 else if((int32_t)(((/*RF2*/(C)->_capacity/*5*/))>(INT8_C(0)))){
/*l51c6/fixed_array.e*/
/*SFN*/(C->_upper/*9*/)=r2max((/*RF2*/(C)->_upper/*9*/),/*(IRF4.6-*/(int32_t)(((/*RF2*/a1))-(INT8_C(1)))/*)*/);
/*l52c6/fixed_array.e*/
/*[IF*/
if((int32_t)(((/*RF2*/(C)->_upper/*9*/))>=(INT8_C(0)))){
/*l53c17/fixed_array.e*/
r43clear_all((/*RF2*/(C)->_storage/*1*/),(/*RF2*/(C)->_upper/*9*/));
}
/*FI]*/
}
/*FI]*/
/*l56c3/fixed_array.e*/
/*SFN*/(C->_upper/*9*/)=/*(IRF4.6-*/(int32_t)(((/*RF2*/a1))-(INT8_C(1)))/*)*/;
}

/*FIXED_ARRAY[INTEGER]*/
void r41remove_last(T41* C){
/*l79c10/arrayed_collection.e*/
/*SFN*/(C->_upper/*9*/)=/*(IRF4.6-*/(int32_t)(((/*RF2*/(/*RF2*/(C)->_upper/*9*/)))-(INT8_C(1)))/*)*/;
}

/*FIXED_ARRAY[INTEGER]*/
void r41add_last(T41* C,T2 a1){
T2 _new_capacity=0;
/*l148c10/fixed_array.e*/
/*[IF*/
if((int32_t)((/*(IRF4.6+*/(int32_t)(((/*RF2*/(/*RF2*/(C)->_upper/*9*/)))+(INT8_C(1)))/*)*/)<=(/*(IRF4.6-*/(int32_t)(((/*RF2*/(/*RF2*/(C)->_capacity/*5*/)))-(INT8_C(1)))/*)*/))){
/*l149c13/fixed_array.e*/
/*SFN*/(C->_upper/*9*/)=/*(IRF4.6+*/(int32_t)(((/*RF2*/(/*RF2*/(C)->_upper/*9*/)))+(INT8_C(1)))/*)*/;
}
 else if(((/*RF2*/(C)->_capacity/*5*/))==(INT8_C(0))){
/*l151c13/fixed_array.e*/
/*SFN*/(C->_storage/*1*/)=new43(INT8_C(2));
/*l152c13/fixed_array.e*/
/*SFN*/(C->_capacity/*5*/)=INT8_C(2);
/*l153c13/fixed_array.e*/
/*SFN*/(C->_upper/*9*/)=INT8_C(0);
}
else{
/*l155c13/fixed_array.e*/
_new_capacity=/*(IRF4.6**/(int32_t)(((/*RF2*/INT8_C(2)))*((/*RF2*/(C)->_capacity/*5*/)))/*)*/;
/*l156c13/fixed_array.e*/
/*SFN*/(C->_storage/*1*/)=r43realloc((/*RF2*/(C)->_storage/*1*/),(/*RF2*/(C)->_capacity/*5*/),_new_capacity);
/*l157c13/fixed_array.e*/
/*SFN*/(C->_capacity/*5*/)=_new_capacity;
/*l158c13/fixed_array.e*/
/*SFN*/(C->_upper/*9*/)=/*(IRF4.6+*/(int32_t)(((/*RF2*/(/*RF2*/(C)->_upper/*9*/)))+(INT8_C(1)))/*)*/;
}
/*FI]*/
/*l160c18/fixed_array.e*/
((/*RF2*/(C)->_storage/*1*/))[(/*RF2*/(C)->_upper/*9*/)]=(a1);
}

/*FIXED_ARRAY[INTEGER]*/
void r41resize(T41* C,T2 a1){
T2 _new_capacity=0;
/*l91c10/fixed_array.e*/
/*[IF*/
if((int32_t)((a1)>(/*(IRF4.6count*//*(IRF4.6+*/(int32_t)(((/*RF2*/(/*RF2*/(C)->_upper/*9*/)))+(INT8_C(1)))/*)*//*)*/))){
/*l92c6/fixed_array.e*/
/*[IF*/
if(((/*RF2*/(C)->_capacity/*5*/))==(INT8_C(0))){
/*l93c9/fixed_array.e*/
/*SFN*/(C->_storage/*1*/)=new43(a1);
/*l94c9/fixed_array.e*/
/*SFN*/(C->_capacity/*5*/)=a1;
}
 else if((int32_t)(((/*RF2*/(C)->_capacity/*5*/))<(a1))){
/*l96c9/fixed_array.e*/
/*l97c5/fixed_array.e*/
_new_capacity=/*(IRF4.6**/(int32_t)(((/*RF2*/(/*RF2*/(C)->_capacity/*5*/)))*(INT8_C(2)))/*)*/;
while (!((int32_t)((_new_capacity)>=(a1))))
{
/*l101c5/fixed_array.e*/
_new_capacity=/*(IRF4.6**/(int32_t)(((/*RF2*/_new_capacity))*(INT8_C(2)))/*)*/;
}
/*l103c9/fixed_array.e*/
/*SFN*/(C->_storage/*1*/)=r43realloc((/*RF2*/(C)->_storage/*1*/),(/*RF2*/(C)->_capacity/*5*/),_new_capacity);
/*l104c9/fixed_array.e*/
/*SFN*/(C->_capacity/*5*/)=_new_capacity;
}
/*FI]*/
}
 else if((a1)!=(/*(IRF4.6count*//*(IRF4.6+*/(int32_t)(((/*RF2*/(/*RF2*/(C)->_upper/*9*/)))+(INT8_C(1)))/*)*//*)*/)){
/*l107c14/fixed_array.e*/
r43clear((/*RF2*/(C)->_storage/*1*/),a1,/*(IRF4.6-*/(int32_t)(((/*RF2*//*(IRF4.6count*//*(IRF4.6+*/(int32_t)(((/*RF2*/(/*RF2*/(C)->_upper/*9*/)))+(INT8_C(1)))/*)*//*)*/))-(/*IC*/(T2)(INT8_C(1))))/*)*/);
}
/*FI]*/
/*l109c3/fixed_array.e*/
/*SFN*/(C->_upper/*9*/)=/*(IRF4.6-*/(int32_t)(((/*RF2*/a1))-(INT8_C(1)))/*)*/;
}

/*FIXED_ARRAY[INTEGER]*/
T0* r41twin(T41* C){
T0* R=NULL;
R=((void*)new41());
r41copy(((T41*)R),((T0*)C));
return R;
}

/*FIXED_ARRAY[SLOT]*/
void r178make(T178* C,T2 a1){
/*l45c3/fixed_array.e*/
/*[IF*/
if((int32_t)((a1)>((/*RF2*/(C)->_capacity/*4*/)))){
/*l47c13/fixed_array.e*/
/*SFN*/(C->_storage/*0*/)=new180(a1);
/*l48c13/fixed_array.e*/
/*SFN*/(C->_capacity/*4*/)=a1;
}
 else if((int32_t)(((/*RF2*/(C)->_capacity/*4*/))>(INT8_C(0)))){
/*l51c6/fixed_array.e*/
/*SFN*/(C->_upper/*8*/)=r2max((/*RF2*/(C)->_upper/*8*/),/*(IRF4.6-*/(int32_t)(((/*RF2*/a1))-(INT8_C(1)))/*)*/);
/*l52c6/fixed_array.e*/
/*[IF*/
if((int32_t)(((/*RF2*/(C)->_upper/*8*/))>=(INT8_C(0)))){
/*l53c17/fixed_array.e*/
r180clear_all((/*RF2*/(C)->_storage/*0*/),(/*RF2*/(C)->_upper/*8*/));
}
/*FI]*/
}
/*FI]*/
/*l56c3/fixed_array.e*/
/*SFN*/(C->_upper/*8*/)=/*(IRF4.6-*/(int32_t)(((/*RF2*/a1))-(INT8_C(1)))/*)*/;
}

/*FIXED_ARRAY[RUNTIME]*/
void r72force(T72* C,T0* a1,T2 a2){
/*l276c10/fixed_array.e*/
/*[IF*/
if((int32_t)((a2)<=((/*RF2*/(C)->_upper/*8*/)))){
/*l277c21/fixed_array.e*/
((/*RF2*/(C)->_storage/*0*/))[a2]=(a1);
}
 else if((a2)==(/*(IRF4.6+*/(int32_t)(((/*RF2*/(/*RF2*/(C)->_upper/*8*/)))+(INT8_C(1)))/*)*/)){
/*l279c13/fixed_array.e*/
r72add_last(C,a1);
}
else{
/*l281c13/fixed_array.e*/
r72resize(C,/*(IRF4.6+*/(int32_t)(((/*RF2*/a2))+(/*IC*/(T2)(INT8_C(1))))/*)*/);
/*l282c21/fixed_array.e*/
((/*RF2*/(C)->_storage/*0*/))[a2]=(a1);
}
/*FI]*/
}

/*FIXED_ARRAY[RUNTIME]*/
T0* r72last(T72* C){
T0* R=NULL;
/*l63c10/arrayed_collection.e*/
R=/*(IRF4.6item*/((/*RF2*/(C)->_storage/*0*/))[(/*RF2*/(C)->_upper/*8*/)]/*)*/;
return R;
}

/*FIXED_ARRAY[RUNTIME]*/
void r72remove_first(T72* C){
T74 _void_storage=NULL;
/*l290c10/fixed_array.e*/
/*[IF*/
if(((/*RF2*/(C)->_upper/*8*/))==(INT8_C(0))){
/*l291c13/fixed_array.e*/
/*SFN*/(C->_storage/*0*/)=_void_storage;
/*l292c13/fixed_array.e*/
/*SFN*/(C->_capacity/*4*/)=INT8_C(0);
/*l293c13/fixed_array.e*/
/*SFN*/(C->_upper/*8*/)=INT8_C(-1);
}
else{
/*l295c21/fixed_array.e*/
r74remove_first((/*RF2*/(C)->_storage/*0*/),(/*RF2*/(C)->_upper/*8*/));
/*l296c13/fixed_array.e*/
/*SFN*/(C->_upper/*8*/)=/*(IRF4.6-*/(int32_t)(((/*RF2*/(/*RF2*/(C)->_upper/*8*/)))-(INT8_C(1)))/*)*/;
}
/*FI]*/
}

/*FIXED_ARRAY[RUNTIME]*/
void r72add_first(T72* C,T0* a1){
/*l134c10/fixed_array.e*/
r72add_last(C,a1);
/*l135c10/fixed_array.e*/
/*[IF*/
if(((/*RF2*/(C)->_upper/*8*/))==(INT8_C(0))){
}
 else if(((/*RF2*/(C)->_upper/*8*/))==(INT8_C(1))){
/*l137c13/fixed_array.e*/
r72swap(C,/*IC*/(T2)(INT8_C(0)),/*IC*/(T2)(INT8_C(1)));
}
else{
/*l139c13/fixed_array.e*/
r72move(C,/*IC*/(T2)(INT8_C(0)),/*(IRF4.6-*/(int32_t)(((/*RF2*/(/*RF2*/(C)->_upper/*8*/)))-(/*IC*/(T2)(INT8_C(1))))/*)*/,/*IC*/(T2)(INT8_C(1)));
/*l140c21/fixed_array.e*/
((/*RF2*/(C)->_storage/*0*/))[/*IC*/(T2)(INT8_C(0))]=(a1);
}
/*FI]*/
}

/*FIXED_ARRAY[RUNTIME]*/
void r72move(T72* C,T2 a1,T2 a2,T2 a3){
T0* _default_value=NULL;
T2 _i=0;
/*l526c10/collection.e*/
/*[IF*/
if((a3)==(INT8_C(0))){
}
 else if((int32_t)((a3)<(INT8_C(0)))){
/*l528c13/collection.e*/
/*l529c16/collection.e*/
_i=a1;
while (!((int32_t)((_i)>(a2))))
{
/*l533c16/collection.e*/
/*[IRF3.5put*/((/*RF2*/(C)->_storage/*0*/))[/*(IRF4.6+*/(int32_t)(((/*RF2*/_i))+(a3))/*)*/]=(/*(IRF4.6item*/((/*RF2*/(C)->_storage/*0*/))[_i]/*)*/);
/*]*/
/*l534c16/collection.e*/
/*[IRF3.5put*/((/*RF2*/(C)->_storage/*0*/))[_i]=(_default_value);
/*]*/
/*l535c16/collection.e*/
_i=/*(IRF4.6+*/(int32_t)(((/*RF2*/_i))+(INT8_C(1)))/*)*/;
}
}
else{
/*l538c13/collection.e*/
/*l539c16/collection.e*/
_i=a2;
while (!((int32_t)((_i)<(a1))))
{
/*l543c16/collection.e*/
/*[IRF3.5put*/((/*RF2*/(C)->_storage/*0*/))[/*(IRF4.6+*/(int32_t)(((/*RF2*/_i))+(a3))/*)*/]=(/*(IRF4.6item*/((/*RF2*/(C)->_storage/*0*/))[_i]/*)*/);
/*]*/
/*l544c16/collection.e*/
/*[IRF3.5put*/((/*RF2*/(C)->_storage/*0*/))[_i]=(_default_value);
/*]*/
/*l545c16/collection.e*/
_i=/*(IRF4.6-*/(int32_t)(((/*RF2*/_i))-(INT8_C(1)))/*)*/;
}
}
/*FI]*/
}

/*FIXED_ARRAY[RUNTIME]*/
void r72remove_last(T72* C){
/*l79c10/arrayed_collection.e*/
/*SFN*/(C->_upper/*8*/)=/*(IRF4.6-*/(int32_t)(((/*RF2*/(/*RF2*/(C)->_upper/*8*/)))-(INT8_C(1)))/*)*/;
}

/*FIXED_ARRAY[RUNTIME]*/
void r72add_last(T72* C,T0* a1){
T2 _new_capacity=0;
/*l148c10/fixed_array.e*/
/*[IF*/
if((int32_t)((/*(IRF4.6+*/(int32_t)(((/*RF2*/(/*RF2*/(C)->_upper/*8*/)))+(INT8_C(1)))/*)*/)<=(/*(IRF4.6-*/(int32_t)(((/*RF2*/(/*RF2*/(C)->_capacity/*4*/)))-(INT8_C(1)))/*)*/))){
/*l149c13/fixed_array.e*/
/*SFN*/(C->_upper/*8*/)=/*(IRF4.6+*/(int32_t)(((/*RF2*/(/*RF2*/(C)->_upper/*8*/)))+(INT8_C(1)))/*)*/;
}
 else if(((/*RF2*/(C)->_capacity/*4*/))==(INT8_C(0))){
/*l151c13/fixed_array.e*/
/*SFN*/(C->_storage/*0*/)=new74(INT8_C(2));
/*l152c13/fixed_array.e*/
/*SFN*/(C->_capacity/*4*/)=INT8_C(2);
/*l153c13/fixed_array.e*/
/*SFN*/(C->_upper/*8*/)=INT8_C(0);
}
else{
/*l155c13/fixed_array.e*/
_new_capacity=/*(IRF4.6**/(int32_t)(((/*RF2*/INT8_C(2)))*((/*RF2*/(C)->_capacity/*4*/)))/*)*/;
/*l156c13/fixed_array.e*/
/*SFN*/(C->_storage/*0*/)=r74realloc((/*RF2*/(C)->_storage/*0*/),(/*RF2*/(C)->_capacity/*4*/),_new_capacity);
/*l157c13/fixed_array.e*/
/*SFN*/(C->_capacity/*4*/)=_new_capacity;
/*l158c13/fixed_array.e*/
/*SFN*/(C->_upper/*8*/)=/*(IRF4.6+*/(int32_t)(((/*RF2*/(/*RF2*/(C)->_upper/*8*/)))+(INT8_C(1)))/*)*/;
}
/*FI]*/
/*l160c18/fixed_array.e*/
((/*RF2*/(C)->_storage/*0*/))[(/*RF2*/(C)->_upper/*8*/)]=(a1);
}

/*FIXED_ARRAY[RUNTIME]*/
void r72resize(T72* C,T2 a1){
T2 _new_capacity=0;
/*l91c10/fixed_array.e*/
/*[IF*/
if((int32_t)((a1)>(/*(IRF4.6count*//*(IRF4.6+*/(int32_t)(((/*RF2*/(/*RF2*/(C)->_upper/*8*/)))+(INT8_C(1)))/*)*//*)*/))){
/*l92c6/fixed_array.e*/
/*[IF*/
if(((/*RF2*/(C)->_capacity/*4*/))==(INT8_C(0))){
/*l93c9/fixed_array.e*/
/*SFN*/(C->_storage/*0*/)=new74(a1);
/*l94c9/fixed_array.e*/
/*SFN*/(C->_capacity/*4*/)=a1;
}
 else if((int32_t)(((/*RF2*/(C)->_capacity/*4*/))<(a1))){
/*l96c9/fixed_array.e*/
/*l97c5/fixed_array.e*/
_new_capacity=/*(IRF4.6**/(int32_t)(((/*RF2*/(/*RF2*/(C)->_capacity/*4*/)))*(INT8_C(2)))/*)*/;
while (!((int32_t)((_new_capacity)>=(a1))))
{
/*l101c5/fixed_array.e*/
_new_capacity=/*(IRF4.6**/(int32_t)(((/*RF2*/_new_capacity))*(INT8_C(2)))/*)*/;
}
/*l103c9/fixed_array.e*/
/*SFN*/(C->_storage/*0*/)=r74realloc((/*RF2*/(C)->_storage/*0*/),(/*RF2*/(C)->_capacity/*4*/),_new_capacity);
/*l104c9/fixed_array.e*/
/*SFN*/(C->_capacity/*4*/)=_new_capacity;
}
/*FI]*/
}
 else if((a1)!=(/*(IRF4.6count*//*(IRF4.6+*/(int32_t)(((/*RF2*/(/*RF2*/(C)->_upper/*8*/)))+(INT8_C(1)))/*)*//*)*/)){
/*l107c14/fixed_array.e*/
r74clear((/*RF2*/(C)->_storage/*0*/),a1,/*(IRF4.6-*/(int32_t)(((/*RF2*//*(IRF4.6count*//*(IRF4.6+*/(int32_t)(((/*RF2*/(/*RF2*/(C)->_upper/*8*/)))+(INT8_C(1)))/*)*//*)*/))-(/*IC*/(T2)(INT8_C(1))))/*)*/);
}
/*FI]*/
/*l109c3/fixed_array.e*/
/*SFN*/(C->_upper/*8*/)=/*(IRF4.6-*/(int32_t)(((/*RF2*/a1))-(INT8_C(1)))/*)*/;
}

/*FIXED_ARRAY[RUNTIME]*/
void r72with_capacity(T72* C,T2 a1){
/*l68c10/fixed_array.e*/
/*[IF*/
if((int32_t)(((/*RF2*/(C)->_capacity/*4*/))<(a1))){
/*l69c13/fixed_array.e*/
/*SFN*/(C->_storage/*0*/)=new74(a1);
/*l70c13/fixed_array.e*/
/*SFN*/(C->_capacity/*4*/)=a1;
}
 else if((int32_t)(((/*RF2*/(C)->_capacity/*4*/))>(a1))){
/*l72c14/fixed_array.e*/
r74clear((/*RF2*/(C)->_storage/*0*/),/*IC*/(T2)(INT8_C(0)),(/*RF2*/(C)->_upper/*8*/));
}
/*FI]*/
/*l74c10/fixed_array.e*/
/*SFN*/(C->_upper/*8*/)=INT8_C(-1);
}

/*FIXED_ARRAY[RUNTIME]*/
void r72swap(T72* C,T2 a1,T2 a2){
T0* _tmp=NULL;
/*l118c10/collection.e*/
_tmp=/*(IRF4.6item*/((/*RF2*/(C)->_storage/*0*/))[a1]/*)*/;
/*l119c10/collection.e*/
/*[IRF3.5put*/((/*RF2*/(C)->_storage/*0*/))[a1]=(/*(IRF4.6item*/((/*RF2*/(C)->_storage/*0*/))[a2]/*)*/);
/*]*/
/*l120c10/collection.e*/
/*[IRF3.5put*/((/*RF2*/(C)->_storage/*0*/))[a2]=(_tmp);
/*]*/
}

/*FIXED_ARRAY[LINKED_LIST[CODE_SLOT]]*/
void r217make(T217* C,T2 a1){
/*l45c3/fixed_array.e*/
/*[IF*/
if((int32_t)((a1)>((/*RF2*/(C)->_capacity/*4*/)))){
/*l47c13/fixed_array.e*/
/*SFN*/(C->_storage/*0*/)=new219(a1);
/*l48c13/fixed_array.e*/
/*SFN*/(C->_capacity/*4*/)=a1;
}
 else if((int32_t)(((/*RF2*/(C)->_capacity/*4*/))>(INT8_C(0)))){
/*l51c6/fixed_array.e*/
/*SFN*/(C->_upper/*8*/)=r2max((/*RF2*/(C)->_upper/*8*/),/*(IRF4.6-*/(int32_t)(((/*RF2*/a1))-(INT8_C(1)))/*)*/);
/*l52c6/fixed_array.e*/
/*[IF*/
if((int32_t)(((/*RF2*/(C)->_upper/*8*/))>=(INT8_C(0)))){
/*l53c17/fixed_array.e*/
r219clear_all((/*RF2*/(C)->_storage/*0*/),(/*RF2*/(C)->_upper/*8*/));
}
/*FI]*/
}
/*FI]*/
/*l56c3/fixed_array.e*/
/*SFN*/(C->_upper/*8*/)=/*(IRF4.6-*/(int32_t)(((/*RF2*/a1))-(INT8_C(1)))/*)*/;
}

/*FIXED_ARRAY[LINKED_LIST[CODE_SLOT]]*/
void r217resize(T217* C,T2 a1){
T2 _new_capacity=0;
/*l91c10/fixed_array.e*/
/*[IF*/
if((int32_t)((a1)>(/*(IRF4.6count*//*(IRF4.6+*/(int32_t)(((/*RF2*/(/*RF2*/(C)->_upper/*8*/)))+(INT8_C(1)))/*)*//*)*/))){
/*l92c6/fixed_array.e*/
/*[IF*/
if(((/*RF2*/(C)->_capacity/*4*/))==(INT8_C(0))){
/*l93c9/fixed_array.e*/
/*SFN*/(C->_storage/*0*/)=new219(a1);
/*l94c9/fixed_array.e*/
/*SFN*/(C->_capacity/*4*/)=a1;
}
 else if((int32_t)(((/*RF2*/(C)->_capacity/*4*/))<(a1))){
/*l96c9/fixed_array.e*/
/*l97c5/fixed_array.e*/
_new_capacity=/*(IRF4.6**/(int32_t)(((/*RF2*/(/*RF2*/(C)->_capacity/*4*/)))*(INT8_C(2)))/*)*/;
while (!((int32_t)((_new_capacity)>=(a1))))
{
/*l101c5/fixed_array.e*/
_new_capacity=/*(IRF4.6**/(int32_t)(((/*RF2*/_new_capacity))*(INT8_C(2)))/*)*/;
}
/*l103c9/fixed_array.e*/
/*SFN*/(C->_storage/*0*/)=r219realloc((/*RF2*/(C)->_storage/*0*/),(/*RF2*/(C)->_capacity/*4*/),_new_capacity);
/*l104c9/fixed_array.e*/
/*SFN*/(C->_capacity/*4*/)=_new_capacity;
}
/*FI]*/
}
 else if((a1)!=(/*(IRF4.6count*//*(IRF4.6+*/(int32_t)(((/*RF2*/(/*RF2*/(C)->_upper/*8*/)))+(INT8_C(1)))/*)*//*)*/)){
/*l107c14/fixed_array.e*/
r219clear((/*RF2*/(C)->_storage/*0*/),a1,/*(IRF4.6-*/(int32_t)(((/*RF2*//*(IRF4.6count*//*(IRF4.6+*/(int32_t)(((/*RF2*/(/*RF2*/(C)->_upper/*8*/)))+(INT8_C(1)))/*)*//*)*/))-(/*IC*/(T2)(INT8_C(1))))/*)*/);
}
/*FI]*/
/*l109c3/fixed_array.e*/
/*SFN*/(C->_upper/*8*/)=/*(IRF4.6-*/(int32_t)(((/*RF2*/a1))-(INT8_C(1)))/*)*/;
}

/*LINK[CODE_SLOT]*/
void r127make(T127* C,T0* a1,T0* a2){
/*l36c10/link.e*/
/*SFN*/(C->_item/*0*/)=a1;
/*l37c10/link.e*/
/*SFN*/(C->_next/*4*/)=a2;
}

/*LINK[ITM_CODE]*/
void r140make(T140* C,T0* a1,T0* a2){
/*l36c10/link.e*/
/*SFN*/(C->_item/*0*/)=a1;
/*l37c10/link.e*/
/*SFN*/(C->_next/*4*/)=a2;
}

/*LINKED_LIST[SET[INTEGER]]*/
void r55remove_first(T55* C){
/*l119c10/linked_list.e*/
/*[IF*/
if(((/*RF2*/(C)->_upper/*0*/))==(INT8_C(1))){
/*l120c13/linked_list.e*/
r55make(C);
}
else{
/*l122c13/linked_list.e*/
/*SFN*/(C->_first_link/*4*/)=(/*RF2*/((T58*)((/*RF2*/(C)->_first_link/*4*/)))->_next/*4*/);
/*l123c13/linked_list.e*/
/*[IF*/
if(((/*RF2*/(C)->_mem_idx/*12*/))==(INT8_C(1))){
/*l124c9/linked_list.e*/
/*SFN*/(C->_mem_lnk/*16*/)=(/*RF2*/(C)->_first_link/*4*/);
}
else{
/*l126c9/linked_list.e*/
/*SFN*/(C->_mem_idx/*12*/)=/*(IRF4.6-*/(int32_t)(((/*RF2*/(/*RF2*/(C)->_mem_idx/*12*/)))-(INT8_C(1)))/*)*/;
}
/*FI]*/
/*l128c6/linked_list.e*/
/*SFN*/(C->_upper/*0*/)=/*(IRF4.6-*/(int32_t)(((/*RF2*/(/*RF2*/(C)->_upper/*0*/)))-(INT8_C(1)))/*)*/;
}
/*FI]*/
}

/*LINKED_LIST[SET[INTEGER]]*/
T0* r55item(T55* C,T2 a1){
T0* R=NULL;
/*l162c10/linked_list.e*/
/*[IF*/
if((a1)!=((/*RF2*/(C)->_mem_idx/*12*/))){
/*l163c13/linked_list.e*/
r55go_item(C,a1);
}
/*FI]*/
/*l165c10/linked_list.e*/
R=(/*RF2*/((T58*)((/*RF2*/(C)->_mem_lnk/*16*/)))->_item/*0*/);
return R;
}

/*LINKED_LIST[SET[INTEGER]]*/
void r55make(T55* C){
/*l52c10/linked_list.e*/
/*SFN*/(C->_first_link/*4*/)=NULL;
/*l53c10/linked_list.e*/
/*SFN*/(C->_upper/*0*/)=INT8_C(0);
/*l54c10/linked_list.e*/
/*SFN*/(C->_last_link/*8*/)=NULL;
/*l55c10/linked_list.e*/
/*SFN*/(C->_mem_idx/*12*/)=INT8_C(0);
/*l56c10/linked_list.e*/
/*SFN*/(C->_mem_lnk/*16*/)=NULL;
}

/*LINKED_LIST[SET[INTEGER]]*/
void r55remove(T55* C,T2 a1){
T0* _link=NULL;
/*l136c10/linked_list.e*/
/*[IF*/
if((a1)==(INT8_C(1))){
/*l137c13/linked_list.e*/
r55remove_first(C);
}
 else if((a1)==((/*RF2*/(C)->_upper/*0*/))){
/*l139c13/linked_list.e*/
r55remove_last(C);
}
else{
/*l141c13/linked_list.e*/
/*[IF*/
if((/*(IRF4.6-*/(int32_t)(((/*RF2*/a1))-(INT8_C(1)))/*)*/)!=((/*RF2*/(C)->_mem_idx/*12*/))){
/*l142c16/linked_list.e*/
r55go_item(C,/*(IRF4.6-*/(int32_t)(((/*RF2*/a1))-(/*IC*/(T2)(INT8_C(1))))/*)*/);
}
/*FI]*/
/*l144c13/linked_list.e*/
_link=(/*RF2*/((T58*)((/*RF2*/(C)->_mem_lnk/*16*/)))->_next/*4*/);
/*l145c21/linked_list.e*/
/*[IRF3.3set_next*/((((T58*)((T58*)((/*RF2*/(C)->_mem_lnk/*16*/)))))->_next/*4*/)=((/*RF2*/(((T58*)_link))->_next/*4*/));
/*]*/
/*l146c13/linked_list.e*/
/*SFN*/(C->_upper/*0*/)=/*(IRF4.6-*/(int32_t)(((/*RF2*/(/*RF2*/(C)->_upper/*0*/)))-(INT8_C(1)))/*)*/;
}
/*FI]*/
}

/*LINKED_LIST[SET[INTEGER]]*/
void r55remove_last(T55* C){
/*l411c10/linked_list.e*/
/*[IF*/
if(((/*RF2*/(C)->_upper/*0*/))==(INT8_C(1))){
/*l412c13/linked_list.e*/
r55make(C);
}
else{
/*l414c13/linked_list.e*/
/*[IF*/
if((/*(IRF4.6-*/(int32_t)(((/*RF2*/(/*RF2*/(C)->_upper/*0*/)))-(INT8_C(1)))/*)*/)!=((/*RF2*/(C)->_mem_idx/*12*/))){
/*l415c16/linked_list.e*/
r55go_item(C,/*(IRF4.6-*/(int32_t)(((/*RF2*/(/*RF2*/(C)->_upper/*0*/)))-(/*IC*/(T2)(INT8_C(1))))/*)*/);
}
/*FI]*/
/*l417c13/linked_list.e*/
/*SFN*/(C->_upper/*0*/)=/*(IRF4.6-*/(int32_t)(((/*RF2*/(/*RF2*/(C)->_upper/*0*/)))-(INT8_C(1)))/*)*/;
/*l418c13/linked_list.e*/
/*SFN*/(C->_last_link/*8*/)=(/*RF2*/(C)->_mem_lnk/*16*/);
/*l419c23/linked_list.e*/
/*[IRF3.3set_next*/((((T58*)((T58*)((/*RF2*/(C)->_last_link/*8*/)))))->_next/*4*/)=(NULL);
/*]*/
}
/*FI]*/
}

/*LINKED_LIST[SET[INTEGER]]*/
void r55add_last(T55* C,T0* a1){
T0* _lnk=NULL;
/*l85c10/linked_list.e*/
/*[IF*/
if(((/*RF2*/(C)->_first_link/*4*/))==((void*)(NULL))){
/*l86c13/linked_list.e*/
{T58*n=new58();
r58make(n,a1,NULL);
/*SFN*/(C->_first_link/*4*/)=((T0*)n);
}
/*l87c13/linked_list.e*/
/*SFN*/(C->_upper/*0*/)=INT8_C(1);
/*l88c13/linked_list.e*/
/*SFN*/(C->_last_link/*8*/)=(/*RF2*/(C)->_first_link/*4*/);
/*l89c13/linked_list.e*/
/*SFN*/(C->_mem_idx/*12*/)=INT8_C(1);
/*l90c13/linked_list.e*/
/*SFN*/(C->_mem_lnk/*16*/)=(/*RF2*/(C)->_first_link/*4*/);
}
else{
/*l92c13/linked_list.e*/
{T58*n=new58();
r58make(n,a1,NULL);
_lnk=((T0*)n);
}
/*l93c23/linked_list.e*/
/*[IRF3.3set_next*/((((T58*)((T58*)((/*RF2*/(C)->_last_link/*8*/)))))->_next/*4*/)=(_lnk);
/*]*/
/*l94c13/linked_list.e*/
/*SFN*/(C->_upper/*0*/)=/*(IRF4.6+*/(int32_t)(((/*RF2*/(/*RF2*/(C)->_upper/*0*/)))+(INT8_C(1)))/*)*/;
/*l95c13/linked_list.e*/
/*SFN*/(C->_last_link/*8*/)=_lnk;
}
/*FI]*/
}

/*LINKED_LIST[SET[INTEGER]]*/
void r55clear(T55* C){
/*l262c10/linked_list.e*/
/*[IF*/
if(((/*RF2*/(C)->_first_link/*4*/))!=((void*)(NULL))){
/*l263c13/linked_list.e*/
/*SFN*/(C->_first_link/*4*/)=NULL;
/*l264c13/linked_list.e*/
/*SFN*/(C->_mem_idx/*12*/)=INT8_C(0);
/*l265c13/linked_list.e*/
/*SFN*/(C->_mem_lnk/*16*/)=NULL;
/*l266c13/linked_list.e*/
/*SFN*/(C->_upper/*0*/)=INT8_C(0);
/*l267c13/linked_list.e*/
/*SFN*/(C->_last_link/*8*/)=NULL;
}
/*FI]*/
}

/*LINKED_LIST[SET[INTEGER]]*/
void r55go_item(T55* C,T2 a1){
/*l490c10/linked_list.e*/
/*[IF*/
if((int32_t)(((/*RF2*/(C)->_mem_idx/*12*/))>(a1))){
/*l491c13/linked_list.e*/
/*SFN*/(C->_mem_idx/*12*/)=INT8_C(1);
/*l492c13/linked_list.e*/
/*SFN*/(C->_mem_lnk/*16*/)=(/*RF2*/(C)->_first_link/*4*/);
}
/*FI]*/
/*l494c10/linked_list.e*/
while (!((a1)==((/*RF2*/(C)->_mem_idx/*12*/))))
{
/*l498c13/linked_list.e*/
/*SFN*/(C->_mem_lnk/*16*/)=(/*RF2*/((T58*)((/*RF2*/(C)->_mem_lnk/*16*/)))->_next/*4*/);
/*l499c13/linked_list.e*/
/*SFN*/(C->_mem_idx/*12*/)=/*(IRF4.6+*/(int32_t)(((/*RF2*/(/*RF2*/(C)->_mem_idx/*12*/)))+(INT8_C(1)))/*)*/;
}
}

/*DICTIONARY[INTEGER,STRING]*/
void r89put(T89* C,T2 a1,T0* a2){
T2 _h=0;
T2 _idx=0;
T0* _node=NULL;
/*l136c3/dictionary.e*/
/*l137c6/dictionary.e*/
_h=r7hash_code(((T7*)a2));
/*l138c6/dictionary.e*/
_idx=(int32_t)((_h)%((/*RF2*/(C)->_capacity/*4*/)));
/*l139c6/dictionary.e*/
_node=((/*RF2*/(C)->_buckets/*0*/))[_idx];
while (!((T6)(((_node)==((void*)(NULL)))||((T6)(r7is_equal((T7*)((/*RF2*/(((T92*)_node))->_key/*4*/)),a2))))))
{
/*l143c6/dictionary.e*/
_node=(/*RF2*/(((T92*)_node))->_next/*8*/);
}
/*l145c3/dictionary.e*/
/*[IF*/
if((_node)==((void*)(NULL))){
/*l146c6/dictionary.e*/
/*[IF*/
if(((/*RF2*/(C)->_capacity/*4*/))==((/*RF2*/(C)->_count/*8*/))){
/*l147c9/dictionary.e*/
r89increase_capacity(C);
/*l148c9/dictionary.e*/
_idx=(int32_t)((_h)%((/*RF2*/(C)->_capacity/*4*/)));
}
/*FI]*/
/*l150c6/dictionary.e*/
{T92*n=new92();
r92make(n,a1,a2,((/*RF2*/(C)->_buckets/*0*/))[_idx]);
_node=((T0*)n);
}
/*l151c14/dictionary.e*/
((/*RF2*/(C)->_buckets/*0*/))[_idx]=(_node);
/*l152c6/dictionary.e*/
/*SFN*/(C->_count/*8*/)=/*(IRF4.6+*/(int32_t)(((/*RF2*/(/*RF2*/(C)->_count/*8*/)))+(INT8_C(1)))/*)*/;
/*l153c13/dictionary.e*/
/*SFN*/(C->_cache_user/*12*/)=INT8_C(-1);
}
else{
/*l155c11/dictionary.e*/
/*[IRF3.3set_item*/((((T92*)(((T92*)_node))))->_item/*0*/)=(a1);
/*]*/
}
/*FI]*/
}

/*DICTIONARY[INTEGER,STRING]*/
void r89increase_capacity(T89* C){
T2 _i=0;
T2 _idx=0;
T2 _new_capacity=0;
T91 _old_buckets=NULL;
T0* _node1=NULL;
T0* _node2=NULL;
int _hts=0;
/*l589c3/dictionary.e*/
/*l590c6/dictionary.e*/
_new_capacity=r67prime_number_ceiling(/*(IRF4.6+*/(int32_t)(((/*RF2*/(/*RF2*/(C)->_capacity/*4*/)))+(INT8_C(1)))/*)*/);
/*l591c6/dictionary.e*/
_old_buckets=(/*RF2*/(C)->_buckets/*0*/);
/*l592c6/dictionary.e*/
/*SFN*/(C->_buckets/*0*/)=new91(_new_capacity);
/*l593c6/dictionary.e*/
_i=/*(IRF4.6-*/(int32_t)(((/*RF2*/(/*RF2*/(C)->_capacity/*4*/)))-(INT8_C(1)))/*)*/;
/*l594c6/dictionary.e*/
/*SFN*/(C->_capacity/*4*/)=_new_capacity;
while (!((int32_t)((_i)<(INT8_C(0)))))
{
/*l598c6/dictionary.e*/
/*l599c9/dictionary.e*/
_node1=(_old_buckets)[_i];
while (!((_node1)==((void*)(NULL))))
{
/*l603c9/dictionary.e*/
_node2=(/*RF2*/(((T92*)_node1))->_next/*8*/);
/*l604c9/dictionary.e*/
_idx=(int32_t)((r7hash_code((T7*)((/*RF2*/(((T92*)_node1))->_key/*4*/))))%((/*RF2*/(C)->_capacity/*4*/)));
/*l605c15/dictionary.e*/
/*[IRF3.3set_next*/((((T92*)(((T92*)_node1))))->_next/*8*/)=(((/*RF2*/(C)->_buckets/*0*/))[_idx]);
/*]*/
/*l606c17/dictionary.e*/
((/*RF2*/(C)->_buckets/*0*/))[_idx]=(_node1);
/*l607c9/dictionary.e*/
_node1=_node2;
}
/*l609c6/dictionary.e*/
_i=/*(IRF4.6-*/(int32_t)(((/*RF2*/_i))-(INT8_C(1)))/*)*/;
}
/*l611c3/dictionary.e*/
/*SFN*/(C->_cache_user/*12*/)=INT8_C(-1);
}

/*DICTIONARY[INTEGER,STRING]*/
void r89add(T89* C,T2 a1,T0* a2){
T2 _idx=0;
T0* _node=NULL;
/*l170c3/dictionary.e*/
/*SFN*/(C->_cache_user/*12*/)=INT8_C(-1);
/*l171c3/dictionary.e*/
/*[IF*/
if(((/*RF2*/(C)->_capacity/*4*/))==((/*RF2*/(C)->_count/*8*/))){
/*l172c6/dictionary.e*/
r89increase_capacity(C);
}
/*FI]*/
/*l174c3/dictionary.e*/
_idx=(int32_t)((r7hash_code(((T7*)a2)))%((/*RF2*/(C)->_capacity/*4*/)));
/*l175c3/dictionary.e*/
{T92*n=new92();
r92make(n,a1,a2,((/*RF2*/(C)->_buckets/*0*/))[_idx]);
_node=((T0*)n);
}
/*l176c11/dictionary.e*/
((/*RF2*/(C)->_buckets/*0*/))[_idx]=(_node);
/*l177c3/dictionary.e*/
/*SFN*/(C->_count/*8*/)=/*(IRF4.6+*/(int32_t)(((/*RF2*/(/*RF2*/(C)->_count/*8*/)))+(INT8_C(1)))/*)*/;
}

/*DICTIONARY[INTEGER,STRING]*/
void r89with_capacity(T89* C,T2 a1){
T2 _new_capacity=0;
int _hts=0;
/*l699c3/dictionary.e*/
_new_capacity=r67prime_number_ceiling(a1);
/*l700c10/dictionary.e*/
/*SFN*/(C->_buckets/*0*/)=new91(_new_capacity);
/*l701c3/dictionary.e*/
/*SFN*/(C->_capacity/*4*/)=_new_capacity;
/*l702c10/dictionary.e*/
/*SFN*/(C->_cache_user/*12*/)=INT8_C(-1);
/*l703c10/dictionary.e*/
/*SFN*/(C->_count/*8*/)=INT8_C(0);
}

/*DICTIONARY[INTEGER,STRING]*/
T2 r89reference_at(T89* C,T0* a1){
T2 R=0;
T2 _idx=0;
T0* _node=NULL;
/*l110c3/dictionary.e*/
/*l111c6/dictionary.e*/
_idx=(int32_t)((r7hash_code(((T7*)a1)))%((/*RF2*/(C)->_capacity/*4*/)));
/*l112c6/dictionary.e*/
_node=((/*RF2*/(C)->_buckets/*0*/))[_idx];
while (!((T6)(((_node)==((void*)(NULL)))||((T6)(r7is_equal((T7*)((/*RF2*/(((T92*)_node))->_key/*4*/)),a1))))))
{
/*l116c6/dictionary.e*/
_node=(/*RF2*/(((T92*)_node))->_next/*8*/);
}
/*l118c3/dictionary.e*/
/*[IF*/
if((_node)!=((void*)(NULL))){
/*l119c6/dictionary.e*/
R=(/*RF2*/(((T92*)_node))->_item/*0*/);
}
/*FI]*/
return R;
}

/*SET_NODE[STRING]*/
void r65make(T65* C,T0* a1,T0* a2){
/*l44c10/set_node.e*/
/*SFN*/(C->_item/*0*/)=a1;
/*l45c10/set_node.e*/
/*SFN*/(C->_next/*4*/)=a2;
}

/*LINK[SLOT]*/
void r87make(T87* C,T0* a1,T0* a2){
/*l36c10/link.e*/
/*SFN*/(C->_item/*0*/)=a1;
/*l37c10/link.e*/
/*SFN*/(C->_next/*4*/)=a2;
}

/*SET_NODE[INTEGER]*/
void r60make(T60* C,T2 a1,T0* a2){
/*l44c10/set_node.e*/
/*SFN*/(C->_item/*0*/)=a1;
/*l45c10/set_node.e*/
/*SFN*/(C->_next/*4*/)=a2;
}

/*LINK[LOCAL_]*/
void r120make(T120* C,T0* a1,T0* a2){
/*l36c10/link.e*/
/*SFN*/(C->_item/*0*/)=a1;
/*l37c10/link.e*/
/*SFN*/(C->_next/*4*/)=a2;
}

/*LINKED_LIST[BLOCK]*/
T0* r220item(T220* C,T2 a1){
T0* R=NULL;
/*l162c10/linked_list.e*/
/*[IF*/
if((a1)!=((/*RF2*/(C)->_mem_idx/*12*/))){
/*l163c13/linked_list.e*/
r220go_item(C,a1);
}
/*FI]*/
/*l165c10/linked_list.e*/
R=(/*RF2*/((T221*)((/*RF2*/(C)->_mem_lnk/*16*/)))->_item/*0*/);
return R;
}

/*LINKED_LIST[BLOCK]*/
void r220make(T220* C){
/*l52c10/linked_list.e*/
/*SFN*/(C->_first_link/*4*/)=NULL;
/*l53c10/linked_list.e*/
/*SFN*/(C->_upper/*0*/)=INT8_C(0);
/*l54c10/linked_list.e*/
/*SFN*/(C->_last_link/*8*/)=NULL;
/*l55c10/linked_list.e*/
/*SFN*/(C->_mem_idx/*12*/)=INT8_C(0);
/*l56c10/linked_list.e*/
/*SFN*/(C->_mem_lnk/*16*/)=NULL;
}

/*LINKED_LIST[BLOCK]*/
void r220add_last(T220* C,T0* a1){
T0* _lnk=NULL;
/*l85c10/linked_list.e*/
/*[IF*/
if(((/*RF2*/(C)->_first_link/*4*/))==((void*)(NULL))){
/*l86c13/linked_list.e*/
{T221*n=new221();
r221make(n,a1,NULL);
/*SFN*/(C->_first_link/*4*/)=((T0*)n);
}
/*l87c13/linked_list.e*/
/*SFN*/(C->_upper/*0*/)=INT8_C(1);
/*l88c13/linked_list.e*/
/*SFN*/(C->_last_link/*8*/)=(/*RF2*/(C)->_first_link/*4*/);
/*l89c13/linked_list.e*/
/*SFN*/(C->_mem_idx/*12*/)=INT8_C(1);
/*l90c13/linked_list.e*/
/*SFN*/(C->_mem_lnk/*16*/)=(/*RF2*/(C)->_first_link/*4*/);
}
else{
/*l92c13/linked_list.e*/
{T221*n=new221();
r221make(n,a1,NULL);
_lnk=((T0*)n);
}
/*l93c23/linked_list.e*/
/*[IRF3.3set_next*/((((T221*)((T221*)((/*RF2*/(C)->_last_link/*8*/)))))->_next/*4*/)=(_lnk);
/*]*/
/*l94c13/linked_list.e*/
/*SFN*/(C->_upper/*0*/)=/*(IRF4.6+*/(int32_t)(((/*RF2*/(/*RF2*/(C)->_upper/*0*/)))+(INT8_C(1)))/*)*/;
/*l95c13/linked_list.e*/
/*SFN*/(C->_last_link/*8*/)=_lnk;
}
/*FI]*/
}

/*LINKED_LIST[BLOCK]*/
void r220clear(T220* C){
/*l262c10/linked_list.e*/
/*[IF*/
if(((/*RF2*/(C)->_first_link/*4*/))!=((void*)(NULL))){
/*l263c13/linked_list.e*/
/*SFN*/(C->_first_link/*4*/)=NULL;
/*l264c13/linked_list.e*/
/*SFN*/(C->_mem_idx/*12*/)=INT8_C(0);
/*l265c13/linked_list.e*/
/*SFN*/(C->_mem_lnk/*16*/)=NULL;
/*l266c13/linked_list.e*/
/*SFN*/(C->_upper/*0*/)=INT8_C(0);
/*l267c13/linked_list.e*/
/*SFN*/(C->_last_link/*8*/)=NULL;
}
/*FI]*/
}

/*LINKED_LIST[BLOCK]*/
void r220go_item(T220* C,T2 a1){
/*l490c10/linked_list.e*/
/*[IF*/
if((int32_t)(((/*RF2*/(C)->_mem_idx/*12*/))>(a1))){
/*l491c13/linked_list.e*/
/*SFN*/(C->_mem_idx/*12*/)=INT8_C(1);
/*l492c13/linked_list.e*/
/*SFN*/(C->_mem_lnk/*16*/)=(/*RF2*/(C)->_first_link/*4*/);
}
/*FI]*/
/*l494c10/linked_list.e*/
while (!((a1)==((/*RF2*/(C)->_mem_idx/*12*/))))
{
/*l498c13/linked_list.e*/
/*SFN*/(C->_mem_lnk/*16*/)=(/*RF2*/((T221*)((/*RF2*/(C)->_mem_lnk/*16*/)))->_next/*4*/);
/*l499c13/linked_list.e*/
/*SFN*/(C->_mem_idx/*12*/)=/*(IRF4.6+*/(int32_t)(((/*RF2*/(/*RF2*/(C)->_mem_idx/*12*/)))+(INT8_C(1)))/*)*/;
}
}

#ifdef __cplusplus
}
#endif
