#ifdef __cplusplus
extern "C" {
#endif
/*
ANSI C code generated by SmartEiffel The GNU Eiffel Compiler, Eiffel tools and libraries
Release 1.1 Release (Monday June 16th 2003) [Charlemagne]
Copyright (C), 1994-2003 - INRIA - LORIA - UHP - Nancy 2 - FRANCE
D.COLNET, S.COLLIN, O.ZENDRA, P.RIBET, C.ADRIAN - SmartEiffel@loria.fr
http://SmartEiffel.loria.fr
C Compiler options used: -pipe -O2
*/

/*
-- This file is  free  software, which  comes  along  with  SmartEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of
-- another product.
--       Copyright (C) 1994-2002 LORIA - INRIA - U.H.P. Nancy 1 - FRANCE
--          Dominique COLNET and Suzanne COLLIN - SmartEiffel@loria.fr
--                       http://SmartEiffel.loria.fr
--
*/
/*
  This file (SmartEiffel/sys/runtime/base.h) contains all basic Eiffel
  type definitions.
  This file is automatically included in the header for all modes of
  compilation: -boost, -no_check, -require_check, -ensure_check, ...
  This file is also included in the header of any cecil file (when the
  -cecil option is used).
  This file is also included in the header file of C++ wrappers (when
  using the external "C++" clause).
*/

#ifndef _BASE_H
#define _BASE_H

#include <stdio.h>
#include <string.h>
#include <math.h>
#include <stdlib.h>
#include <signal.h>
#include <stddef.h>
#include <stdarg.h>
#include <limits.h>
#include <float.h>
#include <setjmp.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#if defined __USE_POSIX || defined __unix__ || defined _POSIX_C_SOURCE
#  include <unistd.h>
#endif
#if !defined(WIN32) && \
       (defined(WINVER) || defined(_WIN32_WINNT) || defined(_WIN32) || \
	defined(__WIN32__) || defined(__TOS_WIN__) || defined(_MSC_VER))
#  define WIN32 1
#endif
#ifdef WIN32
#  include <windows.h>
#else
#  ifndef O_RDONLY
#    include <sys/file.h>
#  endif
#  ifndef O_RDONLY
#    define O_RDONLY 0000
#  endif
#endif

#if defined(_MSC_VER) && (_MSC_VER < 1400) /* MSVC older than v8 */
typedef signed char int8_t;
typedef signed short int16_t;
typedef signed int int32_t;
typedef signed __int64 int64_t;
typedef unsigned char uint8_t;
typedef unsigned short uint16_t;
typedef unsigned int uint32_t;
typedef unsigned __int64 uint64_t;
#  define PRId8 "d"
#  define PRId16 "d"
#  define PRId32 "d"
#  define PRId64 "I64d"
#  define INT8_C(c) c
#  define INT16_C(c) c
#  define INT32_C(c) c
#  define INT64_C(c) c ## i64
#elif defined(__WATCOMC__) && (__WATCOMC__ <= 1100) /* WATCOM 11 or lower */
typedef signed char int8_t;
typedef signed short int16_t;
typedef signed long int int32_t;
typedef signed __int64 int64_t;
typedef unsigned char uint8_t;
typedef unsigned short uint16_t;
typedef unsigned long int uint32_t;
typedef unsigned __int64 uint64_t;
#  define PRId8 "d"
#  define PRId16 "d"
#  define PRId32 "d"
#  define PRId64 "Ld"
#  define INT8_C(c) c
#  define INT16_C(c) c
#  define INT32_C(c) c ## L
#  define INT64_C(c) c ## i64
#elif defined(__BORLANDC__) && (__BORLANDC__ < 0x600) /* Borland before 6.0 */
typedef signed char int8_t;
typedef signed short int16_t;
typedef signed long int int32_t;
typedef signed __int64 int64_t;
typedef unsigned char uint8_t;
typedef unsigned short uint16_t;
typedef unsigned long int uint32_t;
typedef unsigned __int64 uint64_t;
#  define PRId8 "d"
#  define PRId16 "d"
#  define PRId32 "ld"
#  define PRId64 "I64Ld"
#  define INT8_C(c) c
#  define INT16_C(c) c
#  define INT32_C(c) c ## L
#  define INT64_C(c) c ## i64
#elif defined(__FreeBSD__) && (__FreeBSD__ < 5) /* FreeBSD before 5.0 */ && !defined (_SYS_INTTYPES_H_)
typedef signed char int8_t;
typedef signed short int16_t;
typedef signed long int int32_t;
typedef signed long long int int64_t;
typedef unsigned char uint8_t;
typedef unsigned short uint16_t;
typedef unsigned long int uint32_t;
typedef unsigned long long int uint64_t;
#elif defined(__CYGWIN__) && defined(__BIT_TYPES_DEFINED__) /* Cygwin defines intxx_t in sys/types.h instead of inttypes.h */
typedef unsigned char uint8_t;
typedef __uint16_t uint16_t;
typedef __uint32_t uint32_t;
typedef __uint64_t uint64_t;
#else
#  include <inttypes.h>
#  if !defined(INT8_MAX) && defined(INT16_MAX)
/* int8_t is not mandatory */
typedef int_least8_t int8_t;
#  endif
#endif

#if !defined(PRId16)
#  define PRId8 "d"
#  define PRId16 "d"
#  define PRId32 "ld"
#  define PRId64 "lld"
#elif !defined(PRId8)
#  define PRId8 "d"
#endif
#if !defined(INT16_C)
#  define INT8_C(c) c
#  define INT16_C(c) c
#  define INT32_C(c) c ## L
#  define INT64_C(c) c ## LL
#elif !defined(INT8_C)
#  define INT8_C(c) c
#endif
#if !defined(INT16_MIN)
#  define INT8_MIN (-INT8_C(127)-1)
#  define INT8_MAX (INT8_C(127))
#  define INT16_MIN (-INT16_C(32767)-1)
#  define INT16_MAX (INT16_C(32767))
#  define INT32_MIN (-INT32_C(2147483647)-1)
#  define INT32_MAX (INT32_C(2147483647))
#  define INT64_MIN (-INT64_C(9223372036854775807)-1)
#  define INT64_MAX (INT64_C(9223372036854775807))
#elif !defined(INT8_MIN)
#  define INT8_MIN (-INT8_C(127)-1)
#endif


/*
  Endian stuff
*/
#if defined(BSD) && (BSD >= 199103)
#  include <machine/endian.h>
#elif defined(__alpha__) || defined(__alpha) || defined(_M_ALPHA)
/* bi-endian processor, current mode should be find in machine/endian.h file */
#  include <machine/endian.h>
#elif defined(linux)
#  include <endian.h>
#endif



#if !defined(BYTE_ORDER) && defined(__BYTE_ORDER)
#  define BYTE_ORDER      __BYTE_ORDER
#endif

#if !defined(LITTLE_ENDIAN) && defined(__LITTLE_ENDIAN)
#  define LITTLE_ENDIAN      __LITTLE_ENDIAN
#endif

#if !defined(BIG_ENDIAN) && defined(__BIG_ENDIAN)
#  define BIG_ENDIAN      __BIG_ENDIAN
#endif

#if !defined(LITTLE_ENDIAN)
#  define LITTLE_ENDIAN   1234    /* LSB first (vax, pc) */
#endif
#if !defined(BIG_ENDIAN)
#  define BIG_ENDIAN      4321    /* MSB first (IBM, net) */
#endif
#if !defined(PDP_ENDIAN)
#  define PDP_ENDIAN      3412    /* LSB first in word, MSW first in long */
#endif

#if !defined(BYTE_ORDER) && defined(BIT_ZERO_ON_RIGHT)
#  define BYTE_ORDER      LITTLE_ENDIAN
#elif !defined(BYTE_ORDER) && defined(BIT_ZERO_ON_LEFT)
#  define BYTE_ORDER      BIG_ENDIAN
#elif !defined(BYTE_ORDER)

/* HP RISC */
#  if defined(__hppa__) || defined(__hppa) || defined(__hp9000) || \
      defined(__hp9000s300) || defined(hp9000s300) || \
      defined(__hp9000s700) || defined(hp9000s700) || \
      defined(__hp9000s800) || defined(hp9000s800) || defined(hp9000s820)
#    define BYTE_ORDER      BIG_ENDIAN
#  endif

/* IBM */
#  if defined(ibm032) || defined(ibm370) || defined(_IBMR2)
#    define BYTE_ORDER      BIG_ENDIAN
#  endif

/* Intel x86 */
#  if defined(i386) || defined(__i386__) || defined(__i386) || \
      defined(_M_IX86) || defined(_X86_) || defined(__THW_INTEL) || \
      defined(sun386)
#    define BYTE_ORDER      LITTLE_ENDIAN
#  endif

/* Intel Itanium */
#  if defined(__ia64__) || defined(_IA64) || defined(__IA64__) || \
      defined(_M_IA64)
#    define BYTE_ORDER      LITTLE_ENDIAN
#  endif

/* Nationnal Semiconductor 32000 serie */
#  if  defined(ns32000)
#    define BYTE_ORDER      LITTLE_ENDIAN
#  endif

/* Motorola 68000 */
#  if defined(mc68000) || defined(is68k) || defined(macII) || defined(m68k)
#    define BYTE_ORDER      BIG_ENDIAN
#  endif

/* MIPS */
#  if defined(MIPSEL) || defined(_MIPSEL)
#    define BYTE_ORDER      LITTLE_ENDIAN
#  elif defined(MIPSEB) || defined(_MIPSEB)
#    define BYTE_ORDER      BIG_ENDIAN
#  elif defined(__mips__) || defined(__mips) || defined(__MIPS__)
#    error "MIPS are bi-endian processors. Endianness is unknown for this system, please drop an e-mail to SmartEiffel@loria.fr"
#  endif

/* Power PC */
/* this processor is bi-endian, how to know if little-endian is set? */
#  if defined(__powerpc) || defined(__powerpc__) || defined(__POWERPC__) || \
      defined(__ppc__) || defined(__ppc) || defined(_M_PPC) || \
      defined(__PPC) || defined(__PPC__)
#    define BYTE_ORDER      BIG_ENDIAN
#  endif

/* Pyramid 9810 */
#  if defined(pyr)
#    define BYTE_ORDER      BIG_ENDIAN
#  endif

/* RS/6000 */
#  if defined(__THW_RS6000) || defined(_IBMR2) || defined(_POWER) || \
      defined(_ARCH_PWR) || defined(_ARCH_PWR2)
#    define BYTE_ORDER      _ENDIAN
#  endif

/* SPARC */
#  if defined(__sparc__) || defined(sparc) || defined(__sparc)
#    define BYTE_ORDER      BIG_ENDIAN
#  endif

/* CCI Tahoe */
#  if defined(tahoe)
#    define BYTE_ORDER      BIG_ENDIAN
#  endif

/* VAX */
#  if defined(vax) || defined(VAX) || defined(__vax__) || defined(_vax_) || \
      defined(__vax) || defined(__VAX)
#    define BYTE_ORDER      LITTLE_ENDIAN
#  endif

/* ELATE is a virtual OS with a little endian Virtual Processor */
#  if defined(__ELATE__)
#    define BYTE_ORDER      LITTLE_ENDIAN
#  endif

/* Miscellaneous little endian */
#  if defined(wrltitan)
#    define BYTE_ORDER      LITTLE_ENDIAN
#  endif

/* Miscellaneous big endian */
#  if defined(apollo) || defined(__convex__) || defined(_CRAY) || defined(sel)
#    define BYTE_ORDER      BIG_ENDIAN
#  endif
#endif


#if !defined(BYTE_ORDER)
#  error "Unknown byte order. Add your system in above macros once you know your system type. Please drop an e-mail to SmartEiffel@loria.fr"
#endif
#if (BYTE_ORDER != BIG_ENDIAN && BYTE_ORDER != LITTLE_ENDIAN)
#  error "Only little-endian and big-endian are valid at this time. Please drop an e-mail to SmartEiffel@loria.fr"
#endif


/*
  Byte swapping stuff
*/
extern void copy_swap_16(const uint16_t *src, uint16_t *dest, int count);


/* Because ANSI C EXIT_* are not always defined: */
#ifndef EXIT_FAILURE
#  define EXIT_FAILURE 1
#endif
#ifndef EXIT_SUCCESS
#  define EXIT_SUCCESS 0
#endif

/*
   On Linux glibc systems, we need to use sig.* versions of jmp_buf,
   setjmp and longjmp to preserve the signal handling context.
   Currently, the way I figured to detect this is if _SIGSET_H_types has
   been defined in /usr/include/setjmp.h.

   NOTE: with gcc, -ansi is used for SmartEiffel generated files EXCEPT in
   -no_split mode. ANSI only recognizes the non-sig versions.
*/
#if (defined(_SIGSET_H_types) && !defined(__STRICT_ANSI__))
#  define JMP_BUF    sigjmp_buf
#  define SETJMP(x)  sigsetjmp( (x), 1)
#  define LONGJMP    siglongjmp
#else
#  define JMP_BUF    jmp_buf
#  define SETJMP(x)  setjmp( (x) )
#  define LONGJMP    longjmp
#endif

/*
   Type to store reference objects Id:
 */
typedef int Tid;
typedef struct S0 T0;
struct S0{Tid id;};

/*
   The default channel used to print runtime error messages:
*/
#define SE_ERR stderr

/*
   Eiffel type INTEGER_8 is #1:
*/
typedef int8_t T1;
#define EIF_INTEGER_8 T1
#define M1 (INT8_C(0))
#define EIF_INTEGER_8_BITS (CHAR_BIT)
#define EIF_MINIMUM_INTEGER_8 (INT8_MIN)
#define EIF_MAXIMUM_INTEGER_8 (INT8_MAX)

/*
  Eiffel type INTEGER_16 is #10:
*/
typedef int16_t T10;
#define EIF_INTEGER_16 T10
#define M10 (INT16_C(0))
#define EIF_INTEGER_16_BITS (CHAR_BIT*sizeof(T10t))
#define EIF_MINIMUM_INTEGER_16 (INT16_MIN) /*-32768*/
#define EIF_MAXIMUM_INTEGER_16 (INT16_MAX) /*+32767*/

/*
  Eiffel type INTEGER or INTEGER_32 is #2:
*/
typedef int32_t T2;
#define EIF_INTEGER T2
#define EIF_INTEGER_32 T2
#define M2 (INT32_C(0))
#define EIF_INTEGER_BITS ((T2)(CHAR_BIT*sizeof(T2)))
#define EIF_INTEGER_32_BITS EIF_INTEGER_BITS
#define EIF_MINIMUM_INTEGER (INT32_MIN)
#define EIF_MAXIMUM_INTEGER (INT32_MAX)

/*
  Eiffel type INTEGER_64 is #11:
*/
typedef int64_t T11;
#define EIF_INTEGER_64 T11
#define M11 (INT64_C(0))
#define EIF_INTEGER_64_BITS (CHAR_BIT*sizeof(T11))
#define EIF_MINIMUM_INTEGER_64 (INT64_MIN)
#define EIF_MAXIMUM_INTEGER_64 (INT64_MAX)

/*
  Eiffel type CHARACTER is #3:
*/
typedef unsigned char T3;
#define EIF_CHARACTER T3
#define M3 (0)
#define EIF_CHARACTER_BITS (CHAR_BIT)
#define EIF_MINIMUM_CHARACTER_CODE (0)
#define EIF_MAXIMUM_CHARACTER_CODE (255)
#define T3code(x) ((T10)(x))
#define T3to_integer(x) ((signed char)(x))
#define T3to_bit(x) (x)

/*
  Eiffel type REAL is #4:
*/
typedef float T4;
#define EIF_REAL T4
#define M4 (0.0)
#define EIF_REAL_BITS (CHAR_BIT*sizeof(float))
#define EIF_MINIMUM_REAL (-(FLT_MAX))
#define EIF_MAXIMUM_REAL (FLT_MAX)

/*
  Eiffel type DOUBLE is #5:
*/
typedef double T5;
#define EIF_DOUBLE T5
#define M5 (0.0)
#define EIF_DOUBLE_BITS (CHAR_BIT*sizeof(double))
#define EIF_MINIMUM_DOUBLE (-(DBL_MAX))
#define EIF_MAXIMUM_DOUBLE (DBL_MAX)

/*
  Eiffel type BOOLEAN is #6:
*/
typedef char T6;
#define EIF_BOOLEAN T6
#define M6 (0)
#define EIF_BOOLEAN_BITS (CHAR_BIT)

/*
   Eiffel type POINTER is #8:
*/
typedef void* T8;
#define EIF_POINTER T8
/* Sometimes, NULL is defined as 0 */
#define M8 ((void*)NULL)
#define EIF_POINTER_BITS (CHAR_BIT*sizeof(void*))

/*
  To use type STRING on the C side:
*/
#define EIF_STRING T7*

/*
  Some Other EIF_* defined in ETL:
*/
#define eif_access(x) ((char*)(x))
#define EIF_REFERENCE T0*
#define EIF_OBJ T0*
#define EIF_OBJECT EIF_OBJ

/*
   Wrappers for `malloc' and `calloc':
*/
void* se_malloc(size_t size);
void* se_calloc(size_t nmemb, size_t size);


#endif /* #ifndef _BASE_H */
#define SE_BOOST 1
#define SE_GC_LIB 1

/*C Header Pass 1 :*/
typedef struct S40 T40;
typedef void*T68;
typedef struct S191 T191;
typedef struct S127 T127;
typedef struct S110 T110;
typedef struct S12 T12;
typedef struct S140 T140;
typedef int T181;
typedef struct S157 T157;
typedef struct S183 T183;
typedef struct S193 T193;
typedef struct S148 T148;
typedef struct S200 T200;
typedef struct S46 T46;
typedef struct S55 T55;
typedef struct S160 T160;
typedef struct S89 T89;
typedef struct S197 T197;
typedef struct S199 T199;
typedef struct S65 T65;
typedef struct S108 T108;
typedef struct S145 T145;
typedef struct S201 T201;
typedef struct S196 T196;
typedef struct S87 T87;
typedef struct S60 T60;
typedef struct S123 T123;
typedef struct S222 T222;
typedef struct S120 T120;
typedef struct S220 T220;
typedef struct S85 T85;
typedef int T67;
typedef struct S172 T172;
typedef struct S117 T117;
typedef struct S63 T63;
typedef struct S163 T163;
typedef struct S103 T103;
typedef struct S37 T37;
typedef struct S187 T187;
typedef struct S224 T224;
typedef struct S194 T194;
typedef struct S203 T203;
typedef struct S70 T70;
typedef struct S159 T159;
typedef struct S202 T202;
typedef struct S204 T204;
typedef struct S186 T186;
typedef struct S221 T221;
typedef struct S176 T176;
typedef struct S52 T52;
typedef struct S195 T195;
typedef struct S114 T114;
typedef struct S112 T112;
typedef struct S131 T131;
typedef struct S185 T185;
typedef struct S113 T113;
typedef struct S152 T152;
typedef struct S106 T106;
typedef struct S182 T182;
typedef struct S142 T142;
typedef struct S128 T128;
typedef struct S198 T198;
typedef struct S206 T206;
typedef struct S170 T170;
typedef struct S102 T102;
typedef struct S49 T49;
typedef int T104;
typedef struct S111 T111;
typedef struct S105 T105;
typedef struct S121 T121;
typedef struct S25 T25;
typedef struct S7 T7;
typedef struct S125 T125;
typedef struct S119 T119;
typedef struct S174 T174;
typedef struct S81 T81;
typedef struct S94 T94;
typedef struct S98 T98;
typedef struct S171 T171;
typedef struct S71 T71;
typedef struct S151 T151;
typedef struct S58 T58;
typedef struct S213 T213;
typedef struct S192 T192;
typedef struct S99 T99;
typedef struct S188 T188;
typedef struct S190 T190;
typedef struct S205 T205;
typedef struct S84 T84;
typedef struct S168 T168;
typedef struct S132 T132;
typedef struct S165 T165;
typedef struct S155 T155;
typedef struct S135 T135;
typedef int T167;
typedef struct S116 T116;
typedef struct S41 T41;
typedef struct S178 T178;
typedef struct S209 T209;
typedef struct S173 T173;
typedef struct S72 T72;
typedef struct S144 T144;
typedef struct S141 T141;
typedef struct S92 T92;
typedef struct S138 T138;
typedef struct S75 T75;
typedef struct S175 T175;
typedef struct S95 T95;
typedef struct S20 T20;
typedef struct S227 T227;
typedef struct S136 T136;
typedef struct S62 T62;
typedef struct S129 T129;
typedef struct S126 T126;
typedef struct S93 T93;
typedef struct S225 T225;
typedef struct S208 T208;
typedef struct S134 T134;
typedef struct S147 T147;
typedef struct S56 T56;
typedef struct S184 T184;
typedef struct S143 T143;
typedef struct S97 T97;
typedef struct S34 T34;
typedef struct S21 T21;
typedef struct S217 T217;
typedef struct S139 T139;
typedef struct S154 T154;
typedef struct S80 T80;
typedef void*T44;
typedef struct S64 T64;
typedef struct S189 T189;
typedef struct S101 T101;

/*C Header Pass 2 :*/
typedef T0**T219;
#define M219 NULL
typedef T0**T146;
#define M146 NULL
typedef T6*T48;
#define M48 NULL
typedef T0**T162;
#define M162 NULL
typedef T0**T118;
#define M118 NULL
typedef T0**T39;
#define M39 NULL
typedef T0**T180;
#define M180 NULL
typedef T0**T216;
#define M216 NULL
typedef T0**T86;
#define M86 NULL
typedef T0**T51;
#define M51 NULL
typedef T0**T61;
#define M61 NULL
typedef T3*T9;
#define M9 NULL
typedef T0**T91;
#define M91 NULL
typedef T2*T43;
#define M43 NULL
typedef T0**T66;
#define M66 NULL
typedef T0**T74;
#define M74 NULL
typedef T0**T124;
#define M124 NULL

/*C Header Pass 3 :*/
struct S20{T11 _time_memory;};
int se_cmpT20(T20 o1,T20 o2);

/*C Header Pass 4 :*/
struct S40{T2 _position;T0* _prototype;};
extern T40 M40;
extern T68 M68;
struct S191{Tid id;T2 _position;T0* _name;};
extern T191 M191;
struct S127{T0* _item;T0* _next;};
extern T127 M127;
struct S12{T0* _output_name;T0* _input_name;T0* _directory_name;};
extern T12 M12;
struct S140{T0* _item;T0* _next;};
extern T140 M140;
extern T181 M181;
struct S157{Tid id;T0* _variable;T0* _position;T2 _nb_depend;T0* _self;T2 _static_type;T6 _is_runtime;T6 _is_link;};
extern T157 M157;
struct S183{Tid id;T2 _position;T0* _extern;T2 _type;T0* _type_list;T6 _is_persistant;};
extern T183 M183;
struct S193{Tid id;T2 _position;T0* _name;T0* _value;};
extern T193 M193;
struct S148{Tid id;T0* _position;T2 _nb_depend;T0* _base;T0* _self;T0* _root_expr;T0* _slot;T0* _result_;T0* _case_list;T0* _l_v;};
extern T148 M148;
struct S200{Tid id;T0* _position;T2 _nb_depend;T0* _result_;T0* _name;T0* _expr;T0* _slot_ref;T0* _cycle_check;T0* _code;};
extern T200 M200;
struct S46{T48 _storage;T2 _capacity;T2 _upper;};
extern T46 M46;
struct S55{T2 _upper;T0* _first_link;T0* _last_link;T2 _mem_idx;T0* _mem_lnk;};
extern T55 M55;
struct S160{T162 _storage;T2 _capacity;T2 _upper;};
extern T160 M160;
struct S89{T91 _buckets;T2 _capacity;T2 _count;T2 _cache_user;};
extern T89 M89;
struct S197{Tid id;T2 _position;T0* _extern;};
extern T197 M197;
struct S199{Tid id;T0* _position;T2 _nb_depend;T0* _result_;T0* _name;T0* _expr;T0* _slot_ref;T0* _cycle_check;T0* _value;};
extern T199 M199;
struct S65{T0* _item;T0* _next;};
extern T65 M65;
struct S108{Tid id;T0* _position;T2 _nb_depend;T6 _is_link;T0* _require_expr;T0* _parent_static;T0* _argument_list;T0* _local_list;T0* _expr_list;T0* _current_copy;T2 _nb_execute;T2 _nb_pass;T6 _has_brother;T6 _is_genere;T6 _is_recursive;};
extern T108 M108;
struct S201{Tid id;T0* _position;T2 _nb_depend;T0* _result_;T0* _name;T0* _expr;T0* _slot_ref;T0* _cycle_check;T0* _value;};
extern T201 M201;
struct S196{Tid id;T2 _position;T0* _arg_list;T0* _loc_list;T0* _code;T2 _n_arg_value;};
extern T196 M196;
struct S87{T0* _item;T0* _next;};
extern T87 M87;
struct S60{T2 _item;T0* _next;};
extern T60 M60;
struct S123{T124 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T123 M123;
struct S222{T0* _list;};
extern T222 M222;
struct S120{T0* _item;T0* _next;};
extern T120 M120;
struct S220{T2 _upper;T0* _first_link;T0* _last_link;T2 _mem_idx;T0* _mem_lnk;};
extern T220 M220;
struct S85{T0* _item;T0* _next;};
extern T85 M85;
extern T67 M67;
struct S172{Tid id;T0* _position;T2 _nb_depend;T0* _base;T0* _self;T0* _root_expr;T6 _first;T0* _case_list;T6 _is_null;};
extern T172 M172;
struct S63{T0* _list;T0* _operator_equal;T0* _operator_not_equal;T2 _count_variable;};
extern T63 M63;
struct S163{Tid id;T0* _variable;T0* _position;T2 _nb_depend;T0* _value;T2 _static_type;};
extern T163 M163;
struct S103{T0* _item;T0* _next;};
extern T103 M103;
struct S37{T39 _storage;T2 _capacity;T2 _upper;};
extern T37 M37;
struct S187{Tid id;T2 _position;T0* _string;T2 _length;};
extern T187 M187;
struct S224{T5 _item;};
extern T224 M224;
struct S194{Tid id;T2 _position;T0* _name;T0* _value;};
extern T194 M194;
struct S203{T2 _upper;T0* _first_link;T0* _last_link;T2 _mem_idx;T0* _mem_lnk;};
extern T203 M203;
struct S70{T6 _push_back_flag;T3 _last_character;T6 _end_of_input;T9 _buffer;T6 _end_reached;T2 _buffer_position;T2 _buffer_size;T2 _capacity;};
extern T70 M70;
struct S159{Tid id;T0* _position;T2 _nb_depend;T6 _is_link;T0* _require_expr;T2 _static_type;T0* _value;};
extern T159 M159;
struct S202{T2 _upper;T0* _first_link;T0* _last_link;T2 _mem_idx;T0* _mem_lnk;};
extern T202 M202;
struct S204{Tid id;T0* _position;T2 _nb_depend;T6 _is_link;T0* _require_expr;T0* _value_list;T0* _operator_list;T0* _position_list;};
extern T204 M204;
struct S186{Tid id;T2 _position;T0* _character;};
extern T186 M186;
struct S221{T0* _item;T0* _next;};
extern T221 M221;
struct S176{Tid id;T0* _position;T2 _nb_depend;T6 _is_link;T0* _require_expr;T0* _living_type;T2 _static_type;T6 _is_persistant;T0* _code;T0* _code_ready;T0* _access_list;};
extern T176 M176;
struct S117{T0* _item;T0* _key;T0* _next;};
extern T117 M117;
struct S195{Tid id;T2 _position;T0* _name;T0* _value;};
extern T195 M195;
struct S110{T2 _upper;T0* _first_link;T0* _last_link;T2 _mem_idx;T0* _mem_lnk;};
extern T110 M110;
struct S114{Tid id;T0* _position;T2 _nb_depend;T6 _is_link;T0* _require_expr;T2 _static_type;};
extern T114 M114;
struct S112{T2 _upper;T0* _first_link;T0* _last_link;T2 _mem_idx;T0* _mem_lnk;};
extern T112 M112;
struct S131{Tid id;T0* _variable;T0* _position;T2 _nb_depend;T0* _value;};
extern T131 M131;
struct S185{Tid id;T2 _position;T0* _value;};
extern T185 M185;
struct S113{Tid id;T0* _position;T6 _is_use;T3 _style;T0* _name;T0* _intern_name;T2 _hash_code;T2 _type;T2 _loop_arg;T0* _require_list;T2 _ensure_count;T0* _type_list;T2 _level_type;T6 _is_loading;T6 _is_tmp;T0* _current_copy;T6 _is_self;};
extern T113 M113;
struct S152{Tid id;T2 _upper;T0* _first_link;T0* _last_link;T2 _mem_idx;T0* _mem_lnk;};
extern T152 M152;
struct S106{Tid id;T0* _variable;T0* _position;T2 _nb_depend;T0* _value;T6 _is_loop;};
extern T106 M106;
struct S182{T0* _keyword_generic_list;T0* _object;T0* _source;T2 _position;T2 _begin_position;T0* _last_integer;T0* _last_string;T2 _last_len_string;T0* _last_slot;T0* _last_group;T0* _last_section;T6 _category_ok;T6 _default_ok;};
extern T182 M182;
struct S142{T2 _upper;T0* _first_link;T0* _last_link;T2 _mem_idx;T0* _mem_lnk;};
extern T142 M142;
struct S128{T0* _item;T0* _next;};
extern T128 M128;
struct S198{Tid id;T0* _position;T2 _nb_depend;T6 _is_link;T0* _require_expr;T0* _living_type;T2 _static_type;T2 _code;T0* _right;T0* _index;T0* _left;T2 _type_intern;T2 _last_puissance;};
extern T198 M198;
struct S206{T0* _item;T0* _next;};
extern T206 M206;
struct S170{Tid id;T0* _storage;};
extern T170 M170;
struct S102{T2 _upper;T0* _first_link;T0* _last_link;T2 _mem_idx;T0* _mem_lnk;};
extern T102 M102;
struct S49{T51 _storage;T2 _capacity;T2 _upper;};
extern T49 M49;
extern T104 M104;
struct S111{T2 _upper;T0* _first_link;T0* _last_link;T2 _mem_idx;T0* _mem_lnk;};
extern T111 M111;
struct S105{T0* _path;T3 _last_character;T6 _end_of_input;T6 _push_back_flag;T8 _input_stream;T9 _buffer;T6 _end_reached;T2 _buffer_position;T2 _buffer_size;T2 _capacity;};
extern T105 M105;
struct S121{T0* _item;T0* _next;};
extern T121 M121;
struct S25{Tid id;T0* _position;T0* _intern_name;T6 _is_use;T3 _style;T2 _index;T0* _name;T0* _generic_list;T0* _type_collector;T0* _slots;T0* _slots_parent;T6 _is_late_binding;T6 _is_mapping;T6 _old_data_exist;T6 _new_data_exist;T0* _cast_list;T0* _filename;T0* _source;T0* _c_name;T0* _c_generic_name;T0* _c_star;T0* _default_value;T0* _position_list;};
extern T25 M25;
struct S125{T2 _upper;T0* _first_link;T0* _last_link;T2 _mem_idx;T0* _mem_lnk;};
extern T125 M125;
struct S119{T2 _upper;T0* _first_link;T0* _last_link;T2 _mem_idx;T0* _mem_lnk;};
extern T119 M119;
struct S174{Tid id;T2 _upper;T0* _first_link;T0* _last_link;T2 _mem_idx;T0* _mem_lnk;};
extern T174 M174;
struct S81{T2 _value;};
extern T81 M81;
struct S94{T2 _item;T0* _next;};
extern T94 M94;
struct S98{Tid id;T0* _position;T0* _intern_name;T6 _is_use;T3 _style;T2 _index;T0* _name;T0* _generic_list;T0* _type_collector;T0* _slots;T0* _slots_parent;T6 _is_late_binding;T6 _is_mapping;T6 _old_data_exist;T6 _new_data_exist;T0* _cast_list;T0* _filename;T0* _source;T0* _c_name;T0* _c_generic_name;T0* _c_star;T0* _default_value;T0* _position_list;};
extern T98 M98;
struct S171{Tid id;T0* _variable;T0* _position;T2 _nb_depend;T0* _value;T0* _self;T2 _static_type;T6 _is_match_base;};
extern T171 M171;
struct S71{T0* _list;T2 _nb_pass;T2 _index;T0* _call_cite;};
extern T71 M71;
struct S151{Tid id;T0* _position;T2 _nb_depend;T0* _switch;T0* _base;T0* _self;T0* _list;T2 _value_id;T0* _slot;T0* _result_;};
extern T151 M151;
struct S7{T9 _storage;T2 _count;T2 _capacity;};
extern T7 M7;
struct S58{T0* _item;T0* _next;};
extern T58 M58;
struct S213{Tid id;T0* _variable;T0* _position;T2 _nb_depend;T0* _self;T2 _static_type;T6 _is_runtime;T6 _is_link;};
extern T213 M213;
struct S192{Tid id;T2 _position;T0* _name;T0* _args;};
extern T192 M192;
struct S99{Tid id;T2 _position;T2 _type;};
extern T99 M99;
struct S188{Tid id;T2 _position;T0* _name;T0* _arg_first;T0* _arg_second;};
extern T188 M188;
struct S190{Tid id;T2 _position;T0* _name;T0* _arg;};
extern T190 M190;
struct S205{T0* _item;T0* _next;};
extern T205 M205;
struct S84{T86 _buckets;T2 _cache_user;T0* _cache_node;T2 _cache_buckets;T2 _count;T2 _capacity;};
extern T84 M84;
struct S168{Tid id;T0* _storage;};
extern T168 M168;
struct S132{Tid id;T0* _variable;T0* _position;T6 _is_runtime;T2 _nb_depend;T6 _is_link;};
extern T132 M132;
struct S165{Tid id;T2 _value;};
extern T165 M165;
struct S155{Tid id;T0* _variable;T0* _position;T2 _nb_depend;T2 _static_type;T6 _is_runtime;T6 _is_link;};
extern T155 M155;
struct S135{Tid id;T0* _position;T2 _nb_depend;T6 _is_link;T0* _require_expr;T2 _static_type;T0* _parent_static;T0* _block;T0* _profil;T0* _self;T2 _type;T0* _list;};
extern T135 M135;
extern T167 M167;
struct S116{T118 _buckets;T2 _capacity;T2 _count;T2 _cache_user;T0* _cache_node;T2 _cache_buckets;};
extern T116 M116;
struct S41{Tid id;T43 _storage;T2 _capacity;T2 _upper;};
extern T41 M41;
struct S178{T180 _storage;T2 _capacity;T2 _upper;};
extern T178 M178;
struct S209{Tid id;T0* _position;T2 _nb_depend;T6 _is_link;T0* _require_expr;T2 _static_type;T0* _text;};
extern T209 M209;
struct S173{Tid id;T0* _position;T2 _nb_depend;T0* _switch;T0* _base;T0* _self;T0* _list;T6 _first;T2 _type;};
extern T173 M173;
struct S72{T74 _storage;T2 _capacity;T2 _upper;};
extern T72 M72;
struct S144{T146 _buckets;T2 _capacity;T2 _count;T2 _cache_user;};
extern T144 M144;
struct S141{T3 _style;T2 _type;T0* _name;T0* _pos;};
extern T141 M141;
struct S138{T0* _proto;T0* _group;T0* _slot;};
extern T138 M138;
struct S75{Tid id;T0* _position;T2 _nb_depend;T6 _is_link;T0* _require_expr;T0* _slot;T2 _value_id;T0* _intern_name;T0* _source;T0* _call_list;T6 _is_tail_recursive;T0* _argument_list;T0* _type_list;T0* _block_list;T2 _pass;T6 _is_remove;T6 _is_add_arg;};
extern T75 M75;
struct S92{T2 _item;T0* _key;T0* _next;};
extern T92 M92;
struct S175{Tid id;T0* _item;T0* _next;};
extern T175 M175;
struct S95{Tid id;T0* _position;T0* _intern_name;T6 _is_use;T3 _style;T2 _index;T0* _name;T0* _generic_list;T0* _type_collector;T0* _slots;T0* _slots_parent;T6 _is_late_binding;T6 _is_mapping;T6 _old_data_exist;T6 _new_data_exist;T0* _cast_list;T0* _filename;T0* _source;T0* _c_name;T0* _c_generic_name;T0* _c_star;T0* _default_value;T0* _position_list;};
extern T95 M95;
extern T20 M20;
struct S52{Tid id;T0* _position;T6 _is_use;T3 _style;T0* _name;T0* _intern_name;T2 _hash_code;T2 _type;T2 _loop_arg;T0* _require_list;T2 _ensure_count;T0* _type_list;T2 _level_type;T6 _is_loading;T0* _profil;T3 _affect;T2 _priority_and_level;T0* _prototype;T0* _section;T0* _body_slot;T0* _value_origin;T0* _value_run;T6 _is_data;};
extern T52 M52;
struct S227{Tid id;T2 _numerator;T2 _denominator;};
extern T227 M227;
struct S136{Tid id;T2 _position;T0* _arg_list;T0* _loc_list;T0* _code;};
extern T136 M136;
struct S62{T2 _upper;T0* _first_link;T0* _last_link;T2 _mem_idx;T0* _mem_lnk;};
extern T62 M62;
struct S129{Tid id;T0* _position;T2 _nb_depend;T0* _result_;T0* _name;T0* _expr;T0* _slot_ref;T0* _cycle_check;T0* _argument_list;T6 _is_block;T0* _last_block;};
extern T129 M129;
struct S126{T0* _item;T0* _next;};
extern T126 M126;
struct S93{Tid id;T2 _index;T0* _name;T0* _intern_name;T0* _generic_list;};
extern T93 M93;
struct S225{Tid id;T6 _is_negative;T0* _numerator;T0* _denominator;};
extern T225 M225;
struct S208{Tid id;T0* _position;T2 _nb_depend;T6 _is_link;T0* _require_expr;T2 _static_type;T0* _text;};
extern T208 M208;
struct S134{Tid id;T0* _position;T2 _nb_depend;T0* _back;T0* _context;};
extern T134 M134;
struct S147{Tid id;T0* _position;T2 _nb_depend;T2 _static_type;T0* _value;};
extern T147 M147;
struct S56{Tid id;T61 _buckets;T2 _cache_user;T0* _cache_node;T2 _cache_buckets;T2 _count;T2 _capacity;};
extern T56 M56;
struct S184{T0* _last_error;T9 _storage;T2 _capacity;T2 _upper;T2 _internal_index;};
extern T184 M184;
struct S143{T0* _item;T0* _next;};
extern T143 M143;
struct S97{Tid id;T2 _index;T0* _name;T0* _intern_name;};
extern T97 M97;
struct S145{T0* _item;T2 _key;T0* _next;};
extern T145 M145;
struct S34{T2 _upper;T0* _first_link;T0* _last_link;T2 _mem_idx;T0* _mem_lnk;};
extern T34 M34;
struct S21{T0* _path;T9 _buffer;T2 _buffer_position;T2 _capacity;T8 _output_stream;};
extern T21 M21;
struct S217{T219 _storage;T2 _capacity;T2 _upper;};
extern T217 M217;
struct S139{T2 _upper;T0* _first_link;T0* _last_link;T2 _mem_idx;T0* _mem_lnk;};
extern T139 M139;
struct S154{Tid id;T0* _item;T0* _next;};
extern T154 M154;
struct S80{T2 _buffer_position;T9 _buffer;T2 _capacity;};
extern T80 M80;
extern T44 M44;
struct S64{T66 _buckets;T2 _cache_user;T2 _count;T2 _capacity;};
extern T64 M64;
struct S189{Tid id;T0* _pos;T0* _value;T0* _operator;};
extern T189 M189;
struct S101{Tid id;T0* _position;T0* _intern_name;T6 _is_use;T3 _style;T2 _index;T0* _name;T0* _generic_list;T0* _type_collector;T0* _slots;T0* _slots_parent;T6 _is_late_binding;T6 _is_mapping;T6 _old_data_exist;T6 _new_data_exist;T0* _cast_list;T0* _filename;T0* _source;T0* _c_name;T0* _c_generic_name;T0* _c_star;T0* _default_value;T0* _position_list;};
extern T101 M101;
extern char*s182_764636964;
extern char*s172_706737602;
extern char*s25_10;
extern char*s25_32;
extern char*s208_34;
extern char*s198_38;
extern char*s182_39;
extern char*s40_40;
extern char*s108_41;
extern char*s95_42;
extern char*s182_43;
extern char*s108_44;
extern char*s182_45;
extern char*s25_46;
extern char*s108_47;
extern char*s108_58;
extern char*s182_59;
extern char*s76_60;
extern char*s63_61;
extern char*s76_62;
extern char*s108_63;
extern char*s63_1863820;
extern char*s182_91;
extern char*s108_93;
extern char*s198_96;
extern char*s108_125;
extern char*s25_192;
extern char*s25_200;
extern char*s25_215;
extern char*s63_226;
extern char*s172_237;
extern char*s147_240;
extern char*s213_246;
extern char*s159_251;
extern char*s82_251;
extern char*s159_276;
extern char*s182_287;
extern char*s75_300;
extern char*s76_304;
extern char*s25_305;
extern char*s76_317;
extern char*s12_329;
extern char*s63_351;
extern char*s198_360;
extern char*s198_366;
extern char*s149_6550;
extern char*s93_570;
extern char*s108_661417606;
extern char*s108_625;
extern char*s182_1718922222;
extern char*s12_994;
extern char*s182_22661311;
extern char*s171_1151;
extern char*s198_1197;
extern char*s182_1341337541;
extern char*s204_1350;
extern char*s182_878727141;
extern char*s25_1442;
extern char*s198_1603481221;
extern char*s182_1753159665;
extern char*s172_180037;
extern char*s82_1251176606;
extern char*s182_1615162081;
extern char*s75_81737;
extern char*s12_1795;
extern char*s53_14150;
extern char*s12_26485;
extern char*s106_945201589;
extern char*s159_32851;
extern char*s198_481576475;
extern char*s182_1752268520;
extern char*s12_2645;
extern char*s182_66888916;
extern char*s204_1383424395;
extern char*s182_1722000227;
extern char*s12_9366;
extern char*s163_45981962;
extern char*s182_923600569;
extern char*s172_15875;
extern char*s182_1008712295;
extern char*s108_1849670875;
extern char*s25_660418299;
extern char*s130_527704541;
extern char*s201_10359;
extern char*s159_274388042;
extern char*s200_738702612;
extern char*s108_1640741;
extern char*s182_175744891;
extern char*s25_17160;
extern char*s182_175745341;
extern char*s182_40847997;
extern char*s130_343849;
extern char*s25_4692662;
extern char*s12_5867;
extern char*s182_175746191;
extern char*s182_9343320;
/*
-- This file is  free  software, which  comes  along  with  SmartEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of
-- another product.
--       Copyright (C) 1994-2002 LORIA - INRIA - U.H.P. Nancy 1 - FRANCE
--          Dominique COLNET and Suzanne COLLIN - SmartEiffel@loria.fr
--                       http://SmartEiffel.loria.fr
--
*/

/*
  This file (SmartEiffel/sys/runtime/boost.h) is automatically included when
  `run_control.boost' is true (ie. only for mode -boost).
*/
#define SE_BOOST 1
void se_print_run_time_stack (void);
void se_signal_handler(int sig);
#define FSOC_SIZE 8192
#define RSOC_SIZE 32768
/*
-- This file is  free  software, which  comes  along  with  SmartEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of
-- another product.
--       Copyright (C) 1994-2002 LORIA - INRIA - U.H.P. Nancy 1 - FRANCE
--          Dominique COLNET and Suzanne COLLIN - SmartEiffel@loria.fr
--                       http://SmartEiffel.loria.fr
--
*/
/*
   This file (SmartEiffel/sys/runtime/gc_lib.h) is automatically included
   when the Garbage Collector is used (default, unless option -no_gc has
   been selected).
*/

#define SE_GC_LIB 1

#define SE_GC_LOW_MEMORY_STRATEGY 0
#define SE_GC_HIGH_MEMORY_STRATEGY 1
#define SE_GC_DEFAULT_MEMORY_STRATEGY 2
extern int se_gc_strategy;


#define RSOH_UNMARKED 15253
#define RSOH_FREE 1
#define RSOH_MARKED 2


#define FSOH_UNMARKED ((void *) 1)
#define FSOH_MARKED   ((void *) 2)

/* To codify the state and the type of some Memory Chunk, we are
   using the following definitions :
*/
#define FSO_FREE_CHUNK  (-2)
#define RSO_FREE_CHUNK  (-1)
#define RSO_USED_CHUNK  ( 0)
#define FSO_STORE_CHUNK ( 1)
#define FSO_USED_CHUNK  ( 2)
#define FREE_CHUNK(x) ((x)<0)

/* Minimum size for a store area in a ReSizable Objects Chunk :
 */
#define RSOC_MIN_STORE 512

/* The default channel used to print -gc_info flag information :
*/
#define SE_GCINFO SE_ERR

extern int collector_counter; /* MEMORY.collector_counter */

typedef struct s_mch mch; /* Memory Chunk Header. */
typedef struct s_fsoc fsoc; /* Fixed Size Objects Chunk. */
typedef union u_rsoh rsoh; /* ReSizable Object Header. */
typedef struct s_fll_rsoh fll_rsoh;
typedef struct s_rsoc rsoc; /* ReSizable Objects Chunk. */
typedef struct s_na_env na_env; /* Native Array ENVironment. */


struct s_mch{
  unsigned int size; /* In number of bytes (actual argument of malloc).*/
  int state_type; /* One value in : RSO_USED_CHUNK,
                     FREE_CHUNK, FSO_STORE_CHUNK, FSO_USED_CHUNK */
  void(*amfp)(mch*,void*); /* Align Mark Function Pointer. */
  void(*swfp)(mch*); /* SWeep Function Pointer. */
};

struct s_fsoc{
  mch header; /* Common header for fsoc and rsoc. */
  fsoc* next; /* The next one when in free list (fsocfl). */
  int count_minus_one;
  double first_object;
};

typedef struct _rso_header rso_header;

struct _rso_header{
    unsigned int size;
    int magic_flag;     /* RSOH_MARKED when used,
			   RSOH_FREE when free,
			   else RSOH_UNMARKED */
};

union u_rsoh{
  rso_header header;
  double padding;
  };

struct s_fll_rsoh {
  rso_header rsoh_field;
  fll_rsoh* nextflol;
};

struct s_rsoc{
  mch header; /* Common header for fsoc and rsoc. */
  unsigned int isize; /* Initial size (at malloc time) to detect split chunks. */
  rsoc* next; /* The next one when in free list (rsocfl). */
  fll_rsoh*free_list_of_large; /* Intra. free list. */
  na_env*nae;
  rsoh first_header;
};

struct s_na_env{
  unsigned int store_left;
  rsoh* store;
  rsoc*store_chunk;
  rsoc*chunk_list;
  void (*gc_mark)(T0*);
};

extern void**stack_bottom;
extern mch**gcmt;
extern int gcmt_max;
extern int gcmt_used;
extern int gc_is_off;
extern fsoc* fsocfl;
extern unsigned int fsoc_count;
extern unsigned int rsoc_count;
extern void*gcmt_tail_addr;

void gc_sweep(void);
void gc_mark(void* p);
mch* gc_find_chunk(void* p);
int gc_stack_size(void);
int garbage_delayed(void);
void gc_update_ceils(void);
char*new_na(na_env*nae,unsigned int size);
unsigned int fsocfl_count(void);
unsigned int rsocfl_count(void);
void gc_dispose_before_exit(void);
void mark_stack_and_registers (void);
fsoc* gc_fsoc_get1(void);
fsoc* gc_fsoc_get2(void);

int gc_memory_used(void);
/*
-- This file is  free  software, which  comes  along  with  SmartEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of
-- another product.
--       Copyright (C) 1994-2002 LORIA - INRIA - U.H.P. Nancy 1 - FRANCE
--          Dominique COLNET and Suzanne COLLIN - SmartEiffel@loria.fr
--                       http://SmartEiffel.loria.fr
--
*/
/*
  This file (SmartEiffel/sys/runtime/basic_io.h) is automatically
  included when some external "SmartEiffel" basic_io_* feature is used.
*/

#define basic_io_stdin (stdin)
#define basic_io_stdout (stdout)
#define basic_io_stderr (stderr)
#define basic_io_eof (EOF)
#define basic_io_text_file_read_open(p) (fopen(((char*)(p)),"r"))
#define basic_io_text_file_write_open(p) (fopen(((char*)(p)),"w"))
#define basic_io_text_file_write_append(p) (fopen(((char*)(p)),"a"))
#define basic_io_text_file_read_write_open(p) (fopen(((char*)(p)),"r+"))
#define basic_io_text_file_read_write_append(p) (fopen(((char*)(p)),"a+"))
#define basic_io_binary_file_read_open(p) (fopen(((char*)(p)),"rb"))
#define basic_io_binary_file_write_open(p) (fopen(((char*)(p)),"wb"))
#define basic_io_binary_file_write_append(p) (fopen(((char*)(p)),"ab"))
#define basic_io_fclose(p) (fclose((FILE*)(p)))
#define basic_io_flush(p) (fflush((FILE*)(p)))
#define basic_io_getc(f) (getc(((FILE*)(f))))
#define basic_io_putc(b, f) (putc((b),((FILE*)(f))))
#define basic_io_fread(b, n, f) (fread((void *)(b),(size_t)(1), (size_t)(n),(FILE*)(f)))
#define basic_io_fwrite(b, n, f) (fwrite((void *)(b),(size_t)(1), (size_t)(n),(FILE*)(f)))
#define basic_io_feof(f) (feof(((FILE*)(f))))
#define basic_io_rename(o, n) (rename(((char*)(o)),((char*)(n))))
#define basic_io_remove(f) (remove(((char*)(f))))

#if defined __USE_POSIX || defined __unix__ || defined _POSIX_C_SOURCE
#  define basic_io_read_stdin(b, s) (read(STDIN_FILENO, b, s))
#else
  extern int basic_io_read_stdin(char *buffer, int size);
#endif

/*
-- This file is  free  software, which  comes  along  with  SmartEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of
-- another product.
--       Copyright (C) 1994-2002 LORIA - INRIA - U.H.P. Nancy 1 - FRANCE
--          Dominique COLNET and Suzanne COLLIN - SmartEiffel@loria.fr
--                       http://SmartEiffel.loria.fr
--
*/
/*
  This file (SmartEiffel/sys/runtime/basic_getenv.h) is automatically
  included when the GENERAL.basic_getenv feature is used (ie. in live code).
*/

#define basic_getenv(v) (getenv((char*)v))

/*
-- This file is  free  software, which  comes  along  with  SmartEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of
-- another product.
--       Copyright (C) 1994-2002 LORIA - INRIA - U.H.P. Nancy 1 - FRANCE
--          Dominique COLNET and Suzanne COLLIN - SmartEiffel@loria.fr
--                       http://SmartEiffel.loria.fr
--
*/
/*
  This file (SmartEiffel/sys/runtime/basic_time.h) is automatically
  included when some external "SmartEiffel" basic_time_* feature is
  used (i.e. in live code).
*/
#include <time.h>

#define basic_time_time ((EIF_INTEGER_64)time(NULL))
EIF_DOUBLE basic_time_difftime(time_t t2, time_t t1);
EIF_INTEGER basic_time_getyear(time_t t, EIF_INTEGER m);
EIF_INTEGER basic_time_getmonth(time_t t, EIF_INTEGER m);
EIF_INTEGER basic_time_getday(time_t t, EIF_INTEGER m);
EIF_INTEGER basic_time_gethour(time_t t, EIF_INTEGER m);
EIF_INTEGER basic_time_getminute(time_t t, EIF_INTEGER m);
EIF_INTEGER basic_time_getsecond(time_t t, EIF_INTEGER m);
EIF_INTEGER basic_time_getyday(time_t t, EIF_INTEGER m);
EIF_INTEGER basic_time_getwday(time_t t, EIF_INTEGER m);
EIF_BOOLEAN basic_time_is_summer_time_used(time_t t);
EIF_INTEGER_64 basic_time_mktime(EIF_INTEGER year, EIF_INTEGER mon,
			     EIF_INTEGER mday, EIF_INTEGER hour,
			     EIF_INTEGER min,  EIF_INTEGER sec);
void basic_time_add_second(EIF_INTEGER_64 *t, EIF_INTEGER s);
extern unsigned int fsoc_count_ceil;
extern unsigned int rsoc_count_ceil;
/*BOOLEAN*/
T6 r6_ix_and(T6 C,T6 a1);
/*BOOLEAN*/
T6 r6_ix_xor(T6 C,T6 a1);
/*BOOLEAN*/
T0* r6to_string(T6 C);
/*BOOLEAN*/
T6 r6_px_not(T6 C);
/*BOOLEAN*/
T6 r6_ix_or(T6 C,T6 a1);
/*CHARACTER*/
T6 r3is_bit(T3 C);
/*CHARACTER*/
T6 r3is_digit(T3 C);
/*CHARACTER*/
T6 r3is_separator(T3 C);
/*CHARACTER*/
T1 r3octal_value(T3 C);
/*CHARACTER*/
T6 r3is_hexadecimal_digit(T3 C);
/*CHARACTER*/
T6 r3is_octal_digit(T3 C);
/*CHARACTER*/
T6 r3_ix_6061(T3 C,T3 a1);
/*CHARACTER*/
T1 r3value(T3 C);
/*CHARACTER*/
T6 r3is_letter(T3 C);
/*CHARACTER*/
T1 r3decimal_value(T3 C);
/*CHARACTER*/
T6 r3_ix_6261(T3 C,T3 a1);
/*CHARACTER*/
T3 r3to_upper(T3 C);
/*CHARACTER*/
T6 r3is_upper(T3 C);
/*CHARACTER*/
T3 r3to_lower(T3 C);
/*CHARACTER*/
T6 r3_ix_62(T3 C,T3 a1);
/*CHARACTER*/
T6 r3is_letter_or_digit(T3 C);
/*CHARACTER*/
T6 r3is_lower(T3 C);
/*CHARACTER*/
T1 r3hexadecimal_value(T3 C);
/*INTEGER*/
T11 r2_ix_94(T2 C,T2 a1);
/*INTEGER*/
T6 r2is_equal(T2 C,T2 a1);
extern T0*oBC16string_buffer;
/*INTEGER*/
T2 r2max(T2 C,T2 a1);
/*INTEGER*/
T5 r2to_double(T2 C);
/*INTEGER*/
T0* r2to_string(T2 C);
/*INTEGER*/
T5 r2log(T2 C);
/*INTEGER*/
T6 r2odd(T2 C);
/*INTEGER*/
T5 r2log10(T2 C);
/*INTEGER*/
T3 r2digit(T2 C);
/*INTEGER*/
T0* r2to_string_format(T2 C,T2 a1);
/*INTEGER*/
T2 r2hash_code(T2 C);
/*INTEGER*/
void r2append_in(T2 C,T0* a1);
/*INTEGER*/
T5 r2sqrt(T2 C);
/*INTEGER*/
T2 r2abs(T2 C);
/*INTEGER*/
T3 r2decimal_digit(T2 C);
/*INTEGER*/
T11 r2to_integer_64(T2 C);
/*DOUBLE*/
T2 r5floor(T5 C);
/*DOUBLE*/
T2 r5ceiling(T5 C);
/*DOUBLE*/
T5 r5double_ceiling(T5 C);
/*INTEGER_64*/
T3 r11digit(T11 C);
/*INTEGER_64*/
void r11append_in(T11 C,T0* a1);
/*NATIVE_ARRAY[LINKED_LIST[CODE_SLOT]]*/
void r219clear_all(T219 C,T2 a1);
/*NATIVE_ARRAY[LINKED_LIST[CODE_SLOT]]*/
T219 r219realloc(T219 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[LINKED_LIST[CODE_SLOT]]*/
void r219clear(T219 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[LINKED_LIST[CODE_SLOT]]*/
void r219copy_from(T219 C,T219 a1,T2 a2);
/*NATIVE_ARRAY[BOOLEAN]*/
void r48clear_all(T48 C,T2 a1);
/*NATIVE_ARRAY[ITM_CODE]*/
void r162clear_all(T162 C,T2 a1);
/*NATIVE_ARRAY[ITM_CODE]*/
T162 r162realloc(T162 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[ITM_CODE]*/
void r162clear(T162 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[ITM_CODE]*/
void r162copy_from(T162 C,T162 a1,T2 a2);
/*NATIVE_ARRAY[DICTIONARY_NODE[STRING,STRING]]*/
void r118set_all_with(T118 C,T0* a1,T2 a2);
/*NATIVE_ARRAY[PROTOTYPE]*/
void r39clear_all(T39 C,T2 a1);
/*NATIVE_ARRAY[PROTOTYPE]*/
T39 r39realloc(T39 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[PROTOTYPE]*/
void r39copy_from(T39 C,T39 a1,T2 a2);
/*NATIVE_ARRAY[SLOT]*/
void r180clear_all(T180 C,T2 a1);
/*NATIVE_ARRAY[STRING]*/
void r51clear_all(T51 C,T2 a1);
/*NATIVE_ARRAY[STRING]*/
T51 r51realloc(T51 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[STRING]*/
void r51clear(T51 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[STRING]*/
void r51copy_from(T51 C,T51 a1,T2 a2);
/*NATIVE_ARRAY[SET_NODE[INTEGER]]*/
void r61set_all_with(T61 C,T0* a1,T2 a2);
/*NATIVE_ARRAY[CHARACTER]*/
void r9copy_slice(T9 C,T2 a1,T9 a2,T2 a3,T2 a4);
/*NATIVE_ARRAY[CHARACTER]*/
T9 r9realloc(T9 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[CHARACTER]*/
void r9move(T9 C,T2 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[CHARACTER]*/
T6 r9fast_memcmp(T9 C,T9 a1,T2 a2);
/*NATIVE_ARRAY[CHARACTER]*/
void r9fast_replace_all(T9 C,T3 a1,T3 a2,T2 a3);
/*NATIVE_ARRAY[CHARACTER]*/
T6 r9fast_has(T9 C,T3 a1,T2 a2);
/*NATIVE_ARRAY[CHARACTER]*/
void r9copy_at(T9 C,T2 a1,T9 a2,T2 a3);
/*NATIVE_ARRAY[CHARACTER]*/
void r9clear(T9 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[CHARACTER]*/
void r9copy_from(T9 C,T9 a1,T2 a2);
/*NATIVE_ARRAY[INTEGER]*/
void r43clear_all(T43 C,T2 a1);
/*NATIVE_ARRAY[INTEGER]*/
T43 r43realloc(T43 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[INTEGER]*/
T6 r43fast_memcmp(T43 C,T43 a1,T2 a2);
/*NATIVE_ARRAY[INTEGER]*/
void r43clear(T43 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[INTEGER]*/
void r43copy_from(T43 C,T43 a1,T2 a2);
/*NATIVE_ARRAY[RUNTIME]*/
T74 r74realloc(T74 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[RUNTIME]*/
void r74remove_first(T74 C,T2 a1);
/*NATIVE_ARRAY[RUNTIME]*/
void r74clear(T74 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[RUNTIME]*/
void r74copy_from(T74 C,T74 a1,T2 a2);
/*NATIVE_ARRAY[ANY]*/
T124 r124realloc(T124 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[ANY]*/
T2 r124fast_index_of(T124 C,T0* a1,T2 a2);
/*NATIVE_ARRAY[ANY]*/
void r124copy_from(T124 C,T124 a1,T2 a2);
/*STRING*/
void r7copy(T7* C,T0* a1);
/*STRING*/
T6 r7is_bit(T7* C);
/*STRING*/
void r7remove_first(T7* C,T2 a1);
/*STRING*/
T3 r7last(T7* C);
/*STRING*/
T2 r7first_substring_index(T7* C,T0* a1);
/*STRING*/
void r7remove_between(T7* C,T2 a1,T2 a2);
/*STRING*/
T6 r7is_equal(T7* C,T0* a1);
/*STRING*/
void r7prepend(T7* C,T0* a1);
/*STRING*/
void r7append(T7* C,T0* a1);
/*STRING*/
T0* r7to_number(T7* C);
/*STRING*/
T2 r7index_of(T7* C,T3 a1,T2 a2);
/*STRING*/
T6 r7has_suffix(T7* C,T0* a1);
/*STRING*/
T6 r7is_integer(T7* C);
/*STRING*/
void r7make(T7* C,T2 a1);
/*STRING*/
void r7extend(T7* C,T3 a1);
/*STRING*/
void r7insert_string(T7* C,T0* a1,T2 a2);
/*STRING*/
T2 r7hash_code(T7* C);
/*STRING*/
void r7remove_last(T7* C,T2 a1);
/*STRING*/
T6 r7has(T7* C,T3 a1);
/*STRING*/
T2 r7to_integer(T7* C);
/*STRING*/
void r7append_character(T7* C,T3 a1);
/*STRING*/
void r7add_last(T7* C,T3 a1);
/*STRING*/
void r7resize(T7* C,T2 a1);
/*STRING*/
void r7to_upper(T7* C);
/*STRING*/
T2 r7substring_index(T7* C,T0* a1,T2 a2);
/*STRING*/
void r7from_external_copy(T7* C,T8 a1);
/*STRING*/
void r7right_adjust(T7* C);
/*STRING*/
T8 r7to_external(T7* C);
/*STRING*/
void r7extend_multiple(T7* C,T3 a1,T2 a2);
/*STRING*/
void r7to_lower(T7* C);
/*STRING*/
T0* r7twin(T7* C);
/*STRING*/
T0* r7_ix_43(T7* C,T0* a1);
/*STRING*/
T6 r7is_number(T7* C);
/*STRING*/
void r7left_adjust(T7* C);
/*STRING*/
void r7swap(T7* C,T2 a1,T2 a2);
/*FIXED_ARRAY[BOOLEAN]*/
void r46make(T46* C,T2 a1);
/*FIXED_ARRAY[ITM_CODE]*/
void r160force(T160* C,T0* a1,T2 a2);
/*FIXED_ARRAY[ITM_CODE]*/
void r160make(T160* C,T2 a1);
/*FIXED_ARRAY[ITM_CODE]*/
void r160add_last(T160* C,T0* a1);
/*FIXED_ARRAY[ITM_CODE]*/
void r160resize(T160* C,T2 a1);
/*ARRAY[ANY]*/
T2 r123count(T123* C);
/*ARRAY[ANY]*/
void r123add_last(T123* C,T0* a1);
/*ARRAY[ANY]*/
T2 r123fast_index_of(T123* C,T0* a1);
/*ARRAY[ANY]*/
void r123with_capacity(T123* C,T2 a1,T2 a2);
/*FIXED_ARRAY[PROTOTYPE]*/
void r37make(T37* C,T2 a1);
/*FIXED_ARRAY[PROTOTYPE]*/
void r37add_last(T37* C,T0* a1);
/*FIXED_ARRAY[STRING]*/
void r49make(T49* C,T2 a1);
/*FIXED_ARRAY[STRING]*/
void r49add_last(T49* C,T0* a1);
/*FIXED_ARRAY[STRING]*/
void r49with_capacity(T49* C,T2 a1);
/*FIXED_ARRAY[INTEGER]*/
void r41copy(T41* C,T0* a1);
/*FIXED_ARRAY[INTEGER]*/
T6 r41is_equal(T41* C,T0* a1);
/*FIXED_ARRAY[INTEGER]*/
void r41make(T41* C,T2 a1);
/*FIXED_ARRAY[INTEGER]*/
void r41remove_last(T41* C);
/*FIXED_ARRAY[INTEGER]*/
void r41add_last(T41* C,T2 a1);
/*FIXED_ARRAY[INTEGER]*/
void r41resize(T41* C,T2 a1);
/*FIXED_ARRAY[INTEGER]*/
T0* r41twin(T41* C);
/*FIXED_ARRAY[SLOT]*/
void r178make(T178* C,T2 a1);
/*FIXED_ARRAY[RUNTIME]*/
void r72force(T72* C,T0* a1,T2 a2);
/*FIXED_ARRAY[RUNTIME]*/
T0* r72last(T72* C);
/*FIXED_ARRAY[RUNTIME]*/
void r72remove_first(T72* C);
/*FIXED_ARRAY[RUNTIME]*/
void r72add_first(T72* C,T0* a1);
/*FIXED_ARRAY[RUNTIME]*/
void r72move(T72* C,T2 a1,T2 a2,T2 a3);
/*FIXED_ARRAY[RUNTIME]*/
void r72remove_last(T72* C);
/*FIXED_ARRAY[RUNTIME]*/
void r72add_last(T72* C,T0* a1);
/*FIXED_ARRAY[RUNTIME]*/
void r72resize(T72* C,T2 a1);
/*FIXED_ARRAY[RUNTIME]*/
void r72with_capacity(T72* C,T2 a1);
/*FIXED_ARRAY[RUNTIME]*/
void r72swap(T72* C,T2 a1,T2 a2);
/*FIXED_ARRAY[LINKED_LIST[CODE_SLOT]]*/
void r217make(T217* C,T2 a1);
/*FIXED_ARRAY[LINKED_LIST[CODE_SLOT]]*/
void r217resize(T217* C,T2 a1);
/*LINK[CODE_SLOT]*/
void r127make(T127* C,T0* a1,T0* a2);
/*LINK[ITM_CODE]*/
void r140make(T140* C,T0* a1,T0* a2);
/*LINKED_LIST[SET[INTEGER]]*/
void r55remove_first(T55* C);
/*LINKED_LIST[SET[INTEGER]]*/
T0* r55item(T55* C,T2 a1);
/*LINKED_LIST[SET[INTEGER]]*/
void r55make(T55* C);
/*LINKED_LIST[SET[INTEGER]]*/
void r55remove(T55* C,T2 a1);
/*LINKED_LIST[SET[INTEGER]]*/
void r55remove_last(T55* C);
/*LINKED_LIST[SET[INTEGER]]*/
void r55add_last(T55* C,T0* a1);
/*LINKED_LIST[SET[INTEGER]]*/
void r55clear(T55* C);
/*LINKED_LIST[SET[INTEGER]]*/
void r55go_item(T55* C,T2 a1);
/*DICTIONARY[INTEGER,STRING]*/
void r89put(T89* C,T2 a1,T0* a2);
/*DICTIONARY[INTEGER,STRING]*/
void r89increase_capacity(T89* C);
/*DICTIONARY[INTEGER,STRING]*/
void r89add(T89* C,T2 a1,T0* a2);
/*DICTIONARY[INTEGER,STRING]*/
void r89with_capacity(T89* C,T2 a1);
/*DICTIONARY[INTEGER,STRING]*/
T2 r89reference_at(T89* C,T0* a1);
/*SET_NODE[STRING]*/
void r65make(T65* C,T0* a1,T0* a2);
/*LINK[SLOT]*/
void r87make(T87* C,T0* a1,T0* a2);
/*SET_NODE[INTEGER]*/
void r60make(T60* C,T2 a1,T0* a2);
/*LINK[LOCAL_]*/
void r120make(T120* C,T0* a1,T0* a2);
/*LINKED_LIST[BLOCK]*/
T0* r220item(T220* C,T2 a1);
/*LINKED_LIST[BLOCK]*/
void r220make(T220* C);
/*LINKED_LIST[BLOCK]*/
void r220add_last(T220* C,T0* a1);
/*LINKED_LIST[BLOCK]*/
void r220clear(T220* C);
/*LINKED_LIST[BLOCK]*/
void r220go_item(T220* C,T2 a1);
/*SET_NODE[EXPR_WRITE]*/
void r85make(T85* C,T0* a1,T0* a2);
/*LINK[STRING]*/
void r103make(T103* C,T0* a1,T0* a2);
/*LINKED_LIST[POSITION]*/
void r203copy(T203* C,T0* a1);
/*LINKED_LIST[POSITION]*/
void r203remove_first(T203* C);
/*LINKED_LIST[POSITION]*/
T0* r203item(T203* C,T2 a1);
/*LINKED_LIST[POSITION]*/
void r203make(T203* C);
/*LINKED_LIST[POSITION]*/
void r203remove(T203* C,T2 a1);
/*LINKED_LIST[POSITION]*/
void r203remove_last(T203* C);
/*LINKED_LIST[POSITION]*/
void r203add_last(T203* C,T0* a1);
/*LINKED_LIST[POSITION]*/
void r203clear(T203* C);
/*LINKED_LIST[POSITION]*/
void r203go_item(T203* C,T2 a1);
/*LINKED_LIST[POSITION]*/
void r203from_collection(T203* C,T0* a1);
/*LINKED_LIST[EXPR_VALUE]*/
void r202remove_first(T202* C);
/*LINKED_LIST[EXPR_VALUE]*/
void r202put(T202* C,T0* a1,T2 a2);
/*LINKED_LIST[EXPR_VALUE]*/
T0* r202item(T202* C,T2 a1);
/*LINKED_LIST[EXPR_VALUE]*/
void r202make(T202* C);
/*LINKED_LIST[EXPR_VALUE]*/
void r202remove(T202* C,T2 a1);
/*LINKED_LIST[EXPR_VALUE]*/
void r202remove_last(T202* C);
/*LINKED_LIST[EXPR_VALUE]*/
void r202add_last(T202* C,T0* a1);
/*LINKED_LIST[EXPR_VALUE]*/
void r202go_item(T202* C,T2 a1);
/*LINK[BLOCK]*/
void r221make(T221* C,T0* a1,T0* a2);
/*DICTIONARY_NODE[STRING,STRING]*/
void r117make(T117* C,T0* a1,T0* a2,T0* a3);
/*LINKED_LIST[CODE_SLOT]*/
void r110remove_first(T110* C);
/*LINKED_LIST[CODE_SLOT]*/
T0* r110item(T110* C,T2 a1);
/*LINKED_LIST[CODE_SLOT]*/
void r110make(T110* C);
/*LINKED_LIST[CODE_SLOT]*/
void r110remove(T110* C,T2 a1);
/*LINKED_LIST[CODE_SLOT]*/
void r110remove_last(T110* C);
/*LINKED_LIST[CODE_SLOT]*/
void r110add_last(T110* C,T0* a1);
/*LINKED_LIST[CODE_SLOT]*/
T2 r110fast_index_of(T110* C,T0* a1);
/*LINKED_LIST[CODE_SLOT]*/
void r110go_item(T110* C,T2 a1);
/*LINKED_LIST[INSTR]*/
void r112remove_first(T112* C);
/*LINKED_LIST[INSTR]*/
void r112put(T112* C,T0* a1,T2 a2);
/*LINKED_LIST[INSTR]*/
T0* r112item(T112* C,T2 a1);
/*LINKED_LIST[INSTR]*/
void r112make(T112* C);
/*LINKED_LIST[INSTR]*/
void r112remove(T112* C,T2 a1);
/*LINKED_LIST[INSTR]*/
void r112add_first(T112* C,T0* a1);
/*LINKED_LIST[INSTR]*/
void r112remove_last(T112* C);
/*LINKED_LIST[INSTR]*/
void r112add_last(T112* C,T0* a1);
/*LINKED_LIST[INSTR]*/
void r112add(T112* C,T0* a1,T2 a2);
/*LINKED_LIST[INSTR]*/
void r112go_item(T112* C,T2 a1);
/*LINKED_LIST[CASE_BODY]*/
void r152remove_first(T152* C);
/*LINKED_LIST[CASE_BODY]*/
void r152put(T152* C,T0* a1,T2 a2);
/*LINKED_LIST[CASE_BODY]*/
T0* r152item(T152* C,T2 a1);
/*LINKED_LIST[CASE_BODY]*/
void r152make(T152* C);
/*LINKED_LIST[CASE_BODY]*/
void r152remove(T152* C,T2 a1);
/*LINKED_LIST[CASE_BODY]*/
void r152remove_last(T152* C);
/*LINKED_LIST[CASE_BODY]*/
void r152add_last(T152* C,T0* a1);
/*LINKED_LIST[CASE_BODY]*/
void r152go_item(T152* C,T2 a1);
/*LINKED_LIST[ITM_LOCAL]*/
T0* r142item(T142* C,T2 a1);
/*LINKED_LIST[ITM_LOCAL]*/
void r142make(T142* C);
/*LINKED_LIST[ITM_LOCAL]*/
void r142add_last(T142* C,T0* a1);
/*LINKED_LIST[ITM_LOCAL]*/
void r142go_item(T142* C,T2 a1);
/*LINK[ARGUMENT]*/
void r128make(T128* C,T0* a1,T0* a2);
/*LINK[EXPR_VALUE]*/
void r206make(T206* C,T0* a1,T0* a2);
/*LINKED_LIST[STRING]*/
void r102copy(T102* C,T0* a1);
/*LINKED_LIST[STRING]*/
void r102remove_first(T102* C);
/*LINKED_LIST[STRING]*/
T0* r102item(T102* C,T2 a1);
/*LINKED_LIST[STRING]*/
void r102make(T102* C);
/*LINKED_LIST[STRING]*/
void r102remove(T102* C,T2 a1);
/*LINKED_LIST[STRING]*/
void r102remove_last(T102* C);
/*LINKED_LIST[STRING]*/
void r102add_last(T102* C,T0* a1);
/*LINKED_LIST[STRING]*/
void r102clear(T102* C);
/*LINKED_LIST[STRING]*/
T2 r102fast_index_of(T102* C,T0* a1);
/*LINKED_LIST[STRING]*/
void r102go_item(T102* C,T2 a1);
/*LINKED_LIST[STRING]*/
void r102from_collection(T102* C,T0* a1);
/*LINKED_LIST[ARGUMENT]*/
void r111remove_first(T111* C);
/*LINKED_LIST[ARGUMENT]*/
void r111put(T111* C,T0* a1,T2 a2);
/*LINKED_LIST[ARGUMENT]*/
T0* r111item(T111* C,T2 a1);
/*LINKED_LIST[ARGUMENT]*/
void r111make(T111* C);
/*LINKED_LIST[ARGUMENT]*/
void r111remove(T111* C,T2 a1);
/*LINKED_LIST[ARGUMENT]*/
void r111remove_last(T111* C);
/*LINKED_LIST[ARGUMENT]*/
void r111add_last(T111* C,T0* a1);
/*LINKED_LIST[ARGUMENT]*/
void r111clear(T111* C);
/*LINKED_LIST[ARGUMENT]*/
void r111go_item(T111* C,T2 a1);
/*LINK[INSTR]*/
void r121make(T121* C,T0* a1,T0* a2);
/*LINKED_LIST[LINKED_LIST[CODE_SLOT]]*/
void r125remove_first(T125* C);
/*LINKED_LIST[LINKED_LIST[CODE_SLOT]]*/
T0* r125item(T125* C,T2 a1);
/*LINKED_LIST[LINKED_LIST[CODE_SLOT]]*/
void r125make(T125* C);
/*LINKED_LIST[LINKED_LIST[CODE_SLOT]]*/
void r125add_last(T125* C,T0* a1);
/*LINKED_LIST[LINKED_LIST[CODE_SLOT]]*/
T2 r125fast_index_of(T125* C,T0* a1);
/*LINKED_LIST[LINKED_LIST[CODE_SLOT]]*/
void r125go_item(T125* C,T2 a1);
/*LINKED_LIST[LOCAL_]*/
T6 r119safe_equal(T0* a1,T0* a2);
/*LINKED_LIST[LOCAL_]*/
void r119remove_first(T119* C);
/*LINKED_LIST[LOCAL_]*/
T0* r119item(T119* C,T2 a1);
/*LINKED_LIST[LOCAL_]*/
T6 r119valid_index(T119* C,T2 a1);
/*LINKED_LIST[LOCAL_]*/
T2 r119index_of(T119* C,T0* a1);
/*LINKED_LIST[LOCAL_]*/
void r119make(T119* C);
/*LINKED_LIST[LOCAL_]*/
void r119remove(T119* C,T2 a1);
/*LINKED_LIST[LOCAL_]*/
void r119remove_last(T119* C);
/*LINKED_LIST[LOCAL_]*/
T6 r119has(T119* C,T0* a1);
/*LINKED_LIST[LOCAL_]*/
T6 r119fast_has(T119* C,T0* a1);
/*LINKED_LIST[LOCAL_]*/
void r119add_last(T119* C,T0* a1);
/*LINKED_LIST[LOCAL_]*/
void r119clear(T119* C);
/*LINKED_LIST[LOCAL_]*/
T2 r119fast_index_of(T119* C,T0* a1);
/*LINKED_LIST[LOCAL_]*/
void r119go_item(T119* C,T2 a1);
/*LINKED_LIST[CASE_TYPE]*/
void r174remove_first(T174* C);
/*LINKED_LIST[CASE_TYPE]*/
void r174put(T174* C,T0* a1,T2 a2);
/*LINKED_LIST[CASE_TYPE]*/
T0* r174item(T174* C,T2 a1);
/*LINKED_LIST[CASE_TYPE]*/
void r174make(T174* C);
/*LINKED_LIST[CASE_TYPE]*/
void r174remove(T174* C,T2 a1);
/*LINKED_LIST[CASE_TYPE]*/
void r174add_first(T174* C,T0* a1);
/*LINKED_LIST[CASE_TYPE]*/
void r174remove_last(T174* C);
/*LINKED_LIST[CASE_TYPE]*/
void r174add_last(T174* C,T0* a1);
/*LINKED_LIST[CASE_TYPE]*/
void r174go_item(T174* C,T2 a1);
/*LINK[INTEGER]*/
void r94make(T94* C,T2 a1,T0* a2);
/*LINK[SET[INTEGER]]*/
void r58make(T58* C,T0* a1,T0* a2);
/*LINK[POSITION]*/
void r205make(T205* C,T0* a1,T0* a2);
/*SET[EXPR_WRITE]*/
T0* r84item(T84* C,T2 a1);
/*SET[EXPR_WRITE]*/
void r84set_cache_user(T84* C,T2 a1);
/*SET[EXPR_WRITE]*/
void r84remove(T84* C,T0* a1);
/*SET[EXPR_WRITE]*/
void r84increase_capacity(T84* C);
/*SET[EXPR_WRITE]*/
T6 r84has(T84* C,T0* a1);
/*SET[EXPR_WRITE]*/
void r84add(T84* C,T0* a1);
/*SET[EXPR_WRITE]*/
void r84with_capacity(T84* C,T2 a1);
/*DICTIONARY[STRING,STRING]*/
T0* r116at(T116* C,T0* a1);
/*DICTIONARY[STRING,STRING]*/
void r116put(T116* C,T0* a1,T0* a2);
/*DICTIONARY[STRING,STRING]*/
T0* r116item(T116* C,T2 a1);
/*DICTIONARY[STRING,STRING]*/
void r116set_cache_user(T116* C,T2 a1);
/*DICTIONARY[STRING,STRING]*/
void r116increase_capacity(T116* C);
/*DICTIONARY[STRING,STRING]*/
T6 r116has(T116* C,T0* a1);
/*DICTIONARY[STRING,STRING]*/
void r116clear(T116* C);
/*DICTIONARY[STRING,STRING]*/
void r116with_capacity(T116* C,T2 a1);
/*DICTIONARY[POSITION,INTEGER]*/
void r144put(T144* C,T0* a1,T2 a2);
/*DICTIONARY[POSITION,INTEGER]*/
void r144increase_capacity(T144* C);
/*DICTIONARY[POSITION,INTEGER]*/
void r144with_capacity(T144* C,T2 a1);
/*DICTIONARY[POSITION,INTEGER]*/
T0* r144reference_at(T144* C,T2 a1);
/*DICTIONARY_NODE[INTEGER,STRING]*/
void r92make(T92* C,T2 a1,T0* a2,T0* a3);
/*LINK[CASE_TYPE]*/
void r175make(T175* C,T0* a1,T0* a2);
/*LINKED_LIST[SLOT]*/
void r62remove_first(T62* C);
/*LINKED_LIST[SLOT]*/
T0* r62item(T62* C,T2 a1);
/*LINKED_LIST[SLOT]*/
void r62make(T62* C);
/*LINKED_LIST[SLOT]*/
void r62remove(T62* C,T2 a1);
/*LINKED_LIST[SLOT]*/
void r62remove_last(T62* C);
/*LINKED_LIST[SLOT]*/
void r62add_last(T62* C,T0* a1);
/*LINKED_LIST[SLOT]*/
void r62go_item(T62* C,T2 a1);
/*LINK[LINKED_LIST[CODE_SLOT]]*/
void r126make(T126* C,T0* a1,T0* a2);
/*SET[INTEGER]*/
void r56copy(T56* C,T0* a1);
/*SET[INTEGER]*/
T6 r56is_equal(T56* C,T0* a1);
/*SET[INTEGER]*/
void r56union(T56* C,T0* a1);
/*SET[INTEGER]*/
T2 r56item(T56* C,T2 a1);
/*SET[INTEGER]*/
void r56set_cache_user(T56* C,T2 a1);
/*SET[INTEGER]*/
void r56remove(T56* C,T2 a1);
/*SET[INTEGER]*/
void r56increase_capacity(T56* C);
/*SET[INTEGER]*/
T6 r56has(T56* C,T2 a1);
/*SET[INTEGER]*/
T6 r56is_disjoint_from(T56* C,T0* a1);
/*SET[INTEGER]*/
void r56add(T56* C,T2 a1);
/*SET[INTEGER]*/
void r56clear(T56* C);
/*SET[INTEGER]*/
T2 r56fast_index_of(T56* C,T2 a1);
/*SET[INTEGER]*/
T0* r56twin(T56* C);
/*SET[INTEGER]*/
void r56with_capacity(T56* C,T2 a1);
/*LINK[ITM_LOCAL]*/
void r143make(T143* C,T0* a1,T0* a2);
/*DICTIONARY_NODE[POSITION,INTEGER]*/
void r145make(T145* C,T0* a1,T2 a2,T0* a3);
/*LINKED_LIST[INTEGER]*/
T6 r34is_equal(T34* C,T0* a1);
/*LINKED_LIST[INTEGER]*/
T2 r34item(T34* C,T2 a1);
/*LINKED_LIST[INTEGER]*/
void r34make(T34* C);
/*LINKED_LIST[INTEGER]*/
void r34remove_last(T34* C);
/*LINKED_LIST[INTEGER]*/
void r34add_last(T34* C,T2 a1);
/*LINKED_LIST[INTEGER]*/
T2 r34fast_index_of(T34* C,T2 a1);
/*LINKED_LIST[INTEGER]*/
void r34go_item(T34* C,T2 a1);
/*LINKED_LIST[ITM_CODE]*/
T0* r139item(T139* C,T2 a1);
/*LINKED_LIST[ITM_CODE]*/
void r139make(T139* C);
/*LINKED_LIST[ITM_CODE]*/
void r139add_first(T139* C,T0* a1);
/*LINKED_LIST[ITM_CODE]*/
void r139add_last(T139* C,T0* a1);
/*LINKED_LIST[ITM_CODE]*/
void r139go_item(T139* C,T2 a1);
/*LINK[CASE_BODY]*/
void r154make(T154* C,T0* a1,T0* a2);
/*SET[STRING]*/
void r64increase_capacity(T64* C);
/*SET[STRING]*/
T0* r64fast_search(T64* C,T0* a1);
/*SET[STRING]*/
void r64add(T64* C,T0* a1);
/*SET[STRING]*/
void r64with_capacity(T64* C,T2 a1);
/*POSITION*/
void r40put_position(T40* C);
extern T0*oBC13string_tmp2;
/*POSITION*/
void r40put_light_position_in(T40* C,T0* a1);
/*POSITION*/
void r40put_error(T2 a1,T0* a2);
extern T0*oBC40msg_err;
/*POSITION*/
T2 r40get_line(T40* C);
extern T0*oBC13stack_runtime;
extern T0*oBC15io;
/*POSITION*/
void r40make(T40* C,T0* a1,T2 a2);
extern T0*oBC40type_error;
extern T0*oBC13string_tmp;
extern T0*oBC13flag_compiler;
/*POSITION*/
void r40send_error(T40* C);
extern T0*oBC15std_error;
/*DATA_LOCAL*/
void r132semantic_error(T0* a1,T0* a2);
/*DATA_LOCAL*/
void r132display(T132* C,T0* a1);
extern T0*oBC78bucket_type;
extern int fBC78bucket_type;
/*DATA_LOCAL*/
T0* r132bucket_type(void);
/*DATA_LOCAL*/
void r132sub_get_type(T132* C,T0* a1);
/*DATA_LOCAL*/
T6 r132depend(T132* C);
/*DATA_LOCAL*/
void r132display_ref(T132* C,T0* a1);
/*DATA_LOCAL*/
T0* r132my_copy(T132* C);
/*DATA_LOCAL*/
void r132make(T132* C,T0* a1,T0* a2);
/*DATA_LOCAL*/
void r132remove(T132* C);
extern T0*oBC15object_id_memory;
/*DATA_LOCAL*/
T0* r132get_type(T132* C);
/*DATA_LOCAL*/
T0* r132search_block(T132* C);
/*DATA_LOCAL*/
void r132genere(T132* C,T0* a1);
/*DATA_LOCAL*/
T0* r132require_list(T132* C);
/*DATA_LOCAL*/
T2 r132static_type(T132* C);
/*DATA_LOCAL*/
T6 r132is_require_constant(T132* C);
/*DATA_LOCAL*/
T0* r132execute(T132* C);
/*DATA_LOCAL*/
void r132depend_generic(T132* C);
/*DATA_LOCAL*/
T0* r132twin(T132* C);
extern T0*oBC13bucket;
extern int fBC13bucket;
/*DATA_LOCAL*/
T0* r132bucket(void);
/*DATA_LOCAL*/
T2 r132object_id(T132* C);
/*DATA_LOCAL*/
void r132make_expr(T132* C,T0* a1);
/*ITM_READ*/
T6 r191is_constant(T191* C);
extern T0*oBC13prototype_list;
extern int fBC13prototype_list;
/*ITM_READ*/
T0* r191prototype_list(void);
/*ITM_READ*/
T0* r191gt(T2 a1);
/*ITM_READ*/
void r191make(T191* C,T2 a1,T0* a2);
/*ITM_READ*/
T0* r191current_position(T191* C);
extern T0*oBC13run_tools;
extern int fBC13run_tools;
/*ITM_READ*/
T0* r191run_tools(void);
/*ITM_READ*/
T0* r191to_run(T191* C,T0* a1,T0* a2,T0* a3);
/*ITM_READ*/
T0* r191runnable(T191* C);
/*ITM_READ*/
T0* r191get_position(T2 a1);
/*ITM_READ*/
T0* r191bucket(void);
/*ITM_READ*/
T2 r191proto_self_current(void);
/*ITM_READ*/
T0* r191gtr(T2 a1);
/*DATA_SLOT*/
void r157semantic_error(T0* a1,T0* a2);
/*DATA_SLOT*/
void r157display(T157* C,T0* a1);
/*DATA_SLOT*/
T0* r157bucket_type(void);
/*DATA_SLOT*/
void r157sub_get_type(T157* C,T0* a1);
/*DATA_SLOT*/
T0* r157prototype_list(void);
/*DATA_SLOT*/
T6 r157depend(T157* C);
/*DATA_SLOT*/
T0* r157gt(T2 a1);
/*DATA_SLOT*/
void r157display_ref(T157* C,T0* a1);
/*DATA_SLOT*/
void r157set_variable(T157* C,T0* a1);
/*DATA_SLOT*/
T0* r157my_copy(T157* C);
/*DATA_SLOT*/
void r157make(T157* C,T0* a1,T0* a2,T0* a3);
/*DATA_SLOT*/
void r157remove(T157* C);
/*DATA_SLOT*/
T0* r157get_type(T157* C);
/*DATA_SLOT*/
T0* r157search_block(T157* C);
/*DATA_SLOT*/
void r157genere(T157* C,T0* a1);
/*DATA_SLOT*/
T0* r157require_list(T157* C);
/*DATA_SLOT*/
T6 r157is_require_constant(T157* C);
/*DATA_SLOT*/
T0* r157execute(T157* C);
/*DATA_SLOT*/
void r157depend_generic(T157* C);
/*DATA_SLOT*/
T0* r157twin(T157* C);
/*DATA_SLOT*/
T0* r157bucket(void);
/*DATA_SLOT*/
T2 r157object_id(T157* C);
/*DATA_SLOT*/
T2 r157proto_self_current(void);
/*DATA_SLOT*/
void r157make_expr(T157* C,T0* a1);
/*ITM_EXTERNAL_TYPE*/
T6 r183is_constant(T183* C);
/*ITM_EXTERNAL_TYPE*/
T0* r183prototype_list(void);
/*ITM_EXTERNAL_TYPE*/
T0* r183gt(T2 a1);
/*ITM_EXTERNAL_TYPE*/
void r183make(T183* C,T2 a1,T0* a2,T6 a3);
/*ITM_EXTERNAL_TYPE*/
T0* r183current_position(T183* C);
/*ITM_EXTERNAL_TYPE*/
T0* r183run_tools(void);
/*ITM_EXTERNAL_TYPE*/
T0* r183to_run(T183* C,T0* a1,T0* a2,T0* a3);
/*ITM_EXTERNAL_TYPE*/
T0* r183runnable(T183* C);
/*ITM_EXTERNAL_TYPE*/
T0* r183get_position(T2 a1);
/*ITM_EXTERNAL_TYPE*/
T2 r183proto_self_current(void);
/*ITM_WRITE_VALUE*/
T6 r193is_constant(T193* C);
/*ITM_WRITE_VALUE*/
void r193make(T193* C,T2 a1,T0* a2,T0* a3);
/*ITM_WRITE_VALUE*/
T0* r193current_position(T193* C);
/*ITM_WRITE_VALUE*/
T0* r193run_tools(void);
/*ITM_WRITE_VALUE*/
T0* r193to_run(T193* C,T0* a1,T0* a2,T0* a3);
/*ITM_WRITE_VALUE*/
T0* r193runnable(T193* C);
/*ITM_WRITE_VALUE*/
T0* r193get_position(T2 a1);
/*SWITCH_BODY*/
void r148display(T148* C,T0* a1);
/*SWITCH_BODY*/
T6 r148depend(T148* C);
/*SWITCH_BODY*/
void r148display_ref(T148* C,T0* a1);
/*SWITCH_BODY*/
T0* r148my_copy(T148* C);
/*SWITCH_BODY*/
void r148make(T148* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
/*SWITCH_BODY*/
void r148remove(T148* C);
/*SWITCH_BODY*/
T6 r148has(T0* a1,T2 a2);
/*SWITCH_BODY*/
void r148genere(T148* C,T0* a1);
extern T0*oBC13indent;
/*SWITCH_BODY*/
T0* r148execute(T148* C);
/*SWITCH_BODY*/
void r148depend_generic(T148* C);
/*SWITCH_BODY*/
T0* r148twin(T148* C);
/*SWITCH_BODY*/
T2 r148object_id(T148* C);
/*SWITCH_BODY*/
void r148make_expr(T148* C,T0* a1);
/*BASE_A_CODE*/
void r200semantic_error(T0* a1,T0* a2);
/*BASE_A_CODE*/
void r200make_base(T200* C,T0* a1,T0* a2,T0* a3);
/*BASE_A_CODE*/
void r200display(T200* C,T0* a1);
/*BASE_A_CODE*/
void r200syntax_error(T0* a1,T0* a2);
/*BASE_A_CODE*/
T0* r200get_receiver(T200* C);
/*BASE_A_CODE*/
T0* r200prototype_list(void);
/*BASE_A_CODE*/
T6 r200depend(T200* C);
/*BASE_A_CODE*/
T0* r200build_case_type(T200* C,T0* a1);
/*BASE_A_CODE*/
T0* r200build_case_type_parent(T200* C,T0* a1);
/*BASE_A_CODE*/
T0* r200gt(T2 a1);
/*BASE_A_CODE*/
void r200display_ref(T200* C,T0* a1);
/*BASE_A_CODE*/
T0* r200get_argument(T200* C);
/*BASE_A_CODE*/
T0* r200my_copy(T200* C);
/*BASE_A_CODE*/
void r200warning_error(T0* a1,T0* a2);
/*BASE_A_CODE*/
T0* r200build_case_body(T200* C,T0* a1);
/*BASE_A_CODE*/
void r200make(T200* C,T0* a1,T0* a2,T0* a3,T0* a4);
/*BASE_A_CODE*/
void r200remove(T200* C);
/*BASE_A_CODE*/
void r200genere(T200* C,T0* a1);
/*BASE_A_CODE*/
T0* r200build_case_type_action(T200* C,T0* a1,T0* a2);
/*BASE_A_CODE*/
T0* r200execute(T200* C);
/*BASE_A_CODE*/
void r200depend_generic(T200* C);
/*BASE_A_CODE*/
T6 r200depend_base(T200* C,T2 a1);
/*BASE_A_CODE*/
T0* r200twin(T200* C);
/*BASE_A_CODE*/
T0* r200bucket(void);
/*BASE_A_CODE*/
T2 r200object_id(T200* C);
/*BASE_A_CODE*/
T2 r200proto_self_current(void);
/*BASE_A_CODE*/
T0* r200get_n_argument(T200* C,T2 a1);
/*BASE_A_CODE*/
T0* r200gtr(T2 a1);
/*BASE_A_CODE*/
void r200make_expr(T200* C,T0* a1);
/*ITM_EXTERNAL*/
T6 r197is_constant(T197* C);
/*ITM_EXTERNAL*/
void r197make(T197* C,T2 a1,T0* a2);
/*ITM_EXTERNAL*/
T0* r197current_position(T197* C);
/*ITM_EXTERNAL*/
T0* r197run_tools(void);
/*ITM_EXTERNAL*/
T0* r197to_run(T197* C,T0* a1,T0* a2,T0* a3);
/*ITM_EXTERNAL*/
T0* r197runnable(T197* C);
/*ITM_EXTERNAL*/
T0* r197get_position(T2 a1);
/*SLOT*/
void r52set_name(T52* C,T0* a1);
/*SLOT*/
void r52display(T52* C,T0* a1);
extern T167 oBC13int_tools;
/*SLOT*/
T6 r52is_slot_id(T52* C);
/*SLOT*/
void r52copy_star(T52* C,T0* a1,T0* a2);
/*SLOT*/
T0* r52prototype_list(void);
/*SLOT*/
T0* r52get_value(T52* C);
/*SLOT*/
T0* r52gt(T2 a1);
/*SLOT*/
T0* r52add_value(T52* C,T0* a1);
/*SLOT*/
void r52write(T52* C,T0* a1);
/*SLOT*/
T2 r52value_is_argument(T52* C,T2 a1);
/*SLOT*/
void r52make(T52* C,T0* a1,T0* a2,T0* a3);
/*SLOT*/
T2 r52real_type(T52* C);
/*SLOT*/
void r52create_body_slot(T52* C);
/*SLOT*/
void r52set_profil(T52* C,T0* a1);
/*SLOT*/
T0* r52get_type(T52* C);
/*SLOT*/
void r52unlink(T52* C,T0* a1);
extern T0*oBC13global_pass;
/*SLOT*/
T0* r52priority(T52* C);
/*SLOT*/
void r52set_value(T52* C,T0* a1,T2 a2);
/*SLOT*/
void r52load_slot(T52* C);
/*SLOT*/
void r52inc_loop_arg(T52* C);
/*SLOT*/
void r52set_priority(T52* C,T0* a1,T2 a2);
/*SLOT*/
T0* r52bucket(void);
/*SLOT*/
void r52sub_depend(T0* a1);
/*SLOT*/
T0* r52gtr(T2 a1);
/*SLOT*/
void r52link(T52* C,T0* a1);
/*SLOT*/
T0* r52get_code(T52* C,T0* a1);
/*ARGUMENT*/
void r106display(T106* C,T0* a1);
/*ARGUMENT*/
T0* r106bucket_type(void);
/*ARGUMENT*/
T6 r106is_equal(T106* C,T0* a1);
/*ARGUMENT*/
T2 r106ensure_count(T106* C);
/*ARGUMENT*/
void r106sub_get_type(T106* C,T0* a1);
/*ARGUMENT*/
T0* r106prototype_list(void);
/*ARGUMENT*/
T6 r106is_self(T106* C);
/*ARGUMENT*/
T6 r106depend(T106* C);
/*ARGUMENT*/
T0* r106gt(T2 a1);
/*ARGUMENT*/
void r106display_ref(T106* C,T0* a1);
/*ARGUMENT*/
T0* r106my_copy(T106* C);
/*ARGUMENT*/
void r106make(T106* C,T0* a1);
/*ARGUMENT*/
void r106remove(T106* C);
/*ARGUMENT*/
T0* r106get_type(T106* C);
/*ARGUMENT*/
T0* r106search_block(T106* C);
/*ARGUMENT*/
void r106genere(T106* C,T0* a1);
/*ARGUMENT*/
void r106check_type(T106* C);
/*ARGUMENT*/
T2 r106static_type(T106* C);
/*ARGUMENT*/
T0* r106execute(T106* C);
/*ARGUMENT*/
void r106check_type_with(T106* C,T0* a1);
/*ARGUMENT*/
T0* r106twin(T106* C);
/*ARGUMENT*/
T0* r106bucket(void);
/*ARGUMENT*/
T2 r106object_id(T106* C);
/*ARGUMENT*/
T0* r106gtr(T2 a1);
/*ARGUMENT*/
void r106make_expr(T106* C,T0* a1);
/*BASE_A_CAST*/
void r201semantic_error(T0* a1,T0* a2);
/*BASE_A_CAST*/
void r201display(T201* C,T0* a1);
/*BASE_A_CAST*/
void r201syntax_error(T0* a1,T0* a2);
/*BASE_A_CAST*/
T0* r201get_receiver(T201* C);
/*BASE_A_CAST*/
T0* r201prototype_list(void);
/*BASE_A_CAST*/
T6 r201depend(T201* C);
/*BASE_A_CAST*/
T0* r201build_case_type(T201* C,T0* a1);
/*BASE_A_CAST*/
T0* r201build_case_type_parent(T201* C,T0* a1);
/*BASE_A_CAST*/
T0* r201gt(T2 a1);
/*BASE_A_CAST*/
void r201display_ref(T201* C,T0* a1);
/*BASE_A_CAST*/
T0* r201get_argument(T201* C);
/*BASE_A_CAST*/
T0* r201my_copy(T201* C);
/*BASE_A_CAST*/
void r201warning_error(T0* a1,T0* a2);
/*BASE_A_CAST*/
T0* r201build_case_body(T201* C,T0* a1);
/*BASE_A_CAST*/
void r201make(T201* C,T0* a1,T0* a2,T0* a3);
/*BASE_A_CAST*/
void r201remove(T201* C);
/*BASE_A_CAST*/
void r201genere(T201* C,T0* a1);
/*BASE_A_CAST*/
T0* r201build_case_type_action(T201* C,T0* a1,T0* a2);
/*BASE_A_CAST*/
T0* r201execute(T201* C);
/*BASE_A_CAST*/
T0* r201twin(T201* C);
/*BASE_A_CAST*/
T0* r201bucket(void);
/*BASE_A_CAST*/
T2 r201object_id(T201* C);
/*BASE_A_CAST*/
T0* r201get_n_argument(T201* C,T2 a1);
/*BASE_A_CAST*/
T0* r201gtr(T2 a1);
/*BASE_A_CAST*/
void r201make_expr(T201* C,T0* a1);
/*ITM_LIST*/
T6 r196is_constant(T196* C);
/*ITM_LIST*/
T0* r196prototype_list(void);
/*ITM_LIST*/
T0* r196gt(T2 a1);
/*ITM_LIST*/
T2 r196value_is_argument(T196* C);
/*ITM_LIST*/
void r196make(T196* C,T2 a1);
/*ITM_LIST*/
T0* r196current_position(T196* C);
/*ITM_LIST*/
void r196runnable_local(T0* a1);
/*ITM_LIST*/
T0* r196run_tools(void);
/*ITM_LIST*/
T0* r196to_run(T196* C,T0* a1,T0* a2,T0* a3);
/*ITM_LIST*/
T0* r196runnable_group(T196* C);
/*ITM_LIST*/
T0* r196get_position(T2 a1);
/*ITM_LIST*/
T0* r196bucket(void);
/*ITM_LIST*/
T2 r196proto_self_current(void);
/*ALIAS_TYPE*/
void r222make(T222* C);
/*ALIAS_TYPE*/
T0* r222get(T222* C,T0* a1);
/*SWITCH_TYPE*/
void r172semantic_error(T0* a1,T0* a2);
/*SWITCH_TYPE*/
void r172display(T172* C,T0* a1);
/*SWITCH_TYPE*/
T0* r172prototype_list(void);
/*SWITCH_TYPE*/
T6 r172depend(T172* C);
/*SWITCH_TYPE*/
T6 r172test_bool(T0* a1);
/*SWITCH_TYPE*/
void r172sub_genere(T172* C,T0* a1,T2 a2);
/*SWITCH_TYPE*/
void r172display_ref(T172* C,T0* a1);
/*SWITCH_TYPE*/
T0* r172my_copy(T172* C);
/*SWITCH_TYPE*/
T2 r172index_of(T172* C,T2 a1);
/*SWITCH_TYPE*/
void r172make(T172* C,T0* a1,T0* a2,T0* a3,T6 a4);
/*SWITCH_TYPE*/
void r172remove(T172* C);
/*SWITCH_TYPE*/
T6 r172is_empty(T172* C);
/*SWITCH_TYPE*/
T0* r172detect_patern(T172* C);
/*SWITCH_TYPE*/
void r172genere(T172* C,T0* a1);
/*SWITCH_TYPE*/
T0* r172execute(T172* C);
/*SWITCH_TYPE*/
void r172depend_generic(T172* C);
/*SWITCH_TYPE*/
void r172ask_idf_slot(T172* C,T2 a1);
/*SWITCH_TYPE*/
T0* r172twin(T172* C);
/*SWITCH_TYPE*/
T0* r172bucket(void);
/*SWITCH_TYPE*/
T2 r172object_id(T172* C);
extern T0*oBC13idf_proto;
extern int fBC13idf_proto;
/*SWITCH_TYPE*/
T0* r172idf_proto(void);
/*SWITCH_TYPE*/
T0* r172gtr(T2 a1);
/*SWITCH_TYPE*/
void r172make_expr(T172* C,T0* a1);
/*ALIAS_STRING*/
T0* r63get_tmp_idf(T63* C);
/*ALIAS_STRING*/
T6 r63is_integer(T0* a1);
/*ALIAS_STRING*/
void r63make(T63* C);
/*ALIAS_STRING*/
T6 r63is_section(T0* a1);
/*ALIAS_STRING*/
T0* r63operator_to_name(T0* a1,T0* a2);
/*ALIAS_STRING*/
T0* r63get(T63* C,T0* a1);
/*ALIAS_STRING*/
T0* r63get_intern(T63* C,T0* a1);
/*ALIAS_STRING*/
T0* r63bucket(void);
/*A_GLOBAL*/
void r163display(T163* C,T0* a1);
/*A_GLOBAL*/
T0* r163bucket_type(void);
/*A_GLOBAL*/
T6 r163is_equal(T163* C,T0* a1);
/*A_GLOBAL*/
T2 r163ensure_count(T163* C);
/*A_GLOBAL*/
void r163sub_get_type(T163* C,T0* a1);
/*A_GLOBAL*/
T0* r163prototype_list(void);
/*A_GLOBAL*/
T6 r163is_self(T163* C);
/*A_GLOBAL*/
T6 r163depend(T163* C);
/*A_GLOBAL*/
T0* r163gt(T2 a1);
/*A_GLOBAL*/
void r163display_ref(T163* C,T0* a1);
/*A_GLOBAL*/
void r163set_variable(T163* C,T0* a1);
/*A_GLOBAL*/
T0* r163my_copy(T163* C);
/*A_GLOBAL*/
void r163make(T163* C,T0* a1,T0* a2,T0* a3);
/*A_GLOBAL*/
void r163remove(T163* C);
/*A_GLOBAL*/
T0* r163get_type(T163* C);
/*A_GLOBAL*/
T0* r163search_block(T163* C);
/*A_GLOBAL*/
void r163genere(T163* C,T0* a1);
/*A_GLOBAL*/
void r163check_type(T163* C);
/*A_GLOBAL*/
T0* r163execute(T163* C);
/*A_GLOBAL*/
void r163depend_generic(T163* C);
/*A_GLOBAL*/
T0* r163twin(T163* C);
/*A_GLOBAL*/
T0* r163bucket(void);
/*A_GLOBAL*/
T2 r163object_id(T163* C);
/*A_GLOBAL*/
T2 r163proto_self_current(void);
/*A_GLOBAL*/
T0* r163gtr(T2 a1);
/*A_GLOBAL*/
void r163make_expr(T163* C,T0* a1);
/*ITM_STRING*/
T6 r187is_constant(T187* C);
/*ITM_STRING*/
void r187make(T187* C,T2 a1,T0* a2,T2 a3);
/*ITM_STRING*/
T0* r187current_position(T187* C);
/*ITM_STRING*/
T0* r187run_tools(void);
/*ITM_STRING*/
T0* r187to_run(T187* C,T0* a1,T0* a2,T0* a3);
/*ITM_STRING*/
T0* r187runnable(T187* C);
/*ITM_STRING*/
T0* r187get_position(T2 a1);
/*ITM_STRING*/
T0* r187bucket(void);
/*ITM_WRITE_CAST*/
T6 r194is_constant(T194* C);
/*ITM_WRITE_CAST*/
void r194syntax_error(T0* a1,T0* a2);
/*ITM_WRITE_CAST*/
void r194make(T194* C,T2 a1,T0* a2,T0* a3);
/*ITM_WRITE_CAST*/
T0* r194current_position(T194* C);
/*ITM_WRITE_CAST*/
T0* r194run_tools(void);
/*ITM_WRITE_CAST*/
T0* r194to_run(T194* C,T0* a1,T0* a2,T0* a3);
/*ITM_WRITE_CAST*/
T0* r194runnable(T194* C);
/*ITM_WRITE_CAST*/
T0* r194get_position(T2 a1);
/*STD_INPUT*/
void r70read_character(T70* C);
/*STD_INPUT*/
void r70fill_buffer(T70* C);
/*STD_INPUT*/
void r70make(T70* C);
extern T0*oBC15std_output;
/*INTEGER_CST*/
void r159display(T159* C,T0* a1);
/*INTEGER_CST*/
T0* r159bucket_type(void);
/*INTEGER_CST*/
T0* r159prototype_list(void);
extern T0*oBC13min_longint;
extern int fBC13min_longint;
/*INTEGER_CST*/
T0* r159min_longint(void);
/*INTEGER_CST*/
T6 r159depend(T159* C);
/*INTEGER_CST*/
T0* r159gt(T2 a1);
/*INTEGER_CST*/
void r159display_ref(T159* C,T0* a1);
extern T0*oBC13max_longint;
extern int fBC13max_longint;
/*INTEGER_CST*/
T0* r159max_longint(void);
/*INTEGER_CST*/
T0* r159my_copy(T159* C);
extern T0*oBC13max_uinteger;
extern int fBC13max_uinteger;
/*INTEGER_CST*/
T0* r159max_uinteger(void);
/*INTEGER_CST*/
void r159warning_error(T0* a1,T0* a2);
/*INTEGER_CST*/
T6 r159is_fusion(T159* C,T0* a1);
/*INTEGER_CST*/
void r159make(T159* C,T0* a1,T0* a2,T2 a3);
/*INTEGER_CST*/
T0* r159get_type(T159* C);
/*INTEGER_CST*/
T0* r159search_block(T159* C);
/*INTEGER_CST*/
void r159genere(T159* C,T0* a1);
/*INTEGER_CST*/
void r159check_type(T159* C);
/*INTEGER_CST*/
void r159cast_type(T159* C,T2 a1);
/*INTEGER_CST*/
T0* r159execute(T159* C);
/*INTEGER_CST*/
void r159depend_generic(T159* C);
extern T0*oBC13min_integer;
extern int fBC13min_integer;
/*INTEGER_CST*/
T0* r159min_integer(void);
/*INTEGER_CST*/
T0* r159twin(T159* C);
extern T0*oBC13max_integer;
extern int fBC13max_integer;
/*INTEGER_CST*/
T0* r159max_integer(void);
/*INTEGER_CST*/
T2 r159object_id(T159* C);
extern T0*oBC13max_ulongint;
extern int fBC13max_ulongint;
/*INTEGER_CST*/
T0* r159max_ulongint(void);
/*INTEGER_CST*/
void r159make_expr(T159* C,T0* a1);
/*BINARY*/
void r204semantic_error(T0* a1,T0* a2);
/*BINARY*/
void r204display(T204* C,T0* a1);
/*BINARY*/
T0* r204bucket_type(void);
/*BINARY*/
T0* r204prototype_list(void);
/*BINARY*/
void r204sub_get_type(T204* C,T0* a1);
/*BINARY*/
T6 r204depend(T204* C);
/*BINARY*/
T0* r204gt(T2 a1);
/*BINARY*/
void r204display_ref(T204* C,T0* a1);
/*BINARY*/
T0* r204my_copy(T204* C);
/*BINARY*/
void r204warning_error(T0* a1,T0* a2);
/*BINARY*/
void r204make(T204* C,T0* a1,T0* a2,T0* a3);
/*BINARY*/
void r204remove(T204* C);
/*BINARY*/
T0* r204get_type(T204* C);
/*BINARY*/
T0* r204search_block(T204* C);
/*BINARY*/
void r204genere(T204* C,T0* a1);
/*BINARY*/
T2 r204static_type(T204* C);
/*BINARY*/
T0* r204execute(T204* C);
/*BINARY*/
void r204depend_generic(T204* C);
/*BINARY*/
T0* r204twin(T204* C);
/*BINARY*/
T0* r204bucket(void);
/*BINARY*/
T2 r204object_id(T204* C);
/*BINARY*/
T0* r204gtr(T2 a1);
/*BINARY*/
void r204make_expr(T204* C,T0* a1);
/*ITM_CHARACTER*/
T6 r186is_constant(T186* C);
/*ITM_CHARACTER*/
void r186make(T186* C,T2 a1,T0* a2);
/*ITM_CHARACTER*/
T0* r186current_position(T186* C);
/*ITM_CHARACTER*/
T0* r186run_tools(void);
/*ITM_CHARACTER*/
T0* r186to_run(T186* C,T0* a1,T0* a2,T0* a3);
/*ITM_CHARACTER*/
T0* r186runnable(T186* C);
/*ITM_CHARACTER*/
T0* r186get_position(T2 a1);
/*EXTERNAL_C*/
void r176semantic_error(T0* a1,T0* a2);
/*EXTERNAL_C*/
void r176display(T176* C,T0* a1);
/*EXTERNAL_C*/
T0* r176bucket_type(void);
/*EXTERNAL_C*/
void r176syntax_error(T0* a1,T0* a2);
/*EXTERNAL_C*/
T0* r176prototype_list(void);
/*EXTERNAL_C*/
void r176sub_get_type(T176* C,T0* a1);
/*EXTERNAL_C*/
T6 r176depend(T176* C);
/*EXTERNAL_C*/
void r176display_ref(T176* C,T0* a1);
/*EXTERNAL_C*/
T0* r176my_copy(T176* C);
/*EXTERNAL_C*/
void r176make(T176* C,T0* a1,T0* a2,T6 a3,T2 a4);
/*EXTERNAL_C*/
void r176remove(T176* C);
/*EXTERNAL_C*/
T0* r176get_type(T176* C);
/*EXTERNAL_C*/
T0* r176search_block(T176* C);
/*EXTERNAL_C*/
void r176genere(T176* C,T0* a1);
/*EXTERNAL_C*/
T0* r176execute(T176* C);
/*EXTERNAL_C*/
void r176depend_generic(T176* C);
/*EXTERNAL_C*/
T0* r176twin(T176* C);
/*EXTERNAL_C*/
T0* r176bucket(void);
/*EXTERNAL_C*/
T2 r176object_id(T176* C);
/*EXTERNAL_C*/
T0* r176gtr(T2 a1);
/*EXTERNAL_C*/
void r176make_expr(T176* C,T0* a1);
/*ITM_WRITE_CODE*/
void r195semantic_error(T0* a1,T0* a2);
/*ITM_WRITE_CODE*/
T6 r195is_constant(T195* C);
/*ITM_WRITE_CODE*/
void r195make(T195* C,T2 a1,T0* a2,T0* a3);
/*ITM_WRITE_CODE*/
T0* r195current_position(T195* C);
/*ITM_WRITE_CODE*/
T0* r195run_tools(void);
/*ITM_WRITE_CODE*/
T0* r195to_run(T195* C,T0* a1,T0* a2,T0* a3);
/*ITM_WRITE_CODE*/
T0* r195runnable(T195* C);
/*ITM_WRITE_CODE*/
T0* r195get_position(T2 a1);
/*PROTOTYPE_CST*/
void r114display(T114* C,T0* a1);
/*PROTOTYPE_CST*/
T0* r114bucket_type(void);
/*PROTOTYPE_CST*/
T0* r114prototype_list(void);
/*PROTOTYPE_CST*/
T6 r114depend(T114* C);
/*PROTOTYPE_CST*/
T0* r114gt(T2 a1);
/*PROTOTYPE_CST*/
void r114display_ref(T114* C,T0* a1);
/*PROTOTYPE_CST*/
T0* r114my_copy(T114* C);
/*PROTOTYPE_CST*/
T6 r114is_fusion(T114* C,T0* a1);
/*PROTOTYPE_CST*/
void r114make(T114* C,T0* a1,T2 a2);
/*PROTOTYPE_CST*/
T0* r114get_type(T114* C);
/*PROTOTYPE_CST*/
T0* r114search_block(T114* C);
/*PROTOTYPE_CST*/
void r114genere(T114* C,T0* a1);
/*PROTOTYPE_CST*/
T0* r114execute(T114* C);
/*PROTOTYPE_CST*/
void r114depend_generic(T114* C);
/*PROTOTYPE_CST*/
T0* r114twin(T114* C);
/*PROTOTYPE_CST*/
T2 r114object_id(T114* C);
/*PROTOTYPE_CST*/
T2 r114proto_self_current(void);
/*PROTOTYPE_CST*/
T0* r114gtr(T2 a1);
/*PROTOTYPE_CST*/
void r114make_expr(T114* C,T0* a1);
/*A_LOCAL*/
void r131display(T131* C,T0* a1);
/*A_LOCAL*/
T0* r131bucket_type(void);
/*A_LOCAL*/
T6 r131is_equal(T131* C,T0* a1);
/*A_LOCAL*/
T2 r131ensure_count(T131* C);
/*A_LOCAL*/
void r131depend_hot(T131* C);
/*A_LOCAL*/
void r131sub_get_type(T131* C,T0* a1);
/*A_LOCAL*/
T0* r131prototype_list(void);
/*A_LOCAL*/
T6 r131is_self(T131* C);
/*A_LOCAL*/
T6 r131depend(T131* C);
/*A_LOCAL*/
T0* r131gt(T2 a1);
/*A_LOCAL*/
void r131display_ref(T131* C,T0* a1);
/*A_LOCAL*/
T0* r131my_copy(T131* C);
/*A_LOCAL*/
void r131make(T131* C,T0* a1,T0* a2,T0* a3);
/*A_LOCAL*/
void r131remove(T131* C);
/*A_LOCAL*/
T0* r131get_type(T131* C);
/*A_LOCAL*/
T0* r131search_block(T131* C);
/*A_LOCAL*/
void r131genere(T131* C,T0* a1);
/*A_LOCAL*/
void r131check_type(T131* C);
/*A_LOCAL*/
T2 r131static_type(T131* C);
/*A_LOCAL*/
T0* r131execute(T131* C);
/*A_LOCAL*/
void r131depend_generic(T131* C);
/*A_LOCAL*/
T0* r131twin(T131* C);
/*A_LOCAL*/
T0* r131bucket(void);
/*A_LOCAL*/
T2 r131object_id(T131* C);
/*A_LOCAL*/
T0* r131gtr(T2 a1);
/*A_LOCAL*/
void r131make_expr(T131* C,T0* a1);
/*ITM_NUMBER*/
T6 r185is_constant(T185* C);
/*ITM_NUMBER*/
void r185make(T185* C,T2 a1,T0* a2);
/*ITM_NUMBER*/
T0* r185current_position(T185* C);
/*ITM_NUMBER*/
T0* r185run_tools(void);
/*ITM_NUMBER*/
T0* r185to_run(T185* C,T0* a1,T0* a2,T0* a3);
/*ITM_NUMBER*/
T0* r185runnable(T185* C);
/*ITM_NUMBER*/
T0* r185get_position(T2 a1);
/*BASE_SEND*/
void r129semantic_error(T0* a1,T0* a2);
/*BASE_SEND*/
void r129make_base(T129* C,T0* a1,T0* a2,T0* a3);
/*BASE_SEND*/
void r129display(T129* C,T0* a1);
/*BASE_SEND*/
void r129syntax_error(T0* a1,T0* a2);
/*BASE_SEND*/
T0* r129get_receiver(T129* C);
/*BASE_SEND*/
T0* r129prototype_list(void);
/*BASE_SEND*/
T6 r129depend(T129* C);
/*BASE_SEND*/
T0* r129build_case_type(T129* C,T0* a1);
/*BASE_SEND*/
T0* r129build_case_type_parent(T129* C,T0* a1);
/*BASE_SEND*/
T0* r129gt(T2 a1);
/*BASE_SEND*/
void r129display_ref(T129* C,T0* a1);
/*BASE_SEND*/
T0* r129value_expr(T129* C);
/*BASE_SEND*/
T0* r129get_argument(T129* C);
/*BASE_SEND*/
T0* r129my_copy(T129* C);
/*BASE_SEND*/
void r129warning_error(T0* a1,T0* a2);
/*BASE_SEND*/
T0* r129build_case_body(T129* C,T0* a1);
/*BASE_SEND*/
void r129make(T129* C,T0* a1,T0* a2,T0* a3,T0* a4);
/*BASE_SEND*/
void r129check_argument(T129* C,T0* a1,T2 a2);
/*BASE_SEND*/
void r129remove(T129* C);
/*BASE_SEND*/
void r129genere(T129* C,T0* a1);
/*BASE_SEND*/
T0* r129build_case_type_action(T129* C,T0* a1,T0* a2);
/*BASE_SEND*/
T0* r129execute(T129* C);
/*BASE_SEND*/
T0* r129value_profil(T129* C);
/*BASE_SEND*/
void r129depend_generic(T129* C);
/*BASE_SEND*/
T6 r129depend_base(T129* C,T2 a1);
/*BASE_SEND*/
T0* r129twin(T129* C);
/*BASE_SEND*/
T0* r129bucket(void);
/*BASE_SEND*/
T2 r129object_id(T129* C);
/*BASE_SEND*/
T2 r129proto_self_current(void);
/*BASE_SEND*/
T0* r129get_n_argument(T129* C,T2 a1);
/*BASE_SEND*/
T0* r129gtr(T2 a1);
/*BASE_SEND*/
void r129make_expr(T129* C,T0* a1);
/*PARSER*/
void r182read_group(T182* C);
/*PARSER*/
void r182semantic_error(T0* a1,T0* a2);
/*PARSER*/
T0* r182read_send_msg(T182* C,T0* a1);
/*PARSER*/
T0* r182to_binary(T0* a1);
/*PARSER*/
void r182read_escape_character(T182* C);
/*PARSER*/
void r182syntax_error(T0* a1,T0* a2);
/*PARSER*/
T6 r182read_integer(T182* C);
/*PARSER*/
T6 r182read_local(T182* C,T6 a1,T0* a2,T3 a3);
/*PARSER*/
T3 r182read_style(T182* C);
/*PARSER*/
T6 r182name_ok(T182* C);
/*PARSER*/
T0* r182read_argument(T182* C);
/*PARSER*/
T0* r182read_expr(T182* C);
/*PARSER*/
void r182go_on(T182* C,T0* a1);
/*PARSER*/
T6 r182read_characters(T182* C);
/*PARSER*/
T0* r182prototype_list(void);
/*PARSER*/
T6 r182read_program(T182* C);
/*PARSER*/
T6 r182read_space(T182* C);
/*PARSER*/
T0* r182to_octal(T0* a1);
/*PARSER*/
T6 r182read_slot_header(T182* C,T3 a1);
/*PARSER*/
T0* r182gt(T2 a1);
/*PARSER*/
T2 r182found_generic_type(T182* C,T0* a1);
/*PARSER*/
T0* r182read_expr_message(T182* C);
/*PARSER*/
T6 r182is_octal(T0* a1);
/*PARSER*/
void r182warning_error(T0* a1,T0* a2);
/*PARSER*/
T0* r182read_instr(T182* C);
/*PARSER*/
T6 r182read_cap_identifier(T182* C);
/*PARSER*/
T0* r182read_expr_primaire(T182* C);
/*PARSER*/
T0* r182current_position(T182* C);
/*PARSER*/
void r182read_type_slot(T182* C,T0* a1);
extern T0*oBC13output_external;
/*PARSER*/
T0* r182operator_to_name(T0* a1,T0* a2);
/*PARSER*/
T6 r182read_external(T182* C);
/*PARSER*/
T0* r182to_hexadecimal(T0* a1);
/*PARSER*/
T6 r182read_identifier(T182* C);
/*PARSER*/
T6 r182read_string(T182* C);
/*PARSER*/
T3 r182last_character(T182* C);
/*PARSER*/
T6 r182read_slot(T182* C);
/*PARSER*/
T0* r182read_expr_base(T182* C);
/*PARSER*/
T6 r182read_l_argument(T182* C,T0* a1);
/*PARSER*/
T6 r182read_symbol(T182* C,T0* a1);
/*PARSER*/
T6 r182read_keyword(T182* C,T0* a1);
/*PARSER*/
T0* r182read_expr_prefix(T182* C);
extern T0*oBC13prototype_dico;
/*PARSER*/
T0* r182bucket(void);
/*PARSER*/
T0* r182read_symbol_affect(T182* C);
/*PARSER*/
T6 r182read_operator(T182* C);
/*PARSER*/
T2 r182read_type(T182* C);
/*PARSER*/
T0* r182read_list_method(T182* C,T0* a1);
/*EXTERNAL_LISAAC*/
void r198semantic_error(T0* a1,T0* a2);
/*EXTERNAL_LISAAC*/
void r198arithmetic_genere(T198* C,T0* a1);
/*EXTERNAL_LISAAC*/
void r198display(T198* C,T0* a1);
/*EXTERNAL_LISAAC*/
T0* r198bucket_type(void);
/*EXTERNAL_LISAAC*/
T0* r198arithmetic_execute(T198* C);
/*EXTERNAL_LISAAC*/
void r198syntax_error(T0* a1,T0* a2);
/*EXTERNAL_LISAAC*/
void r198sub_get_type(T198* C,T0* a1);
/*EXTERNAL_LISAAC*/
T0* r198prototype_list(void);
/*EXTERNAL_LISAAC*/
T0* r198min_longint(void);
/*EXTERNAL_LISAAC*/
T6 r198depend(T198* C);
/*EXTERNAL_LISAAC*/
T0* r198gt(T2 a1);
/*EXTERNAL_LISAAC*/
T0* r198clone(T0* a1);
/*EXTERNAL_LISAAC*/
void r198display_ref(T198* C,T0* a1);
/*EXTERNAL_LISAAC*/
T0* r198max_uinteger(void);
/*EXTERNAL_LISAAC*/
T0* r198my_copy(T198* C);
/*EXTERNAL_LISAAC*/
T6 r198is_copy(T198* C);
/*EXTERNAL_LISAAC*/
T0* r198convert(T198* C,T0* a1);
/*EXTERNAL_LISAAC*/
void r198make(T198* C,T0* a1,T2 a2);
extern T0*oBC13slot_command_argument;
/*EXTERNAL_LISAAC*/
void r198remove(T198* C);
/*EXTERNAL_LISAAC*/
void r198set_left_right(T198* C,T0* a1,T0* a2);
/*EXTERNAL_LISAAC*/
T0* r198get_type(T198* C);
/*EXTERNAL_LISAAC*/
T0* r198search_block(T198* C);
/*EXTERNAL_LISAAC*/
void r198genere(T198* C,T0* a1);
/*EXTERNAL_LISAAC*/
T0* r198boolean_execute(T198* C);
/*EXTERNAL_LISAAC*/
T0* r198execute(T198* C);
/*EXTERNAL_LISAAC*/
T6 r198is_puissance(T198* C,T0* a1);
/*EXTERNAL_LISAAC*/
void r198depend_generic(T198* C);
/*EXTERNAL_LISAAC*/
T0* r198min_integer(void);
/*EXTERNAL_LISAAC*/
T0* r198twin(T198* C);
/*EXTERNAL_LISAAC*/
T0* r198bucket(void);
/*EXTERNAL_LISAAC*/
T2 r198object_id(T198* C);
/*EXTERNAL_LISAAC*/
T0* r198max_ulongint(void);
/*EXTERNAL_LISAAC*/
T2 r198proto_self_current(void);
/*EXTERNAL_LISAAC*/
T0* r198gtr(T2 a1);
/*EXTERNAL_LISAAC*/
void r198make_expr(T198* C,T0* a1);
/*SMALL_INTEGER*/
T0* r165integer_divide_small_integer(T165* C,T0* a1);
/*SMALL_INTEGER*/
T0* r165_ix_649292(T165* C,T2 a1);
/*SMALL_INTEGER*/
T0* r165remainder_of_divide_large_positive_integer(T165* C,T0* a1);
/*SMALL_INTEGER*/
T0* r165_ix_4747(T165* C,T0* a1);
/*SMALL_INTEGER*/
T0* r165_ix_6494(T165* C,T2 a1);
/*SMALL_INTEGER*/
T6 r165is_abstract_integer(T165* C);
/*SMALL_INTEGER*/
T0* r165add_with_small_fraction(T165* C,T0* a1);
/*SMALL_INTEGER*/
T0* r165multiply_with_small_fraction(T165* C,T0* a1);
/*SMALL_INTEGER*/
T0* r165factorial(T165* C);
/*SMALL_INTEGER*/
T6 r165greater_with_small_fraction(T165* C,T0* a1);
/*SMALL_INTEGER*/
T2 r165sign(T165* C);
/*SMALL_INTEGER*/
T0* r165_ix_644747(T165* C,T2 a1);
/*SMALL_INTEGER*/
T0* r165multiply_with_large_negative_integer(T165* C,T0* a1);
/*SMALL_INTEGER*/
T0* r165to_string(T165* C);
/*SMALL_INTEGER*/
T6 r165greater_with_large_positive_integer(T0* a1);
/*SMALL_INTEGER*/
T0* r165add_with_large_negative_integer(T165* C,T0* a1);
/*SMALL_INTEGER*/
T6 r165greater_with_large_fraction(T165* C,T0* a1);
/*SMALL_INTEGER*/
T6 r165is_small_integer(T165* C);
/*SMALL_INTEGER*/
T0* r165gcd(T165* C,T0* a1);
/*SMALL_INTEGER*/
T6 r165_ix_6061(T165* C,T0* a1);
/*SMALL_INTEGER*/
T6 r165odd(T165* C);
/*SMALL_INTEGER*/
T0* r165multiply_with_large_fraction(T165* C,T0* a1);
/*SMALL_INTEGER*/
T0* r165inverse(T165* C);
/*SMALL_INTEGER*/
T0* r165_px_45(T165* C);
/*SMALL_INTEGER*/
T0* r165integer_divide_large_positive_integer(T165* C,T0* a1);
extern T5 oBC164Log_base;
extern int fBC164Log_base;
/*SMALL_INTEGER*/
T5 r165Log_base(void);
/*SMALL_INTEGER*/
T0* r165remainder_of_divide_large_negative_integer(T165* C,T0* a1);
/*SMALL_INTEGER*/
T0* r165add_with_large_fraction(T165* C,T0* a1);
extern T0*oBC164zero;
extern int fBC164zero;
/*SMALL_INTEGER*/
T0* r165zero(void);
/*SMALL_INTEGER*/
T0* r165abs(T165* C);
/*SMALL_INTEGER*/
T6 r165_ix_6261(T165* C,T0* a1);
/*SMALL_INTEGER*/
T0* r165add_with_large_positive_integer(T165* C,T0* a1);
/*SMALL_INTEGER*/
T2 r165compare(T165* C,T0* a1);
/*SMALL_INTEGER*/
T0* r165_ix_9292(T165* C,T0* a1);
/*SMALL_INTEGER*/
T0* r165multiply_with_large_positive_integer(T165* C,T0* a1);
extern T2 oBC164Base;
extern int fBC164Base;
/*SMALL_INTEGER*/
T2 r165Base(void);
/*SMALL_INTEGER*/
T0* r165_ix_42(T165* C,T0* a1);
/*SMALL_INTEGER*/
T0* r165integer_divide_large_negative_integer(T165* C,T0* a1);
/*SMALL_INTEGER*/
T0* r165_ix_43(T165* C,T0* a1);
/*SMALL_INTEGER*/
T0* r165_ix_45(T165* C,T0* a1);
/*SMALL_INTEGER*/
T0* r165_ix_47(T165* C,T0* a1);
/*SMALL_INTEGER*/
T6 r165_ix_60(T165* C,T0* a1);
/*SMALL_INTEGER*/
T2 r165nb_c(T2 a1);
/*SMALL_INTEGER*/
T6 r165_ix_62(T165* C,T0* a1);
/*SMALL_INTEGER*/
T0* r165_ix_6442(T165* C,T2 a1);
/*SMALL_INTEGER*/
T0* r165_ix_6443(T165* C,T2 a1);
/*SMALL_INTEGER*/
T0* r165_ix_6445(T165* C,T2 a1);
/*SMALL_INTEGER*/
T0* r165remainder_of_divide_small_integer(T165* C,T0* a1);
/*TEXT_FILE_READ*/
void r105disconnect(T105* C);
/*TEXT_FILE_READ*/
void r105read_character(T105* C);
/*TEXT_FILE_READ*/
void r105fill_buffer(T105* C);
/*TEXT_FILE_READ*/
void r105read_line_in(T105* C,T0* a1);
/*TEXT_FILE_READ*/
void r105connect_to(T105* C,T0* a1);
/*PROTOTYPE_RUN*/
void r25semantic_error(T0* a1,T0* a2);
extern T0*oBC13string_tmp3;
extern T0*oBC13string_tmp4;
/*PROTOTYPE_RUN*/
void r25genere_c_name(T25* C);
/*PROTOTYPE_RUN*/
void r25check_cycle(T25* C);
extern T0*oBC13check_life;
extern int fBC13check_life;
/*PROTOTYPE_RUN*/
T0* r25check_life(void);
extern T0*oBC13output_main;
/*PROTOTYPE_RUN*/
void r25reset_pass(T25* C);
/*PROTOTYPE_RUN*/
T0* r25prototype_list(void);
/*PROTOTYPE_RUN*/
T0* r25get_slot_full(T25* C,T0* a1);
/*PROTOTYPE_RUN*/
void r25depend(T25* C);
/*PROTOTYPE_RUN*/
T0* r25get_slot(T25* C,T0* a1);
extern T0*oBC25list_check;
extern int fBC25list_check;
/*PROTOTYPE_RUN*/
T0* r25list_check(void);
extern T0*oBC13output_stat;
/*PROTOTYPE_RUN*/
void r25make(T25* C,T0* a1,T0* a2);
/*PROTOTYPE_RUN*/
T6 r25is_sub_type(T25* C,T2 a1);
/*PROTOTYPE_RUN*/
void r25set_type_collector(T25* C,T0* a1);
/*PROTOTYPE_RUN*/
T0* r25creation_main(T25* C,T0* a1);
extern T0*oBC13parser;
extern int fBC13parser;
/*PROTOTYPE_RUN*/
T0* r25parser(void);
/*PROTOTYPE_RUN*/
void r25genere(T25* C);
extern T0*oBC13output_buffer;
extern T0*oBC13output_global;
/*PROTOTYPE_RUN*/
T6 r25is_data_exist(T25* C);
/*PROTOTYPE_RUN*/
void r25parse(T25* C);
extern T0*oBC13execute_count;
/*PROTOTYPE_RUN*/
T0* r25bucket(void);
/*PROTOTYPE_RUN*/
T2 r25sub_check_cycle(T25* C);
/*PROTOTYPE_RUN*/
T0* r25gtr(T2 a1);
/*PROTOTYPE_RUN*/
T0* r25idf_proto(void);
extern T0*oBC13output_type;
/*PROTOTYPE_RUN*/
T0* r25new_position(T25* C,T2 a1);
/*VOID_*/
void r98semantic_error(T0* a1,T0* a2);
/*VOID_*/
void r98genere_c_name(T98* C);
/*VOID_*/
void r98check_cycle(T98* C);
/*VOID_*/
T0* r98check_life(void);
/*VOID_*/
void r98reset_pass(T98* C);
/*VOID_*/
T0* r98prototype_list(void);
/*VOID_*/
T0* r98get_slot_full(T98* C,T0* a1);
/*VOID_*/
void r98depend(T98* C);
/*VOID_*/
T0* r98get_slot(T98* C,T0* a1);
/*VOID_*/
T0* r98list_check(void);
/*VOID_*/
void r98make(T98* C,T0* a1,T0* a2);
/*VOID_*/
T6 r98is_sub_type(T98* C,T2 a1);
/*VOID_*/
void r98set_type_collector(T98* C,T0* a1);
/*VOID_*/
T0* r98creation_main(T98* C,T0* a1);
/*VOID_*/
T0* r98parser(void);
/*VOID_*/
void r98make_void(T98* C);
/*VOID_*/
void r98genere(T98* C);
/*VOID_*/
T6 r98is_data_exist(T98* C);
/*VOID_*/
void r98parse(T98* C);
/*VOID_*/
T0* r98bucket(void);
/*VOID_*/
T2 r98sub_check_cycle(T98* C);
/*VOID_*/
T0* r98idf_proto(void);
/*VOID_*/
T0* r98gtr(T2 a1);
/*A_SLOT*/
void r171message_error(T0* a1,T0* a2);
/*A_SLOT*/
void r171display(T171* C,T0* a1);
/*A_SLOT*/
T0* r171bucket_type(void);
/*A_SLOT*/
T6 r171fast_match_base(T0* a1,T0* a2);
/*A_SLOT*/
T6 r171is_equal(T171* C,T0* a1);
/*A_SLOT*/
T2 r171ensure_count(T171* C);
/*A_SLOT*/
void r171sub_get_type(T171* C,T0* a1);
/*A_SLOT*/
T0* r171prototype_list(void);
/*A_SLOT*/
T6 r171is_self(T171* C);
/*A_SLOT*/
T6 r171depend(T171* C);
/*A_SLOT*/
T0* r171gt(T2 a1);
/*A_SLOT*/
void r171display_ref(T171* C,T0* a1);
/*A_SLOT*/
void r171set_variable(T171* C,T0* a1);
/*A_SLOT*/
T0* r171my_copy(T171* C);
/*A_SLOT*/
void r171make(T171* C,T0* a1,T0* a2,T0* a3,T0* a4);
/*A_SLOT*/
void r171remove(T171* C);
/*A_SLOT*/
T0* r171get_type(T171* C);
/*A_SLOT*/
T0* r171search_block(T171* C);
/*A_SLOT*/
void r171genere(T171* C,T0* a1);
/*A_SLOT*/
void r171check_type(T171* C);
/*A_SLOT*/
T6 r171match_base(T171* C,T0* a1,T0* a2);
/*A_SLOT*/
T0* r171execute(T171* C);
/*A_SLOT*/
void r171depend_generic(T171* C);
/*A_SLOT*/
T0* r171twin(T171* C);
/*A_SLOT*/
T0* r171bucket(void);
/*A_SLOT*/
T2 r171object_id(T171* C);
/*A_SLOT*/
T2 r171proto_self_current(void);
/*A_SLOT*/
T0* r171gtr(T2 a1);
/*A_SLOT*/
void r171make_expr(T171* C,T0* a1);
/*LIST*/
void r108display(T108* C,T0* a1);
/*LIST*/
T0* r108bucket_type(void);
/*LIST*/
void r108genere_profile(T108* C,T0* a1);
/*LIST*/
void r108inc_nb_pass(T108* C);
/*LIST*/
T0* r108get_temporary(T108* C,T0* a1);
/*LIST*/
void r108sub_get_type(T108* C,T0* a1);
/*LIST*/
T0* r108prototype_list(void);
/*LIST*/
T6 r108depend(T108* C);
/*LIST*/
T0* r108gt(T2 a1);
/*LIST*/
T0* r108search_in(T0* a1,T0* a2);
/*LIST*/
void r108display_ref(T108* C,T0* a1);
/*LIST*/
T0* r108my_copy(T108* C);
/*LIST*/
void r108add_local(T108* C,T0* a1);
/*LIST*/
T0* r108execute_with_msg(T108* C,T0* a1);
/*LIST*/
T6 r108depend_with_argument(T108* C,T0* a1,T0* a2);
/*LIST*/
void r108make(T108* C,T0* a1,T0* a2);
extern T0*oBC13output_profile;
/*LIST*/
void r108remove(T108* C);
/*LIST*/
T6 r108is_empty(T108* C);
/*LIST*/
void r108crash(T108* C);
/*LIST*/
void r108copy_expr_in(T108* C,T0* a1);
/*LIST*/
T0* r108lookup(T108* C,T0* a1);
/*LIST*/
void r108copy_local(T108* C,T0* a1);
/*LIST*/
T0* r108get_type(T108* C);
/*LIST*/
T0* r108search_block(T108* C);
/*LIST*/
void r108genere(T108* C,T0* a1);
/*LIST*/
T2 r108static_type(T108* C);
/*LIST*/
void r108copy_argument(T108* C,T0* a1);
extern T0*oBC108dico_local;
/*LIST*/
T0* r108execute(T108* C);
/*LIST*/
void r108depend_generic(T108* C);
/*LIST*/
void r108add_local_list(T108* C,T0* a1);
/*LIST*/
T0* r108twin(T108* C);
/*LIST*/
T0* r108bucket(void);
/*LIST*/
T2 r108object_id(T108* C);
/*LIST*/
T0* r108gtr(T2 a1);
/*LIST*/
void r108debug_display_expr(T108* C);
/*LIST*/
void r108make_expr(T108* C,T0* a1);
/*CASE_BODY*/
void r151display(T151* C,T0* a1);
/*CASE_BODY*/
T6 r151depend(T151* C);
/*CASE_BODY*/
void r151display_ref(T151* C,T0* a1);
/*CASE_BODY*/
T0* r151my_copy(T151* C);
/*CASE_BODY*/
void r151make(T151* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T2 a6);
/*CASE_BODY*/
void r151genere(T151* C,T0* a1);
/*CASE_BODY*/
T0* r151execute(T151* C);
/*CASE_BODY*/
void r151depend_generic(T151* C);
/*CASE_BODY*/
T0* r151twin(T151* C);
/*CASE_BODY*/
T2 r151object_id(T151* C);
/*CASE_BODY*/
void r151make_expr(T151* C,T0* a1);
/*DATA_STAR_SLOT*/
void r213semantic_error(T0* a1,T0* a2);
/*DATA_STAR_SLOT*/
void r213display(T213* C,T0* a1);
/*DATA_STAR_SLOT*/
T0* r213bucket_type(void);
/*DATA_STAR_SLOT*/
T0* r213prototype_list(void);
/*DATA_STAR_SLOT*/
T6 r213depend(T213* C);
/*DATA_STAR_SLOT*/
T0* r213gt(T2 a1);
/*DATA_STAR_SLOT*/
void r213display_ref(T213* C,T0* a1);
/*DATA_STAR_SLOT*/
void r213set_variable(T213* C,T0* a1);
/*DATA_STAR_SLOT*/
T0* r213my_copy(T213* C);
/*DATA_STAR_SLOT*/
void r213make(T213* C,T0* a1,T0* a2,T0* a3);
/*DATA_STAR_SLOT*/
void r213remove(T213* C);
/*DATA_STAR_SLOT*/
T0* r213get_type(T213* C);
/*DATA_STAR_SLOT*/
T0* r213search_block(T213* C);
/*DATA_STAR_SLOT*/
T0* r213require_list(T213* C);
/*DATA_STAR_SLOT*/
void r213genere(T213* C,T0* a1);
/*DATA_STAR_SLOT*/
T0* r213execute(T213* C);
/*DATA_STAR_SLOT*/
void r213depend_generic(T213* C);
/*DATA_STAR_SLOT*/
T0* r213twin(T213* C);
/*DATA_STAR_SLOT*/
T2 r213object_id(T213* C);
/*DATA_STAR_SLOT*/
T2 r213proto_self_current(void);
/*DATA_STAR_SLOT*/
void r213make_expr(T213* C,T0* a1);
/*ITM_READ_ARGS*/
T6 r192is_constant(T192* C);
/*ITM_READ_ARGS*/
void r192make(T192* C,T2 a1,T0* a2,T0* a3);
/*ITM_READ_ARGS*/
T0* r192current_position(T192* C);
/*ITM_READ_ARGS*/
T0* r192run_tools(void);
/*ITM_READ_ARGS*/
T0* r192to_run(T192* C,T0* a1,T0* a2,T0* a3);
/*ITM_READ_ARGS*/
T0* r192runnable(T192* C);
/*ITM_READ_ARGS*/
T0* r192get_position(T2 a1);
/*ITM_READ_ARGS*/
T0* r192bucket(void);
/*ITM_PROTOTYPE*/
T6 r99is_constant(T99* C);
/*ITM_PROTOTYPE*/
T0* r99prototype_list(void);
/*ITM_PROTOTYPE*/
T0* r99gt(T2 a1);
/*ITM_PROTOTYPE*/
void r99make(T99* C,T2 a1,T2 a2);
/*ITM_PROTOTYPE*/
T0* r99current_position(T99* C);
/*ITM_PROTOTYPE*/
T0* r99run_tools(void);
/*ITM_PROTOTYPE*/
T0* r99to_run(T99* C,T0* a1,T0* a2,T0* a3);
/*ITM_PROTOTYPE*/
T0* r99runnable(T99* C);
/*ITM_PROTOTYPE*/
T0* r99get_position(T2 a1);
/*ITM_PROTOTYPE*/
T2 r99proto_self_current(void);
/*ITM_READ_ARG2*/
T6 r188is_constant(T188* C);
/*ITM_READ_ARG2*/
void r188make(T188* C,T2 a1,T0* a2,T0* a3,T0* a4);
/*ITM_READ_ARG2*/
T0* r188current_position(T188* C);
/*ITM_READ_ARG2*/
T0* r188run_tools(void);
/*ITM_READ_ARG2*/
T0* r188to_run(T188* C,T0* a1,T0* a2,T0* a3);
/*ITM_READ_ARG2*/
T0* r188runnable(T188* C);
/*ITM_READ_ARG2*/
T0* r188get_position(T2 a1);
/*ITM_READ_ARG2*/
T0* r188bucket(void);
/*ITM_READ_ARG1*/
T6 r190is_constant(T190* C);
/*ITM_READ_ARG1*/
void r190make(T190* C,T2 a1,T0* a2,T0* a3);
/*ITM_READ_ARG1*/
T0* r190current_position(T190* C);
/*ITM_READ_ARG1*/
T0* r190run_tools(void);
/*ITM_READ_ARG1*/
T0* r190to_run(T190* C,T0* a1,T0* a2,T0* a3);
/*ITM_READ_ARG1*/
T0* r190runnable(T190* C);
/*ITM_READ_ARG1*/
T0* r190get_position(T2 a1);
/*LARGE_NEGATIVE_INTEGER*/
T0* r168integer_divide_small_integer(T168* C,T0* a1);
extern T0*oBC164temp_after_mult;
/*LARGE_NEGATIVE_INTEGER*/
T6 r168_ix_646261(T168* C,T2 a1);
/*LARGE_NEGATIVE_INTEGER*/
T0* r168_ix_649292(T168* C,T2 a1);
/*LARGE_NEGATIVE_INTEGER*/
T0* r168remainder_of_divide_large_positive_integer(T168* C,T0* a1);
/*LARGE_NEGATIVE_INTEGER*/
T0* r168_ix_4747(T168* C,T0* a1);
/*LARGE_NEGATIVE_INTEGER*/
T0* r168_ix_6494(T168* C,T2 a1);
/*LARGE_NEGATIVE_INTEGER*/
T6 r168greater_with_large_negative_integer(T168* C,T0* a1);
/*LARGE_NEGATIVE_INTEGER*/
T6 r168is_abstract_integer(T168* C);
/*LARGE_NEGATIVE_INTEGER*/
void r168difference_between_fixed_arrays_in_himself_from(T0* a1,T0* a2,T2 a3);
/*LARGE_NEGATIVE_INTEGER*/
T0* r168add_with_small_fraction(T168* C,T0* a1);
/*LARGE_NEGATIVE_INTEGER*/
void r168make_from_product(T168* C,T2 a1,T2 a2);
/*LARGE_NEGATIVE_INTEGER*/
T0* r168multiply_with_small_integer(T168* C,T0* a1);
extern T6 oBC164Base_is_impair;
extern int fBC164Base_is_impair;
/*LARGE_NEGATIVE_INTEGER*/
T6 r168Base_is_impair(void);
/*LARGE_NEGATIVE_INTEGER*/
T0* r168multiply_with_small_fraction(T168* C,T0* a1);
extern T0*oBC164temp_from_mult;
/*LARGE_NEGATIVE_INTEGER*/
T0* r168factorial(T168* C);
/*LARGE_NEGATIVE_INTEGER*/
T0* r168clone(T0* a1);
/*LARGE_NEGATIVE_INTEGER*/
T6 r168greater_with_small_fraction(T0* a1);
extern T2 oBC164Half_base_2;
extern int fBC164Half_base_2;
/*LARGE_NEGATIVE_INTEGER*/
T2 r168Half_base_2(void);
/*LARGE_NEGATIVE_INTEGER*/
T0* r168_ix_644747(T168* C,T2 a1);
/*LARGE_NEGATIVE_INTEGER*/
void r168add_fixed_arrays_in_himself(T0* a1,T0* a2);
/*LARGE_NEGATIVE_INTEGER*/
T0* r168multiply_with_large_negative_integer(T168* C,T0* a1);
/*LARGE_NEGATIVE_INTEGER*/
T0* r168to_string(T168* C);
extern T0*oBC164temp_1_digint;
/*LARGE_NEGATIVE_INTEGER*/
void r168make_from_large_product(T168* C,T2 a1,T2 a2);
/*LARGE_NEGATIVE_INTEGER*/
T0* r168create_positive(T0* a1);
/*LARGE_NEGATIVE_INTEGER*/
T6 r168greater_with_large_positive_integer(T0* a1);
extern T0*oBC164temp_2_digints;
/*LARGE_NEGATIVE_INTEGER*/
T0* r168add_with_large_negative_integer(T168* C,T0* a1);
/*LARGE_NEGATIVE_INTEGER*/
void r168divise_fixed_array(T0* a1,T0* a2);
/*LARGE_NEGATIVE_INTEGER*/
T6 r168greater_with_large_fraction(T168* C,T0* a1);
/*LARGE_NEGATIVE_INTEGER*/
T6 r168is_small_integer(T168* C);
/*LARGE_NEGATIVE_INTEGER*/
T0* r168gcd(T168* C,T0* a1);
/*LARGE_NEGATIVE_INTEGER*/
T6 r168_ix_6061(T168* C,T0* a1);
/*LARGE_NEGATIVE_INTEGER*/
T6 r168odd(T168* C);
/*LARGE_NEGATIVE_INTEGER*/
T0* r168multiply_with_large_fraction(T168* C,T0* a1);
/*LARGE_NEGATIVE_INTEGER*/
T0* r168inverse(T168* C);
extern T2 oBC164Half_base;
extern int fBC164Half_base;
/*LARGE_NEGATIVE_INTEGER*/
T2 r168Half_base(void);
/*LARGE_NEGATIVE_INTEGER*/
T0* r168_px_45(T168* C);
/*LARGE_NEGATIVE_INTEGER*/
T0* r168integer_divide_large_positive_integer(T168* C,T0* a1);
/*LARGE_NEGATIVE_INTEGER*/
void r168append_in(T168* C,T0* a1);
/*LARGE_NEGATIVE_INTEGER*/
T0* r168remainder_of_divide_large_negative_integer(T168* C,T0* a1);
/*LARGE_NEGATIVE_INTEGER*/
T2 r168to_integer(T168* C);
/*LARGE_NEGATIVE_INTEGER*/
void r168add_fixed_array_with_integer_in_himself_from(T2 a1,T0* a2,T2 a3);
/*LARGE_NEGATIVE_INTEGER*/
void r168make_smaller(T168* C,T2 a1);
/*LARGE_NEGATIVE_INTEGER*/
void r168shift(T0* a1);
/*LARGE_NEGATIVE_INTEGER*/
T0* r168add_with_large_fraction(T168* C,T0* a1);
/*LARGE_NEGATIVE_INTEGER*/
T0* r168zero(void);
/*LARGE_NEGATIVE_INTEGER*/
void r168mult_fixed_with_integer_in(T0* a1,T2 a2,T0* a3);
/*LARGE_NEGATIVE_INTEGER*/
void r168mult_2_fixed_in_temp(T0* a1,T0* a2);
extern T0*oBC164temp_quotient;
/*LARGE_NEGATIVE_INTEGER*/
T6 r168_ix_6261(T168* C,T0* a1);
/*LARGE_NEGATIVE_INTEGER*/
T0* r168mult_2_fixed(T0* a1,T0* a2);
extern T5 oBC164Double_base;
extern int fBC164Double_base;
/*LARGE_NEGATIVE_INTEGER*/
T5 r168Double_base(void);
/*LARGE_NEGATIVE_INTEGER*/
void r168mult_fixed_with_integer_in_temp(T0* a1,T2 a2);
/*LARGE_NEGATIVE_INTEGER*/
T0* r168add_with_large_positive_integer(T168* C,T0* a1);
/*LARGE_NEGATIVE_INTEGER*/
T2 r168compare(T168* C,T0* a1);
/*LARGE_NEGATIVE_INTEGER*/
T0* r168_ix_9292(T168* C,T0* a1);
/*LARGE_NEGATIVE_INTEGER*/
T6 r168_ix_646061(T168* C,T2 a1);
extern T2 oBC164Rest_base;
extern int fBC164Rest_base;
/*LARGE_NEGATIVE_INTEGER*/
T2 r168Rest_base(void);
/*LARGE_NEGATIVE_INTEGER*/
T0* r168multiply_with_large_positive_integer(T168* C,T0* a1);
extern T0*oBC164one;
extern int fBC164one;
/*LARGE_NEGATIVE_INTEGER*/
T0* r168one(void);
/*LARGE_NEGATIVE_INTEGER*/
T6 r168fixed_array_greater_than(T0* a1,T0* a2);
/*LARGE_NEGATIVE_INTEGER*/
T2 r168Base(void);
/*LARGE_NEGATIVE_INTEGER*/
T0* r168_ix_42(T168* C,T0* a1);
/*LARGE_NEGATIVE_INTEGER*/
void r168add_fixed_arrays_in_himself_from(T0* a1,T0* a2,T2 a3);
/*LARGE_NEGATIVE_INTEGER*/
T0* r168integer_divide_large_negative_integer(T168* C,T0* a1);
/*LARGE_NEGATIVE_INTEGER*/
T0* r168_ix_43(T168* C,T0* a1);
/*LARGE_NEGATIVE_INTEGER*/
T0* r168_ix_45(T168* C,T0* a1);
/*LARGE_NEGATIVE_INTEGER*/
T6 r168is_integer_value(T168* C);
/*LARGE_NEGATIVE_INTEGER*/
T0* r168_ix_47(T168* C,T0* a1);
/*LARGE_NEGATIVE_INTEGER*/
T6 r168_ix_60(T168* C,T0* a1);
/*LARGE_NEGATIVE_INTEGER*/
T2 r168nb_c(T2 a1);
/*LARGE_NEGATIVE_INTEGER*/
T6 r168_ix_62(T168* C,T0* a1);
/*LARGE_NEGATIVE_INTEGER*/
T0* r168_ix_6442(T168* C,T2 a1);
/*LARGE_NEGATIVE_INTEGER*/
T0* r168_ix_6443(T168* C,T2 a1);
extern T0*oBC164temp_remainder;
/*LARGE_NEGATIVE_INTEGER*/
T0* r168_ix_6445(T168* C,T2 a1);
/*LARGE_NEGATIVE_INTEGER*/
T0* r168add_fixed_arrays(T0* a1,T0* a2);
/*LARGE_NEGATIVE_INTEGER*/
T0* r168remainder_of_divide_small_integer(T168* C,T0* a1);
extern T0*oBC169fa_one;
/*LARGE_NEGATIVE_INTEGER*/
T6 r168_ix_6460(T168* C,T2 a1);
/*LARGE_NEGATIVE_INTEGER*/
T6 r168_ix_6461(T168* C,T2 a1);
/*LARGE_NEGATIVE_INTEGER*/
T0* r168mult_fixed_with_integer(T0* a1,T2 a2);
/*LARGE_NEGATIVE_INTEGER*/
T6 r168_ix_6462(T168* C,T2 a1);
/*LARGE_NEGATIVE_INTEGER*/
T0* r168create_negative(T0* a1);
/*DATA_GLOBAL*/
void r155semantic_error(T0* a1,T0* a2);
/*DATA_GLOBAL*/
void r155display(T155* C,T0* a1);
/*DATA_GLOBAL*/
T0* r155bucket_type(void);
/*DATA_GLOBAL*/
void r155sub_get_type(T155* C,T0* a1);
/*DATA_GLOBAL*/
T0* r155prototype_list(void);
/*DATA_GLOBAL*/
T6 r155depend(T155* C);
/*DATA_GLOBAL*/
T0* r155gt(T2 a1);
/*DATA_GLOBAL*/
void r155display_ref(T155* C,T0* a1);
/*DATA_GLOBAL*/
void r155set_variable(T155* C,T0* a1);
/*DATA_GLOBAL*/
T0* r155my_copy(T155* C);
/*DATA_GLOBAL*/
void r155make(T155* C,T0* a1,T0* a2);
/*DATA_GLOBAL*/
void r155remove(T155* C);
/*DATA_GLOBAL*/
T0* r155get_type(T155* C);
/*DATA_GLOBAL*/
T0* r155search_block(T155* C);
/*DATA_GLOBAL*/
void r155genere(T155* C,T0* a1);
/*DATA_GLOBAL*/
T0* r155require_list(T155* C);
/*DATA_GLOBAL*/
T6 r155is_require_constant(T155* C);
/*DATA_GLOBAL*/
T0* r155execute(T155* C);
/*DATA_GLOBAL*/
void r155depend_generic(T155* C);
/*DATA_GLOBAL*/
T0* r155twin(T155* C);
/*DATA_GLOBAL*/
T2 r155object_id(T155* C);
/*DATA_GLOBAL*/
T2 r155proto_self_current(void);
/*DATA_GLOBAL*/
void r155make_expr(T155* C,T0* a1);
/*BLOCK*/
void r135display(T135* C,T0* a1);
/*BLOCK*/
T0* r135bucket_type(void);
/*BLOCK*/
T6 r135depend(T135* C);
/*BLOCK*/
void r135display_ref(T135* C,T0* a1);
/*BLOCK*/
T0* r135my_copy(T135* C);
/*BLOCK*/
void r135make(T135* C,T0* a1,T0* a2,T0* a3);
/*BLOCK*/
T0* r135get_type(T135* C);
/*BLOCK*/
T0* r135run_tools(void);
/*BLOCK*/
void r135to_run(T135* C);
/*BLOCK*/
T0* r135search_block(T135* C);
/*BLOCK*/
T0* r135execute(T135* C);
/*BLOCK*/
void r135depend_generic(T135* C);
/*BLOCK*/
T0* r135twin(T135* C);
/*BLOCK*/
T0* r135bucket(void);
/*BLOCK*/
T2 r135object_id(T135* C);
/*BLOCK*/
void r135make_expr(T135* C,T0* a1);
/*CHARACTER_CST*/
void r209display(T209* C,T0* a1);
/*CHARACTER_CST*/
T0* r209bucket_type(void);
/*CHARACTER_CST*/
T6 r209depend(T209* C);
/*CHARACTER_CST*/
void r209display_ref(T209* C,T0* a1);
/*CHARACTER_CST*/
T0* r209my_copy(T209* C);
/*CHARACTER_CST*/
T6 r209is_fusion(T209* C,T0* a1);
/*CHARACTER_CST*/
void r209make(T209* C,T0* a1,T0* a2);
/*CHARACTER_CST*/
T0* r209get_type(T209* C);
/*CHARACTER_CST*/
T0* r209search_block(T209* C);
/*CHARACTER_CST*/
void r209genere(T209* C,T0* a1);
/*CHARACTER_CST*/
T0* r209execute(T209* C);
/*CHARACTER_CST*/
void r209depend_generic(T209* C);
/*CHARACTER_CST*/
T0* r209twin(T209* C);
/*CHARACTER_CST*/
T2 r209object_id(T209* C);
/*CHARACTER_CST*/
void r209make_expr(T209* C,T0* a1);
/*CASE_TYPE*/
void r173semantic_error(T0* a1,T0* a2);
/*CASE_TYPE*/
void r173display(T173* C,T0* a1);
/*CASE_TYPE*/
T0* r173prototype_list(void);
/*CASE_TYPE*/
T6 r173depend(T173* C);
/*CASE_TYPE*/
T0* r173gt(T2 a1);
/*CASE_TYPE*/
void r173display_ref(T173* C,T0* a1);
/*CASE_TYPE*/
T0* r173build_null(T173* C);
/*CASE_TYPE*/
T0* r173my_copy(T173* C);
/*CASE_TYPE*/
void r173make(T173* C,T0* a1,T0* a2,T0* a3,T2 a4,T6 a5);
/*CASE_TYPE*/
void r173display_case(T173* C,T0* a1);
/*CASE_TYPE*/
void r173genere(T173* C,T0* a1);
/*CASE_TYPE*/
T0* r173execute(T173* C);
/*CASE_TYPE*/
void r173depend_generic(T173* C);
/*CASE_TYPE*/
T0* r173twin(T173* C);
/*CASE_TYPE*/
void r173genere_case(T173* C,T0* a1);
/*CASE_TYPE*/
T2 r173object_id(T173* C);
/*CASE_TYPE*/
T2 r173proto_self_current(void);
/*CASE_TYPE*/
T0* r173gtr(T2 a1);
/*CASE_TYPE*/
void r173make_expr(T173* C,T0* a1);
/*ITM_LOCAL*/
void r141syntax_error(T0* a1,T0* a2);
/*ITM_LOCAL*/
T0* r141prototype_list(void);
/*ITM_LOCAL*/
T0* r141gt(T2 a1);
/*ITM_LOCAL*/
void r141make(T141* C,T3 a1);
/*ITM_LOCAL*/
void r141crash(T141* C);
/*ITM_LOCAL*/
T0* r141run_tools(void);
/*ITM_LOCAL*/
void r141runnable(T141* C);
/*ITM_LOCAL*/
T0* r141bucket(void);
/*ITM_LOCAL*/
T2 r141proto_self_current(void);
/*CODE_SLOT*/
void r75semantic_error(T0* a1,T0* a2);
/*CODE_SLOT*/
void r75to_tail_recursive(T75* C);
/*CODE_SLOT*/
T6 r75is_interrupt(T75* C);
/*CODE_SLOT*/
void r75display(T75* C,T0* a1);
/*CODE_SLOT*/
T0* r75bucket_type(void);
/*CODE_SLOT*/
T6 r75load_type(T75* C);
/*CODE_SLOT*/
T0* r75check_life(void);
/*CODE_SLOT*/
void r75display_light(T75* C);
/*CODE_SLOT*/
void r75sub_get_type(T75* C,T0* a1);
/*CODE_SLOT*/
T0* r75prototype_list(void);
/*CODE_SLOT*/
T6 r75depend(T75* C);
/*CODE_SLOT*/
T0* r75gt(T2 a1);
/*CODE_SLOT*/
void r75display_ref(T75* C,T0* a1);
/*CODE_SLOT*/
T6 r75genere_while(T75* C,T0* a1);
/*CODE_SLOT*/
void r75display_style(T75* C,T0* a1);
/*CODE_SLOT*/
T0* r75my_copy(T75* C);
/*CODE_SLOT*/
void r75make(T75* C,T0* a1,T0* a2,T0* a3,T2 a4);
/*CODE_SLOT*/
T6 r75is_equal_call(T75* C,T0* a1);
/*CODE_SLOT*/
void r75remove(T75* C);
/*CODE_SLOT*/
T0* r75get_type(T75* C);
/*CODE_SLOT*/
T0* r75search_block(T75* C);
/*CODE_SLOT*/
void r75genere(T75* C,T0* a1);
/*CODE_SLOT*/
T2 r75static_type(T75* C);
/*CODE_SLOT*/
T6 r75search_tail_recursive(T75* C);
extern T0*oBC13alias_type;
extern int fBC13alias_type;
/*CODE_SLOT*/
T0* r75alias_type(void);
/*CODE_SLOT*/
T0* r75execute(T75* C);
/*CODE_SLOT*/
void r75depend_generic(T75* C);
/*CODE_SLOT*/
T0* r75twin(T75* C);
/*CODE_SLOT*/
T0* r75bucket(void);
/*CODE_SLOT*/
T2 r75object_id(T75* C);
/*CODE_SLOT*/
T2 r75proto_self_current(void);
/*CODE_SLOT*/
T0* r75gtr(T2 a1);
/*CODE_SLOT*/
void r75debug_display_expr(T75* C);
/*CODE_SLOT*/
void r75make_expr(T75* C,T0* a1);
/*CONTEXT*/
void r95semantic_error(T0* a1,T0* a2);
/*CONTEXT*/
void r95genere_c_name(T95* C);
/*CONTEXT*/
void r95check_cycle(T95* C);
/*CONTEXT*/
T0* r95check_life(void);
/*CONTEXT*/
void r95reset_pass(T95* C);
/*CONTEXT*/
T0* r95prototype_list(void);
/*CONTEXT*/
T0* r95get_slot_full(T95* C,T0* a1);
/*CONTEXT*/
void r95depend(T95* C);
/*CONTEXT*/
T0* r95get_slot(T95* C,T0* a1);
/*CONTEXT*/
T0* r95list_check(void);
/*CONTEXT*/
void r95make(T95* C,T0* a1,T0* a2);
/*CONTEXT*/
T6 r95is_sub_type(T95* C,T2 a1);
/*CONTEXT*/
void r95set_type_collector(T95* C,T0* a1);
/*CONTEXT*/
T0* r95creation_main(T95* C,T0* a1);
/*CONTEXT*/
T0* r95parser(void);
/*CONTEXT*/
void r95make_context(T95* C);
/*CONTEXT*/
T6 r95is_data_exist(T95* C);
/*CONTEXT*/
void r95parse(T95* C);
/*CONTEXT*/
T0* r95bucket(void);
/*CONTEXT*/
T2 r95sub_check_cycle(T95* C);
/*CONTEXT*/
T0* r95idf_proto(void);
/*CONTEXT*/
T0* r95gtr(T2 a1);
/*NUMBER_FRACTION*/
T6 r225_ix_646261(T225* C,T2 a1);
/*NUMBER_FRACTION*/
T0* r225_ix_6494(T225* C,T2 a1);
/*NUMBER_FRACTION*/
T6 r225greater_with_large_negative_integer(T225* C,T0* a1);
/*NUMBER_FRACTION*/
T6 r225is_abstract_integer(T225* C);
/*NUMBER_FRACTION*/
T0* r225add_with_small_fraction(T225* C,T0* a1);
/*NUMBER_FRACTION*/
T0* r225multiply_with_small_integer(T225* C,T0* a1);
/*NUMBER_FRACTION*/
T0* r225multiply_with_small_fraction(T225* C,T0* a1);
/*NUMBER_FRACTION*/
T0* r225factorial(T225* C);
/*NUMBER_FRACTION*/
T6 r225greater_with_small_fraction(T225* C,T0* a1);
/*NUMBER_FRACTION*/
T0* r225multiply_with_large_negative_integer(T225* C,T0* a1);
/*NUMBER_FRACTION*/
T0* r225to_string(T225* C);
/*NUMBER_FRACTION*/
T6 r225greater_with_large_positive_integer(T225* C,T0* a1);
/*NUMBER_FRACTION*/
T0* r225add_with_large_negative_integer(T225* C,T0* a1);
/*NUMBER_FRACTION*/
T6 r225greater_with_large_fraction(T225* C,T0* a1);
/*NUMBER_FRACTION*/
T0* r225gcd(T225* C,T0* a1);
/*NUMBER_FRACTION*/
void r225make_simply(T225* C,T0* a1,T0* a2,T6 a3);
/*NUMBER_FRACTION*/
T6 r225odd(void);
/*NUMBER_FRACTION*/
T0* r225multiply_with_large_fraction(T225* C,T0* a1);
/*NUMBER_FRACTION*/
T0* r225inverse(T225* C);
/*NUMBER_FRACTION*/
T0* r225add_with_small_integer(T225* C,T0* a1);
/*NUMBER_FRACTION*/
T0* r225_px_45(T225* C);
/*NUMBER_FRACTION*/
void r225append_in(T225* C,T0* a1);
/*NUMBER_FRACTION*/
T2 r225to_integer(void);
/*NUMBER_FRACTION*/
T0* r225add_with_large_fraction(T225* C,T0* a1);
/*NUMBER_FRACTION*/
T6 r225_ix_6261(T225* C,T0* a1);
/*NUMBER_FRACTION*/
T0* r225add_with_large_positive_integer(T225* C,T0* a1);
/*NUMBER_FRACTION*/
T2 r225compare(T225* C,T0* a1);
/*NUMBER_FRACTION*/
T0* r225multiply_with_large_positive_integer(T225* C,T0* a1);
/*NUMBER_FRACTION*/
T0* r225from_two_abstract_integer(T0* a1,T0* a2);
/*NUMBER_FRACTION*/
T2 r225Base(void);
/*NUMBER_FRACTION*/
T0* r225_ix_42(T225* C,T0* a1);
/*NUMBER_FRACTION*/
T0* r225_ix_43(T225* C,T0* a1);
/*NUMBER_FRACTION*/
T0* r225_ix_45(T225* C,T0* a1);
/*NUMBER_FRACTION*/
T0* r225_ix_47(T225* C,T0* a1);
/*NUMBER_FRACTION*/
T2 r225nb_c(T2 a1);
/*NUMBER_FRACTION*/
T6 r225_ix_60(T225* C,T0* a1);
/*NUMBER_FRACTION*/
T6 r225_ix_62(T225* C,T0* a1);
/*NUMBER_FRACTION*/
T0* r225_ix_6442(T225* C,T2 a1);
/*NUMBER_FRACTION*/
T0* r225_ix_6443(T225* C,T2 a1);
/*NUMBER_FRACTION*/
T0* r225_ix_6445(T225* C,T2 a1);
/*NUMBER_FRACTION*/
T6 r225_ix_6460(T225* C,T2 a1);
/*NUMBER_FRACTION*/
T6 r225_ix_6461(T2 a1);
/*NUMBER_FRACTION*/
T6 r225_ix_6462(T225* C,T2 a1);
/*NUMBER_FRACTION*/
T0* r225from_integer_and_abstract_integer(T2 a1,T0* a2);
/*ITM_BLOCK*/
T6 r136is_constant(T136* C);
/*ITM_BLOCK*/
T0* r136prototype_list(void);
/*ITM_BLOCK*/
T0* r136gt(T2 a1);
/*ITM_BLOCK*/
void r136make(T136* C,T2 a1);
/*ITM_BLOCK*/
T0* r136current_position(T136* C);
/*ITM_BLOCK*/
void r136runnable_local(T0* a1);
/*ITM_BLOCK*/
T0* r136run_tools(void);
/*ITM_BLOCK*/
T0* r136to_run(T136* C,T0* a1,T0* a2,T0* a3);
/*ITM_BLOCK*/
T0* r136runnable(T136* C);
/*ITM_BLOCK*/
T0* r136runnable_group(T136* C);
/*ITM_BLOCK*/
T0* r136get_position(T2 a1);
/*ITM_BLOCK*/
T0* r136bucket(void);
/*ITM_BLOCK*/
T2 r136proto_self_current(void);
/*PROTOTYPE_HEAD*/
void r93semantic_error(T0* a1,T0* a2);
/*PROTOTYPE_HEAD*/
T6 r93file_exists(T0* a1);
/*PROTOTYPE_HEAD*/
T0* r93prototype_list(void);
/*PROTOTYPE_HEAD*/
void r93depend(T93* C);
/*PROTOTYPE_HEAD*/
T0* r93gt(T2 a1);
/*PROTOTYPE_HEAD*/
void r93make_generic(T93* C,T2 a1,T0* a2,T0* a3);
/*PROTOTYPE_HEAD*/
T0* r93position(T93* C);
extern T0*oBC13path_directory;
extern int fBC13path_directory;
/*PROTOTYPE_HEAD*/
T0* r93path_directory(void);
/*PROTOTYPE_HEAD*/
void r93make(T93* C,T2 a1,T0* a2);
/*PROTOTYPE_HEAD*/
T0* r93to_run(T93* C);
extern T181 oBC15file_tools;
/*PROTOTYPE_HEAD*/
T0* r93bucket(void);
/*PROTOTYPE_HEAD*/
T0* r93gtr(T2 a1);
/*PROTOTYPE_HEAD*/
void r93make_generic2(T93* C,T2 a1,T0* a2,T0* a3,T0* a4);
/*STRING_CST*/
void r208display(T208* C,T0* a1);
/*STRING_CST*/
T0* r208bucket_type(void);
/*STRING_CST*/
T6 r208depend(T208* C);
/*STRING_CST*/
void r208display_ref(T208* C,T0* a1);
extern T0*oBC13output_string;
/*STRING_CST*/
T0* r208my_copy(T208* C);
/*STRING_CST*/
T6 r208is_fusion(T208* C,T0* a1);
/*STRING_CST*/
void r208make(T208* C,T0* a1,T0* a2);
/*STRING_CST*/
T0* r208get_type(T208* C);
/*STRING_CST*/
T0* r208search_block(T208* C);
/*STRING_CST*/
void r208genere(T208* C,T0* a1);
/*STRING_CST*/
T0* r208execute(T208* C);
/*STRING_CST*/
void r208depend_generic(T208* C);
/*STRING_CST*/
T0* r208twin(T208* C);
/*STRING_CST*/
T2 r208object_id(T208* C);
/*STRING_CST*/
void r208make_expr(T208* C,T0* a1);
/*PUSH*/
void r134display(T134* C,T0* a1);
/*PUSH*/
void r134syntax_error(T0* a1,T0* a2);
/*PUSH*/
T6 r134depend(T134* C);
extern T0*oBC13output_trace;
/*PUSH*/
void r134display_ref(T134* C,T0* a1);
/*PUSH*/
T0* r134my_copy(T134* C);
/*PUSH*/
void r134remove(T134* C);
/*PUSH*/
void r134genere(T134* C,T0* a1);
/*PUSH*/
T0* r134execute(T134* C);
/*PUSH*/
void r134depend_generic(T134* C);
/*PUSH*/
T0* r134twin(T134* C);
/*PUSH*/
T0* r134bucket(void);
/*PUSH*/
T2 r134object_id(T134* C);
/*PUSH*/
void r134make_expr(T134* C,T0* a1);
/*SELF*/
void r147display(T147* C,T0* a1);
/*SELF*/
T0* r147prototype_list(void);
/*SELF*/
T6 r147depend(T147* C);
/*SELF*/
void r147display_ref(T147* C,T0* a1);
/*SELF*/
T0* r147my_copy(T147* C);
/*SELF*/
void r147make(T147* C,T0* a1,T2 a2);
/*SELF*/
void r147remove(T147* C);
/*SELF*/
void r147genere(T147* C,T0* a1);
/*SELF*/
T0* r147execute(T147* C);
/*SELF*/
void r147depend_generic(T147* C);
/*SELF*/
T0* r147twin(T147* C);
/*SELF*/
T2 r147object_id(T147* C);
/*SELF*/
T0* r147gtr(T2 a1);
/*SELF*/
void r147make_expr(T147* C,T0* a1);
/*SELF_TYPE*/
void r97syntax_error(T0* a1,T0* a2);
/*SELF_TYPE*/
T0* r97prototype_list(void);
/*SELF_TYPE*/
void r97make_self(T97* C);
/*SELF_TYPE*/
T0* r97position(void);
/*SELF_TYPE*/
T0* r97to_run(void);
/*SELF_TYPE*/
T0* r97bucket(void);
/*SELF_TYPE*/
T0* r97gtr(T2 a1);
/*TEXT_FILE_WRITE*/
void r21disconnect(T21* C);
/*TEXT_FILE_WRITE*/
void r21connect_to(T21* C,T0* a1);
/*TEXT_FILE_WRITE*/
void r21dispose(void);
/*TEXT_FILE_WRITE*/
void r21write_buffer(T21* C);
/*TEXT_FILE_WRITE*/
void r21put_character(T21* C,T3 a1);
extern T0*oBC15std_input;
extern T0*oBC24tmp_string;
/*STD_INPUT_OUTPUT*/
void r68put_integer(T11 a1);
/*STD_INPUT_OUTPUT*/
void r68put_string(T0* a1);
/*STD_ERROR*/
void r44put_integer(T11 a1);
/*STD_ERROR*/
void r44put_string(T0* a1);
/*ITM_BINARY*/
T6 r189is_constant(T189* C);
/*ITM_BINARY*/
void r189make(T189* C,T0* a1,T0* a2,T0* a3);
/*ITM_BINARY*/
T0* r189run_tools(void);
/*ITM_BINARY*/
T0* r189to_run(T189* C,T0* a1,T0* a2,T0* a3);
/*ITM_BINARY*/
T0* r189runnable(T189* C);
/*ITM_BINARY*/
T0* r189get_position(T2 a1);
/*NULL*/
void r101semantic_error(T0* a1,T0* a2);
/*NULL*/
void r101genere_c_name(T101* C);
/*NULL*/
void r101check_cycle(T101* C);
/*NULL*/
T0* r101check_life(void);
/*NULL*/
void r101reset_pass(T101* C);
/*NULL*/
T0* r101prototype_list(void);
/*NULL*/
T0* r101get_slot_full(T101* C,T0* a1);
/*NULL*/
void r101depend(T101* C);
/*NULL*/
void r101make_null(T101* C);
/*NULL*/
T0* r101get_slot(T101* C,T0* a1);
/*NULL*/
T0* r101list_check(void);
/*NULL*/
void r101make(T101* C,T0* a1,T0* a2);
/*NULL*/
void r101set_type_collector(T101* C,T0* a1);
/*NULL*/
T0* r101creation_main(T101* C,T0* a1);
/*NULL*/
T0* r101parser(void);
/*NULL*/
T6 r101is_data_exist(T101* C);
/*NULL*/
void r101parse(T101* C);
/*NULL*/
T0* r101bucket(void);
/*NULL*/
T2 r101sub_check_cycle(T101* C);
/*NULL*/
T0* r101idf_proto(void);
/*NULL*/
T0* r101gtr(T2 a1);
/*BASE_A_DATA*/
void r199semantic_error(T0* a1,T0* a2);
/*BASE_A_DATA*/
void r199make_base(T199* C,T0* a1,T0* a2,T0* a3);
/*BASE_A_DATA*/
void r199display(T199* C,T0* a1);
/*BASE_A_DATA*/
void r199syntax_error(T0* a1,T0* a2);
/*BASE_A_DATA*/
T0* r199get_receiver(T199* C);
/*BASE_A_DATA*/
T0* r199prototype_list(void);
/*BASE_A_DATA*/
T6 r199depend(T199* C);
/*BASE_A_DATA*/
T0* r199build_case_type(T199* C,T0* a1);
/*BASE_A_DATA*/
T0* r199build_case_type_parent(T199* C,T0* a1);
/*BASE_A_DATA*/
T0* r199gt(T2 a1);
/*BASE_A_DATA*/
void r199display_ref(T199* C,T0* a1);
/*BASE_A_DATA*/
T0* r199get_argument(T199* C);
/*BASE_A_DATA*/
T0* r199my_copy(T199* C);
/*BASE_A_DATA*/
void r199warning_error(T0* a1,T0* a2);
/*BASE_A_DATA*/
T0* r199build_case_body(T199* C,T0* a1);
/*BASE_A_DATA*/
void r199make(T199* C,T0* a1,T0* a2,T0* a3,T0* a4);
/*BASE_A_DATA*/
void r199remove(T199* C);
/*BASE_A_DATA*/
void r199genere(T199* C,T0* a1);
/*BASE_A_DATA*/
T0* r199build_case_type_action(T199* C,T0* a1,T0* a2);
/*BASE_A_DATA*/
T0* r199execute(T199* C);
/*BASE_A_DATA*/
void r199depend_generic(T199* C);
/*BASE_A_DATA*/
T6 r199depend_base(T199* C,T2 a1);
/*BASE_A_DATA*/
T0* r199twin(T199* C);
/*BASE_A_DATA*/
T0* r199bucket(void);
/*BASE_A_DATA*/
T2 r199object_id(T199* C);
/*BASE_A_DATA*/
T2 r199proto_self_current(void);
/*BASE_A_DATA*/
T0* r199get_n_argument(T199* C,T2 a1);
/*BASE_A_DATA*/
T0* r199gtr(T2 a1);
/*BASE_A_DATA*/
void r199make_expr(T199* C,T0* a1);
/*LOCAL_*/
void r113set_name(T113* C,T0* a1);
/*LOCAL_*/
void r113display(T113* C,T0* a1);
/*LOCAL_*/
T6 r113is_equal(T113* C,T0* a1);
/*LOCAL_*/
T0* r113prototype_list(void);
/*LOCAL_*/
T0* r113get_value(T113* C);
/*LOCAL_*/
T0* r113gt(T2 a1);
/*LOCAL_*/
void r113write(T113* C,T0* a1);
/*LOCAL_*/
T0* r113my_copy(T113* C);
/*LOCAL_*/
void r113make(T113* C,T0* a1,T0* a2,T6 a3);
/*LOCAL_*/
T2 r113real_type(T113* C);
/*LOCAL_*/
T0* r113get_type(T113* C);
/*LOCAL_*/
void r113unlink(T113* C,T0* a1);
/*LOCAL_*/
void r113genere(T113* C,T0* a1);
/*LOCAL_*/
void r113load_slot(T113* C);
/*LOCAL_*/
void r113inc_loop_arg(T113* C);
/*LOCAL_*/
T0* r113bucket(void);
/*LOCAL_*/
T2 r113proto_self_current(void);
/*LOCAL_*/
void r113make_tmp(T113* C,T0* a1);
/*LOCAL_*/
T0* r113gtr(T2 a1);
/*LOCAL_*/
void r113link(T113* C,T0* a1);
/*LARGE_POSITIVE_INTEGER*/
T0* r170integer_divide_small_integer(T170* C,T0* a1);
/*LARGE_POSITIVE_INTEGER*/
T6 r170_ix_646261(T170* C,T2 a1);
/*LARGE_POSITIVE_INTEGER*/
T0* r170_ix_649292(T170* C,T2 a1);
/*LARGE_POSITIVE_INTEGER*/
T0* r170remainder_of_divide_large_positive_integer(T170* C,T0* a1);
/*LARGE_POSITIVE_INTEGER*/
T0* r170_ix_4747(T170* C,T0* a1);
/*LARGE_POSITIVE_INTEGER*/
T0* r170_ix_6494(T170* C,T2 a1);
extern T6 oBC170greater_with_large_negative_integer;
/*LARGE_POSITIVE_INTEGER*/
T6 r170is_abstract_integer(T170* C);
/*LARGE_POSITIVE_INTEGER*/
void r170difference_between_fixed_arrays_in_himself_from(T0* a1,T0* a2,T2 a3);
/*LARGE_POSITIVE_INTEGER*/
T0* r170add_with_small_fraction(T170* C,T0* a1);
/*LARGE_POSITIVE_INTEGER*/
void r170make_from_product(T170* C,T2 a1,T2 a2);
/*LARGE_POSITIVE_INTEGER*/
T0* r170create_negative_directly(T0* a1);
/*LARGE_POSITIVE_INTEGER*/
T0* r170multiply_with_small_integer(T170* C,T0* a1);
/*LARGE_POSITIVE_INTEGER*/
T6 r170Base_is_impair(void);
/*LARGE_POSITIVE_INTEGER*/
T0* r170multiply_with_small_fraction(T170* C,T0* a1);
/*LARGE_POSITIVE_INTEGER*/
T0* r170factorial(T170* C);
/*LARGE_POSITIVE_INTEGER*/
T0* r170clone(T0* a1);
extern T6 oBC170greater_with_small_fraction;
/*LARGE_POSITIVE_INTEGER*/
T2 r170Half_base_2(void);
/*LARGE_POSITIVE_INTEGER*/
T0* r170_ix_644747(T170* C,T2 a1);
/*LARGE_POSITIVE_INTEGER*/
void r170add_fixed_arrays_in_himself(T0* a1,T0* a2);
/*LARGE_POSITIVE_INTEGER*/
T0* r170multiply_with_large_negative_integer(T170* C,T0* a1);
/*LARGE_POSITIVE_INTEGER*/
T0* r170to_string(T170* C);
/*LARGE_POSITIVE_INTEGER*/
void r170make_from_large_product(T170* C,T2 a1,T2 a2);
/*LARGE_POSITIVE_INTEGER*/
T0* r170create_positive(T0* a1);
/*LARGE_POSITIVE_INTEGER*/
T6 r170greater_with_large_positive_integer(T170* C,T0* a1);
/*LARGE_POSITIVE_INTEGER*/
T0* r170add_with_large_negative_integer(T170* C,T0* a1);
/*LARGE_POSITIVE_INTEGER*/
void r170divise_fixed_array(T0* a1,T0* a2);
/*LARGE_POSITIVE_INTEGER*/
T6 r170greater_with_large_fraction(T170* C,T0* a1);
/*LARGE_POSITIVE_INTEGER*/
T6 r170is_small_integer(T170* C);
/*LARGE_POSITIVE_INTEGER*/
T0* r170gcd(T170* C,T0* a1);
/*LARGE_POSITIVE_INTEGER*/
T6 r170_ix_6061(T170* C,T0* a1);
/*LARGE_POSITIVE_INTEGER*/
T6 r170odd(T170* C);
/*LARGE_POSITIVE_INTEGER*/
T0* r170multiply_with_large_fraction(T170* C,T0* a1);
/*LARGE_POSITIVE_INTEGER*/
T0* r170inverse(T170* C);
/*LARGE_POSITIVE_INTEGER*/
T0* r170create_positive_directly(T0* a1);
/*LARGE_POSITIVE_INTEGER*/
T2 r170Half_base(void);
/*LARGE_POSITIVE_INTEGER*/
T0* r170_px_45(T170* C);
/*LARGE_POSITIVE_INTEGER*/
T0* r170difference_between_fixed_arrays(T0* a1,T0* a2);
/*LARGE_POSITIVE_INTEGER*/
T0* r170integer_divide_large_positive_integer(T170* C,T0* a1);
/*LARGE_POSITIVE_INTEGER*/
void r170append_in(T170* C,T0* a1);
/*LARGE_POSITIVE_INTEGER*/
T0* r170remainder_of_divide_large_negative_integer(T170* C,T0* a1);
/*LARGE_POSITIVE_INTEGER*/
T2 r170to_integer(T170* C);
/*LARGE_POSITIVE_INTEGER*/
void r170add_fixed_array_with_integer_in_himself_from(T2 a1,T0* a2,T2 a3);
/*LARGE_POSITIVE_INTEGER*/
void r170make_smaller(T170* C,T2 a1);
/*LARGE_POSITIVE_INTEGER*/
void r170shift(T0* a1);
/*LARGE_POSITIVE_INTEGER*/
T0* r170add_with_large_fraction(T170* C,T0* a1);
/*LARGE_POSITIVE_INTEGER*/
T0* r170zero(void);
/*LARGE_POSITIVE_INTEGER*/
void r170mult_fixed_with_integer_in(T0* a1,T2 a2,T0* a3);
/*LARGE_POSITIVE_INTEGER*/
void r170mult_2_fixed_in_temp(T0* a1,T0* a2);
/*LARGE_POSITIVE_INTEGER*/
T6 r170_ix_6261(T170* C,T0* a1);
/*LARGE_POSITIVE_INTEGER*/
T0* r170mult_2_fixed(T0* a1,T0* a2);
/*LARGE_POSITIVE_INTEGER*/
T5 r170Double_base(void);
/*LARGE_POSITIVE_INTEGER*/
void r170mult_fixed_with_integer_in_temp(T0* a1,T2 a2);
/*LARGE_POSITIVE_INTEGER*/
T0* r170add_with_large_positive_integer(T170* C,T0* a1);
/*LARGE_POSITIVE_INTEGER*/
T2 r170compare(T170* C,T0* a1);
/*LARGE_POSITIVE_INTEGER*/
T0* r170_ix_9292(T170* C,T0* a1);
/*LARGE_POSITIVE_INTEGER*/
T6 r170_ix_646061(T170* C,T2 a1);
/*LARGE_POSITIVE_INTEGER*/
T2 r170Rest_base(void);
/*LARGE_POSITIVE_INTEGER*/
T0* r170multiply_with_large_positive_integer(T170* C,T0* a1);
/*LARGE_POSITIVE_INTEGER*/
T0* r170one(void);
/*LARGE_POSITIVE_INTEGER*/
T6 r170fixed_array_greater_than(T0* a1,T0* a2);
/*LARGE_POSITIVE_INTEGER*/
T2 r170Base(void);
/*LARGE_POSITIVE_INTEGER*/
T0* r170_ix_42(T170* C,T0* a1);
/*LARGE_POSITIVE_INTEGER*/
void r170add_fixed_arrays_in_himself_from(T0* a1,T0* a2,T2 a3);
/*LARGE_POSITIVE_INTEGER*/
T0* r170integer_divide_large_negative_integer(T170* C,T0* a1);
/*LARGE_POSITIVE_INTEGER*/
T0* r170_ix_43(T170* C,T0* a1);
/*LARGE_POSITIVE_INTEGER*/
T0* r170_ix_45(T170* C,T0* a1);
/*LARGE_POSITIVE_INTEGER*/
T6 r170is_integer_value(T170* C);
/*LARGE_POSITIVE_INTEGER*/
T0* r170_ix_47(T170* C,T0* a1);
/*LARGE_POSITIVE_INTEGER*/
T6 r170_ix_60(T170* C,T0* a1);
/*LARGE_POSITIVE_INTEGER*/
T2 r170nb_c(T2 a1);
/*LARGE_POSITIVE_INTEGER*/
T6 r170_ix_62(T170* C,T0* a1);
/*LARGE_POSITIVE_INTEGER*/
T0* r170_ix_6442(T170* C,T2 a1);
/*LARGE_POSITIVE_INTEGER*/
T0* r170_ix_6443(T170* C,T2 a1);
/*LARGE_POSITIVE_INTEGER*/
T0* r170_ix_6445(T170* C,T2 a1);
/*LARGE_POSITIVE_INTEGER*/
T0* r170add_fixed_arrays(T0* a1,T0* a2);
/*LARGE_POSITIVE_INTEGER*/
T0* r170remainder_of_divide_small_integer(T170* C,T0* a1);
/*LARGE_POSITIVE_INTEGER*/
T6 r170_ix_6460(T170* C,T2 a1);
/*LARGE_POSITIVE_INTEGER*/
T6 r170_ix_6461(T170* C,T2 a1);
/*LARGE_POSITIVE_INTEGER*/
T0* r170mult_fixed_with_integer(T0* a1,T2 a2);
/*LARGE_POSITIVE_INTEGER*/
T6 r170_ix_6462(T170* C,T2 a1);
/*LARGE_POSITIVE_INTEGER*/
T0* r170create_negative(T0* a1);
/*RUNTIME*/
void r71insert_before(T71* C,T0* a1);
/*RUNTIME*/
void r71open(T71* C,T0* a1,T0* a2);
/*RUNTIME*/
void r71open_light(T71* C,T0* a1,T0* a2);
/*RUNTIME*/
void r71inc_index(T71* C);
/*RUNTIME*/
void r71insert_first(T71* C,T0* a1);
/*INTEGER_FRACTION*/
T6 r227_ix_646261(T227* C,T2 a1);
/*INTEGER_FRACTION*/
T0* r227_ix_6494(T227* C,T2 a1);
extern T6 oBC227greater_with_large_negative_integer;
/*INTEGER_FRACTION*/
T6 r227is_abstract_integer(T227* C);
/*INTEGER_FRACTION*/
T0* r227small_numerator(T227* C);
/*INTEGER_FRACTION*/
T0* r227add_with_small_fraction(T227* C,T0* a1);
/*INTEGER_FRACTION*/
T0* r227multiply_with_small_integer(T227* C,T0* a1);
/*INTEGER_FRACTION*/
T0* r227multiply_with_small_fraction(T227* C,T0* a1);
/*INTEGER_FRACTION*/
T5 r227to_double(T227* C);
/*INTEGER_FRACTION*/
T0* r227factorial(T227* C);
/*INTEGER_FRACTION*/
T6 r227greater_with_small_fraction(T227* C,T0* a1);
/*INTEGER_FRACTION*/
T0* r227from_abstract_integer_and_integer(T0* a1,T2 a2);
/*INTEGER_FRACTION*/
T0* r227multiply_with_large_negative_integer(T227* C,T0* a1);
/*INTEGER_FRACTION*/
T0* r227to_string(T227* C);
/*INTEGER_FRACTION*/
T6 r227greater_with_large_positive_integer(T0* a1);
/*INTEGER_FRACTION*/
T0* r227add_with_large_negative_integer(T227* C,T0* a1);
/*INTEGER_FRACTION*/
T6 r227greater_with_large_fraction(T227* C,T0* a1);
/*INTEGER_FRACTION*/
T0* r227gcd(T227* C,T0* a1);
/*INTEGER_FRACTION*/
void r227make(T227* C,T2 a1,T2 a2);
/*INTEGER_FRACTION*/
T6 r227odd(void);
/*INTEGER_FRACTION*/
T0* r227multiply_with_large_fraction(T227* C,T0* a1);
/*INTEGER_FRACTION*/
T0* r227inverse(T227* C);
/*INTEGER_FRACTION*/
T0* r227_px_45(T227* C);
/*INTEGER_FRACTION*/
void r227append_in(T227* C,T0* a1);
/*INTEGER_FRACTION*/
T2 r227to_integer(void);
/*INTEGER_FRACTION*/
T0* r227add_with_large_fraction(T227* C,T0* a1);
/*INTEGER_FRACTION*/
T6 r227_ix_6261(T227* C,T0* a1);
/*INTEGER_FRACTION*/
T0* r227add_with_large_positive_integer(T227* C,T0* a1);
/*INTEGER_FRACTION*/
T2 r227compare(T227* C,T0* a1);
/*INTEGER_FRACTION*/
T0* r227small_denominator(T227* C);
/*INTEGER_FRACTION*/
T0* r227multiply_with_large_positive_integer(T227* C,T0* a1);
/*INTEGER_FRACTION*/
T0* r227from_two_abstract_integer(T0* a1,T0* a2);
/*INTEGER_FRACTION*/
T2 r227Base(void);
/*INTEGER_FRACTION*/
T0* r227_ix_42(T227* C,T0* a1);
/*INTEGER_FRACTION*/
T0* r227_ix_43(T227* C,T0* a1);
/*INTEGER_FRACTION*/
T0* r227_ix_45(T227* C,T0* a1);
/*INTEGER_FRACTION*/
T0* r227_ix_47(T227* C,T0* a1);
/*INTEGER_FRACTION*/
T2 r227nb_c(T2 a1);
/*INTEGER_FRACTION*/
T6 r227_ix_60(T227* C,T0* a1);
/*INTEGER_FRACTION*/
T6 r227_ix_62(T227* C,T0* a1);
/*INTEGER_FRACTION*/
T0* r227_ix_6442(T227* C,T2 a1);
/*INTEGER_FRACTION*/
T0* r227_ix_6443(T227* C,T2 a1);
/*INTEGER_FRACTION*/
T0* r227_ix_6445(T227* C,T2 a1);
/*INTEGER_FRACTION*/
T6 r227_ix_6460(T227* C,T2 a1);
/*INTEGER_FRACTION*/
T6 r227_ix_6461(T2 a1);
/*INTEGER_FRACTION*/
T6 r227_ix_6462(T227* C,T2 a1);
/*STD_OUTPUT*/
void r80make(T80* C);
/*STD_OUTPUT*/
void r80flush(T80* C);
/*STD_OUTPUT*/
void r80write_buffer(T80* C);
/*STD_OUTPUT*/
void r80put_character(T80* C,T3 a1);
/*LISAAC*/
void r12read_options(T12* C);
/*LISAAC*/
T0* r12prototype_list(void);
extern T0*oBC15command_arguments;
extern int fBC15command_arguments;
/*LISAAC*/
T0* r12command_arguments(void);
/*LISAAC*/
T0* r12gt(T2 a1);
/*LISAAC*/
void r12put_trace_code(T0* a1);
/*LISAAC*/
T0* r12path_directory(void);
/*LISAAC*/
void r12make(T12* C);
/*LISAAC*/
void r12load_proto(T2 a1,T0* a2);
/*LISAAC*/
T0* r12bucket(void);
/*LISAAC*/
T0* r12load_directory(T12* C);
/*LISAAC*/
void r12display_usage(T12* C);
/*LISAAC*/
T2 r12last_index(T0* a1,T3 a2);
/*LISAAC*/
T0* r12argument(T2 a1);
/*LISAAC*/
T0* r12extract_directory(T0* a1);
extern T0*oBC181tfr1;
/*FILE_TOOLS*/
T6 r181is_readable(T0* a1);
/*HASH_TABLE_SIZE*/
T2 r67prime_number_ceiling(T2 a1);
/*SYSTEM*/
T0* r104get_environment_variable(T0* a1);
/*COUNTER*/
void r81increment(T81* C);
/*NUMBER_TOOLS*/
T0* r167from_integer(T2 a1);
/*NUMBER_TOOLS*/
T6 r167parse_constant(void);
/*NUMBER_TOOLS*/
T0* r167parse_create_r3(T0* a1);
/*NUMBER_TOOLS*/
T0* r167parse_create_r2(int C,T0* a1);
extern T0*oBC167parser_buffer;
/*NUMBER_TOOLS*/
T0* r167parse_create_r1(int C,T0* a1);
/*NUMBER_TOOLS*/
T6 r167parse_e0(int C);
/*NUMBER_TOOLS*/
T6 r167parse_e1(int C);
/*NUMBER_TOOLS*/
T6 r167parse_e2(int C);
/*NUMBER_TOOLS*/
T6 r167parse_e3(int C);
/*NUMBER_TOOLS*/
T0* r167parse_create_e3(int C);
/*NUMBER_TOOLS*/
T0* r167parse_create_e2(int C);
/*NUMBER_TOOLS*/
T0* r167parse_create_constant(void);
/*NUMBER_TOOLS*/
T0* r167parse_create_e1(int C);
/*NUMBER_TOOLS*/
T0* r167parse_create_e0(int C);
/*NUMBER_TOOLS*/
T0* r167from_string(int C,T0* a1);
extern T2 oBC167Base;
/*NUMBER_TOOLS*/
T6 r167is_number(int C,T0* a1);
/*NUMBER_TOOLS*/
T6 r167parse_r1(int C);
/*NUMBER_TOOLS*/
T6 r167parse_r2(int C);
/*TIME*/
T5 r20elapsed_seconds(T20* C,T20 a1);
/*MINI_PARSER_BUFFER*/
void r184next(T184* C);
/*MINI_PARSER_BUFFER*/
void r184initialize_with(T184* C,T0* a1);
/*MINI_PARSER_BUFFER*/
T3 r184current_character(T184* C);
/*MINI_PARSER_BUFFER*/
void r184skip_separators(T184* C);
/*MINI_PARSER_BUFFER*/
T6 r184end_reached(T184* C);
extern T12*eiffel_root_object;
extern int se_argc;
extern char**se_argv;
#define SE_MAXID 229
void se_atexit(void);
void initialize_eiffel_runtime(int argc,char*argv[]);
extern T0*ms167_22239201;
extern T0*ms6_59251;
extern T0*ms63_9691966;
extern T0*ms63_1564739;
extern T0*ms63_1957581;
extern T0*ms63_1506588927;
extern T0*ms167_120568283;
extern T0*ms63_41123424;
extern T0*ms63_313707;
extern T0*ms63_829606548;
extern T0*ms167_683885672;
extern T0*ms63_1554777;
extern T0*ms63_53135;
extern T0*ms82_251;
extern T0*ms63_61;
extern T0*ms167_1812875223;
extern T0*ms63_54259;
extern T0*ms63_275452;
extern T0*ms63_1160915598;
extern T0*ms63_1494299;
extern T0*ms63_7920299;
extern T0*ms63_1543607;
extern T0*ms63_226;
extern T0*ms63_1339128;
extern T0*ms63_345;
extern T0*ms63_351;
extern T0*ms63_2192165;
extern T0*ms63_376;
extern T0*ms63_278377;
extern T0*ms82_251a;
extern T0*ms63_58414;
extern T0*ms12_832373680;
extern T0*ms63_59414;
extern T0*ms63_10208843;
extern T0*ms63_290121;
extern T0*ms63_1996039083;
extern T0*ms6_14036;
extern T0*ms63_1144166169;
extern T0*ms167_833080669;
extern T0*ms63_1468536;
extern T0*ms63_232058366;
extern T0*ms164_76093782;
extern T0*ms63_8088327;
extern T0*ms63_265492705;
extern T0*ms63_349117293;
extern T0*ms63_213304386;
extern T0*ms63_8134924;
extern T0*ms63_1855902;
extern T0*ms63_1761252149;
extern T0*ms63_87586;
extern T0*ms63_1257395809;
extern T0*ms63_89261;
extern T0*ms63_371682;
extern T0*ms63_1447702;
extern T0*ms63_1383170301;
extern T0*ms63_45886499;
extern T0*ms63_1500210;
extern T0*ms167_1038265457;
extern T0*ms63_12331;
extern T0*ms63_13044;
extern T0*ms63_13158;
extern T0*ms63_12685;
extern T0*ms63_33120277;
extern T0*ms63_41153049;
extern T0*ms63_36201609;
extern T0*ms63_1440499;
extern T0*ms63_7949924;
extern T0*ms63_16651;
extern T0*ms63_16821;
extern T0*ms63_17542;
extern T0*ms63_18150;
extern T0*ms63_18186;
T0*se_ms(int c,char*e);
T0*se_string(char*e);
void se_msi1(void);
void se_msi2(void);
void manifest_string_mark1(void);
void once_function_mark(void);
void gc_start(void);
typedef struct B40 gc40;
struct B40{T40 object;union {void*flag;gc40*next;} header;};
extern gc40*store40;
extern int store_left40;
extern fsoc*store_chunk40;
extern gc40*gc_free40;
typedef struct B68 gc68;
struct B68{T68 object;union {void*flag;gc68*next;} header;};
extern gc68*store68;
extern int store_left68;
extern fsoc*store_chunk68;
extern gc68*gc_free68;
typedef struct B191 gc191;
struct B191{T191 object;union {void*flag;gc191*next;} header;};
extern gc191*store191;
extern int store_left191;
extern fsoc*store_chunk191;
extern gc191*gc_free191;
typedef struct B127 gc127;
struct B127{T127 object;union {void*flag;gc127*next;} header;};
extern gc127*store127;
extern int store_left127;
extern fsoc*store_chunk127;
extern gc127*gc_free127;
extern na_env na_env219;
typedef struct B12 gc12;
struct B12{T12 object;union {void*flag;gc12*next;} header;};
extern gc12*store12;
extern int store_left12;
extern fsoc*store_chunk12;
extern gc12*gc_free12;
typedef struct B140 gc140;
struct B140{T140 object;union {void*flag;gc140*next;} header;};
extern gc140*store140;
extern int store_left140;
extern fsoc*store_chunk140;
extern gc140*gc_free140;
typedef struct B157 gc157;
struct B157{T157 object;union {void*flag;gc157*next;} header;};
extern gc157*store157;
extern int store_left157;
extern fsoc*store_chunk157;
extern gc157*gc_free157;
typedef struct B183 gc183;
struct B183{T183 object;union {void*flag;gc183*next;} header;};
extern gc183*store183;
extern int store_left183;
extern fsoc*store_chunk183;
extern gc183*gc_free183;
typedef struct B193 gc193;
struct B193{T193 object;union {void*flag;gc193*next;} header;};
extern gc193*store193;
extern int store_left193;
extern fsoc*store_chunk193;
extern gc193*gc_free193;
typedef struct B148 gc148;
struct B148{T148 object;union {void*flag;gc148*next;} header;};
extern gc148*store148;
extern int store_left148;
extern fsoc*store_chunk148;
extern gc148*gc_free148;
typedef struct B200 gc200;
struct B200{T200 object;union {void*flag;gc200*next;} header;};
extern gc200*store200;
extern int store_left200;
extern fsoc*store_chunk200;
extern gc200*gc_free200;
typedef struct B46 gc46;
struct B46{T46 object;union {void*flag;gc46*next;} header;};
extern gc46*store46;
extern int store_left46;
extern fsoc*store_chunk46;
extern gc46*gc_free46;
typedef struct B55 gc55;
struct B55{T55 object;union {void*flag;gc55*next;} header;};
extern gc55*store55;
extern int store_left55;
extern fsoc*store_chunk55;
extern gc55*gc_free55;
typedef struct B160 gc160;
struct B160{T160 object;union {void*flag;gc160*next;} header;};
extern gc160*store160;
extern int store_left160;
extern fsoc*store_chunk160;
extern gc160*gc_free160;
typedef struct B89 gc89;
struct B89{T89 object;union {void*flag;gc89*next;} header;};
extern gc89*store89;
extern int store_left89;
extern fsoc*store_chunk89;
extern gc89*gc_free89;
typedef struct B197 gc197;
struct B197{T197 object;union {void*flag;gc197*next;} header;};
extern gc197*store197;
extern int store_left197;
extern fsoc*store_chunk197;
extern gc197*gc_free197;
typedef struct B199 gc199;
struct B199{T199 object;union {void*flag;gc199*next;} header;};
extern gc199*store199;
extern int store_left199;
extern fsoc*store_chunk199;
extern gc199*gc_free199;
typedef struct B65 gc65;
struct B65{T65 object;union {void*flag;gc65*next;} header;};
extern gc65*store65;
extern int store_left65;
extern fsoc*store_chunk65;
extern gc65*gc_free65;
typedef struct B108 gc108;
struct B108{T108 object;union {void*flag;gc108*next;} header;};
extern gc108*store108;
extern int store_left108;
extern fsoc*store_chunk108;
extern gc108*gc_free108;
extern na_env na_env146;
typedef struct B201 gc201;
struct B201{T201 object;union {void*flag;gc201*next;} header;};
extern gc201*store201;
extern int store_left201;
extern fsoc*store_chunk201;
extern gc201*gc_free201;
typedef struct B196 gc196;
struct B196{T196 object;union {void*flag;gc196*next;} header;};
extern gc196*store196;
extern int store_left196;
extern fsoc*store_chunk196;
extern gc196*gc_free196;
typedef struct B87 gc87;
struct B87{T87 object;union {void*flag;gc87*next;} header;};
extern gc87*store87;
extern int store_left87;
extern fsoc*store_chunk87;
extern gc87*gc_free87;
typedef struct B60 gc60;
struct B60{T60 object;union {void*flag;gc60*next;} header;};
extern gc60*store60;
extern int store_left60;
extern fsoc*store_chunk60;
extern gc60*gc_free60;
typedef struct B123 gc123;
struct B123{T123 object;union {void*flag;gc123*next;} header;};
extern gc123*store123;
extern int store_left123;
extern fsoc*store_chunk123;
extern gc123*gc_free123;
typedef struct B222 gc222;
struct B222{T222 object;union {void*flag;gc222*next;} header;};
extern gc222*store222;
extern int store_left222;
extern fsoc*store_chunk222;
extern gc222*gc_free222;
typedef struct B120 gc120;
struct B120{T120 object;union {void*flag;gc120*next;} header;};
extern gc120*store120;
extern int store_left120;
extern fsoc*store_chunk120;
extern gc120*gc_free120;
extern na_env na_env48;
typedef struct B220 gc220;
struct B220{T220 object;union {void*flag;gc220*next;} header;};
extern gc220*store220;
extern int store_left220;
extern fsoc*store_chunk220;
extern gc220*gc_free220;
typedef struct B85 gc85;
struct B85{T85 object;union {void*flag;gc85*next;} header;};
extern gc85*store85;
extern int store_left85;
extern fsoc*store_chunk85;
extern gc85*gc_free85;
extern na_env na_env162;
typedef struct B172 gc172;
struct B172{T172 object;union {void*flag;gc172*next;} header;};
extern gc172*store172;
extern int store_left172;
extern fsoc*store_chunk172;
extern gc172*gc_free172;
extern na_env na_env118;
typedef struct B63 gc63;
struct B63{T63 object;union {void*flag;gc63*next;} header;};
extern gc63*store63;
extern int store_left63;
extern fsoc*store_chunk63;
extern gc63*gc_free63;
typedef struct B163 gc163;
struct B163{T163 object;union {void*flag;gc163*next;} header;};
extern gc163*store163;
extern int store_left163;
extern fsoc*store_chunk163;
extern gc163*gc_free163;
typedef struct B103 gc103;
struct B103{T103 object;union {void*flag;gc103*next;} header;};
extern gc103*store103;
extern int store_left103;
extern fsoc*store_chunk103;
extern gc103*gc_free103;
typedef struct B37 gc37;
struct B37{T37 object;union {void*flag;gc37*next;} header;};
extern gc37*store37;
extern int store_left37;
extern fsoc*store_chunk37;
extern gc37*gc_free37;
typedef struct B187 gc187;
struct B187{T187 object;union {void*flag;gc187*next;} header;};
extern gc187*store187;
extern int store_left187;
extern fsoc*store_chunk187;
extern gc187*gc_free187;
typedef struct B224 gc224;
struct B224{T224 object;union {void*flag;gc224*next;} header;};
extern gc224*store224;
extern int store_left224;
extern fsoc*store_chunk224;
extern gc224*gc_free224;
typedef struct B194 gc194;
struct B194{T194 object;union {void*flag;gc194*next;} header;};
extern gc194*store194;
extern int store_left194;
extern fsoc*store_chunk194;
extern gc194*gc_free194;
typedef struct B203 gc203;
struct B203{T203 object;union {void*flag;gc203*next;} header;};
extern gc203*store203;
extern int store_left203;
extern fsoc*store_chunk203;
extern gc203*gc_free203;
typedef struct B70 gc70;
struct B70{T70 object;union {void*flag;gc70*next;} header;};
extern gc70*store70;
extern int store_left70;
extern fsoc*store_chunk70;
extern gc70*gc_free70;
typedef struct B159 gc159;
struct B159{T159 object;union {void*flag;gc159*next;} header;};
extern gc159*store159;
extern int store_left159;
extern fsoc*store_chunk159;
extern gc159*gc_free159;
extern na_env na_env39;
typedef struct B202 gc202;
struct B202{T202 object;union {void*flag;gc202*next;} header;};
extern gc202*store202;
extern int store_left202;
extern fsoc*store_chunk202;
extern gc202*gc_free202;
typedef struct B204 gc204;
struct B204{T204 object;union {void*flag;gc204*next;} header;};
extern gc204*store204;
extern int store_left204;
extern fsoc*store_chunk204;
extern gc204*gc_free204;
typedef struct B186 gc186;
struct B186{T186 object;union {void*flag;gc186*next;} header;};
extern gc186*store186;
extern int store_left186;
extern fsoc*store_chunk186;
extern gc186*gc_free186;
typedef struct B221 gc221;
struct B221{T221 object;union {void*flag;gc221*next;} header;};
extern gc221*store221;
extern int store_left221;
extern fsoc*store_chunk221;
extern gc221*gc_free221;
typedef struct B176 gc176;
struct B176{T176 object;union {void*flag;gc176*next;} header;};
extern gc176*store176;
extern int store_left176;
extern fsoc*store_chunk176;
extern gc176*gc_free176;
typedef struct B117 gc117;
struct B117{T117 object;union {void*flag;gc117*next;} header;};
extern gc117*store117;
extern int store_left117;
extern fsoc*store_chunk117;
extern gc117*gc_free117;
extern na_env na_env180;
typedef struct B195 gc195;
struct B195{T195 object;union {void*flag;gc195*next;} header;};
extern gc195*store195;
extern int store_left195;
extern fsoc*store_chunk195;
extern gc195*gc_free195;
typedef struct B110 gc110;
struct B110{T110 object;union {void*flag;gc110*next;} header;};
extern gc110*store110;
extern int store_left110;
extern fsoc*store_chunk110;
extern gc110*gc_free110;
typedef struct B114 gc114;
struct B114{T114 object;union {void*flag;gc114*next;} header;};
extern gc114*store114;
extern int store_left114;
extern fsoc*store_chunk114;
extern gc114*gc_free114;
extern na_env na_env216;
typedef struct B112 gc112;
struct B112{T112 object;union {void*flag;gc112*next;} header;};
extern gc112*store112;
extern int store_left112;
extern fsoc*store_chunk112;
extern gc112*gc_free112;
typedef struct B131 gc131;
struct B131{T131 object;union {void*flag;gc131*next;} header;};
extern gc131*store131;
extern int store_left131;
extern fsoc*store_chunk131;
extern gc131*gc_free131;
typedef struct B185 gc185;
struct B185{T185 object;union {void*flag;gc185*next;} header;};
extern gc185*store185;
extern int store_left185;
extern fsoc*store_chunk185;
extern gc185*gc_free185;
extern na_env na_env86;
typedef struct B113 gc113;
struct B113{T113 object;union {void*flag;gc113*next;} header;};
extern gc113*store113;
extern int store_left113;
extern fsoc*store_chunk113;
extern gc113*gc_free113;
typedef struct B152 gc152;
struct B152{T152 object;union {void*flag;gc152*next;} header;};
extern gc152*store152;
extern int store_left152;
extern fsoc*store_chunk152;
extern gc152*gc_free152;
typedef struct B106 gc106;
struct B106{T106 object;union {void*flag;gc106*next;} header;};
extern gc106*store106;
extern int store_left106;
extern fsoc*store_chunk106;
extern gc106*gc_free106;
typedef struct B182 gc182;
struct B182{T182 object;union {void*flag;gc182*next;} header;};
extern gc182*store182;
extern int store_left182;
extern fsoc*store_chunk182;
extern gc182*gc_free182;
typedef struct B142 gc142;
struct B142{T142 object;union {void*flag;gc142*next;} header;};
extern gc142*store142;
extern int store_left142;
extern fsoc*store_chunk142;
extern gc142*gc_free142;
typedef struct B128 gc128;
struct B128{T128 object;union {void*flag;gc128*next;} header;};
extern gc128*store128;
extern int store_left128;
extern fsoc*store_chunk128;
extern gc128*gc_free128;
typedef struct B198 gc198;
struct B198{T198 object;union {void*flag;gc198*next;} header;};
extern gc198*store198;
extern int store_left198;
extern fsoc*store_chunk198;
extern gc198*gc_free198;
typedef struct B206 gc206;
struct B206{T206 object;union {void*flag;gc206*next;} header;};
extern gc206*store206;
extern int store_left206;
extern fsoc*store_chunk206;
extern gc206*gc_free206;
typedef struct B170 gc170;
struct B170{T170 object;union {void*flag;gc170*next;} header;};
extern gc170*store170;
extern int store_left170;
extern fsoc*store_chunk170;
extern gc170*gc_free170;
typedef struct B102 gc102;
struct B102{T102 object;union {void*flag;gc102*next;} header;};
extern gc102*store102;
extern int store_left102;
extern fsoc*store_chunk102;
extern gc102*gc_free102;
typedef struct B49 gc49;
struct B49{T49 object;union {void*flag;gc49*next;} header;};
extern gc49*store49;
extern int store_left49;
extern fsoc*store_chunk49;
extern gc49*gc_free49;
typedef struct B111 gc111;
struct B111{T111 object;union {void*flag;gc111*next;} header;};
extern gc111*store111;
extern int store_left111;
extern fsoc*store_chunk111;
extern gc111*gc_free111;
typedef struct B105 gc105;
struct B105{T105 object;union {void*flag;gc105*next;} header;};
extern gc105*store105;
extern int store_left105;
extern fsoc*store_chunk105;
extern gc105*gc_free105;
typedef struct B121 gc121;
struct B121{T121 object;union {void*flag;gc121*next;} header;};
extern gc121*store121;
extern int store_left121;
extern fsoc*store_chunk121;
extern gc121*gc_free121;
typedef struct B25 gc25;
struct B25{T25 object;union {void*flag;gc25*next;} header;};
extern gc25*store25;
extern int store_left25;
extern fsoc*store_chunk25;
extern gc25*gc_free25;
extern na_env na_env51;
typedef struct B125 gc125;
struct B125{T125 object;union {void*flag;gc125*next;} header;};
extern gc125*store125;
extern int store_left125;
extern fsoc*store_chunk125;
extern gc125*gc_free125;
extern na_env na_env61;
typedef struct B119 gc119;
struct B119{T119 object;union {void*flag;gc119*next;} header;};
extern gc119*store119;
extern int store_left119;
extern fsoc*store_chunk119;
extern gc119*gc_free119;
typedef struct B174 gc174;
struct B174{T174 object;union {void*flag;gc174*next;} header;};
extern gc174*store174;
extern int store_left174;
extern fsoc*store_chunk174;
extern gc174*gc_free174;
typedef struct B81 gc81;
struct B81{T81 object;union {void*flag;gc81*next;} header;};
extern gc81*store81;
extern int store_left81;
extern fsoc*store_chunk81;
extern gc81*gc_free81;
typedef struct B94 gc94;
struct B94{T94 object;union {void*flag;gc94*next;} header;};
extern gc94*store94;
extern int store_left94;
extern fsoc*store_chunk94;
extern gc94*gc_free94;
typedef struct B98 gc98;
struct B98{T98 object;union {void*flag;gc98*next;} header;};
extern gc98*store98;
extern int store_left98;
extern fsoc*store_chunk98;
extern gc98*gc_free98;
typedef struct B171 gc171;
struct B171{T171 object;union {void*flag;gc171*next;} header;};
extern gc171*store171;
extern int store_left171;
extern fsoc*store_chunk171;
extern gc171*gc_free171;
typedef struct B71 gc71;
struct B71{T71 object;union {void*flag;gc71*next;} header;};
extern gc71*store71;
extern int store_left71;
extern fsoc*store_chunk71;
extern gc71*gc_free71;
typedef struct B151 gc151;
struct B151{T151 object;union {void*flag;gc151*next;} header;};
extern gc151*store151;
extern int store_left151;
extern fsoc*store_chunk151;
extern gc151*gc_free151;
typedef struct B7 gc7;
struct B7{T7 object;union {void*flag;gc7*next;} header;};
extern gc7*store7;
extern int store_left7;
extern fsoc*store_chunk7;
extern gc7*gc_free7;
typedef struct B58 gc58;
struct B58{T58 object;union {void*flag;gc58*next;} header;};
extern gc58*store58;
extern int store_left58;
extern fsoc*store_chunk58;
extern gc58*gc_free58;
typedef struct B213 gc213;
struct B213{T213 object;union {void*flag;gc213*next;} header;};
extern gc213*store213;
extern int store_left213;
extern fsoc*store_chunk213;
extern gc213*gc_free213;
typedef struct B192 gc192;
struct B192{T192 object;union {void*flag;gc192*next;} header;};
extern gc192*store192;
extern int store_left192;
extern fsoc*store_chunk192;
extern gc192*gc_free192;
typedef struct B99 gc99;
struct B99{T99 object;union {void*flag;gc99*next;} header;};
extern gc99*store99;
extern int store_left99;
extern fsoc*store_chunk99;
extern gc99*gc_free99;
typedef struct B188 gc188;
struct B188{T188 object;union {void*flag;gc188*next;} header;};
extern gc188*store188;
extern int store_left188;
extern fsoc*store_chunk188;
extern gc188*gc_free188;
typedef struct B190 gc190;
struct B190{T190 object;union {void*flag;gc190*next;} header;};
extern gc190*store190;
extern int store_left190;
extern fsoc*store_chunk190;
extern gc190*gc_free190;
typedef struct B205 gc205;
struct B205{T205 object;union {void*flag;gc205*next;} header;};
extern gc205*store205;
extern int store_left205;
extern fsoc*store_chunk205;
extern gc205*gc_free205;
typedef struct B84 gc84;
struct B84{T84 object;union {void*flag;gc84*next;} header;};
extern gc84*store84;
extern int store_left84;
extern fsoc*store_chunk84;
extern gc84*gc_free84;
extern na_env na_env9;
typedef struct B168 gc168;
struct B168{T168 object;union {void*flag;gc168*next;} header;};
extern gc168*store168;
extern int store_left168;
extern fsoc*store_chunk168;
extern gc168*gc_free168;
typedef struct B132 gc132;
struct B132{T132 object;union {void*flag;gc132*next;} header;};
extern gc132*store132;
extern int store_left132;
extern fsoc*store_chunk132;
extern gc132*gc_free132;
typedef struct B165 gc165;
struct B165{T165 object;union {void*flag;gc165*next;} header;};
extern gc165*store165;
extern int store_left165;
extern fsoc*store_chunk165;
extern gc165*gc_free165;
typedef struct B155 gc155;
struct B155{T155 object;union {void*flag;gc155*next;} header;};
extern gc155*store155;
extern int store_left155;
extern fsoc*store_chunk155;
extern gc155*gc_free155;
typedef struct B135 gc135;
struct B135{T135 object;union {void*flag;gc135*next;} header;};
extern gc135*store135;
extern int store_left135;
extern fsoc*store_chunk135;
extern gc135*gc_free135;
typedef struct B116 gc116;
struct B116{T116 object;union {void*flag;gc116*next;} header;};
extern gc116*store116;
extern int store_left116;
extern fsoc*store_chunk116;
extern gc116*gc_free116;
typedef struct B41 gc41;
struct B41{T41 object;union {void*flag;gc41*next;} header;};
extern gc41*store41;
extern int store_left41;
extern fsoc*store_chunk41;
extern gc41*gc_free41;
typedef struct B178 gc178;
struct B178{T178 object;union {void*flag;gc178*next;} header;};
extern gc178*store178;
extern int store_left178;
extern fsoc*store_chunk178;
extern gc178*gc_free178;
typedef struct B209 gc209;
struct B209{T209 object;union {void*flag;gc209*next;} header;};
extern gc209*store209;
extern int store_left209;
extern fsoc*store_chunk209;
extern gc209*gc_free209;
typedef struct B173 gc173;
struct B173{T173 object;union {void*flag;gc173*next;} header;};
extern gc173*store173;
extern int store_left173;
extern fsoc*store_chunk173;
extern gc173*gc_free173;
typedef struct B72 gc72;
struct B72{T72 object;union {void*flag;gc72*next;} header;};
extern gc72*store72;
extern int store_left72;
extern fsoc*store_chunk72;
extern gc72*gc_free72;
typedef struct B144 gc144;
struct B144{T144 object;union {void*flag;gc144*next;} header;};
extern gc144*store144;
extern int store_left144;
extern fsoc*store_chunk144;
extern gc144*gc_free144;
typedef struct B141 gc141;
struct B141{T141 object;union {void*flag;gc141*next;} header;};
extern gc141*store141;
extern int store_left141;
extern fsoc*store_chunk141;
extern gc141*gc_free141;
extern na_env na_env91;
typedef struct B138 gc138;
struct B138{T138 object;union {void*flag;gc138*next;} header;};
extern gc138*store138;
extern int store_left138;
extern fsoc*store_chunk138;
extern gc138*gc_free138;
typedef struct B75 gc75;
struct B75{T75 object;union {void*flag;gc75*next;} header;};
extern gc75*store75;
extern int store_left75;
extern fsoc*store_chunk75;
extern gc75*gc_free75;
typedef struct B92 gc92;
struct B92{T92 object;union {void*flag;gc92*next;} header;};
extern gc92*store92;
extern int store_left92;
extern fsoc*store_chunk92;
extern gc92*gc_free92;
typedef struct B175 gc175;
struct B175{T175 object;union {void*flag;gc175*next;} header;};
extern gc175*store175;
extern int store_left175;
extern fsoc*store_chunk175;
extern gc175*gc_free175;
typedef struct B95 gc95;
struct B95{T95 object;union {void*flag;gc95*next;} header;};
extern gc95*store95;
extern int store_left95;
extern fsoc*store_chunk95;
extern gc95*gc_free95;
typedef struct B52 gc52;
struct B52{T52 object;union {void*flag;gc52*next;} header;};
extern gc52*store52;
extern int store_left52;
extern fsoc*store_chunk52;
extern gc52*gc_free52;
typedef struct B227 gc227;
struct B227{T227 object;union {void*flag;gc227*next;} header;};
extern gc227*store227;
extern int store_left227;
extern fsoc*store_chunk227;
extern gc227*gc_free227;
typedef struct B136 gc136;
struct B136{T136 object;union {void*flag;gc136*next;} header;};
extern gc136*store136;
extern int store_left136;
extern fsoc*store_chunk136;
extern gc136*gc_free136;
typedef struct B62 gc62;
struct B62{T62 object;union {void*flag;gc62*next;} header;};
extern gc62*store62;
extern int store_left62;
extern fsoc*store_chunk62;
extern gc62*gc_free62;
typedef struct B129 gc129;
struct B129{T129 object;union {void*flag;gc129*next;} header;};
extern gc129*store129;
extern int store_left129;
extern fsoc*store_chunk129;
extern gc129*gc_free129;
typedef struct B126 gc126;
struct B126{T126 object;union {void*flag;gc126*next;} header;};
extern gc126*store126;
extern int store_left126;
extern fsoc*store_chunk126;
extern gc126*gc_free126;
typedef struct B93 gc93;
struct B93{T93 object;union {void*flag;gc93*next;} header;};
extern gc93*store93;
extern int store_left93;
extern fsoc*store_chunk93;
extern gc93*gc_free93;
typedef struct B225 gc225;
struct B225{T225 object;union {void*flag;gc225*next;} header;};
extern gc225*store225;
extern int store_left225;
extern fsoc*store_chunk225;
extern gc225*gc_free225;
typedef struct B208 gc208;
struct B208{T208 object;union {void*flag;gc208*next;} header;};
extern gc208*store208;
extern int store_left208;
extern fsoc*store_chunk208;
extern gc208*gc_free208;
typedef struct B134 gc134;
struct B134{T134 object;union {void*flag;gc134*next;} header;};
extern gc134*store134;
extern int store_left134;
extern fsoc*store_chunk134;
extern gc134*gc_free134;
extern na_env na_env43;
extern na_env na_env66;
typedef struct B147 gc147;
struct B147{T147 object;union {void*flag;gc147*next;} header;};
extern gc147*store147;
extern int store_left147;
extern fsoc*store_chunk147;
extern gc147*gc_free147;
typedef struct B56 gc56;
struct B56{T56 object;union {void*flag;gc56*next;} header;};
extern gc56*store56;
extern int store_left56;
extern fsoc*store_chunk56;
extern gc56*gc_free56;
typedef struct B184 gc184;
struct B184{T184 object;union {void*flag;gc184*next;} header;};
extern gc184*store184;
extern int store_left184;
extern fsoc*store_chunk184;
extern gc184*gc_free184;
typedef struct B143 gc143;
struct B143{T143 object;union {void*flag;gc143*next;} header;};
extern gc143*store143;
extern int store_left143;
extern fsoc*store_chunk143;
extern gc143*gc_free143;
typedef struct B97 gc97;
struct B97{T97 object;union {void*flag;gc97*next;} header;};
extern gc97*store97;
extern int store_left97;
extern fsoc*store_chunk97;
extern gc97*gc_free97;
typedef struct B145 gc145;
struct B145{T145 object;union {void*flag;gc145*next;} header;};
extern gc145*store145;
extern int store_left145;
extern fsoc*store_chunk145;
extern gc145*gc_free145;
extern na_env na_env74;
typedef struct B34 gc34;
struct B34{T34 object;union {void*flag;gc34*next;} header;};
extern gc34*store34;
extern int store_left34;
extern fsoc*store_chunk34;
extern gc34*gc_free34;
typedef struct B21 gc21;
struct B21{T21 object;union {void*flag;gc21*next;} header;};
extern gc21*store21;
extern int store_left21;
extern fsoc*store_chunk21;
extern gc21*gc_free21;
typedef struct B217 gc217;
struct B217{T217 object;union {void*flag;gc217*next;} header;};
extern gc217*store217;
extern int store_left217;
extern fsoc*store_chunk217;
extern gc217*gc_free217;
typedef struct B139 gc139;
struct B139{T139 object;union {void*flag;gc139*next;} header;};
extern gc139*store139;
extern int store_left139;
extern fsoc*store_chunk139;
extern gc139*gc_free139;
typedef struct B154 gc154;
struct B154{T154 object;union {void*flag;gc154*next;} header;};
extern gc154*store154;
extern int store_left154;
extern fsoc*store_chunk154;
extern gc154*gc_free154;
typedef struct B80 gc80;
struct B80{T80 object;union {void*flag;gc80*next;} header;};
extern gc80*store80;
extern int store_left80;
extern fsoc*store_chunk80;
extern gc80*gc_free80;
typedef struct B44 gc44;
struct B44{T44 object;union {void*flag;gc44*next;} header;};
extern gc44*store44;
extern int store_left44;
extern fsoc*store_chunk44;
extern gc44*gc_free44;
extern na_env na_env124;
typedef struct B64 gc64;
struct B64{T64 object;union {void*flag;gc64*next;} header;};
extern gc64*store64;
extern int store_left64;
extern fsoc*store_chunk64;
extern gc64*gc_free64;
typedef struct B189 gc189;
struct B189{T189 object;union {void*flag;gc189*next;} header;};
extern gc189*store189;
extern int store_left189;
extern fsoc*store_chunk189;
extern gc189*gc_free189;
typedef struct B101 gc101;
struct B101{T101 object;union {void*flag;gc101*next;} header;};
extern gc101*store101;
extern int store_left101;
extern fsoc*store_chunk101;
extern gc101*gc_free101;
void gc_sweep40(fsoc*c);
void gc_mark40(T40*o);
void gc_align_mark40(fsoc*c,gc40*p);
extern fsoc H40;
T40*new40(void);
void gc_sweep68(fsoc*c);
void gc_mark68(T68*o);
void gc_align_mark68(fsoc*c,gc68*p);
extern fsoc H68;
T68*new68(void);
void gc_sweep191(fsoc*c);
void gc_mark191(T191*o);
void gc_align_mark191(fsoc*c,gc191*p);
extern fsoc H191;
T191*new191(void);
void gc_sweep127(fsoc*c);
void gc_mark127(T127*o);
void gc_align_mark127(fsoc*c,gc127*p);
extern fsoc H127;
T127*new127(void);
void gc_mark219(T219 o);
T219 new219(unsigned int size);
void gc_sweep12(fsoc*c);
void gc_mark12(T12*o);
void gc_align_mark12(fsoc*c,gc12*p);
extern fsoc H12;
T12*new12(void);
void gc_sweep140(fsoc*c);
void gc_mark140(T140*o);
void gc_align_mark140(fsoc*c,gc140*p);
extern fsoc H140;
T140*new140(void);
void gc_sweep157(fsoc*c);
void gc_mark157(T157*o);
void gc_align_mark157(fsoc*c,gc157*p);
extern fsoc H157;
T157*new157(void);
void gc_sweep183(fsoc*c);
void gc_mark183(T183*o);
void gc_align_mark183(fsoc*c,gc183*p);
extern fsoc H183;
T183*new183(void);
void gc_sweep193(fsoc*c);
void gc_mark193(T193*o);
void gc_align_mark193(fsoc*c,gc193*p);
extern fsoc H193;
T193*new193(void);
void gc_sweep148(fsoc*c);
void gc_mark148(T148*o);
void gc_align_mark148(fsoc*c,gc148*p);
extern fsoc H148;
T148*new148(void);
void gc_sweep200(fsoc*c);
void gc_mark200(T200*o);
void gc_align_mark200(fsoc*c,gc200*p);
extern fsoc H200;
T200*new200(void);
void gc_sweep46(fsoc*c);
void gc_mark46(T46*o);
void gc_align_mark46(fsoc*c,gc46*p);
extern fsoc H46;
T46*new46(void);
void gc_sweep55(fsoc*c);
void gc_mark55(T55*o);
void gc_align_mark55(fsoc*c,gc55*p);
extern fsoc H55;
T55*new55(void);
void gc_sweep160(fsoc*c);
void gc_mark160(T160*o);
void gc_align_mark160(fsoc*c,gc160*p);
extern fsoc H160;
T160*new160(void);
void gc_sweep89(fsoc*c);
void gc_mark89(T89*o);
void gc_align_mark89(fsoc*c,gc89*p);
extern fsoc H89;
T89*new89(void);
void gc_sweep197(fsoc*c);
void gc_mark197(T197*o);
void gc_align_mark197(fsoc*c,gc197*p);
extern fsoc H197;
T197*new197(void);
void gc_sweep199(fsoc*c);
void gc_mark199(T199*o);
void gc_align_mark199(fsoc*c,gc199*p);
extern fsoc H199;
T199*new199(void);
void gc_sweep65(fsoc*c);
void gc_mark65(T65*o);
void gc_align_mark65(fsoc*c,gc65*p);
extern fsoc H65;
T65*new65(void);
void gc_sweep108(fsoc*c);
void gc_mark108(T108*o);
void gc_align_mark108(fsoc*c,gc108*p);
extern fsoc H108;
T108*new108(void);
void gc_mark146(T146 o);
T146 new146(unsigned int size);
void gc_sweep201(fsoc*c);
void gc_mark201(T201*o);
void gc_align_mark201(fsoc*c,gc201*p);
extern fsoc H201;
T201*new201(void);
void gc_sweep196(fsoc*c);
void gc_mark196(T196*o);
void gc_align_mark196(fsoc*c,gc196*p);
extern fsoc H196;
T196*new196(void);
void gc_sweep87(fsoc*c);
void gc_mark87(T87*o);
void gc_align_mark87(fsoc*c,gc87*p);
extern fsoc H87;
T87*new87(void);
void gc_sweep60(fsoc*c);
void gc_mark60(T60*o);
void gc_align_mark60(fsoc*c,gc60*p);
extern fsoc H60;
T60*new60(void);
void gc_sweep123(fsoc*c);
void gc_mark123(T123*o);
void gc_align_mark123(fsoc*c,gc123*p);
extern fsoc H123;
T123*new123(void);
void gc_sweep222(fsoc*c);
void gc_mark222(T222*o);
void gc_align_mark222(fsoc*c,gc222*p);
extern fsoc H222;
T222*new222(void);
void gc_sweep120(fsoc*c);
void gc_mark120(T120*o);
void gc_align_mark120(fsoc*c,gc120*p);
extern fsoc H120;
T120*new120(void);
void gc_mark48(T48 o);
T48 new48(unsigned int size);
void gc_sweep220(fsoc*c);
void gc_mark220(T220*o);
void gc_align_mark220(fsoc*c,gc220*p);
extern fsoc H220;
T220*new220(void);
void gc_sweep85(fsoc*c);
void gc_mark85(T85*o);
void gc_align_mark85(fsoc*c,gc85*p);
extern fsoc H85;
T85*new85(void);
void gc_mark162(T162 o);
T162 new162(unsigned int size);
void gc_sweep172(fsoc*c);
void gc_mark172(T172*o);
void gc_align_mark172(fsoc*c,gc172*p);
extern fsoc H172;
T172*new172(void);
void gc_mark118(T118 o);
T118 new118(unsigned int size);
void gc_sweep63(fsoc*c);
void gc_mark63(T63*o);
void gc_align_mark63(fsoc*c,gc63*p);
extern fsoc H63;
T63*new63(void);
void gc_sweep163(fsoc*c);
void gc_mark163(T163*o);
void gc_align_mark163(fsoc*c,gc163*p);
extern fsoc H163;
T163*new163(void);
void gc_sweep103(fsoc*c);
void gc_mark103(T103*o);
void gc_align_mark103(fsoc*c,gc103*p);
extern fsoc H103;
T103*new103(void);
void gc_sweep37(fsoc*c);
void gc_mark37(T37*o);
void gc_align_mark37(fsoc*c,gc37*p);
extern fsoc H37;
T37*new37(void);
void gc_sweep187(fsoc*c);
void gc_mark187(T187*o);
void gc_align_mark187(fsoc*c,gc187*p);
extern fsoc H187;
T187*new187(void);
void gc_sweep224(fsoc*c);
void gc_mark224(T224*o);
void gc_align_mark224(fsoc*c,gc224*p);
extern fsoc H224;
T224*new224(void);
void gc_sweep194(fsoc*c);
void gc_mark194(T194*o);
void gc_align_mark194(fsoc*c,gc194*p);
extern fsoc H194;
T194*new194(void);
void gc_sweep203(fsoc*c);
void gc_mark203(T203*o);
void gc_align_mark203(fsoc*c,gc203*p);
extern fsoc H203;
T203*new203(void);
void gc_sweep70(fsoc*c);
void gc_mark70(T70*o);
void gc_align_mark70(fsoc*c,gc70*p);
extern fsoc H70;
T70*new70(void);
void gc_sweep159(fsoc*c);
void gc_mark159(T159*o);
void gc_align_mark159(fsoc*c,gc159*p);
extern fsoc H159;
T159*new159(void);
void gc_mark39(T39 o);
T39 new39(unsigned int size);
void gc_sweep202(fsoc*c);
void gc_mark202(T202*o);
void gc_align_mark202(fsoc*c,gc202*p);
extern fsoc H202;
T202*new202(void);
void gc_sweep204(fsoc*c);
void gc_mark204(T204*o);
void gc_align_mark204(fsoc*c,gc204*p);
extern fsoc H204;
T204*new204(void);
void gc_sweep186(fsoc*c);
void gc_mark186(T186*o);
void gc_align_mark186(fsoc*c,gc186*p);
extern fsoc H186;
T186*new186(void);
void gc_sweep221(fsoc*c);
void gc_mark221(T221*o);
void gc_align_mark221(fsoc*c,gc221*p);
extern fsoc H221;
T221*new221(void);
void gc_sweep176(fsoc*c);
void gc_mark176(T176*o);
void gc_align_mark176(fsoc*c,gc176*p);
extern fsoc H176;
T176*new176(void);
void gc_sweep117(fsoc*c);
void gc_mark117(T117*o);
void gc_align_mark117(fsoc*c,gc117*p);
extern fsoc H117;
T117*new117(void);
void gc_mark180(T180 o);
T180 new180(unsigned int size);
void gc_sweep195(fsoc*c);
void gc_mark195(T195*o);
void gc_align_mark195(fsoc*c,gc195*p);
extern fsoc H195;
T195*new195(void);
void gc_sweep110(fsoc*c);
void gc_mark110(T110*o);
void gc_align_mark110(fsoc*c,gc110*p);
extern fsoc H110;
T110*new110(void);
void gc_sweep114(fsoc*c);
void gc_mark114(T114*o);
void gc_align_mark114(fsoc*c,gc114*p);
extern fsoc H114;
T114*new114(void);
void gc_mark216(T216 o);
T216 new216(unsigned int size);
void gc_sweep112(fsoc*c);
void gc_mark112(T112*o);
void gc_align_mark112(fsoc*c,gc112*p);
extern fsoc H112;
T112*new112(void);
void gc_sweep131(fsoc*c);
void gc_mark131(T131*o);
void gc_align_mark131(fsoc*c,gc131*p);
extern fsoc H131;
T131*new131(void);
void gc_sweep185(fsoc*c);
void gc_mark185(T185*o);
void gc_align_mark185(fsoc*c,gc185*p);
extern fsoc H185;
T185*new185(void);
void gc_mark86(T86 o);
T86 new86(unsigned int size);
void gc_sweep113(fsoc*c);
void gc_mark113(T113*o);
void gc_align_mark113(fsoc*c,gc113*p);
extern fsoc H113;
T113*new113(void);
void gc_sweep152(fsoc*c);
void gc_mark152(T152*o);
void gc_align_mark152(fsoc*c,gc152*p);
extern fsoc H152;
T152*new152(void);
void gc_sweep106(fsoc*c);
void gc_mark106(T106*o);
void gc_align_mark106(fsoc*c,gc106*p);
extern fsoc H106;
T106*new106(void);
void gc_sweep182(fsoc*c);
void gc_mark182(T182*o);
void gc_align_mark182(fsoc*c,gc182*p);
extern fsoc H182;
T182*new182(void);
void gc_sweep142(fsoc*c);
void gc_mark142(T142*o);
void gc_align_mark142(fsoc*c,gc142*p);
extern fsoc H142;
T142*new142(void);
void gc_sweep128(fsoc*c);
void gc_mark128(T128*o);
void gc_align_mark128(fsoc*c,gc128*p);
extern fsoc H128;
T128*new128(void);
void gc_sweep198(fsoc*c);
void gc_mark198(T198*o);
void gc_align_mark198(fsoc*c,gc198*p);
extern fsoc H198;
T198*new198(void);
void gc_sweep206(fsoc*c);
void gc_mark206(T206*o);
void gc_align_mark206(fsoc*c,gc206*p);
extern fsoc H206;
T206*new206(void);
void gc_sweep170(fsoc*c);
void gc_mark170(T170*o);
void gc_align_mark170(fsoc*c,gc170*p);
extern fsoc H170;
T170*new170(void);
void gc_sweep102(fsoc*c);
void gc_mark102(T102*o);
void gc_align_mark102(fsoc*c,gc102*p);
extern fsoc H102;
T102*new102(void);
void gc_sweep49(fsoc*c);
void gc_mark49(T49*o);
void gc_align_mark49(fsoc*c,gc49*p);
extern fsoc H49;
T49*new49(void);
void gc_sweep111(fsoc*c);
void gc_mark111(T111*o);
void gc_align_mark111(fsoc*c,gc111*p);
extern fsoc H111;
T111*new111(void);
void gc_sweep105(fsoc*c);
void gc_mark105(T105*o);
void gc_align_mark105(fsoc*c,gc105*p);
extern fsoc H105;
T105*new105(void);
void gc_sweep121(fsoc*c);
void gc_mark121(T121*o);
void gc_align_mark121(fsoc*c,gc121*p);
extern fsoc H121;
T121*new121(void);
void gc_sweep25(fsoc*c);
void gc_mark25(T25*o);
void gc_align_mark25(fsoc*c,gc25*p);
extern fsoc H25;
T25*new25(void);
void gc_mark51(T51 o);
T51 new51(unsigned int size);
void gc_sweep125(fsoc*c);
void gc_mark125(T125*o);
void gc_align_mark125(fsoc*c,gc125*p);
extern fsoc H125;
T125*new125(void);
void gc_mark61(T61 o);
T61 new61(unsigned int size);
void gc_sweep119(fsoc*c);
void gc_mark119(T119*o);
void gc_align_mark119(fsoc*c,gc119*p);
extern fsoc H119;
T119*new119(void);
void gc_sweep174(fsoc*c);
void gc_mark174(T174*o);
void gc_align_mark174(fsoc*c,gc174*p);
extern fsoc H174;
T174*new174(void);
void gc_sweep81(fsoc*c);
void gc_mark81(T81*o);
void gc_align_mark81(fsoc*c,gc81*p);
extern fsoc H81;
T81*new81(void);
void gc_sweep94(fsoc*c);
void gc_mark94(T94*o);
void gc_align_mark94(fsoc*c,gc94*p);
extern fsoc H94;
T94*new94(void);
void gc_sweep98(fsoc*c);
void gc_mark98(T98*o);
void gc_align_mark98(fsoc*c,gc98*p);
extern fsoc H98;
T98*new98(void);
void gc_sweep171(fsoc*c);
void gc_mark171(T171*o);
void gc_align_mark171(fsoc*c,gc171*p);
extern fsoc H171;
T171*new171(void);
void gc_sweep71(fsoc*c);
void gc_mark71(T71*o);
void gc_align_mark71(fsoc*c,gc71*p);
extern fsoc H71;
T71*new71(void);
void gc_sweep151(fsoc*c);
void gc_mark151(T151*o);
void gc_align_mark151(fsoc*c,gc151*p);
extern fsoc H151;
T151*new151(void);
void gc_sweep7(fsoc*c);
void gc_mark7(T7*o);
void gc_align_mark7(fsoc*c,gc7*p);
extern fsoc H7;
T7*new7(void);
void gc_sweep58(fsoc*c);
void gc_mark58(T58*o);
void gc_align_mark58(fsoc*c,gc58*p);
extern fsoc H58;
T58*new58(void);
void gc_sweep213(fsoc*c);
void gc_mark213(T213*o);
void gc_align_mark213(fsoc*c,gc213*p);
extern fsoc H213;
T213*new213(void);
void gc_sweep192(fsoc*c);
void gc_mark192(T192*o);
void gc_align_mark192(fsoc*c,gc192*p);
extern fsoc H192;
T192*new192(void);
void gc_sweep99(fsoc*c);
void gc_mark99(T99*o);
void gc_align_mark99(fsoc*c,gc99*p);
extern fsoc H99;
T99*new99(void);
void gc_sweep188(fsoc*c);
void gc_mark188(T188*o);
void gc_align_mark188(fsoc*c,gc188*p);
extern fsoc H188;
T188*new188(void);
void gc_sweep190(fsoc*c);
void gc_mark190(T190*o);
void gc_align_mark190(fsoc*c,gc190*p);
extern fsoc H190;
T190*new190(void);
void gc_sweep205(fsoc*c);
void gc_mark205(T205*o);
void gc_align_mark205(fsoc*c,gc205*p);
extern fsoc H205;
T205*new205(void);
void gc_sweep84(fsoc*c);
void gc_mark84(T84*o);
void gc_align_mark84(fsoc*c,gc84*p);
extern fsoc H84;
T84*new84(void);
void gc_mark9(T9 o);
T9 new9(unsigned int size);
void gc_sweep168(fsoc*c);
void gc_mark168(T168*o);
void gc_align_mark168(fsoc*c,gc168*p);
extern fsoc H168;
T168*new168(void);
void gc_sweep132(fsoc*c);
void gc_mark132(T132*o);
void gc_align_mark132(fsoc*c,gc132*p);
extern fsoc H132;
T132*new132(void);
void gc_sweep165(fsoc*c);
void gc_mark165(T165*o);
void gc_align_mark165(fsoc*c,gc165*p);
extern fsoc H165;
T165*new165(void);
void gc_sweep155(fsoc*c);
void gc_mark155(T155*o);
void gc_align_mark155(fsoc*c,gc155*p);
extern fsoc H155;
T155*new155(void);
void gc_sweep135(fsoc*c);
void gc_mark135(T135*o);
void gc_align_mark135(fsoc*c,gc135*p);
extern fsoc H135;
T135*new135(void);
void gc_sweep116(fsoc*c);
void gc_mark116(T116*o);
void gc_align_mark116(fsoc*c,gc116*p);
extern fsoc H116;
T116*new116(void);
void gc_sweep41(fsoc*c);
void gc_mark41(T41*o);
void gc_align_mark41(fsoc*c,gc41*p);
extern fsoc H41;
T41*new41(void);
void gc_sweep178(fsoc*c);
void gc_mark178(T178*o);
void gc_align_mark178(fsoc*c,gc178*p);
extern fsoc H178;
T178*new178(void);
void gc_sweep209(fsoc*c);
void gc_mark209(T209*o);
void gc_align_mark209(fsoc*c,gc209*p);
extern fsoc H209;
T209*new209(void);
void gc_sweep173(fsoc*c);
void gc_mark173(T173*o);
void gc_align_mark173(fsoc*c,gc173*p);
extern fsoc H173;
T173*new173(void);
void gc_sweep72(fsoc*c);
void gc_mark72(T72*o);
void gc_align_mark72(fsoc*c,gc72*p);
extern fsoc H72;
T72*new72(void);
void gc_sweep144(fsoc*c);
void gc_mark144(T144*o);
void gc_align_mark144(fsoc*c,gc144*p);
extern fsoc H144;
T144*new144(void);
void gc_sweep141(fsoc*c);
void gc_mark141(T141*o);
void gc_align_mark141(fsoc*c,gc141*p);
extern fsoc H141;
T141*new141(void);
void gc_mark91(T91 o);
T91 new91(unsigned int size);
void gc_sweep138(fsoc*c);
void gc_mark138(T138*o);
void gc_align_mark138(fsoc*c,gc138*p);
extern fsoc H138;
T138*new138(void);
void gc_sweep75(fsoc*c);
void gc_mark75(T75*o);
void gc_align_mark75(fsoc*c,gc75*p);
extern fsoc H75;
T75*new75(void);
void gc_sweep92(fsoc*c);
void gc_mark92(T92*o);
void gc_align_mark92(fsoc*c,gc92*p);
extern fsoc H92;
T92*new92(void);
void gc_sweep175(fsoc*c);
void gc_mark175(T175*o);
void gc_align_mark175(fsoc*c,gc175*p);
extern fsoc H175;
T175*new175(void);
void gc_sweep95(fsoc*c);
void gc_mark95(T95*o);
void gc_align_mark95(fsoc*c,gc95*p);
extern fsoc H95;
T95*new95(void);
void gc_sweep52(fsoc*c);
void gc_mark52(T52*o);
void gc_align_mark52(fsoc*c,gc52*p);
extern fsoc H52;
T52*new52(void);
void gc_sweep227(fsoc*c);
void gc_mark227(T227*o);
void gc_align_mark227(fsoc*c,gc227*p);
extern fsoc H227;
T227*new227(void);
void gc_sweep136(fsoc*c);
void gc_mark136(T136*o);
void gc_align_mark136(fsoc*c,gc136*p);
extern fsoc H136;
T136*new136(void);
void gc_sweep62(fsoc*c);
void gc_mark62(T62*o);
void gc_align_mark62(fsoc*c,gc62*p);
extern fsoc H62;
T62*new62(void);
void gc_sweep129(fsoc*c);
void gc_mark129(T129*o);
void gc_align_mark129(fsoc*c,gc129*p);
extern fsoc H129;
T129*new129(void);
void gc_sweep126(fsoc*c);
void gc_mark126(T126*o);
void gc_align_mark126(fsoc*c,gc126*p);
extern fsoc H126;
T126*new126(void);
void gc_sweep93(fsoc*c);
void gc_mark93(T93*o);
void gc_align_mark93(fsoc*c,gc93*p);
extern fsoc H93;
T93*new93(void);
void gc_sweep225(fsoc*c);
void gc_mark225(T225*o);
void gc_align_mark225(fsoc*c,gc225*p);
extern fsoc H225;
T225*new225(void);
void gc_sweep208(fsoc*c);
void gc_mark208(T208*o);
void gc_align_mark208(fsoc*c,gc208*p);
extern fsoc H208;
T208*new208(void);
void gc_sweep134(fsoc*c);
void gc_mark134(T134*o);
void gc_align_mark134(fsoc*c,gc134*p);
extern fsoc H134;
T134*new134(void);
void gc_mark43(T43 o);
T43 new43(unsigned int size);
void gc_mark66(T66 o);
T66 new66(unsigned int size);
void gc_sweep147(fsoc*c);
void gc_mark147(T147*o);
void gc_align_mark147(fsoc*c,gc147*p);
extern fsoc H147;
T147*new147(void);
void gc_sweep56(fsoc*c);
void gc_mark56(T56*o);
void gc_align_mark56(fsoc*c,gc56*p);
extern fsoc H56;
T56*new56(void);
void gc_sweep184(fsoc*c);
void gc_mark184(T184*o);
void gc_align_mark184(fsoc*c,gc184*p);
extern fsoc H184;
T184*new184(void);
void gc_sweep143(fsoc*c);
void gc_mark143(T143*o);
void gc_align_mark143(fsoc*c,gc143*p);
extern fsoc H143;
T143*new143(void);
void gc_sweep97(fsoc*c);
void gc_mark97(T97*o);
void gc_align_mark97(fsoc*c,gc97*p);
extern fsoc H97;
T97*new97(void);
void gc_sweep145(fsoc*c);
void gc_mark145(T145*o);
void gc_align_mark145(fsoc*c,gc145*p);
extern fsoc H145;
T145*new145(void);
void gc_mark74(T74 o);
T74 new74(unsigned int size);
void gc_sweep34(fsoc*c);
void gc_mark34(T34*o);
void gc_align_mark34(fsoc*c,gc34*p);
extern fsoc H34;
T34*new34(void);
void gc_sweep21(fsoc*c);
void gc_mark21(T21*o);
void gc_align_mark21(fsoc*c,gc21*p);
extern fsoc H21;
T21*new21(void);
void gc_sweep217(fsoc*c);
void gc_mark217(T217*o);
void gc_align_mark217(fsoc*c,gc217*p);
extern fsoc H217;
T217*new217(void);
void gc_sweep139(fsoc*c);
void gc_mark139(T139*o);
void gc_align_mark139(fsoc*c,gc139*p);
extern fsoc H139;
T139*new139(void);
void gc_sweep154(fsoc*c);
void gc_mark154(T154*o);
void gc_align_mark154(fsoc*c,gc154*p);
extern fsoc H154;
T154*new154(void);
void gc_sweep80(fsoc*c);
void gc_mark80(T80*o);
void gc_align_mark80(fsoc*c,gc80*p);
extern fsoc H80;
T80*new80(void);
void gc_sweep44(fsoc*c);
void gc_mark44(T44*o);
void gc_align_mark44(fsoc*c,gc44*p);
extern fsoc H44;
T44*new44(void);
void gc_mark124(T124 o);
T124 new124(unsigned int size);
void gc_sweep64(fsoc*c);
void gc_mark64(T64*o);
void gc_align_mark64(fsoc*c,gc64*p);
extern fsoc H64;
T64*new64(void);
void gc_sweep189(fsoc*c);
void gc_mark189(T189*o);
void gc_align_mark189(fsoc*c,gc189*p);
extern fsoc H189;
T189*new189(void);
void gc_sweep101(fsoc*c);
void gc_mark101(T101*o);
void gc_align_mark101(fsoc*c,gc101*p);
extern fsoc H101;
T101*new101(void);
void Xgc_mark13(T0*o);
void Xgc_mark166(T0*o);
void Xgc_mark149(T0*o);
void Xgc_mark137(T0*o);
void Xgc_mark26(T0*o);
void Xgc_mark82(T0*o);
void Xgc_mark79(T0*o);
void Xgc_mark130(T0*o);
void Xgc_mark77(T0*o);
void Xgc_mark53(T0*o);
void Xgc_mark96(T0*o);
void Xgc_mark25(T0*o);
void Xgc_mark164(T0*o);
T6 X77is_constant(T0*C);
void X77display(T0*C,T0* a1);
void X77sub_get_type(T0*C,T0* a1);
T6 X77depend(T0*C);
T0* X77my_copy(T0*C);
T6 X77is_copy(T0*C);
T0* X77position(T0*C);
void X77remove(T0*C);
T0* X77get_type(T0*C);
void X77unlink(T0*C);
T0* X77search_block(T0*C);
void X77genere(T0*C,T0* a1);
T2 X77static_type(T0*C);
T0* X77execute(T0*C);
T2 X77object_id(T0*C);
void X77link(T0*C);
T6 X115is_fusion(T0*C,T0* a1);
T6 X96is_constant(T0*C);
T0* X96to_run(T0*C,T0* a1,T0* a2,T0* a3);
T0* X96runnable(T0*C);
T0* X26name(T0*C);
void X26depend(T0*C);
T0* X26proto_run(T0*C);
T0* X26position(T0*C);
T2 X26index(T0*C);
void X26set_index(T0*C,T2 a1);
T0* X26intern_name(T0*C);
T0* X214next(T0*C);
T0* X214item(T0*C);
T6 X78depend(T0*C);
void X78remove(T0*C);
T0* X78get_type(T0*C);
T0* X78search_block(T0*C);
T2 X78static_type(T0*C);
T0* X78execute(T0*C);
T0* X13twin(T0*C);
T0* X25get_slot_full(T0*C,T0* a1);
void X25depend(T0*C);
T6 X25is_sub_type(T0*C,T2 a1);
void X25set_type_collector(T0*C,T0* a1);
void X25genere(T0*C);
void X25parse(T0*C);
T2 X25sub_check_cycle(T0*C);
T0* X25new_position(T0*C,T2 a1);
void X79display(T0*C,T0* a1);
T6 X79depend(T0*C);
T0* X79my_copy(T0*C);
T6 X79is_copy(T0*C);
void X79remove(T0*C);
void X79genere(T0*C,T0* a1);
T0* X79execute(T0*C);
T0* X153item(T0*C,T2 a1);
T0* X130build_case_type(T0*C,T0* a1);
T0* X130build_case_body(T0*C,T0* a1);
T6 X82is_equal(T0*C,T0* a1);
void X82sub_get_type(T0*C,T0* a1);
T0* X82search_block(T0*C);
T2 X82object_id(T0*C);
void X53display(T0*C,T0* a1);
T6 X53is_self(T0*C);
void X53write(T0*C,T0* a1);
T0* X53get_type(T0*C);
void X53link(T0*C,T0* a1);
T0* X166integer_divide_small_integer(T0*C,T0* a1);
T0* X166_ix_4747(T0*C,T0* a1);
T0* X166remainder_of_divide_large_positive_integer(T0*C,T0* a1);
T0* X166multiply_with_large_negative_integer(T0*C,T0* a1);
T0* X166gcd(T0*C,T0* a1);
T6 X166is_small_integer(T0*C);
T6 X166_ix_6061(T0*C,T0* a1);
T0* X166_px_45(T0*C);
T0* X166integer_divide_large_positive_integer(T0*C,T0* a1);
void X166append_in(T0*C,T0* a1);
T2 X166to_integer(T0*C);
T0* X166remainder_of_divide_large_negative_integer(T0*C,T0* a1);
T6 X166is_negative(T0*C);
T0* X166abs(T0*C);
T6 X166_ix_6261(T0*C,T0* a1);
T0* X166multiply_with_large_positive_integer(T0*C,T0* a1);
T6 X166is_one(T0*C);
T0* X166_ix_42(T0*C,T0* a1);
T0* X166integer_divide_large_negative_integer(T0*C,T0* a1);
T6 X166_ix_60(T0*C,T0* a1);
T6 X166_ix_62(T0*C,T0* a1);
T0* X166_ix_6442(T0*C,T2 a1);
T0* X166remainder_of_divide_small_integer(T0*C,T0* a1);
T6 X166_ix_6461(T0*C,T2 a1);
T6 X164_ix_646261(T0*C,T2 a1);
T0* X164_ix_4747(T0*C,T0* a1);
T6 X164is_positive(T0*C);
T0* X164_ix_6494(T0*C,T2 a1);
T6 X164greater_with_large_negative_integer(T0*C,T0* a1);
T6 X164is_abstract_integer(T0*C);
T0* X164add_with_small_fraction(T0*C,T0* a1);
T0* X164multiply_with_small_fraction(T0*C,T0* a1);
T0* X164factorial(T0*C);
T6 X164greater_with_small_fraction(T0*C,T0* a1);
T0* X164_ix_644747(T0*C,T2 a1);
T0* X164multiply_with_large_negative_integer(T0*C,T0* a1);
T0* X164to_string(T0*C);
T6 X164greater_with_large_positive_integer(T0*C,T0* a1);
T0* X164add_with_large_negative_integer(T0*C,T0* a1);
T6 X164greater_with_large_fraction(T0*C,T0* a1);
T0* X164gcd(T0*C,T0* a1);
T6 X164odd(T0*C);
T0* X164multiply_with_large_fraction(T0*C,T0* a1);
T0* X164inverse(T0*C);
T0* X164_px_45(T0*C);
T2 X164to_integer(T0*C);
T0* X164add_with_large_fraction(T0*C,T0* a1);
T6 X164is_negative(T0*C);
T6 X164_ix_6261(T0*C,T0* a1);
T0* X164add_with_large_positive_integer(T0*C,T0* a1);
T2 X164compare(T0*C,T0* a1);
T0* X164multiply_with_large_positive_integer(T0*C,T0* a1);
T6 X164is_one(T0*C);
T0* X164_ix_42(T0*C,T0* a1);
T0* X164_ix_43(T0*C,T0* a1);
T0* X164_ix_45(T0*C,T0* a1);
T0* X164_ix_47(T0*C,T0* a1);
T6 X164_ix_60(T0*C,T0* a1);
T0* X164_ix_6442(T0*C,T2 a1);
T6 X164_ix_62(T0*C,T0* a1);
T0* X164_ix_6443(T0*C,T2 a1);
T0* X164_ix_6445(T0*C,T2 a1);
T6 X164is_zero(T0*C);
T6 X164_ix_6460(T0*C,T2 a1);
T6 X164_ix_6461(T0*C,T2 a1);
T6 X164_ix_6462(T0*C,T2 a1);
T0* T5toT224(T5 source);

#ifdef __cplusplus
}
#endif
