#include <stdio.h>
#include <string.h>
#include <limits.h>

static unsigned char iubpairs[][2] = {
    {    'A',    'T'    },
    {    'C',    'G'    },
    {    'B',    'V'    },
    {    'D',    'H'    },
    {    'K',    'M'    },
    {    'R',    'Y'    },
    {    '\0',   '\0'   }
};

static unsigned char iubComplement[1+UCHAR_MAX];

static void buildIubComplement (void) {
    int i;
    for (i=0; i <= UCHAR_MAX; i++) iubComplement[i] = (unsigned char) i;
    for (i=0; iubpairs[i][0] != '\0'; i++) {
    	iubComplement[iubpairs[i][0]] = iubpairs[i][1];
    	iubComplement[iubpairs[i][1]] = iubpairs[i][0];
    	iubComplement[tolower (iubpairs[i][0])] = iubpairs[i][1];
    	iubComplement[tolower (iubpairs[i][1])] = iubpairs[i][0];
    }
}

static void inPlaceReverse (unsigned char * strand, int len) {
    int i;
    for (i=0, len--; i < len; i++,len--) {
    	unsigned char c = strand[i];
    	strand[i] = iubComplement[strand[len]];
    	strand[len] = iubComplement[c];
    }
    if (i == len) strand[i] = iubComplement[strand[i]];
}

static void process (char * strand, int len) {
    char * s, c;

    inPlaceReverse ((unsigned char *) strand, len);

    s = strand;

    while (len > 60) {
    	c = s[60];
    	s[60] = '\0';
    	puts (s);
    	s[60] = c;
    	s += 60;
    	len -= 60;
    }

    s[len] = '\0';
    puts (s);
}

int main (int argc, char * argv[]) {
    static char buffer[1024];
    char * inp = (char *) malloc (129);
    int mlen = 128;
    int slen = 0;

    buildIubComplement ();

    while (NULL != fgets (buffer, 1023, stdin)) {
    	if (buffer[0] == '>') {
    	    if (slen > 0) {
	        process (inp, slen);
    	    	slen = 0;
    	    }
    	    printf ("%s", buffer);
    	} else {
    	    int l = strlen (buffer);
    	    while (l > 0 && !isalpha (buffer[l-1])) l--;
    	    while (slen + l > mlen) {
    	    	mlen += mlen;
    	    	inp = (char *) realloc (inp, mlen + 1);
    	    }

    	    memcpy (inp + slen, buffer, l);
    	    slen += l;
    	}
    }
    if (slen > 0) process (inp, slen);
    free (inp);
    return 0;
}
