/*The Computer Language Shootout
  http://shootout.alioth.debian.org/

  contributed by Greg Buchholz

  Uses SSE packed doubles to run the inner loop computations in parallel.
  I don't have a machine with SSE to test with, but the assembly looks
  pretty nice.  With gcc-3.4.2 there's no difference in the assembly
  between -msse2 and -msse3, YMMV.  It uses gcc's vector extentions
  ( http://gcc.gnu.org/onlinedocs/gcc-4.0.0/gcc/Vector-Extensions.html ),
  so it will run (slowly) on hardware without SSE.

  compile (AMD):
  gcc -D_ISOC9X_SOURCE -O3 -mfpmath=sse -msse2 -march=athlon-xp
      -ffast-math -funroll-loops -o mandelbrot.gcc-3.gcc_run mandelbrot.c -lm

  compile (INTEL):
  gcc -D_ISOC9X_SOURCE -O3 -mfpmath=sse -msse2 -march=pentium4
      -ffast-math -funroll-loops -o mandelbrot.gcc-3.gcc_run mandelbrot.c -lm
*/

#include<stdio.h>
#include<math.h>
#include<fenv.h>
typedef double v2df __attribute__ ((mode(V2DF))); // vector of two double floats

int main (int argc, char **argv)
{
    int w, h, bit_num = 0;
    char byte_acc = 0;
    int i, iter = 50;
    double x, y, limit_sqr = 4.0;
    v2df Zrv, Ziv, Crv, Civ, Trv, Tiv;
    v2df zero, one, _1p5, two;
    double *Zr = (double*)&Zrv, *Zi = (double*)&Ziv,
           *Cr = (double*)&Crv, *Ci = (double*)&Civ,
           *Tr = (double*)&Trv, *Ti = (double*)&Tiv;

#define initv(name, val) *((double*)&name)   = (double) val; \
                         *((double*)&name+1) = (double) val
    initv(zero,0.0); initv(one,1.0); initv(_1p5,1.5); initv(two,2.0);

    w = h = atoi(argv[1]);

    printf("P4\n%d %d\n",w,h);

    for(y=0;y<h;++y)
    {
        for(x=0;x<w;x+=2)
        {
            Zrv = Ziv = Trv = Tiv = zero;
            *Cr = x/w;  *(Cr+1) = (x+1.0)/w;
            *Ci = y/h;  *(Ci+1) = *Ci;
            Crv = two * Crv - _1p5;
            Civ = two * Civ - one;

	    printf("cr=%f %f\n",(float) *Cr, (float) *(Cr+1));
	    printf("ci=%f\n",(float) *Ci);
	    //getchar();

            for (i=0;i<iter && (islessequal( *Tr    +  *Ti,   limit_sqr) ||
                                islessequal(*(Tr+1) + *(Ti+1),limit_sqr)   ); ++i)
            {
                Ziv = two*Zrv*Ziv + Civ;
                Zrv = Trv - Tiv + Crv;
                Trv = Zrv * Zrv;
                Tiv = Ziv * Ziv;

		printf("tr=%f\n",(float) *Tr);
		//printf("tr=%f tr2=%f ",(float) *Tr, (float) *(Tr+1));
		//printf("ti=%f ti2=%f\n",(float) *Ti, (float) *(Ti+1));
            }
	    printf("%d\n",i);
            byte_acc <<= 2;
            if(islessequal(*Tr + *Ti, limit_sqr))
                byte_acc |= 0x02;

            if(islessequal(*(Tr+1) + *(Ti+1), limit_sqr))
                byte_acc |= 0x01;

            bit_num+=2;

            if(bit_num == 8)
            {
	      //putc(byte_acc,stdout);
	      //printf("%d ",byte_acc);
                byte_acc = 0;
                bit_num = 0;
            }
            else if(x == w-1)
            {
                byte_acc <<= (8-w%8);
                //putc(byte_acc,stdout);
		//printf("%d ",byte_acc);
                byte_acc = 0;
                bit_num = 0;
            }
        }
	printf("\n");
    }
    
}
