#!/bin/sh
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
# Author: Eddy Petrisor <eddy.petrisor at gmail.com>
# 
# Last change: $Date: 2005-10-14 20:44:34 +0300 (Vi, 14 oct 2005) $

# Syntax:
# check-file.sh some_po_file.po


# Checks the ortography of a po file, using aspell and a msgstr extractor.
# Before the checking, it removes special characters used in interfaces to
# indicate shorcuts or accelerators ( "_","&" )
# 
# The output consists of two files:
# - some_po_file.po.$MSGSUFFIX
# - some_po_file.po.$ORTOSUFFIX
#
# The first will contain all the msgstr-s and the second will contain all
# the words which were reported as unknown by the spell checker.


POFILE="$1"
MSGEXTRACTOR="extract_msg.pl -msgstr"
MSGSUFFIX="msgstr"
ORTOSUFFIX="orto"
ASPELLCMD="aspell -l ro --dict-dir=/usr/lib/aspell-0.60 --ignore-case=true --encoding=utf-8"

PATH=$PATH:.

$MSGEXTRACTOR "$POFILE" | tee ${POFILE}.${MSGSUFFIX} | sed 's#\([a-zA-Z]*\)[_&]\([a-zA-Z]*\)#\1\2#g' | $ASPELLCMD list | sort | uniq > "${POFILE}.${ORTOSUFFIX}"

