﻿# -*- coding: UTF-8 -*-

#
# This file is distributed under the terms of GNU GPL v2 or later, at your choice
# Copyright: Eddy Petrişor <eddy.petrisor at gmail.com>
#

# Revision ID : $Id: CTipCuv.py 33 2005-09-25 22:21:04Z eddy $

"""Implementează operaţiile legate de prelucrarea
şi memorarea cuvintelor

Conţine funcţia aproximează_tipcuv care încearcă
să găsească tipul cuvântului curent stocat."""

import os
import re

errmsg = os.sys.stderr.write
dbgmsg = os.sys.stderr.write

class CTipCuv:

	"""Ajută la manevrarea informaţiilor legate de cuvinte"""

	def __init__ ( self, cuv = '', tip_cuv = 'incorect' ):
		"""Iniţializăm tipul de cuvânt şi cuvântul implicit"""

		self.__appdebug__ = False
		self.init_debug()

		# Iniţializăm variabilele clasei
		self.Cuvant = ''
		self.TipCuvant = tip_cuv
		
		self.mem_tipcuv ( tip_cuv )
		self.mem_cuv ( cuv )
	
	def init_debug ( self ):
		"""Importă atributul __appdebug__ în obiectul curent"""

		try:
			self.__appdebug__ = __appdebug__
		except NameError:
			self.__appdebug__ = False
			pass

	def __deinit__ ( self ):
		"""Curăţă frumos înainte de plecare (decamdată nimic)"""
		pass

	def mem_tipcuv ( self, tip_cuv):
		"""Memorează tipul de cuvânt precizat"""
		self.TipCuvant = tip_cuv
		if ( self.__appdebug__ ):
			dbgmsg ( "tipul = %s\n" % ( self.TipCuvant, ) )

	def ret_tipcuv ( self ):
		"""Returnează tipul de cuvânt memorat"""
		return self.TipCuvant
	
	def mem_cuv ( self, cuv ):
		"""Memeorează cuvântul curent"""
		self.Cuvant = cuv

	def ret_cuv ( self ):
		"""Returnează cuvântul memorat"""
		return self.Cuvant

	def aproximeaza_tipcuv ( self ):
		"""Încercă să aproximeze tipul cuvântului"""
		
		self.mem_tipcuv( "incorect" )

		# dacă e verb la gerunziu, se termină în "ând"		
		regex_result = re.search ( '(.*)(ând)?$', self.Cuvant )
		if regex_result.group(2) != '' :
			self.mem_tipcuv( "comun" )

		# dacă conţine "ghe|ghi|che|chi" probabil e românesc		
		regex_result = re.search ( '.*([cg]h[ei])?.*$', self.Cuvant )
		if regex_result.group(1) != '' :
			self.mem_tipcuv( "comun" )		

		# î precedat de câteva prefixe, sau pe poziţia iniţială,
		# probabil este corect în română
		regex_result = \
			re.search ( '^((re|ne|de[sz]|răs|bine|rău|prea|mult)?î)?.*$', \
			self.Cuvant )
		if regex_result.group(2) != '' :
			self.mem_tipcuv( "comun" )
		
		# Abrevierile se scriu, de regulă, cu toate litere mari
		regex_result = re.search ( '^([A-Z]*)(.*)$', self.Cuvant )
		if regex_result.group(1) != '' and regex_result.group(2) == '' :
			self.mem_tipcuv( "abreviere" )
		
		# cuvinte finalizate în "ing" sună a engleză
		regex_result = re.search ( '(ing)?$', self.Cuvant )
		if regex_result.group(1) != None :
			self.mem_tipcuv( "englezism" )		

		# litere rare în română
		regex_result = re.search ( '([qwyxk]|th)', self.Cuvant )
		try:
			if regex_result.group(1) != None :
				if self.__appdebug__:
					dbgmsg ( "%s\n" % regex_result )
				self.mem_tipcuv( "englezism" )
		except AttributeError:
			# nu a fost găsită dovada englezismului :)
			if self.__appdebug__:
				dbgmsg ( "%s nu conţine literele qwyxk sau grupul th\n" % \
					(self.Cuvant,) )
			pass

		# litere dublate, mai rar în română
		regex_result = re.search ( '.*(([a-z])\\2).*', self.Cuvant )		
		try:
			if regex_result.group(1) != None :
				if self.__appdebug__:
					dbgmsg ( "%s\n" % regex_result )
				self.mem_tipcuv( "englezism" )
		except AttributeError:
			# nu a fost găsită dovada englezismului :)
			if self.__appdebug__:
				dbgmsg ( "%s nu conţine litere dublate\n" % \
					(self.Cuvant,) )
			pass
		
		# Numele încep cu literă mare şi continuă cu litere mici
		regex_result = re.search ( '([A-Z]?)([a-z]*)$', self.Cuvant )
		if regex_result.group(1) != '' and regex_result.group(2) != '':
			self.mem_tipcuv( "nume" )		
		
		# dacă are diacritice, probabil e cuvânt românesc		
		regex_result = re.search ( '.*([âăşţî]*).*$', self.Cuvant )
		if regex_result.group(1) != '' :
			self.mem_tipcuv( "comun" )		
		
		# Un număr în cuvânt poate indica o eroare
		regex_result = re.search ( '([0-9])', self.Cuvant )
		try:
			if regex_result.group(1) != '' :
				self.mem_tipcuv( "incorect" )
		except AttributeError:
			if self.__appdebug__:
				dbgmsg ( "%s conţine cifră\n" % \
					(self.Cuvant,) )
			pass
		
		if self.__appdebug__ :
			dbgmsg ( '%s : tip aproximat : %s\n' % \
				( self.Cuvant, self.TipCuvant ))
		
