﻿# -*- coding: UTF-8 -*-

#
# This file is distributed under the terms of GNU GPL v2 or later, at your choice
# Copyright: Eddy Petrişor <eddy.petrisor at gmail.com>
#

# Revision ID : $Id: CIOHandler.py 33 2005-09-25 22:21:04Z eddy $

"""Se ocupă cu operaţiile de intrare/ieşire ale aplicaţiei OrtoSelector"""

import os

errmsg = os.sys.stderr.write
dbgmsg = os.sys.stderr.write

class CIOHandler:
	"""Asigură funcţionalitatea de intrare/ieşire a aplicaţiei
	Are rolul de a deschide fişierul de intrare, şi a scrie
	informaţiile obţinute de la utilizator în fişierul de ieşire
	"""
		
	def __init__(self, nume_fisier_intrare = '', nume_fisier_iesire = ''):
		"""Dechide fişierele cu care se va lucra"""

		self.nume_fisier_intrare = nume_fisier_intrare
		self.nume_fisier_iesire = nume_fisier_iesire
		
		self.__appdebug__ = False
		self.init_debug()
		
		# definim variabilele membru în __init__, aşa cum trebuie
		self.FisierInNeterminat = False
		self.fisier_intrare = None
		self.fisier_iesire = None
		
		
		self.openinput()			
		self.openoutput()
		

	def init_debug ( self ):
		"""Importă atributul __appdebug__ în obiectul curent"""

		try:
			self.__appdebug__ = __appdebug__
		except NameError:
			self.__appdebug__ = False
			pass


	def openinput(self):
		"""Deschide ca intrare fişierul self.nume_fisier_intrare.
		Dacă nu e definit, fişierul de intrare va fi os.sys.stdin"""
			
		if (self.__appdebug__):
			dbgmsg ( "openinput : %s" % ( self.nume_fisier_intrare, ) )
		
		if ( len(self.nume_fisier_intrare) != 0 ):
			try:
				self.fisier_intrare = open ( self.nume_fisier_intrare ,"r")
			except IOError:
				if ( self.__appdebug__ ):
					errmsg ( "A fost o eroare la deschiderea fişierului de intrare %s" % \
						( self.nume_fisier_intrare, ) )
			except:
				errmsg('Excepţie netratată în openinput\n')
		else:
			# nu e definit numele fişierului de intrare, deci folosim stdin
			self.fisier_intrare = os.sys.stdin
		# fresh input
		self.FisierInNeterminat = True


	def openoutput(self):
		"""Deschide ca ieşire fişierul self.nume_fisier_iesire.
		Dacă nu e definit, fişierul de iesire va fi os.sys.stdout"""
			
		if (self.__appdebug__):
			dbgmsg ( "openinput : %s" % ( self.nume_fisier_iesire, ) )
		
		if ( len(self.nume_fisier_iesire) != 0 ):
			try:
				self.fisier_iesire = open ( self.nume_fisier_iesire ,"r")
			except IOError:
				if ( self.__appdebug__ ):
					errmsg ( "A fost o eroare la deschiderea fişierului de iesire %s\n" % \
						( self.nume_fisier_iesire, ) )
			except:
				errmsg('Excepţie netratată în openoutput\n')
		else:
			# nu e definit numele fişierului de iesire, deci folosim stdout
			self.fisier_iesire = os.sys.stdout


	def inclose(self):
		"""Închide fişierul de intrare"""
		try:
			self.fisier_intrare.close()
		except IOError:
			errmsg ( "Eroare la închiderea fişierului de intrare\n" )
			pass

		self.FisierInNeterminat = False
		
	def outclose(self):
		"""Închide fişierul de ieşire"""
		try:
			self.fisier_iesire.close()
		except IOError:
			errmsg ( "Eroare la închiderea fişierului de ieşire\n" )
			pass
	
	def __deinit__(self):
		"""Pregăteşte închiderea aplicaţiei"""
		self.inclose()
		self.outclose()


	def get_next_line(self):
		"""Citeşte linia următoare din fişierul de intrare
		şi o returnează după tăierea lui \n de pe final"""

		
		if (self.__appdebug__):
			dbgmsg ( self.fisier_intrare )
		
		try:
			line = self.fisier_intrare.next()
			if (self.__appdebug__):
				dbgmsg ( "Citit : %s" % ( line, ) )
				
		except IOError:
			errmsg ( "Nici un element următor din fişierul %s la poziţia %d\n" % 
				( self.fisier_intrare, self.fisier_intrare.tell() ) )
			# dacă avem eroare, măcar să nu se porcească interfaţa
			line = '\n'
			pass
			
		except AttributeError:
			errmsg ( "Nici un fişier de intrare\n" )
			# dacă avem eroare, măcar să nu se porcească interfaţa
			line = '\n'
			pass
			
		except StopIteration:
			errmsg ( "Ultima înregistrare din fişier\n" )
			# dacă avem eroare, măcar să nu se porcească interfaţa
			line = '\n'
			self.FisierInNeterminat = False
			# dacă tot s-a terminat, de ce să nu-l închidem ?
			# pentru că apar erori
			#
			# dacă implementez funcţionalitatea de „înapoi” 
			# poate ar fi bine să renunţ la închidere
			# self.inclose()
			pass


		line = line.strip("\n")

		if (self.__appdebug__):
			dbgmsg ( " <<%s>> \n" % ( line, ) )
		return line

	def write ( self, string ):
		"""Scrie parametrul la ieşirea curentă"""
		
		self.fisier_iesire.write ( string )


